/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.cache;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import rxvesapi.system.kernel.cache.TextCacheEditor;
import rxvesapi.system.kernel.cache.VirtualizedFileConsole;
import rxvesapi.system.kernel.cache.VirtualizedFileConsoleListener;
import rxvesapi.system.kernel.cache.VirtualizedIOFile;
import rxvesapi.system.kernel.cache.VirtualizedInputStream;

public class VirtualizedIOServer
implements VirtualizedFileConsoleListener {
    private static final VirtualizedIOServer instance = new VirtualizedIOServer();
    private VirtualizedIOFile[] file = new VirtualizedIOFile[0];
    private VirtualizedFileConsole console = null;

    private VirtualizedIOServer() {
    }

    public static VirtualizedIOServer getInstance() {
        return instance;
    }

    public void dispose() {
        if (this.console != null) {
            this.console.dispose();
        }
        this.console = null;
        this.file = new VirtualizedIOFile[0];
    }

    @Override
    public void virtualizedFileOpened(String string) {
        Object[] objectArray = new String[]{"TEXT (AUTO)", "TEXT (Shift_JIS)", "TEXT (UTF-8)", "BINARY"};
        String string2 = (String)JOptionPane.showInputDialog(null, "\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") + "Please select the file format.", "Open File", 1, null, objectArray, objectArray[0]);
        if (string2.equals("TEXT (AUTO)")) {
            String string3 = this.getFileContent(string);
            new TextCacheEditor(string, string3);
        } else if (string2.equals("TEXT (Shift_JIS)")) {
            String string4 = this.getFileContent(string, "Shift_JIS");
            new TextCacheEditor(string, string4);
        } else if (string2.equals("TEXT (UTF-8)")) {
            String string5 = this.getFileContent(string, "UTF-8");
            new TextCacheEditor(string, string5);
        } else if (string2.equals("BINARY")) {
            String string6 = this.getFileBinaryContent(string);
            new TextCacheEditor(string, string6);
        }
    }

    @Override
    public void virtualizedFileDeleted(String string) {
    }

    public void disposeConsole() {
        this.console.dispose();
        this.console = null;
    }

    public void createConsoleIcon(String string, String string2) {
        if (this.console == null) {
            this.console = new VirtualizedFileConsole();
            this.console.addVirtualizedFileConsoleListener(this);
        }
        this.console.addVirtualizedFileIcon(string, string2);
    }

    public void setVisible(boolean bl) {
        this.console.setVisible(bl);
    }

    private VirtualizedIOFile createFile(String string) {
        int n;
        int n2 = this.file.length;
        VirtualizedIOFile[] virtualizedIOFileArray = new VirtualizedIOFile[n2];
        for (n = 0; n < n2; ++n) {
            virtualizedIOFileArray[n] = this.file[n];
        }
        this.file = new VirtualizedIOFile[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.file[n] = virtualizedIOFileArray[n];
        }
        virtualizedIOFileArray = null;
        this.file[n2] = new VirtualizedIOFile(string);
        return this.file[n2];
    }

    public boolean exists(String string) {
        return this.searchFile(string) != null;
    }

    private VirtualizedIOFile searchFile(String string) {
        int n = this.file.length;
        for (int i = 0; i < n; ++i) {
            if (!this.file[i].getPath().equals(string)) continue;
            return this.file[i];
        }
        return null;
    }

    public VirtualizedIOFile open(String string) {
        VirtualizedIOFile virtualizedIOFile = this.searchFile(string);
        if (virtualizedIOFile == null) {
            virtualizedIOFile = this.createFile(string);
        }
        return virtualizedIOFile;
    }

    public String getFileContent(String string) {
        if (this.searchFile(string) == null) {
            return "";
        }
        try {
            VirtualizedInputStream virtualizedInputStream = new VirtualizedInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(virtualizedInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer("");
            String string2 = null;
            String string3 = System.getProperty("line.separator");
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(string3);
            }
            String string4 = stringBuffer.toString();
            inputStreamReader.close();
            inputStreamReader = null;
            virtualizedInputStream.close();
            virtualizedInputStream = null;
            stringBuffer = null;
            return string4;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public String getFileContent(String string, String string2) {
        if (this.searchFile(string) == null) {
            return "";
        }
        try {
            VirtualizedInputStream virtualizedInputStream = new VirtualizedInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)virtualizedInputStream, string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer("");
            String string3 = null;
            String string4 = System.getProperty("line.separator");
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
                stringBuffer.append(string4);
            }
            String string5 = stringBuffer.toString();
            inputStreamReader.close();
            inputStreamReader = null;
            virtualizedInputStream.close();
            virtualizedInputStream = null;
            stringBuffer = null;
            return string5;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public String getFileBinaryContent(String string) {
        if (this.searchFile(string) == null) {
            return "";
        }
        try {
            VirtualizedInputStream virtualizedInputStream = new VirtualizedInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(virtualizedInputStream);
            int n = 1024;
            byte[] byArray = new byte[n];
            StringBuffer stringBuffer = new StringBuffer("");
            int n2 = -1;
            int n3 = 0;
            String string2 = System.getProperty("line.separator");
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                for (int i = 0; i < n2; ++i) {
                    int n4 = byArray[i] & 0xFF;
                    String string3 = Integer.toHexString(n4);
                    if ((string3 = string3.toUpperCase()).length() == 1) {
                        string3 = "0" + string3;
                    }
                    stringBuffer.append(string3);
                    if (++n3 == 8) {
                        n3 = 0;
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(" ");
                }
            }
            String string4 = stringBuffer.toString();
            bufferedInputStream.close();
            bufferedInputStream = null;
            virtualizedInputStream.close();
            virtualizedInputStream = null;
            return string4;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public String getFileContentsSeparatedByBlankLines(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getFileContent(stringArray[i]));
            stringBuffer.append(string);
        }
        String string2 = stringBuffer.toString();
        stringBuffer = null;
        return string2;
    }
}

