/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.process;

import rxvesapi.system.kernel.process.SystemScriptProcess;

public class SystemProcessManager {
    public SystemScriptProcess[] SystemScriptProcess;
    public static int DISPOSE_ON_END = 100;
    public static int EXIT_ON_END = 101;
    private int PROCESS_END_OPERATION = DISPOSE_ON_END;

    public SystemProcessManager() {
        this.init();
    }

    public void setProcessEndOperation(int n) {
        this.PROCESS_END_OPERATION = n;
    }

    public void init() {
        this.SystemScriptProcess = new SystemScriptProcess[1];
    }

    public void disposeResource() {
        int n = this.SystemScriptProcess.length;
        for (int i = 0; i < n; ++i) {
            if (this.SystemScriptProcess[i] == null) continue;
            try {
                this.SystemScriptProcess[i].disposeResource();
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.SystemScriptProcess = null;
    }

    public void createScriptProcess(SystemScriptProcess systemScriptProcess) {
        int n;
        systemScriptProcess.manager = this;
        int n2 = this.SystemScriptProcess.length;
        for (int i = 0; i < n2; ++i) {
            if (this.SystemScriptProcess[i] != null) continue;
            this.SystemScriptProcess[i] = systemScriptProcess;
            return;
        }
        SystemScriptProcess[] systemScriptProcessArray = new SystemScriptProcess[n2];
        for (n = 0; n < n2; ++n) {
            systemScriptProcessArray[n] = this.SystemScriptProcess[n];
        }
        this.SystemScriptProcess = new SystemScriptProcess[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.SystemScriptProcess[n] = systemScriptProcessArray[n];
        }
        systemScriptProcessArray = null;
        this.SystemScriptProcess[n2] = systemScriptProcess;
    }

    public void disposeScriptProcess(SystemScriptProcess systemScriptProcess) {
        int n = this.SystemScriptProcess.length;
        for (int i = 0; i < n; ++i) {
            if (this.SystemScriptProcess[i] != systemScriptProcess) continue;
            this.SystemScriptProcess[i].hide();
            this.SystemScriptProcess[i].disposeResource();
            this.SystemScriptProcess[i] = null;
        }
        if (this.PROCESS_END_OPERATION == EXIT_ON_END) {
            this.disposeResource();
            System.exit(0);
        }
    }
}

