/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.process;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rxvesapi.process.ScriptProcessor;

public class SystemScriptProcessEngineManager
implements WindowListener {
    public JFrame frame;
    public JPanel infoPanelR;
    public JPanel infoPanelL;
    public JPanel drivePanel;
    public JLabel driveLabel;
    public JLabel memoryLabel;
    private long lastDrive = -1L;

    public SystemScriptProcessEngineManager() {
        this.componentInit();
    }

    public void dispose() {
        this.disposeResource();
    }

    public void disposeResource() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.frame = null;
        this.infoPanelR = null;
        this.infoPanelL = null;
        this.drivePanel = null;
        this.driveLabel = null;
        this.memoryLabel = null;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void componentInit() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(this);
        this.frame.setBounds(10, 10, 400, 210);
        this.frame.getContentPane().setLayout(null);
        this.frame.setTitle("Engine Mnager");
        Font font = new Font("Dialog", 1, 14);
        this.infoPanelL = new JPanel();
        this.infoPanelL.setLayout(new GridLayout(3, 1));
        this.infoPanelL.setBounds(10, 10, 110, 70);
        JLabel jLabel = new JLabel("ENGINE ID :");
        jLabel.setFont(font);
        this.infoPanelL.add(jLabel);
        jLabel.setVisible(true);
        jLabel = new JLabel("ENGINE NAME :");
        this.infoPanelL.add(jLabel);
        jLabel.setVisible(true);
        jLabel = new JLabel("ARCHITECTURE :");
        this.infoPanelL.add(jLabel);
        jLabel.setVisible(true);
        this.infoPanelR = new JPanel();
        this.infoPanelR.setLayout(new GridLayout(3, 1));
        this.infoPanelR.setBounds(120, 10, 280, 70);
        jLabel = new JLabel("RINEARN  " + ScriptProcessor.MODEL_ID);
        jLabel.setForeground(Color.blue);
        jLabel.setFont(font);
        this.infoPanelR.add(jLabel);
        jLabel.setVisible(true);
        jLabel = new JLabel(ScriptProcessor.MODEL_NAME);
        this.infoPanelR.add(jLabel);
        jLabel.setVisible(true);
        jLabel = new JLabel(ScriptProcessor.ARCHITECTURE_NAME);
        this.infoPanelR.add(jLabel);
        jLabel.setVisible(true);
        this.infoPanelR.setVisible(true);
        this.infoPanelL.setVisible(true);
        this.frame.getContentPane().add(this.infoPanelL);
        this.frame.getContentPane().add(this.infoPanelR);
        this.drivePanel = new JPanel();
        this.drivePanel.setLayout(new GridLayout(2, 2));
        this.drivePanel.setBounds(10, 100, 360, 50);
        jLabel = new JLabel("DRIVE :");
        jLabel.setFont(font);
        this.drivePanel.add(jLabel);
        jLabel.setVisible(true);
        this.driveLabel = new JLabel(" -");
        this.driveLabel.setForeground(Color.white);
        this.driveLabel.setFont(font);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.driveLabel.setBounds(5, 0, 240, 20);
        jPanel.setBackground(Color.blue);
        jPanel.add(this.driveLabel);
        this.drivePanel.add(jPanel);
        this.driveLabel.setVisible(true);
        jPanel.setVisible(true);
        jLabel = new JLabel("RAM :");
        jLabel.setFont(font);
        this.drivePanel.add(jLabel);
        jLabel.setVisible(true);
        this.memoryLabel = new JLabel(" -");
        this.memoryLabel.setForeground(Color.white);
        jPanel = new JPanel();
        jPanel.setLayout(null);
        this.memoryLabel.setBounds(5, 0, 240, 20);
        jPanel.setBackground(Color.blue);
        jPanel.add(this.memoryLabel);
        this.drivePanel.add(jPanel);
        this.driveLabel.setVisible(true);
        jPanel.setVisible(true);
        this.infoPanelL.setVisible(true);
        this.infoPanelR.setVisible(true);
        this.frame.getContentPane().add(this.drivePanel);
        this.frame.setVisible(true);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public static String getDriveSpeedString(long l) {
        String string = "";
        string = l > 1000000L ? "" + (float)(0.1 * (double)((int)(l / 100000L))) + " MHz" : (l > 1000L ? "" + (float)(0.1 * (double)((int)(l / 100L))) + " KHz" : "" + l + " Hz");
        return string;
    }

    public void setDriveLabel(long l) {
        if (l == this.lastDrive && l == 0L) {
            return;
        }
        this.driveLabel.setText(SystemScriptProcessEngineManager.getDriveSpeedString(l));
        this.setMemoryLabel();
        this.driveLabel.repaint();
        this.drivePanel.repaint();
        this.lastDrive = l;
    }

    public static String getMemoryUsedString() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        String string = "";
        string = l3 > 1000000000L ? "" + (float)(0.1 * (double)((int)(l3 / 100000000L))) + " GB" : (l3 > 1000000L ? "" + (float)(0.1 * (double)((int)(l3 / 100000L))) + " MB" : (l3 > 1000L ? "" + (float)(0.1 * (double)((int)(l3 / 100L))) + " KB" : "" + l3 + " B"));
        return string;
    }

    public static String getMemoryTotalString() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        long l4 = Runtime.getRuntime().maxMemory();
        String string = "";
        string = l4 > 1000000000L ? "" + (float)(0.1 * (double)((int)(l4 / 100000000L))) + " GB" : (l3 > 1000000L ? "" + (float)(0.1 * (double)((int)(l4 / 100000L))) + " MB" : (l3 > 1000L ? "" + (float)(0.1 * (double)((int)(l4 / 100L))) + " KB" : "" + l4 + " B"));
        return string;
    }

    public void setMemoryLabel() {
        this.memoryLabel.setText(this.getMemoryUsedString() + "  /  " + this.getMemoryTotalString());
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.disposeResource();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

