/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system.kernel.process;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import rxvesapi.system.kernel.process.SystemScriptProcess;

public class SystemScriptProcessSettingWindow
implements ActionListener {
    static final int DEFAULT_FRAME_WIDTH = 600;
    static final int DEFAULT_FRAME_HEIGHT = 400;
    static final String FRAME_TITLE = "Setting";
    static int WIDTH_MARGIN = 50;
    static int HEIGHT_MARGIN = 30;
    static final int LOWER_BUTTON_HEIGHT = 30;
    static final int LOWER_BUTTON_WIDTH = 120;
    static final String SETTING_FILE_ENCODING = "Shift_JIS";
    static final String EOL = System.getProperty("line.separator");
    public JFrame frame = null;
    public JTabbedPane tabbedPane = null;
    public JButton OKButton = null;
    public JButton CancelButton = null;
    public SystemScriptProcess shell = null;
    public JTextArea libraryArea;
    public JPanel libraryPanel = null;
    public JButton addPathButton = null;
    public JPanel windowPanel = null;
    public JTextField fontSizeField = null;
    public JTextField fontRedField = null;
    public JTextField fontGreenField = null;
    public JTextField fontBlueField = null;
    public JTextField fontAlphaField = null;
    public JTextField bgRedField = null;
    public JTextField bgGreenField = null;
    public JTextField bgBlueField = null;
    public JTextField bgAlphaField = null;
    public JTextField fontRedField2 = null;
    public JTextField fontGreenField2 = null;
    public JTextField fontBlueField2 = null;
    public JTextField fontAlphaField2 = null;
    public JTextField bgRedField2 = null;
    public JTextField bgGreenField2 = null;
    public JTextField bgBlueField2 = null;
    public JTextField bgAlphaField2 = null;
    boolean settingConfirmed = false;

    public SystemScriptProcessSettingWindow(SystemScriptProcess systemScriptProcess) {
        this.shell = systemScriptProcess;
        try {
            this.loadIniFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponent();
    }

    public SystemScriptProcessSettingWindow(SystemScriptProcess systemScriptProcess, String string) {
        this.shell = systemScriptProcess;
        this.initComponent();
        this.loadIniFile();
        if (string.equals("Library")) {
            this.tabbedPane.setSelectedComponent(this.libraryPanel);
        } else if (string.equals("Window")) {
            this.tabbedPane.setSelectedComponent(this.windowPanel);
        }
    }

    private void loadIniFile() {
        File file = new File("VCSSL_Setting.ini");
        try {
            file = new File("etc").exists() && new File("etc").isDirectory() && new File("etc/VCSSL_Setting.ini").exists() ? new File("etc/VCSSL_Setting.ini") : new File("VCSSL_Setting.ini");
        }
        catch (Exception exception) {
            return;
        }
        try {
            if (!file.exists()) {
                file = new File("bin/VCSSL_Setting.ini");
            }
        }
        catch (Exception exception) {
            return;
        }
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file.getPath());
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, SETTING_FILE_ENCODING);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf("=");
                if (0 > n) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                String[] stringArray = string3.split(";");
                if (string2.equals("LIBRARY")) {
                    for (int i = 0; i < stringArray.length - 1; ++i) {
                        this.libraryArea.append(stringArray[i] + EOL);
                    }
                    if (1 <= stringArray.length) {
                        this.libraryArea.append(stringArray[stringArray.length - 1]);
                    }
                }
                if (!string2.equals("FULL_SCREEN") || 1 <= stringArray.length) {
                    // empty if block
                }
                if (string2.equals("FONT_SIZE") && 1 <= stringArray.length) {
                    this.fontSizeField.setText(stringArray[0]);
                }
                if (string2.equals("FONT_COLOR") && 4 == stringArray.length) {
                    this.fontRedField.setText(stringArray[0]);
                    this.fontGreenField.setText(stringArray[1]);
                    this.fontBlueField.setText(stringArray[2]);
                    this.fontAlphaField.setText(stringArray[3]);
                }
                if (string2.equals("FONT_COLOR2") && 4 == stringArray.length) {
                    this.fontRedField2.setText(stringArray[0]);
                    this.fontGreenField2.setText(stringArray[1]);
                    this.fontBlueField2.setText(stringArray[2]);
                    this.fontAlphaField2.setText(stringArray[3]);
                }
                if (string2.equals("BACKGROUND_COLOR") && 4 == stringArray.length) {
                    this.bgRedField.setText(stringArray[0]);
                    this.bgGreenField.setText(stringArray[1]);
                    this.bgBlueField.setText(stringArray[2]);
                    this.bgAlphaField.setText(stringArray[3]);
                }
                if (!string2.equals("BACKGROUND_COLOR2") || 4 != stringArray.length) continue;
                this.bgRedField2.setText(stringArray[0]);
                this.bgGreenField2.setText(stringArray[1]);
                this.bgBlueField2.setText(stringArray[2]);
                this.bgAlphaField2.setText(stringArray[3]);
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            try {
                bufferedReader.close();
                inputStreamReader.close();
                fileInputStream.close();
            }
            catch (Exception exception2) {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    fileInputStream.close();
                }
                catch (Exception exception3) {
                    try {
                        bufferedReader.close();
                        inputStreamReader.close();
                        fileInputStream.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void initComponent() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(2);
        this.frame.setBounds(20, 20, 600, 400);
        this.frame.setTitle(FRAME_TITLE);
        this.tabbedPane = new JTabbedPane();
        this.frame.getContentPane().add(this.tabbedPane);
        this.frame.getContentPane().setLayout(null);
        this.initLibraryPanel();
        this.tabbedPane.addTab("Library", this.libraryPanel);
        this.initWindowPanel();
        this.tabbedPane.addTab("Window", this.windowPanel);
        this.tabbedPane.setBounds(10, 10, 600 - WIDTH_MARGIN - 5, 400 - HEIGHT_MARGIN - 30 - 60);
        this.OKButton = new JButton("OK");
        this.OKButton.setBounds(10, this.tabbedPane.getY() + this.tabbedPane.getHeight() + 20, 120, 30);
        this.frame.getContentPane().add(this.OKButton);
        this.OKButton.setVisible(true);
        this.OKButton.addActionListener(this);
        this.CancelButton = new JButton("Cancel");
        this.CancelButton.setBounds(10 + 120 + 10, this.tabbedPane.getY() + this.tabbedPane.getHeight() + 20, 120, 30);
        this.frame.getContentPane().add(this.CancelButton);
        this.CancelButton.setVisible(true);
        this.CancelButton.addActionListener(this);
        this.tabbedPane.setVisible(true);
        this.frame.setVisible(true);
    }

    public String replaceLineFeed(String string) {
        string = string.replaceAll("\r\n", "\n");
        string = string.replaceAll("\n\r", "\n");
        string = string.replaceAll("\r", "\n");
        string = string.replaceAll("\n", EOL);
        return string;
    }

    private int getDefaultPanelWidth() {
        return 600 - WIDTH_MARGIN;
    }

    private int getDefaultPanelHeight() {
        return 400 - HEIGHT_MARGIN - 30 - 30;
    }

    private void initLibraryPanel() {
        this.libraryPanel = new JPanel();
        this.libraryPanel.setLayout(null);
        int n = 10;
        int n2 = this.getDefaultPanelWidth();
        int n3 = this.getDefaultPanelHeight();
        int n4 = n3 - 128;
        int n5 = 35;
        int n6 = 25;
        JLabel jLabel = new JLabel("Library Path - \u30e9\u30a4\u30d6\u30e9\u30ea\u8aad\u307f\u8fbc\u307f\u5834\u6240");
        jLabel.setBounds(n, n, 1000, 20);
        this.libraryPanel.add(jLabel);
        jLabel.setVisible(true);
        this.libraryArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.libraryArea);
        jScrollPane.setBounds(n, n5, n2 - n * 3, n4);
        this.libraryPanel.add(jScrollPane);
        this.libraryArea.setVisible(true);
        this.addPathButton = new JButton("Add Path - \u5834\u6240\u3092\u8ffd\u52a0");
        this.addPathButton.setBounds(n, n5 + n4, n2 - n * 3, n6);
        this.libraryPanel.add(this.addPathButton);
        this.addPathButton.setVisible(true);
        this.addPathButton.addActionListener(this);
        jScrollPane.setVisible(true);
        this.libraryPanel.setVisible(true);
    }

    private void initWindowPanel() {
        this.windowPanel = new JPanel();
        this.windowPanel.setLayout(null);
        int n = this.getDefaultPanelWidth();
        int n2 = this.getDefaultPanelHeight();
        int n3 = 10;
        int n4 = 14;
        int n5 = 0;
        JLabel jLabel = new JLabel("Window Size - \u753b\u9762\u30b5\u30a4\u30ba\u306e\u8a2d\u5b9a");
        jLabel.setBounds(n3, n3 + n5, 1000, 20);
        jLabel.setVisible(true);
        this.windowPanel.add(jLabel);
        jLabel = new JLabel("  -");
        jLabel.setBounds(n3 + n4, n3 + (n5 += 20), 1000, 20);
        this.windowPanel.add(jLabel);
        jLabel = new JLabel("Font - \u6587\u5b57\u306e\u8a2d\u5b9a");
        jLabel.setBounds(n3, n3 + (n5 += 40), 1000, 20);
        jLabel.setVisible(true);
        this.windowPanel.add(jLabel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.setBounds(n3 + n4, n3 + (n5 += 20), 224, 20);
        this.windowPanel.add(jPanel);
        jLabel = new JLabel("Size \u30b5\u30a4\u30ba", 2);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontSizeField = new JTextField("20");
        jPanel.add(this.fontSizeField);
        this.fontSizeField.setVisible(true);
        jPanel.setVisible(true);
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 5));
        jPanel.setBounds(n3 + n4, n3 + (n5 += 24), 500, 20);
        this.windowPanel.add(jPanel);
        jLabel = new JLabel("Color \u8272", 2);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        jLabel = new JLabel("R \u8d64 ", 4);
        jLabel.setForeground(new Color(180, 0, 0));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontRedField = new JTextField("255");
        jPanel.add(this.fontRedField);
        this.fontRedField.setVisible(true);
        jLabel = new JLabel("G \u7dd1  ", 4);
        jLabel.setForeground(new Color(0, 180, 0));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontGreenField = new JTextField("255");
        jPanel.add(this.fontGreenField);
        this.fontGreenField.setVisible(true);
        jLabel = new JLabel("B \u9752  ", 4);
        jLabel.setForeground(new Color(0, 0, 180));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontBlueField = new JTextField("255");
        jPanel.add(this.fontBlueField);
        this.fontBlueField.setVisible(true);
        jLabel = new JLabel("A \u03b1  ", 4);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontAlphaField = new JTextField("255");
        jPanel.add(this.fontAlphaField);
        this.fontAlphaField.setVisible(true);
        jPanel.setVisible(true);
        this.windowPanel.setVisible(true);
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 5));
        jPanel.setBounds(n3 + n4, n3 + (n5 += 20), 500, 20);
        this.windowPanel.add(jPanel);
        jLabel = new JLabel("Color (2)", 2);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        jLabel = new JLabel("R \u8d64 ", 4);
        jLabel.setForeground(new Color(180, 0, 0));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontRedField2 = new JTextField("255");
        jPanel.add(this.fontRedField2);
        this.fontRedField2.setVisible(true);
        jLabel = new JLabel("G \u7dd1  ", 4);
        jLabel.setForeground(new Color(0, 180, 0));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontGreenField2 = new JTextField("255");
        jPanel.add(this.fontGreenField2);
        this.fontGreenField2.setVisible(true);
        jLabel = new JLabel("B \u9752  ", 4);
        jLabel.setForeground(new Color(0, 0, 180));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontBlueField2 = new JTextField("255");
        jPanel.add(this.fontBlueField2);
        this.fontBlueField2.setVisible(true);
        jLabel = new JLabel("A \u03b1  ", 4);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.fontAlphaField2 = new JTextField("255");
        jPanel.add(this.fontAlphaField2);
        this.fontAlphaField2.setVisible(true);
        jPanel.setVisible(true);
        this.windowPanel.setVisible(true);
        jLabel = new JLabel("Background - \u80cc\u666f\u306e\u8a2d\u5b9a");
        jLabel.setBounds(n3, n3 + (n5 += 40), 1000, 20);
        jLabel.setVisible(true);
        this.windowPanel.add(jLabel);
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 5));
        jPanel.setBounds(n3 + n4, n3 + (n5 += 20), 500, 20);
        this.windowPanel.add(jPanel);
        jLabel = new JLabel("Color \u8272", 2);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        jLabel = new JLabel("R \u8d64 ", 4);
        jLabel.setForeground(new Color(180, 0, 0));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.bgRedField = new JTextField("0");
        jPanel.add(this.bgRedField);
        this.bgRedField.setVisible(true);
        jLabel = new JLabel("G \u7dd1  ", 4);
        jLabel.setForeground(new Color(0, 180, 0));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.bgGreenField = new JTextField("0");
        jPanel.add(this.bgGreenField);
        this.bgGreenField.setVisible(true);
        jLabel = new JLabel("B \u9752  ", 4);
        jLabel.setForeground(new Color(0, 0, 180));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.bgBlueField = new JTextField("0");
        jPanel.add(this.bgBlueField);
        this.bgBlueField.setVisible(true);
        jLabel = new JLabel("A \u03b1  ", 4);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.bgAlphaField = new JTextField("255");
        jPanel.add(this.bgAlphaField);
        this.bgAlphaField.setVisible(true);
        jPanel.setVisible(true);
        this.windowPanel.setVisible(true);
        jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 5));
        jPanel.setBounds(n3 + n4, n3 + (n5 += 20), 500, 20);
        this.windowPanel.add(jPanel);
        jLabel = new JLabel("Color (2)", 2);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        jLabel = new JLabel("R \u8d64 ", 4);
        jLabel.setForeground(new Color(180, 0, 0));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.bgRedField2 = new JTextField("0");
        jPanel.add(this.bgRedField2);
        this.bgRedField2.setVisible(true);
        jLabel = new JLabel("G \u7dd1  ", 4);
        jLabel.setForeground(new Color(0, 180, 0));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.bgGreenField2 = new JTextField("0");
        jPanel.add(this.bgGreenField2);
        this.bgGreenField2.setVisible(true);
        jLabel = new JLabel("B \u9752  ", 4);
        jLabel.setForeground(new Color(0, 0, 180));
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.bgBlueField2 = new JTextField("255");
        jPanel.add(this.bgBlueField2);
        this.bgBlueField2.setVisible(true);
        jLabel = new JLabel("A \u03b1  ", 4);
        jPanel.add(jLabel);
        jLabel.setVisible(true);
        this.bgAlphaField2 = new JTextField("255");
        jPanel.add(this.bgAlphaField2);
        this.bgAlphaField2.setVisible(true);
        jPanel.setVisible(true);
        this.windowPanel.setVisible(true);
    }

    public void dispose() {
        try {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addPathButton) {
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(this.frame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                String string = this.libraryArea.getText();
                if (!string.endsWith("\\r") && !string.endsWith("\\n")) {
                    this.libraryArea.append(EOL);
                }
                this.libraryArea.append(file.getPath());
                this.libraryArea.append(EOL);
            }
        }
        if (object == this.CancelButton) {
            this.dispose();
        }
        if (object == this.OKButton) {
            this.shell.saveIniFile();
            this.frame.setVisible(false);
            this.dispose();
        }
    }
}

