/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.geometry;

import rxvesapi.system3d.geometry.CoordinateSystem3DEG;

public class Vector3DEG {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double w = 1.0;
    public CoordinateSystem3DEG belongingSystem;

    public Vector3DEG() {
    }

    public Vector3DEG(double d, double d2, double d3) {
        this.setXYZ(d, d2, d3);
    }

    public Vector3DEG copy() {
        Vector3DEG vector3DEG = new Vector3DEG();
        vector3DEG.setXYZ(this.x, this.y, this.z);
        return vector3DEG;
    }

    public void dispose() {
        this.belongingSystem = null;
    }

    public void disposeResource() {
        this.dispose();
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public void setW(double d) {
        this.w = d;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public void setXYZ(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
    }

    public void rotX(double d) {
        double d2 = this.y;
        double d3 = this.z;
        this.y = d2 * Math.cos(d) + -d3 * Math.sin(d);
        this.z = d2 * Math.sin(d) + d3 * Math.cos(d);
    }

    public void rotY(double d) {
        double d2 = this.z;
        double d3 = this.x;
        this.z = d2 * Math.cos(d) + -d3 * Math.sin(d);
        this.x = d2 * Math.sin(d) + d3 * Math.cos(d);
    }

    public void rotZ(double d) {
        double d2 = this.x;
        double d3 = this.y;
        this.x = d2 * Math.cos(d) + -d3 * Math.sin(d);
        this.y = d2 * Math.sin(d) + d3 * Math.cos(d);
    }

    public void rot(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d != 0.0) {
            double[] dArray = new double[]{d2, d3, d4};
            double d8 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
            dArray[0] = dArray[0] / d8;
            dArray[1] = dArray[1] / d8;
            dArray[2] = dArray[2] / d8;
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[]{this.x - d5, this.y - d6, this.z - d7};
            double d9 = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
            if (d9 != 0.0) {
                dArray4[0] = dArray4[0] / d9;
                dArray4[1] = dArray4[1] / d9;
                dArray4[2] = dArray4[2] / d9;
                double[] dArray5 = new double[3];
                double d10 = this.getCosin(dArray4, dArray);
                dArray5[0] = dArray[0] * d10;
                dArray5[1] = dArray[1] * d10;
                dArray5[2] = dArray[2] * d10;
                dArray2 = this.andVector(3, 1.0, dArray4, -1.0, dArray5);
                double d11 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
                if (d11 != 0.0) {
                    dArray3 = this.getCross(dArray, dArray2);
                    double d12 = Math.cos(d);
                    double d13 = Math.sin(d);
                    dArray4 = this.andVector(3, d12, dArray2, d13, dArray3);
                    dArray4 = this.andVector(3, 1.0, dArray4, 1.0, dArray5);
                    this.x = dArray4[0] * d9 + d5;
                    this.y = dArray4[1] * d9 + d6;
                    this.z = dArray4[2] * d9 + d7;
                }
            }
        }
    }

    public void rot(double d, double d2, double d3, double d4) {
        this.rot(d, d2, d3, d4, 0.0, 0.0, 0.0);
    }

    public double getCosin(double[] dArray, double[] dArray2) {
        double d = (dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2]) / (Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]) * Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]));
        return d;
    }

    public double[] getCross(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    public double[] andVector(int n, double d, double[] dArray, double d2, double[] dArray2) {
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = d * dArray[i] + d2 * dArray2[i];
        }
        return dArray3;
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void scalarTime(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public void setLength(double d) {
        double d2 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (d2 != 0.0) {
            this.x *= d / d2;
            this.y *= d / d2;
            this.z *= d / d2;
        }
    }

    public void rot(double d, Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        this.rot(d, vector3DEG.x, vector3DEG.y, vector3DEG.z, vector3DEG2.x, vector3DEG2.y, vector3DEG2.z);
    }

    public void rot(double d, Vector3DEG vector3DEG) {
        this.rot(d, vector3DEG.x, vector3DEG.y, vector3DEG.z);
    }

    public double dot(Vector3DEG vector3DEG) {
        double d = this.x * vector3DEG.x + this.y * vector3DEG.y + this.z * vector3DEG.z;
        return d;
    }

    public Vector3DEG cross(Vector3DEG vector3DEG) {
        Vector3DEG vector3DEG2 = new Vector3DEG();
        vector3DEG2.x = this.y * vector3DEG.z - this.z * vector3DEG.y;
        vector3DEG2.y = this.z * vector3DEG.x - this.x * vector3DEG.z;
        vector3DEG2.z = this.x * vector3DEG.y - this.y * vector3DEG.x;
        return vector3DEG2;
    }

    public void cross(Vector3DEG vector3DEG, Vector3DEG vector3DEG2) {
        vector3DEG2.x = this.y * vector3DEG.z - this.z * vector3DEG.y;
        vector3DEG2.y = this.z * vector3DEG.x - this.x * vector3DEG.z;
        vector3DEG2.z = this.x * vector3DEG.y - this.y * vector3DEG.x;
    }

    public Vector3DEG cpVector() {
        Vector3DEG vector3DEG = new Vector3DEG(this.x, this.y, this.z);
        return vector3DEG;
    }

    public void and(Vector3DEG vector3DEG) {
        this.x += vector3DEG.x;
        this.y += vector3DEG.y;
        this.z += vector3DEG.z;
    }
}

