/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.model;

import java.awt.Color;
import java.awt.Font;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.QuadrangleElement3DEG;

public class AxisModel3DEG
extends Model3DEG {
    private double Lx = 3.0;
    private double Ly = 3.0;
    private double Lz = 3.0;
    private double hx = 1.0;
    private double hy = 1.0;
    private double hz = 1.0;
    private int N = 10;
    private Color xcolor = Color.blue;
    private Color ycolor = Color.green;
    private Color zcolor = Color.red;
    private String xstr = "X";
    private String ystr = "Y";
    private String zstr = "Z";
    private Font font = new Font("serif", 1, 22);

    public AxisModel3DEG() {
        this.element = new QuadrangleElement3DEG[3 * this.N + 3 + 12];
        for (int i = 0; i < 3 * this.N + 3 + 12; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
        this.setEmission(1.0);
    }

    public AxisModel3DEG(int n) {
        this.N = n;
        this.element = new QuadrangleElement3DEG[3 * this.N + 3 + 12];
        for (int i = 0; i < 3 * this.N + 3 + 12; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.setEmission(1.0);
    }

    public AxisModel3DEG(double d, Color color) {
        this.Lx = d;
        this.Ly = d;
        this.Lz = d;
        this.xcolor = color;
        this.xcolor = color;
        this.xcolor = color;
        this.element = new QuadrangleElement3DEG[3 * this.N + 3 + 12];
        for (int i = 0; i < 3 * this.N + 3 + 12; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
        this.setEmission(1.0);
    }

    public AxisModel3DEG(double d, Color color, Color color2, Color color3) {
        this.Lx = d;
        this.Ly = d;
        this.Lz = d;
        this.xcolor = color;
        this.xcolor = color2;
        this.xcolor = color3;
        this.element = new QuadrangleElement3DEG[3 * this.N + 3 + 12];
        for (int i = 0; i < 3 * this.N + 3 + 12; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
        this.setEmission(1.0);
    }

    public void setLength(double d, double d2, double d3) {
        this.Lx = d * 0.8;
        this.Ly = d2 * 0.8;
        this.Lz = d3 * 0.8;
        this.hx = d * 0.2;
        this.hy = d2 * 0.2;
        this.hz = d3 * 0.2;
        this.make();
    }

    public void setLength(double d) {
        this.Lx = d * 0.8;
        this.Ly = d * 0.8;
        this.Lz = d * 0.8;
        this.hx = d * 0.2;
        this.hy = d * 0.2;
        this.hz = d * 0.2;
        this.make();
    }

    @Override
    public void setSize(double[] dArray) {
        if (dArray.length == 1) {
            this.setLength(dArray[0]);
        }
        if (dArray.length == 3) {
            this.setLength(dArray[0], dArray[1], dArray[2]);
        }
    }

    @Override
    public void setText(String[] stringArray) {
        if (stringArray.length == 3) {
            this.setString(stringArray[0], stringArray[1], stringArray[2]);
        }
    }

    public void setString(String[] stringArray) {
        if (stringArray.length == 3) {
            this.setString(stringArray[0], stringArray[1], stringArray[2]);
        }
    }

    public void setColor(Color color, Color color2, Color color3) {
        this.xcolor = color;
        this.ycolor = color2;
        this.zcolor = color3;
        this.make();
    }

    @Override
    public void setColor(Color color) {
        this.xcolor = color;
        this.ycolor = color;
        this.zcolor = color;
        this.make();
    }

    public void setString(String string, String string2, String string3) {
        this.xstr = string;
        this.ystr = string2;
        this.zstr = string3;
        this.make();
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    public void make() {
        int n = this.Line(0, 0.0, 0.0, 0.0, this.Lx, 0.0, 0.0, this.xcolor, this.N);
        n = this.Line(n, 0.0, 0.0, 0.0, 0.0, this.Ly, 0.0, this.ycolor, this.N);
        n = this.Line(n, 0.0, 0.0, 0.0, 0.0, 0.0, this.Lz, this.zcolor, this.N);
        this.element[n].setVertex(this.Lx + this.hx, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.element[n].string = this.xstr;
        this.element[n].type = 5;
        this.element[n].font = this.font;
        this.element[n].color = this.xcolor;
        this.element[++n].setVertex(0.0, this.Ly + this.hy, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.element[n].string = this.ystr;
        this.element[n].type = 5;
        this.element[n].font = this.font;
        this.element[n].color = this.ycolor;
        this.element[++n].setVertex(0.0, 0.0, this.Lz + this.hz, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.element[n].string = this.zstr;
        this.element[n].type = 5;
        this.element[n].font = this.font;
        this.element[n].color = this.zcolor;
        ++n;
        n = this.Tube(n, 0.0, 0.0, this.Lx, 0.0, 0.0, this.Lx + this.hx, this.hx / 7.0, this.hx / 7.0, 0.0, 0.0, this.xcolor, 4, 1, 0, 0, 4, 1);
        this.element[n - 4].rotY(1.57075);
        this.element[n - 3].rotY(1.57075);
        this.element[n - 2].rotY(1.57075);
        this.element[n - 1].rotY(1.57075);
        n = this.Tube(n, 0.0, 0.0, this.Ly, 0.0, 0.0, this.Ly + this.hy, this.hy / 7.0, this.hy / 7.0, 0.0, 0.0, this.ycolor, 4, 1, 0, 0, 4, 1);
        this.element[n - 4].rotX(-1.57075);
        this.element[n - 3].rotX(-1.57075);
        this.element[n - 2].rotX(-1.57075);
        this.element[n - 1].rotX(-1.57075);
        this.Tube(n, 0.0, 0.0, this.Lz, 0.0, 0.0, this.Lz + this.hz, this.hz / 7.0, this.hz / 7.0, 0.0, 0.0, this.zcolor, 4, 1, 0, 0, 4, 1);
    }

    public int Line(int n, double d, double d2, double d3, double d4, double d5, double d6, Color color, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.element[n + i].setVertex((d * (double)i + d4 * (double)(n2 - i)) / (double)n2, (d2 * (double)i + d5 * (double)(n2 - i)) / (double)n2, (d3 * (double)i + d6 * (double)(n2 - i)) / (double)n2, (d * (double)(i + 1) + d4 * (double)(n2 - (i + 1))) / (double)n2, (d2 * (double)(i + 1) + d5 * (double)(n2 - (i + 1))) / (double)n2, (d3 * (double)(i + 1) + d6 * (double)(n2 - (i + 1))) / (double)n2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.element[n + i].color = color;
            this.element[n + i].type = 2;
        }
        return n + n2;
    }

    public int Tube(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double d11 = d6 - d3;
        for (int i = n5; i < n7; ++i) {
            double d12 = d11 * ((double)i / (double)n3);
            double d13 = d11 * (((double)i + 1.0) / (double)n3);
            double d14 = d7 * (1.0 - d12 / d11) + d9 * (d12 / d11);
            double d15 = d7 * (1.0 - d13 / d11) + d9 * (d13 / d11);
            double d16 = d8 * (1.0 - d12 / d11) + d10 * (d12 / d11);
            double d17 = d8 * (1.0 - d13 / d11) + d10 * (d13 / d11);
            double d18 = (1.0 - d12 / d11) * d + d12 / d11 * d4;
            double d19 = (1.0 - d12 / d11) * d2 + d12 / d11 * d5;
            double d20 = (1.0 - d13 / d11) * d + d13 / d11 * d4;
            double d21 = (1.0 - d13 / d11) * d2 + d13 / d11 * d5;
            for (int j = n4; j < n6; ++j) {
                double d22 = 6.2831853 * ((double)j / (double)n2);
                double d23 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray[0] = d14 * Math.cos(d22) + d18;
                dArray[1] = d16 * Math.sin(d22) + d19;
                dArray[2] = d12 + d3;
                dArray2[0] = d14 * Math.cos(d23) + d18;
                dArray2[1] = d16 * Math.sin(d23) + d19;
                dArray2[2] = d12 + d3;
                dArray3[0] = d15 * Math.cos(d23) + d20;
                dArray3[1] = d17 * Math.sin(d23) + d21;
                dArray3[2] = d13 + d3;
                dArray4[0] = d15 * Math.cos(d22) + d20;
                dArray4[1] = d17 * Math.sin(d22) + d21;
                dArray4[2] = d13 + d3;
                if (i == 0 && d7 == 0.0 && d8 == 0.0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2], dArray[0], dArray[1], dArray[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else if (i == n3 - 1 && d9 == 0.0 && d10 == 0.0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray4[0], dArray4[1], dArray4[2], dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }
}

