/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.model;

import java.awt.Color;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.QuadrangleElement3DEG;

public class BoxModel3DEG
extends Model3DEG {
    private double[] LA = new double[]{0.0, 0.0, 0.0};
    private double[] LB = new double[]{0.0, 0.0, 0.0};
    private double[] LC = new double[]{0.0, 0.0, 0.0};
    private double[] LD = new double[]{0.0, 0.0, 0.0};
    private double[] UA = new double[]{0.0, 0.0, 0.0};
    private double[] UB = new double[]{0.0, 0.0, 0.0};
    private double[] UC = new double[]{0.0, 0.0, 0.0};
    private double[] UD = new double[]{0.0, 0.0, 0.0};
    private int N1 = 1;
    private int N2 = 1;
    private int N3 = 1;
    private Color color = Color.lightGray;
    private boolean face = true;

    public BoxModel3DEG() {
        this.element = new Element3DEG[this.N1 * this.N2 * 2 + this.N2 * this.N3 * 2 + this.N3 * this.N1 * 2];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public BoxModel3DEG(int n, int n2) {
        this.N1 = n;
        this.N2 = n2;
        this.element = new Element3DEG[this.N1 * this.N2 * 2 + this.N2 * this.N3 * 2 + this.N3 * this.N1 * 2];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public BoxModel3DEG(int n, int n2, int n3) {
        this.N1 = n;
        this.N2 = n2;
        this.N3 = n3;
        this.element = new Element3DEG[this.N1 * this.N2 * 2 + this.N2 * this.N3 * 2 + this.N3 * this.N1 * 2];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public BoxModel3DEG(double d, double d2, double d3, Color color) {
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2 * 2 + this.N2 * this.N3 * 2 + this.N3 * this.N1 * 2];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.setLowerVertex(0.0, 0.0, 0.0, d, 0.0, 0.0, d, d2, 0.0, 0.0, d2, 0.0);
        this.setUpperVertex(0.0, 0.0, d3, d, 0.0, d3, d, d2, d3, 0.0, d2, d3);
        this.make();
        this.move(-d / 2.0, -d2 / 2.0, -d3 / 2.0);
    }

    public BoxModel3DEG(double d, double d2, double d3, double d4, double d5, Color color) {
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2 * 2 + this.N2 * this.N3 * 2 + this.N3 * this.N1 * 2];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.setLowerVertex(-d, -d2, 0.0, d, -d2, 0.0, d, d2, 0.0, -d, d2, 0.0);
        this.setUpperVertex(-d3, -d4, d5, d3, -d4, d5, d3, d4, d5, -d3, d4, d5);
        this.make();
    }

    public BoxModel3DEG(double d, double d2, double d3, double d4, double d5, double d6, double d7, Color color) {
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2 * 2 + this.N2 * this.N3 * 2 + this.N3 * this.N1 * 2];
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.setLowerVertex(-d, -d2, 0.0, d, -d2, 0.0, d, d2, 0.0, -d, d2, 0.0);
        this.setUpperVertex(-d3 + d5, -d4 + d6, d7, d3 + d5, -d4 + d6, d7, d3 + d5, d4 + d6, d7, -d3 + d5, d4 + d6, d7);
        this.make();
    }

    @Override
    public void setSize(double[] dArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (dArray.length == 1) {
            d5 = dArray[0];
            d4 = dArray[0];
            d3 = dArray[0];
            this.setLowerVertex(0.0, 0.0, 0.0, d5, 0.0, 0.0, d5, d4, 0.0, 0.0, d4, 0.0);
            this.setUpperVertex(0.0, 0.0, d3, d5, 0.0, d3, d5, d4, d3, 0.0, d4, d3);
            this.make();
            this.move(-d5 / 2.0, -d4 / 2.0, -d3 / 2.0);
        }
        if (dArray.length == 3) {
            d5 = dArray[0];
            d4 = dArray[1];
            d3 = dArray[2];
            this.setLowerVertex(0.0, 0.0, 0.0, d5, 0.0, 0.0, d5, d4, 0.0, 0.0, d4, 0.0);
            this.setUpperVertex(0.0, 0.0, d3, d5, 0.0, d3, d5, d4, d3, 0.0, d4, d3);
            this.make();
            this.move(-d5 / 2.0, -d4 / 2.0, -d3 / 2.0);
        }
        if (dArray.length == 5) {
            d5 = dArray[0];
            d4 = dArray[1];
            d3 = dArray[2];
            d2 = dArray[3];
            d = dArray[4];
            this.setLowerVertex(-d5, -d4, 0.0, d5, -d4, 0.0, d5, d4, 0.0, -d5, d4, 0.0);
            this.setUpperVertex(-d3, -d2, d, d3, -d2, d, d3, d2, d, -d3, d2, d);
            this.make();
        }
        if (dArray.length == 7) {
            d5 = dArray[0];
            d4 = dArray[1];
            d3 = dArray[2];
            d2 = dArray[3];
            d = dArray[4];
            double d6 = dArray[5];
            double d7 = dArray[6];
            this.setLowerVertex(-d5, -d4, 0.0, d5, -d4, 0.0, d5, d4, 0.0, -d5, d4, 0.0);
            this.setUpperVertex(-d3 + d, -d2 + d6, d7, d3 + d, -d2 + d6, d7, d3 + d, d2 + d6, d7, -d3 + d, d2 + d6, d7);
            this.make();
        }
    }

    @Override
    public void setSurface(boolean bl) {
        this.setFace(bl);
    }

    public void setFace(boolean bl) {
        this.face = bl;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setLowerVertex(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.LA[0] = d;
        this.LA[1] = d2;
        this.LA[2] = d3;
        this.LB[0] = d4;
        this.LB[1] = d5;
        this.LB[2] = d6;
        this.LC[0] = d7;
        this.LC[1] = d8;
        this.LC[2] = d9;
        this.LD[0] = d10;
        this.LD[1] = d11;
        this.LD[2] = d12;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setUpperVertex(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.UA[0] = d;
        this.UA[1] = d2;
        this.UA[2] = d3;
        this.UB[0] = d4;
        this.UB[1] = d5;
        this.UB[2] = d6;
        this.UC[0] = d7;
        this.UC[1] = d8;
        this.UC[2] = d9;
        this.UD[0] = d10;
        this.UD[1] = d11;
        this.UD[2] = d12;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i].color = color;
        }
    }

    public void make() {
        int n = this.Quadrangle(0, this.UA[0], this.UA[1], this.UA[2], this.UB[0], this.UB[1], this.UB[2], this.UC[0], this.UC[1], this.UC[2], this.UD[0], this.UD[1], this.UD[2], this.color, this.N1, this.N2);
        n = this.Quadrangle_REV(n, this.LA[0], this.LA[1], this.LA[2], this.LB[0], this.LB[1], this.LB[2], this.LC[0], this.LC[1], this.LC[2], this.LD[0], this.LD[1], this.LD[2], this.color, this.N1, this.N2);
        n = this.Quadrangle(n, this.UB[0], this.UB[1], this.UB[2], this.LB[0], this.LB[1], this.LB[2], this.LC[0], this.LC[1], this.LC[2], this.UC[0], this.UC[1], this.UC[2], this.color, this.N3, this.N2);
        n = this.Quadrangle(n, this.UD[0], this.UD[1], this.UD[2], this.LD[0], this.LD[1], this.LD[2], this.LA[0], this.LA[1], this.LA[2], this.UA[0], this.UA[1], this.UA[2], this.color, this.N3, this.N2);
        n = this.Quadrangle(n, this.UA[0], this.UA[1], this.UA[2], this.LA[0], this.LA[1], this.LA[2], this.LB[0], this.LB[1], this.LB[2], this.UB[0], this.UB[1], this.UB[2], this.color, this.N3, this.N1);
        n = this.Quadrangle(n, this.UC[0], this.UC[1], this.UC[2], this.LC[0], this.LC[1], this.LC[2], this.LD[0], this.LD[1], this.LD[2], this.UD[0], this.UD[1], this.UD[2], this.color, this.N3, this.N1);
    }

    public void make_REV() {
        int n = this.Quadrangle_REV(0, this.UA[0], this.UA[1], this.UA[2], this.UB[0], this.UB[1], this.UB[2], this.UC[0], this.UC[1], this.UC[2], this.UD[0], this.UD[1], this.UD[2], this.color, this.N1, this.N2);
        n = this.Quadrangle(n, this.LA[0], this.LA[1], this.LA[2], this.LB[0], this.LB[1], this.LB[2], this.LC[0], this.LC[1], this.LC[2], this.LD[0], this.LD[1], this.LD[2], this.color, this.N1, this.N2);
        n = this.Quadrangle_REV(n, this.UB[0], this.UB[1], this.UB[2], this.LB[0], this.LB[1], this.LB[2], this.LC[0], this.LC[1], this.LC[2], this.UC[0], this.UC[1], this.UC[2], this.color, this.N3, this.N2);
        n = this.Quadrangle_REV(n, this.UD[0], this.UD[1], this.UD[2], this.LD[0], this.LD[1], this.LD[2], this.LA[0], this.LA[1], this.LA[2], this.UA[0], this.UA[1], this.UA[2], this.color, this.N3, this.N2);
        n = this.Quadrangle_REV(n, this.UA[0], this.UA[1], this.UA[2], this.LA[0], this.LA[1], this.LA[2], this.LB[0], this.LB[1], this.LB[2], this.UB[0], this.UB[1], this.UB[2], this.color, this.N3, this.N1);
        n = this.Quadrangle_REV(n, this.UC[0], this.UC[1], this.UC[2], this.LC[0], this.LC[1], this.LC[2], this.LD[0], this.LD[1], this.LD[2], this.UD[0], this.UD[1], this.UD[2], this.color, this.N3, this.N1);
    }

    public int Quadrangle(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, Color color, int n2, int n3) {
        double[] dArray = new double[]{d, d2, d3};
        double[] dArray2 = new double[]{d4, d5, d6};
        double[] dArray3 = new double[]{d7, d8, d9};
        double[] dArray4 = new double[]{d10, d11, d12};
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4;
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - i) * dArray[n4] + (double)i * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - i) * dArray4[n4] + (double)i * dArray3[n4]) / (double)n2;
                    dArray5[n4] = ((double)(n3 - j) * dArray9[n4] + (double)j * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - (i + 1)) * dArray[n4] + (double)(i + 1) * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - (i + 1)) * dArray4[n4] + (double)(i + 1) * dArray3[n4]) / (double)n2;
                    dArray6[n4] = ((double)(n3 - j) * dArray9[n4] + (double)j * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - (i + 1)) * dArray[n4] + (double)(i + 1) * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - (i + 1)) * dArray4[n4] + (double)(i + 1) * dArray3[n4]) / (double)n2;
                    dArray7[n4] = ((double)(n3 - (j + 1)) * dArray9[n4] + (double)(j + 1) * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - i) * dArray[n4] + (double)i * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - i) * dArray4[n4] + (double)i * dArray3[n4]) / (double)n2;
                    dArray8[n4] = ((double)(n3 - (j + 1)) * dArray9[n4] + (double)(j + 1) * dArray10[n4]) / (double)n3;
                }
                this.element[n + i * n3 + j].setVertex(dArray5[0], dArray5[1], dArray5[2], dArray6[0], dArray6[1], dArray6[2], dArray7[0], dArray7[1], dArray7[2], dArray8[0], dArray8[1], dArray8[2]);
                this.element[n + i * n3 + j].color = color;
                this.element[n + i * n3 + j].type = 4;
            }
        }
        return n + n2 * n3;
    }

    public int Quadrangle_REV(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, Color color, int n2, int n3) {
        double[] dArray = new double[]{d, d2, d3};
        double[] dArray2 = new double[]{d4, d5, d6};
        double[] dArray3 = new double[]{d7, d8, d9};
        double[] dArray4 = new double[]{d10, d11, d12};
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4;
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - i) * dArray[n4] + (double)i * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - i) * dArray4[n4] + (double)i * dArray3[n4]) / (double)n2;
                    dArray5[n4] = ((double)(n3 - j) * dArray9[n4] + (double)j * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - (i + 1)) * dArray[n4] + (double)(i + 1) * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - (i + 1)) * dArray4[n4] + (double)(i + 1) * dArray3[n4]) / (double)n2;
                    dArray6[n4] = ((double)(n3 - j) * dArray9[n4] + (double)j * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - (i + 1)) * dArray[n4] + (double)(i + 1) * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - (i + 1)) * dArray4[n4] + (double)(i + 1) * dArray3[n4]) / (double)n2;
                    dArray7[n4] = ((double)(n3 - (j + 1)) * dArray9[n4] + (double)(j + 1) * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - i) * dArray[n4] + (double)i * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - i) * dArray4[n4] + (double)i * dArray3[n4]) / (double)n2;
                    dArray8[n4] = ((double)(n3 - (j + 1)) * dArray9[n4] + (double)(j + 1) * dArray10[n4]) / (double)n3;
                }
                this.element[n + i * n3 + j].setVertex(dArray5[0], dArray5[1], dArray5[2], dArray8[0], dArray8[1], dArray8[2], dArray7[0], dArray7[1], dArray7[2], dArray6[0], dArray6[1], dArray6[2]);
                this.element[n + i * n3 + j].color = color;
                this.element[n + i * n3 + j].type = 4;
            }
        }
        return n + n2 * n3;
    }
}

