/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.model;

import java.awt.Color;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.QuadrangleElement3DEG;

public class CylinderModel3DEG
extends Model3DEG {
    private double RLx = 1.0;
    private double RLy = 1.0;
    private double RUx = 1.0;
    private double RUy = 1.0;
    private double px = 0.0;
    private double py = 0.0;
    private double pz = 1.0;
    private int N1 = 27;
    private int N2 = 1;
    private int sn1 = 0;
    private int sn2 = 0;
    private int en1 = 27;
    private int en2 = 1;
    private Color color = Color.lightGray;
    private boolean face = true;

    public CylinderModel3DEG() {
        this.element = new Element3DEG[this.N1 * this.N2 + this.N1 + this.N1];
        for (int i = 0; i < this.N1 * this.N2 + this.N1 + this.N1; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
    }

    public CylinderModel3DEG(int n, int n2) {
        this.N1 = n;
        this.N2 = n2;
        this.sn1 = 0;
        this.sn2 = 0;
        this.en1 = n;
        this.en2 = n2;
        this.element = new Element3DEG[this.N1 * this.N2 + this.N1 + this.N1];
        for (int i = 0; i < this.N1 * this.N2 + this.N1 + this.N1; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
    }

    public CylinderModel3DEG(int n, int n2, int n3, int n4, int n5, int n6) {
        this.N1 = n;
        this.N2 = n2;
        this.sn1 = n3;
        this.sn2 = n4;
        this.en1 = n5;
        this.en2 = n6;
        this.element = new QuadrangleElement3DEG[(this.en1 - this.sn1) * (this.en2 - this.sn2) + (this.en1 - this.sn1) + (this.en1 - this.sn1)];
        for (int i = 0; i < (this.en1 - this.sn1) * (this.en2 - this.sn2) + (this.en1 - this.sn1) + (this.en1 - this.sn1); ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
    }

    public CylinderModel3DEG(double d, double d2, Color color) {
        this.RLx = d;
        this.RLy = d;
        this.RUx = d;
        this.RUy = d;
        this.px = 0.0;
        this.py = 0.0;
        this.pz = d2;
        this.color = color;
        this.element = new Element3DEG[(this.en1 - this.sn1) * (this.en2 - this.sn2) + (this.en1 - this.sn1) + (this.en1 - this.sn1)];
        for (int i = 0; i < (this.en1 - this.sn1) * (this.en2 - this.sn2) + (this.en1 - this.sn1) + (this.en1 - this.sn1); ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    @Override
    public void setSize(double[] dArray) {
        if (dArray.length == 2) {
            this.RLx = dArray[0];
            this.RLy = dArray[0];
            this.RUx = dArray[0];
            this.RUy = dArray[0];
            this.px = 0.0;
            this.py = 0.0;
            this.pz = dArray[1];
            if (this.face) {
                this.make();
            } else {
                this.make_REV();
            }
        }
        if (dArray.length == 3) {
            this.RLx = dArray[0];
            this.RLy = dArray[1];
            this.RUx = dArray[0];
            this.RUy = dArray[1];
            this.px = 0.0;
            this.py = 0.0;
            this.pz = dArray[2];
            if (this.face) {
                this.make();
            } else {
                this.make_REV();
            }
        }
        if (dArray.length == 5) {
            this.RLx = dArray[0];
            this.RLy = dArray[1];
            this.RUx = dArray[2];
            this.RUy = dArray[3];
            this.px = 0.0;
            this.py = 0.0;
            this.pz = dArray[4];
            if (this.face) {
                this.make();
            } else {
                this.make_REV();
            }
        }
        if (dArray.length == 7) {
            this.RLx = dArray[0];
            this.RLy = dArray[1];
            this.RUx = dArray[2];
            this.RUy = dArray[3];
            this.px = dArray[4];
            this.py = dArray[5];
            this.pz = dArray[6];
            if (this.face) {
                this.make();
            } else {
                this.make_REV();
            }
        }
    }

    @Override
    public void setSurface(boolean bl) {
        this.setFace(bl);
    }

    public void setFace(boolean bl) {
        this.face = bl;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setRadius(double d) {
        this.RLx = d;
        this.RLy = d;
        this.RUx = d;
        this.RUy = d;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setRadius(double d, double d2) {
        this.RUx = d;
        this.RUy = d2;
        this.RLx = d;
        this.RLy = d2;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setRadius(double d, double d2, double d3, double d4) {
        this.RUx = d3;
        this.RUy = d4;
        this.RLx = d;
        this.RLy = d2;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setUpperRadius(double d, double d2) {
        this.RUx = d;
        this.RUy = d2;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setLowerRadius(double d, double d2) {
        this.RLx = d;
        this.RLy = d2;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setHeight(double d) {
        this.px = 0.0;
        this.py = 0.0;
        this.pz = d;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setUpperCenter(double d, double d2, double d3) {
        this.px = d;
        this.py = d2;
        this.pz = d3;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i].color = color;
        }
    }

    public void make() {
        int n = this.Tube(0, 0.0, 0.0, 0.0, this.px, this.py, this.pz, this.RLx, this.RLy, this.RUx, this.RUy, this.color, this.N1, this.N2, this.sn1, this.sn2, this.en1, this.en2);
        n = this.Circle(n, this.px, this.py, this.pz, this.RUx, this.RUy, this.color, this.N1, 1, this.sn1, 0, this.en1, 1);
        this.Circle_REV(n, 0.0, 0.0, 0.0, this.RLx, this.RLy, this.color, this.N1, 1, this.sn1, 0, this.en1, 1);
    }

    public void make_REV() {
        int n = this.Tube_REV(0, 0.0, 0.0, 0.0, this.px, this.py, this.pz, this.RLx, this.RLy, this.RUx, this.RUy, this.color, this.N1, this.N2, this.sn1, this.sn2, this.en1, this.en2);
        n = this.Circle_REV(n, this.px, this.py, this.pz, this.RUx, this.RUy, this.color, this.N1, 1, this.sn1, 0, this.en1, 1);
        this.Circle(n, 0.0, 0.0, 0.0, this.RLx, this.RLy, this.color, this.N1, 1, this.sn1, 0, this.en1, 1);
    }

    public int Tube(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double d11 = d6 - d3;
        for (int i = n5; i < n7; ++i) {
            double d12 = d11 * ((double)i / (double)n3);
            double d13 = d11 * (((double)i + 1.0) / (double)n3);
            double d14 = d7 * (1.0 - d12 / d11) + d9 * (d12 / d11);
            double d15 = d7 * (1.0 - d13 / d11) + d9 * (d13 / d11);
            double d16 = d8 * (1.0 - d12 / d11) + d10 * (d12 / d11);
            double d17 = d8 * (1.0 - d13 / d11) + d10 * (d13 / d11);
            double d18 = (1.0 - d12 / d11) * d + d12 / d11 * d4;
            double d19 = (1.0 - d12 / d11) * d2 + d12 / d11 * d5;
            double d20 = (1.0 - d13 / d11) * d + d13 / d11 * d4;
            double d21 = (1.0 - d13 / d11) * d2 + d13 / d11 * d5;
            for (int j = n4; j < n6; ++j) {
                double d22 = 6.2831853 * ((double)j / (double)n2);
                double d23 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray[0] = d14 * Math.cos(d22) + d18;
                dArray[1] = d16 * Math.sin(d22) + d19;
                dArray[2] = d12 + d3;
                dArray2[0] = d14 * Math.cos(d23) + d18;
                dArray2[1] = d16 * Math.sin(d23) + d19;
                dArray2[2] = d12 + d3;
                dArray3[0] = d15 * Math.cos(d23) + d20;
                dArray3[1] = d17 * Math.sin(d23) + d21;
                dArray3[2] = d13 + d3;
                dArray4[0] = d15 * Math.cos(d22) + d20;
                dArray4[1] = d17 * Math.sin(d22) + d21;
                dArray4[2] = d13 + d3;
                if (i == 0 && d7 == 0.0 && d8 == 0.0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2], dArray[0], dArray[1], dArray[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else if (i == n3 - 1 && d9 == 0.0 && d10 == 0.0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray4[0], dArray4[1], dArray4[2], dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }

    public int Tube_REV(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double d11 = d6 - d3;
        for (int i = n5; i < n7; ++i) {
            double d12 = d11 * ((double)i / (double)n3);
            double d13 = d11 * (((double)i + 1.0) / (double)n3);
            double d14 = d7 * (1.0 - d12 / d11) + d9 * (d12 / d11);
            double d15 = d7 * (1.0 - d13 / d11) + d9 * (d13 / d11);
            double d16 = d8 * (1.0 - d12 / d11) + d10 * (d12 / d11);
            double d17 = d8 * (1.0 - d13 / d11) + d10 * (d13 / d11);
            double d18 = (1.0 - d12 / d11) * d + d12 / d11 * d4;
            double d19 = (1.0 - d12 / d11) * d2 + d12 / d11 * d5;
            double d20 = (1.0 - d13 / d11) * d + d13 / d11 * d4;
            double d21 = (1.0 - d13 / d11) * d2 + d13 / d11 * d5;
            for (int j = n4; j < n6; ++j) {
                double d22 = 6.2831853 * ((double)j / (double)n2);
                double d23 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray[0] = d14 * Math.cos(d22) + d18;
                dArray[1] = d16 * Math.sin(d22) + d19;
                dArray[2] = d12 + d3;
                dArray2[0] = d14 * Math.cos(d23) + d18;
                dArray2[1] = d16 * Math.sin(d23) + d19;
                dArray2[2] = d12 + d3;
                dArray3[0] = d15 * Math.cos(d23) + d20;
                dArray3[1] = d17 * Math.sin(d23) + d21;
                dArray3[2] = d13 + d3;
                dArray4[0] = d15 * Math.cos(d22) + d20;
                dArray4[1] = d17 * Math.sin(d22) + d21;
                dArray4[2] = d13 + d3;
                if (i == 0 && d7 == 0.0 && d8 == 0.0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray[0], dArray[1], dArray[2], dArray4[0], dArray4[1], dArray4[2], dArray3[0], dArray3[1], dArray3[2], dArray2[0], dArray2[1], dArray2[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else if (i == n3 - 1 && d9 == 0.0 && d10 == 0.0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray3[0], dArray3[1], dArray3[2], dArray2[0], dArray2[1], dArray2[2], dArray[0], dArray[1], dArray[2], dArray4[0], dArray4[1], dArray4[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray[0], dArray[1], dArray[2], dArray4[0], dArray4[1], dArray4[2], dArray3[0], dArray3[1], dArray3[2], dArray2[0], dArray2[1], dArray2[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }

    public int Circle(int n, double d, double d2, double d3, double d4, double d5, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = n5; i < n7; ++i) {
            double d6 = d4 * ((double)i / (double)n3);
            double d7 = d4 * (((double)i + 1.0) / (double)n3);
            double d8 = d5 * ((double)i / (double)n3);
            double d9 = d5 * (((double)i + 1.0) / (double)n3);
            for (int j = n4; j < n6; ++j) {
                double d10 = 6.2831853 * ((double)j / (double)n2);
                double d11 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray[0] = d6 * Math.cos(d10) + d;
                dArray[1] = d8 * Math.sin(d10) + d2;
                dArray[2] = d3;
                dArray2[0] = d6 * Math.cos(d11) + d;
                dArray2[1] = d8 * Math.sin(d11) + d2;
                dArray2[2] = d3;
                dArray3[0] = d7 * Math.cos(d11) + d;
                dArray3[1] = d9 * Math.sin(d11) + d2;
                dArray3[2] = d3;
                dArray4[0] = d7 * Math.cos(d10) + d;
                dArray4[1] = d9 * Math.sin(d10) + d2;
                dArray4[2] = d3;
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray2[0], dArray2[1], dArray2[2], dArray[0], dArray[1], dArray[2], dArray4[0], dArray4[1], dArray4[2], dArray3[0], dArray3[1], dArray3[2]);
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
                if (i == 0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray2[0], dArray2[1], dArray2[2], dArray4[0], dArray4[1], dArray4[2], dArray3[0], dArray3[1], dArray3[2], dArray3[0], dArray3[1], dArray3[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                    continue;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }

    public int Circle_REV(int n, double d, double d2, double d3, double d4, double d5, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = n5; i < n7; ++i) {
            double d6 = d4 * ((double)i / (double)n3);
            double d7 = d4 * (((double)i + 1.0) / (double)n3);
            double d8 = d5 * ((double)i / (double)n3);
            double d9 = d5 * (((double)i + 1.0) / (double)n3);
            for (int j = n4; j < n6; ++j) {
                double d10 = 6.2831853 * ((double)j / (double)n2);
                double d11 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray[0] = d6 * Math.cos(d10) + d;
                dArray[1] = d8 * Math.sin(d10) + d2;
                dArray[2] = d3;
                dArray2[0] = d6 * Math.cos(d11) + d;
                dArray2[1] = d8 * Math.sin(d11) + d2;
                dArray2[2] = d3;
                dArray3[0] = d7 * Math.cos(d11) + d;
                dArray3[1] = d9 * Math.sin(d11) + d2;
                dArray3[2] = d3;
                dArray4[0] = d7 * Math.cos(d10) + d;
                dArray4[1] = d9 * Math.sin(d10) + d2;
                dArray4[2] = d3;
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2], dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2]);
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
                if (i == 0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2], dArray2[0], dArray2[1], dArray2[2], dArray2[0], dArray2[1], dArray2[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                    continue;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }
}

