/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.model;

import java.awt.Color;
import java.awt.Font;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.FixedSizeStringElement3DEG;
import rxvesapi.system3d.renderer.LineElement3DEG;

public class ScaleDisplayModel3DEG
extends Model3DEG {
    private Color color = Color.blue;
    private double xMax = 5.0;
    private double yMax = 5.0;
    private double zMax = 5.0;
    private double xMin = 0.0;
    private double yMin = 0.0;
    private double zMin = 0.0;
    private int xN = 5;
    private int yN = 5;
    private int zN = 5;

    public ScaleDisplayModel3DEG() {
        int n;
        this.element = new Element3DEG[120 + this.xN + this.yN + this.zN + 3];
        for (n = 0; n < 120; ++n) {
            this.element[n] = new LineElement3DEG(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, this.color);
        }
        for (n = 120; n < this.element.length; ++n) {
            this.element[n] = new FixedSizeStringElement3DEG(0.0, 0.0, 0.0, "___no data", new Font("Serif", 0, 14), this.color);
        }
        this.make();
    }

    public ScaleDisplayModel3DEG(int n, int n2, int n3) {
        int n4;
        this.element = new Element3DEG[120 + n + n2 + n3 + 3];
        for (n4 = 0; n4 < 120; ++n4) {
            this.element[n4] = new LineElement3DEG(0.0, 0.0, 0.0, 1.0, 1.0, 1.0, this.color);
        }
        for (n4 = 120; n4 < this.element.length; ++n4) {
            this.element[n4] = new FixedSizeStringElement3DEG(0.0, 0.0, 0.0, "___no data", new Font("Serif", 0, 14), this.color);
        }
        this.make();
    }

    public ScaleDisplayModel3DEG(double d, double d2, double d3, double d4, double d5, double d6, Color color) {
        this.xMax = d;
        this.yMax = d3;
        this.zMax = d5;
        this.xMin = d2;
        this.yMin = d4;
        this.zMin = d6;
        this.color = color;
        this.make();
    }

    public void setRange(double d, double d2, double d3, double d4, double d5, double d6) {
        this.xMax = d;
        this.yMax = d3;
        this.zMax = d5;
        this.xMin = d2;
        this.yMin = d4;
        this.zMin = d6;
        this.make();
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i].setColor(this.color);
        }
    }

    private void make() {
        BigDecimal bigDecimal;
        int n;
        int n2;
        int n3 = 0;
        double d = (this.xMax - this.xMin) * 0.1;
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMin + d * (double)n2, this.yMin, this.zMin, this.xMin + d * (double)(n2 + 1), this.yMin, this.zMin, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMin + d * (double)n2, this.yMax, this.zMin, this.xMin + d * (double)(n2 + 1), this.yMax, this.zMin, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMin + d * (double)n2, this.yMin, this.zMax, this.xMin + d * (double)(n2 + 1), this.yMin, this.zMax, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMin + d * (double)n2, this.yMax, this.zMax, this.xMin + d * (double)(n2 + 1), this.yMax, this.zMax, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        d = (this.yMax - this.yMin) * 0.1;
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMin, this.yMin + d * (double)n2, this.zMin, this.xMin, this.yMin + d * (double)(n2 + 1), this.zMin, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMax, this.yMin + d * (double)n2, this.zMin, this.xMax, this.yMin + d * (double)(n2 + 1), this.zMin, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMin, this.yMin + d * (double)n2, this.zMax, this.xMin, this.yMin + d * (double)(n2 + 1), this.zMax, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMax, this.yMin + d * (double)n2, this.zMax, this.xMax, this.yMin + d * (double)(n2 + 1), this.zMax, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        d = (this.zMax - this.zMin) * 0.1;
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMin, this.yMin, this.zMin + d * (double)n2, this.xMin, this.yMin, this.zMin + d * (double)(n2 + 1), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMax, this.yMin, this.zMin + d * (double)n2, this.xMax, this.yMin, this.zMin + d * (double)(n2 + 1), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMin, this.yMax, this.zMin + d * (double)n2, this.xMin, this.yMax, this.zMin + d * (double)(n2 + 1), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        for (n2 = 0; n2 < 10; ++n2) {
            this.element[n3].setVertex(this.xMax, this.yMax, this.zMin + d * (double)n2, this.xMax, this.yMax, this.zMin + d * (double)(n2 + 1), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            ++n3;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        d = (this.xMax - this.xMin) / (double)(this.xN - 1);
        for (n = 0; n < this.xN; ++n) {
            double d2 = this.xMin + d * (double)n;
            bigDecimal = new BigDecimal(d2);
            d2 = Double.parseDouble(decimalFormat.format(bigDecimal.doubleValue()));
            this.element[n3].setVertex(this.xMin + d * (double)n, this.yMin, this.zMin);
            this.element[n3].setString("__" + d2);
            ++n3;
        }
        this.element[n3].setVertex(this.xMax + d * 0.3, this.yMin, this.zMin);
        this.element[n3].setString("X");
        ++n3;
        d = (this.yMax - this.yMin) / (double)(this.yN - 1);
        for (n = 0; n < this.yN; ++n) {
            double d3 = this.yMin + d * (double)n;
            bigDecimal = new BigDecimal(d3);
            d3 = Double.parseDouble(decimalFormat.format(bigDecimal.doubleValue()));
            this.element[n3].setVertex(this.xMin, this.yMin + d * (double)n, this.zMin);
            this.element[n3].setString("__" + d3);
            if (n == 0) {
                this.element[n3].move(0.0, 0.0, -d * 0.14);
            }
            ++n3;
        }
        this.element[n3].setVertex(this.xMin, this.yMax + d * 0.3, this.zMin);
        this.element[n3].setString("Y");
        ++n3;
        d = (this.zMax - this.zMin) / (double)(this.zN - 1);
        for (n = 0; n < this.zN; ++n) {
            double d4 = this.zMin + d * (double)n;
            bigDecimal = new BigDecimal(d4);
            d4 = Double.parseDouble(decimalFormat.format(bigDecimal.doubleValue()));
            this.element[n3].setVertex(this.xMin, this.yMin, this.zMin + d * (double)n);
            this.element[n3].setString("__" + d4);
            if (n == 0) {
                this.element[n3].move(0.0, 0.0, -d * 0.28);
            }
            ++n3;
        }
        this.element[n3].setVertex(this.xMin, this.yMin, this.zMax + d * 0.3);
        this.element[n3].setString("Z");
        ++n3;
    }
}

