/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.model;

import java.awt.Color;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.QuadrangleElement3DEG;

public class SphereModel3DEG
extends Model3DEG {
    private double Rx;
    private double Ry;
    private double Rz;
    private int N1 = 10;
    private int N2 = 7;
    private int sn1 = 0;
    private int sn2 = 0;
    private int en1 = 10;
    private int en2 = 7;
    private Color color = Color.lightGray;
    private boolean face = true;

    public SphereModel3DEG() {
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public SphereModel3DEG(int n, int n2) {
        this.N1 = n;
        this.N2 = n2;
        this.sn1 = 0;
        this.sn2 = 0;
        this.en1 = n;
        this.en2 = n2;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public SphereModel3DEG(int n, int n2, int n3, int n4, int n5, int n6) {
        this.N1 = n;
        this.N2 = n2;
        this.sn1 = n3;
        this.sn2 = n4;
        this.en1 = n5;
        this.en2 = n6;
        this.element = new QuadrangleElement3DEG[(this.en1 - this.sn1) * (this.en2 - this.sn2)];
        for (int i = 0; i < (this.en1 - this.sn1) * (this.en2 - this.sn2); ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public SphereModel3DEG(double d, double d2, double d3, Color color) {
        this.Rx = d;
        this.Ry = d2;
        this.Rz = d3;
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public SphereModel3DEG(double d, Color color) {
        this.Rx = d;
        this.Ry = d;
        this.Rz = d;
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    @Override
    public void setSurface(boolean bl) {
        this.setFace(bl);
    }

    public void setFace(boolean bl) {
        this.face = bl;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setRadius(double d) {
        this.Rx = d;
        this.Ry = d;
        this.Rz = d;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setRadius(double d, double d2, double d3) {
        this.Rx = d;
        this.Ry = d2;
        this.Rz = d3;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (int i = 0; i < (this.en1 - this.sn1) * (this.en2 - this.sn2); ++i) {
            this.element[i].color = color;
        }
    }

    @Override
    public void setSize(double[] dArray) {
        if (dArray.length == 1) {
            this.setRadius(dArray[0]);
        }
        if (dArray.length == 3) {
            this.setRadius(dArray[0], dArray[1], dArray[2]);
        }
    }

    public void make() {
        this.Sphere(0, 0.0, 0.0, 0.0, this.Rx, this.Ry, this.Rz, this.color, this.N1, this.N2, this.sn1, this.sn2, this.en1, this.en2);
    }

    public void make_REV() {
        this.Sphere_REV(0, 0.0, 0.0, 0.0, this.Rx, this.Ry, this.Rz, this.color, this.N1, this.N2, this.sn1, this.sn2, this.en1, this.en2);
    }

    public int Sphere(int n, double d, double d2, double d3, double d4, double d5, double d6, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = n5; i < n7; ++i) {
            double d7 = 3.14159265 * ((double)i / (double)n3);
            double d8 = 3.14159265 * (((double)i + 1.0) / (double)n3);
            for (int j = n4; j < n6; ++j) {
                double d9 = 6.2831853 * ((double)j / (double)n2);
                double d10 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray4[0] = d4 * Math.sin(d7) * Math.cos(d9) + d;
                dArray4[1] = d5 * Math.sin(d7) * Math.sin(d9) + d2;
                dArray4[2] = d6 * Math.cos(d7) + d3;
                dArray3[0] = d4 * Math.sin(d7) * Math.cos(d10) + d;
                dArray3[1] = d5 * Math.sin(d7) * Math.sin(d10) + d2;
                dArray3[2] = d6 * Math.cos(d7) + d3;
                dArray[0] = d4 * Math.sin(d8) * Math.cos(d9) + d;
                dArray[1] = d5 * Math.sin(d8) * Math.sin(d9) + d2;
                dArray[2] = d6 * Math.cos(d8) + d3;
                dArray2[0] = d4 * Math.sin(d8) * Math.cos(d10) + d;
                dArray2[1] = d5 * Math.sin(d8) * Math.sin(d10) + d2;
                dArray2[2] = d6 * Math.cos(d8) + d3;
                if (i == 0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray4[0], dArray4[1], dArray4[2], dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else if (i == n3 - 1) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2], dArray[0], dArray[1], dArray[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2], dArray3[0], dArray3[1], dArray3[2], dArray4[0], dArray4[1], dArray4[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }

    public int Sphere_REV(int n, double d, double d2, double d3, double d4, double d5, double d6, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        for (int i = n5; i < n7; ++i) {
            double d7 = 3.14159265 * ((double)i / (double)n3);
            double d8 = 3.14159265 * (((double)i + 1.0) / (double)n3);
            for (int j = n4; j < n6; ++j) {
                double d9 = 6.2831853 * ((double)j / (double)n2);
                double d10 = 6.2831853 * (((double)j + 1.0) / (double)n2);
                dArray4[0] = d4 * Math.sin(d7) * Math.cos(d9) + d;
                dArray4[1] = d5 * Math.sin(d7) * Math.sin(d9) + d2;
                dArray4[2] = d6 * Math.cos(d7) + d3;
                dArray3[0] = d4 * Math.sin(d7) * Math.cos(d10) + d;
                dArray3[1] = d5 * Math.sin(d7) * Math.sin(d10) + d2;
                dArray3[2] = d6 * Math.cos(d7) + d3;
                dArray[0] = d4 * Math.sin(d8) * Math.cos(d9) + d;
                dArray[1] = d5 * Math.sin(d8) * Math.sin(d9) + d2;
                dArray[2] = d6 * Math.cos(d8) + d3;
                dArray2[0] = d4 * Math.sin(d8) * Math.cos(d10) + d;
                dArray2[1] = d5 * Math.sin(d8) * Math.sin(d10) + d2;
                dArray2[2] = d6 * Math.cos(d8) + d3;
                if (i == 0) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray3[0], dArray3[1], dArray3[2], dArray2[0], dArray2[1], dArray2[2], dArray[0], dArray[1], dArray[2], dArray4[0], dArray4[1], dArray4[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else if (i == n3 - 1) {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray[0], dArray[1], dArray[2], dArray4[0], dArray4[1], dArray4[2], dArray3[0], dArray3[1], dArray3[2], dArray2[0], dArray2[1], dArray2[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 3;
                } else {
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].setVertex(dArray[0], dArray[1], dArray[2], dArray4[0], dArray4[1], dArray4[2], dArray3[0], dArray3[1], dArray3[2], dArray2[0], dArray2[1], dArray2[2]);
                    this.element[n + (i - n5) * (n6 - n4) + (j - n4)].type = 4;
                }
                this.element[n + (i - n5) * (n6 - n4) + (j - n4)].color = color;
            }
        }
        return n + (n7 - n5) * (n6 - n4);
    }
}

