/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.model;

import java.awt.Color;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.LineElement3DEG;

public class SuperLineModel3DEG
extends Model3DEG {
    private double Sx;
    private double Sy;
    private double Sz;
    private double Ex;
    private double Ey;
    private double Ez;
    private int N = 10;
    private Color color = Color.lightGray;

    public SuperLineModel3DEG() {
        this.element = new Element3DEG[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.element[i] = new LineElement3DEG();
        }
        this.make();
    }

    public SuperLineModel3DEG(int n) {
        this.N = n;
        this.element = new Element3DEG[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.element[i] = new LineElement3DEG();
        }
        this.make();
    }

    public SuperLineModel3DEG(double d, double d2, double d3, double d4, double d5, double d6, Color color) {
        this.Ex = d4;
        this.Ey = d5;
        this.Ez = d6;
        this.Sx = d;
        this.Sy = d2;
        this.Sz = d3;
        this.color = color;
        this.element = new LineElement3DEG[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.element[i] = new LineElement3DEG();
        }
        this.make();
    }

    public SuperLineModel3DEG(double d, double d2, double d3, double d4, double d5, double d6, Color color, int n) {
        this.N = n;
        this.Ex = d4;
        this.Ey = d5;
        this.Ez = d6;
        this.Sx = d;
        this.Sy = d2;
        this.Sz = d3;
        this.color = color;
        this.element = new LineElement3DEG[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.element[i] = new LineElement3DEG();
        }
        this.make();
    }

    public void setStart(double d, double d2, double d3) {
        this.Sx = d;
        this.Sy = d2;
        this.Sz = d3;
        this.make();
    }

    public void setEnd(double d, double d2, double d3) {
        this.Ex = d;
        this.Ey = d2;
        this.Ez = d3;
        this.make();
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (int i = 0; i < this.N; ++i) {
            this.element[i].color = color;
        }
    }

    public void make() {
        this.Line(0, this.Sx, this.Sy, this.Sz, this.Ex, this.Ey, this.Ez, this.color, this.N);
    }

    public int Line(int n, double d, double d2, double d3, double d4, double d5, double d6, Color color, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.element[n + i].setVertex((d * (double)i + d4 * (double)(n2 - i)) / (double)n2, (d2 * (double)i + d5 * (double)(n2 - i)) / (double)n2, (d3 * (double)i + d6 * (double)(n2 - i)) / (double)n2, (d * (double)(i + 1) + d4 * (double)(n2 - (i + 1))) / (double)n2, (d2 * (double)(i + 1) + d5 * (double)(n2 - (i + 1))) / (double)n2, (d3 * (double)(i + 1) + d6 * (double)(n2 - (i + 1))) / (double)n2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.element[n + i].color = color;
            this.element[n + i].type = 2;
        }
        return n + n2;
    }
}

