/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.model;

import java.awt.Color;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.renderer.QuadrangleElement3DEG;

public class SuperQuadrangleModel3DEG
extends Model3DEG {
    private double[] A = new double[]{0.0, 0.0, 0.0};
    private double[] B = new double[]{0.0, 0.0, 0.0};
    private double[] C = new double[]{0.0, 0.0, 0.0};
    private double[] D = new double[]{0.0, 0.0, 0.0};
    private int N1 = 3;
    private int N2 = 3;
    private Color color = Color.lightGray;
    private boolean face = true;

    public SuperQuadrangleModel3DEG() {
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public SuperQuadrangleModel3DEG(int n, int n2) {
        this.N1 = n;
        this.N2 = n2;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.make();
    }

    public SuperQuadrangleModel3DEG(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, Color color, int n, int n2) {
        this.N1 = n;
        this.N2 = n2;
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.setVertex(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        this.make();
    }

    public SuperQuadrangleModel3DEG(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, Color color) {
        this.color = color;
        this.element = new Element3DEG[this.N1 * this.N2];
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i] = new QuadrangleElement3DEG();
        }
        this.setVertex(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        this.make();
    }

    public void setFace(boolean bl) {
        this.face = bl;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    public void setVertex(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        this.A[0] = d;
        this.A[1] = d2;
        this.A[2] = d3;
        this.B[0] = d4;
        this.B[1] = d5;
        this.B[2] = d6;
        this.C[0] = d7;
        this.C[1] = d8;
        this.C[2] = d9;
        this.D[0] = d10;
        this.D[1] = d11;
        this.D[2] = d12;
        if (this.face) {
            this.make();
        } else {
            this.make_REV();
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (int i = 0; i < this.N1 * this.N2; ++i) {
            this.element[i].color = color;
        }
    }

    public void make() {
        this.Quadrangle(0, this.A[0], this.A[1], this.A[2], this.B[0], this.B[1], this.B[2], this.C[0], this.C[1], this.C[2], this.D[0], this.D[1], this.D[2], this.color, this.N1, this.N2);
    }

    public void make_REV() {
        this.Quadrangle_REV(0, this.A[0], this.A[1], this.A[2], this.B[0], this.B[1], this.B[2], this.C[0], this.C[1], this.C[2], this.D[0], this.D[1], this.D[2], this.color, this.N1, this.N2);
    }

    public int Quadrangle(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, Color color, int n2, int n3) {
        double[] dArray = new double[]{d, d2, d3};
        double[] dArray2 = new double[]{d4, d5, d6};
        double[] dArray3 = new double[]{d7, d8, d9};
        double[] dArray4 = new double[]{d10, d11, d12};
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4;
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - i) * dArray[n4] + (double)i * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - i) * dArray4[n4] + (double)i * dArray3[n4]) / (double)n2;
                    dArray5[n4] = ((double)(n3 - j) * dArray9[n4] + (double)j * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - (i + 1)) * dArray[n4] + (double)(i + 1) * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - (i + 1)) * dArray4[n4] + (double)(i + 1) * dArray3[n4]) / (double)n2;
                    dArray6[n4] = ((double)(n3 - j) * dArray9[n4] + (double)j * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - (i + 1)) * dArray[n4] + (double)(i + 1) * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - (i + 1)) * dArray4[n4] + (double)(i + 1) * dArray3[n4]) / (double)n2;
                    dArray7[n4] = ((double)(n3 - (j + 1)) * dArray9[n4] + (double)(j + 1) * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - i) * dArray[n4] + (double)i * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - i) * dArray4[n4] + (double)i * dArray3[n4]) / (double)n2;
                    dArray8[n4] = ((double)(n3 - (j + 1)) * dArray9[n4] + (double)(j + 1) * dArray10[n4]) / (double)n3;
                }
                this.element[n + i * n3 + j].setVertex(dArray5[0], dArray5[1], dArray5[2], dArray6[0], dArray6[1], dArray6[2], dArray7[0], dArray7[1], dArray7[2], dArray8[0], dArray8[1], dArray8[2]);
                this.element[n + i * n3 + j].color = color;
                this.element[n + i * n3 + j].type = 4;
            }
        }
        return n + n2 * n3;
    }

    public int Quadrangle_REV(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, Color color, int n2, int n3) {
        double[] dArray = new double[]{d, d2, d3};
        double[] dArray2 = new double[]{d4, d5, d6};
        double[] dArray3 = new double[]{d7, d8, d9};
        double[] dArray4 = new double[]{d10, d11, d12};
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4;
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - i) * dArray[n4] + (double)i * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - i) * dArray4[n4] + (double)i * dArray3[n4]) / (double)n2;
                    dArray5[n4] = ((double)(n3 - j) * dArray9[n4] + (double)j * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - (i + 1)) * dArray[n4] + (double)(i + 1) * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - (i + 1)) * dArray4[n4] + (double)(i + 1) * dArray3[n4]) / (double)n2;
                    dArray6[n4] = ((double)(n3 - j) * dArray9[n4] + (double)j * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - (i + 1)) * dArray[n4] + (double)(i + 1) * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - (i + 1)) * dArray4[n4] + (double)(i + 1) * dArray3[n4]) / (double)n2;
                    dArray7[n4] = ((double)(n3 - (j + 1)) * dArray9[n4] + (double)(j + 1) * dArray10[n4]) / (double)n3;
                }
                for (n4 = 0; n4 < 3; ++n4) {
                    dArray9[n4] = ((double)(n2 - i) * dArray[n4] + (double)i * dArray2[n4]) / (double)n2;
                    dArray10[n4] = ((double)(n2 - i) * dArray4[n4] + (double)i * dArray3[n4]) / (double)n2;
                    dArray8[n4] = ((double)(n3 - (j + 1)) * dArray9[n4] + (double)(j + 1) * dArray10[n4]) / (double)n3;
                }
                this.element[n + i * n3 + j].setVertex(dArray5[0], dArray5[1], dArray5[2], dArray8[0], dArray8[1], dArray8[2], dArray7[0], dArray7[1], dArray7[2], dArray6[0], dArray6[1], dArray6[2]);
                this.element[n + i * n3 + j].color = color;
                this.element[n + i * n3 + j].type = 4;
            }
        }
        return n + n2 * n3;
    }
}

