/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rxvesapi.system3d.geometry.CoordinateSystem3DEG;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.geometry.Structure3DEG;
import rxvesapi.system3d.geometry.Vector3DEG;
import rxvesapi.system3d.renderer.AmbientLightElement3DEG;
import rxvesapi.system3d.renderer.LightElement3DEG;
import rxvesapi.system3d.renderer.Realtime3DScreenRefreshEvent;
import rxvesapi.system3d.renderer.Realtime3DScreenRefreshListener;
import rxvesapi.system3d.renderer.ScreenSystem3DEG;

public class Realtime3DPanel
extends JPanel
implements Runnable,
MouseListener,
ComponentListener,
MouseMotionListener,
MouseWheelListener {
    public ScreenSystem3DEG screen;
    public CoordinateSystem3DEG world;
    public static int IDLE_MODE = -1;
    public static int SEMI_IDLE_MODE = 0;
    public static int SEMI_REALTIME_MODE = 1;
    public static int REALTIME_MODE = 2;
    public static int ZERO_LIMITER_MODE = 3;
    public static int WIRE_FRAME_MODE = 0;
    public static int FLAT_SHADING_MODE = 1;
    private double[] sunDirection = new double[]{-70.0, -81.0, 43.0};
    private double sunlightness = 0.5;
    private LightElement3DEG theSun;
    private int processMode = 2;
    private int shadingMode = 1;
    private boolean informationDisplay;
    private double rotLimit = 200.0;
    private double dragSpeed = 0.015;
    Thread th = null;
    private double Xcenter = 0.0;
    private double Ycenter = 0.0;
    private double Xclip = 1.0;
    private double Yclip = 1.0;
    private int mouseDraggingInt = 0;
    private int systemEnable = 0;
    private int cursorOn = 0;
    private int cursorX = 0;
    private int cursorY = 0;
    private int wait_Idle = 25;
    private int wait_Busy = 5;
    private int FrameWaitLimiter = 5;
    private Font debugFont = new Font("Serif", 1, 14);
    private double targetedFrameRate = 30.0;
    private int targetedFrameCycle = 33;
    private double measuredFrameRate = 0.0;
    private int measuredFrameCycle = 33;
    private long repaintStartTime = 0L;
    private long repaintEndTime = 0L;
    private boolean repaintRequestFrag = false;
    private Dimension frameDim = new Dimension();
    public JFrame frame;
    private boolean shiftKeyPressing = false;
    private boolean mainRoopFrag = true;
    public Color informationColor = Color.black;
    public int resizeInt = 0;
    int width;
    int height;
    boolean whiteOutFrag = false;
    private Realtime3DScreenRefreshListener[] realtime3DScreenRefreshListener = new Realtime3DScreenRefreshListener[0];
    private Realtime3DScreenRefreshEvent realtime3DScreenRefreshEvent;
    double valueX;
    double valueY;
    int mouse_sx;
    int mouse_sy;
    int mouse_ex;
    int mouse_ey;
    double mouse_dx;
    double mouse_dy;
    double x1;
    double x2;
    double y1;
    double y2;
    double R1;
    double d_r;
    double d_theta;

    public void addRealtime3DScreenRefreshListener(Realtime3DScreenRefreshListener realtime3DScreenRefreshListener) {
        int n;
        int n2 = this.realtime3DScreenRefreshListener.length;
        Realtime3DScreenRefreshListener[] realtime3DScreenRefreshListenerArray = new Realtime3DScreenRefreshListener[n2];
        for (n = 0; n < n2; ++n) {
            realtime3DScreenRefreshListenerArray[n] = this.realtime3DScreenRefreshListener[n];
        }
        this.realtime3DScreenRefreshListener = new Realtime3DScreenRefreshListener[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.realtime3DScreenRefreshListener[n] = realtime3DScreenRefreshListenerArray[n];
        }
        this.realtime3DScreenRefreshListener[n2] = realtime3DScreenRefreshListener;
    }

    public void disposeResource() {
        this.setVisible(false);
        this.mainRoopFrag = false;
        this.th = null;
        this.screen.dispose();
        this.screen = null;
        this.world = null;
        for (int i = 0; i < this.realtime3DScreenRefreshListener.length; ++i) {
            this.realtime3DScreenRefreshListener[i] = null;
        }
    }

    public Realtime3DPanel() {
        this.init();
    }

    public void init() {
        this.setBackground(Color.white);
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.setBounds(0, 0, 690, 540);
        this.setVisible(true);
        this.reSize();
        this.start();
        this.screen = new ScreenSystem3DEG();
        this.world = new CoordinateSystem3DEG();
        this.world.setOrigin(0.0, 0.0, -8.0);
        this.screen.add(this.world);
        this.theSun = new LightElement3DEG(this.sunDirection[0], this.sunDirection[1], this.sunDirection[2], this.sunlightness, Color.white);
        this.world.add(this.theSun);
        this.screen.request(this.theSun);
        AmbientLightElement3DEG ambientLightElement3DEG = new AmbientLightElement3DEG(0.0, 0.0, 0.0, 1.0, Color.white);
        this.world.add(ambientLightElement3DEG);
        this.screen.request(ambientLightElement3DEG);
    }

    public void setScreenCenter(int n, int n2) {
        this.screen.ox = n;
        this.screen.oy = n2;
    }

    public double getFrameRate() {
        return this.targetedFrameRate;
    }

    public void setFrameRate(double d) {
        this.targetedFrameRate = d;
        this.targetedFrameCycle = (int)(1000.0 / d);
        if (this.targetedFrameCycle == 0) {
            this.targetedFrameCycle = 1;
        }
    }

    public double getCurrentPolygonRate() {
        return (double)this.screen.getTotalNumberOfPolygon() * this.measuredFrameRate;
    }

    public int getCurrentNumberOfPolygons() {
        return this.screen.getTotalNumberOfPolygon();
    }

    public double getCurrentFrameRate() {
        return this.measuredFrameRate;
    }

    public int getCurrentFrameWait() {
        return this.wait_Idle;
    }

    public void setProcessMode(int n) {
        this.processMode = n;
    }

    public void setFrameWaitLimiter(int n) {
        this.FrameWaitLimiter = n;
    }

    public int getFrameWaitLimiter() {
        return this.FrameWaitLimiter;
    }

    public void setInformationDisplay(boolean bl) {
        this.informationDisplay = bl;
    }

    public boolean isInformationDisplay() {
        return this.informationDisplay;
    }

    public void setShadingMode(int n) {
        this.shadingMode = n;
    }

    public int getShadingMode() {
        return this.shadingMode;
    }

    public ScreenSystem3DEG getScreenSystem() {
        return this.screen;
    }

    public CoordinateSystem3DEG getWorldSystem() {
        return this.world;
    }

    public Image getScreenImage() {
        return this.screen.getScreenImage();
    }

    public void setScreenSystem(ScreenSystem3DEG screenSystem3DEG) {
        this.screen = screenSystem3DEG;
    }

    public void setWorldSystem(CoordinateSystem3DEG coordinateSystem3DEG) {
        this.world = coordinateSystem3DEG;
        this.screen.add(this.world);
    }

    public void repaint3D() {
        try {
            if (this.shadingMode == 1) {
                this.screen.repaint3D(this);
            } else if (this.shadingMode == 0) {
                this.screen.repaint3D_WIRE(this);
            }
            for (int i = 0; i < this.realtime3DScreenRefreshListener.length; ++i) {
                Realtime3DScreenRefreshEvent realtime3DScreenRefreshEvent = new Realtime3DScreenRefreshEvent();
                realtime3DScreenRefreshEvent.setSource(this);
                this.realtime3DScreenRefreshListener[i].screenRefreshed(realtime3DScreenRefreshEvent);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setScreenBackground(Color color) {
        this.screen.setBackground(color);
    }

    public void setInformationColor(Color color) {
        this.informationColor = color;
    }

    public void wait(int n) {
        if (this.th != null) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void repaint3DRequest() {
        this.repaintRequestFrag = true;
    }

    public void reSize() {
        this.frameDim = this.getSize();
        this.width = this.frameDim.width;
        this.height = this.frameDim.height;
        try {
            this.screen.setScreenSize(this.width, this.height);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.repaint3D();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        try {
            this.reSize();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.processMode != -1) {
            this.mouse_sx = mouseEvent.getX();
            this.mouse_sy = mouseEvent.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.processMode != -1) {
            this.mouseDraggingInt = 1;
            this.mouse_ex = mouseEvent.getX();
            this.mouse_ey = mouseEvent.getY();
            this.mouse_dx = ((double)this.mouse_sx - (double)this.mouse_ex) * this.dragSpeed;
            this.mouse_dy = ((double)this.mouse_sy - (double)this.mouse_ey) * this.dragSpeed;
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.x1 = this.mouse_sx - this.screen.ox;
                this.y1 = -this.mouse_sy + this.screen.oy;
                this.x2 = this.mouse_ex - this.screen.ox;
                this.y2 = -this.mouse_ey + this.screen.oy;
                this.R1 = Math.sqrt(this.x1 * this.x1 + this.y1 * this.y1);
                double[] dArray = new double[]{this.x1, this.y1, 0.0};
                double[] dArray2 = new double[]{-this.y1, this.x1, 0.0};
                double[] dArray3 = new double[]{this.x2 - this.x1, this.y2 - this.y1, 0.0};
                if (this.R1 != 0.0 && (this.x2 - this.x1 != 0.0 || this.y2 - this.y1 != 0.0)) {
                    this.d_r = this.screen.getCosin(dArray, dArray3);
                    this.d_theta = this.screen.getCosin(dArray2, dArray3);
                    this.world.rot(-this.mouse_dx * Math.abs(this.d_r), 0.0, 1.0, 0.0, this.world.getOriginX(), this.world.getOriginY(), this.world.getOriginZ());
                    this.world.rot(-this.mouse_dy * Math.abs(this.d_r), 1.0, 0.0, 0.0, this.world.getOriginX(), this.world.getOriginY(), this.world.getOriginZ());
                    this.world.rot(this.d_theta * this.dragSpeed * 1.5 * (Math.sqrt(this.x1 * this.x1 + this.y1 * this.y1) / this.rotLimit), 0.0, 0.0, 1.0, this.world.getOriginX(), this.world.getOriginY(), this.world.getOriginZ());
                }
            } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.screen.setScreenCenter(this.screen.getScreenCenterX() + (this.mouse_ex - this.mouse_sx), this.screen.getScreenCenterY() + (this.mouse_ey - this.mouse_sy));
            }
            this.mouse_sx = mouseEvent.getX();
            this.mouse_sy = mouseEvent.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDraggingInt = 0;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.mouseDraggingInt = 1;
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            this.screen.setMagnification(this.screen.getMagnification() * 1.1);
        } else {
            this.screen.setMagnification(this.screen.getMagnification() / 1.1);
        }
    }

    public void start() {
        if (this.th == null) {
            this.th = new Thread(this);
            this.th.start();
        }
    }

    public void stop() {
        if (this.th != null) {
            this.mainRoopFrag = false;
            this.world = null;
            this.screen.canvasGraphics.dispose();
            this.screen = null;
            this.th = null;
        }
    }

    void reStart() {
        this.run();
    }

    @Override
    public void run() {
        while (this.mainRoopFrag) {
            try {
                this.systemEnable = 1;
                while (true) {
                    if (this.mouseDraggingInt == 1) {
                        if (this.processMode != -1 && this.processMode != 0) {
                            this.repaint3D();
                            if (this.processMode == 3) {
                                try {
                                    Thread.sleep(0L);
                                }
                                catch (InterruptedException interruptedException) {}
                            } else {
                                try {
                                    Thread.sleep(this.wait_Idle);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            this.mouseDraggingInt = 0;
                        } else {
                            try {
                                Thread.sleep(this.wait_Idle);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    } else if (this.processMode == -1) {
                        if (this.repaintRequestFrag) {
                            this.repaint3D();
                            this.repaintRequestFrag = false;
                        }
                        try {
                            Thread.sleep(this.wait_Idle);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (this.processMode == 0) {
                        if (this.repaintRequestFrag) {
                            this.repaint3D();
                            this.repaintRequestFrag = false;
                        }
                        try {
                            Thread.sleep(this.wait_Idle);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (this.processMode == 1) {
                        if (this.repaintRequestFrag) {
                            this.repaint3D();
                            this.repaintRequestFrag = false;
                        }
                        try {
                            Thread.sleep(this.wait_Idle);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (this.processMode == 2) {
                        this.repaint3D();
                        try {
                            Thread.sleep(this.wait_Idle);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (this.processMode == 3) {
                        this.repaint3D();
                        try {
                            Thread.sleep(0L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.resizeInt == 1) {
                        this.whiteOutFrag = true;
                        try {
                            Thread.sleep(0L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.reSize();
                        this.resizeInt = 2;
                    }
                    if (this.resizeInt == 2) {
                        this.whiteOutFrag = true;
                        try {
                            Thread.sleep(0L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.reSize();
                        this.resizeInt = 3;
                    }
                    if (this.resizeInt != 3) continue;
                    this.whiteOutFrag = true;
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.reSize();
                    this.resizeInt = 0;
                }
            }
            catch (NullPointerException nullPointerException) {
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        try {
            this.repaintEndTime = System.currentTimeMillis();
            this.measuredFrameCycle = (int)(this.repaintEndTime - this.repaintStartTime);
            this.measuredFrameRate = 1000.0 / (double)this.measuredFrameCycle;
            this.wait_Idle = this.processMode == REALTIME_MODE || this.processMode == SEMI_REALTIME_MODE ? (this.measuredFrameCycle > this.targetedFrameCycle ? (this.FrameWaitLimiter < this.wait_Idle ? --this.wait_Idle : this.FrameWaitLimiter) : ++this.wait_Idle) : (this.FrameWaitLimiter < this.wait_Idle ? this.targetedFrameCycle : this.FrameWaitLimiter);
            if (this.informationDisplay) {
                this.screen.canvasGraphics.setColor(this.informationColor);
                this.screen.canvasGraphics.setFont(this.debugFont);
                this.screen.canvasGraphics.drawString("********************************************************************************", 0, 122);
                this.screen.canvasGraphics.drawString("- PERFORMANCE -----", 20, 150);
                this.screen.canvasGraphics.drawString("Frame Rate = " + this.measuredFrameRate + " [Frames/sec]", 35, 170);
                this.screen.canvasGraphics.drawString("Polygon Rate = " + (double)this.screen.getTotalNumberOfPolygon() * this.measuredFrameRate + " [Polygons/sec]", 35, 190);
                this.screen.canvasGraphics.drawString("Roop Wait = " + this.wait_Idle + " [msec]", 35, 210);
                this.screen.canvasGraphics.drawString("- SCENE INFORMATION -----", 20, 250);
                this.screen.canvasGraphics.drawString("Total Number of Polygons = " + this.screen.getTotalNumberOfPolygon() + " [Polygons]", 35, 270);
                this.screen.canvasGraphics.drawString("Total Number of Lights = " + this.screen.getTotalNumberOfLight() + " [Lights]", 35, 290);
                this.screen.canvasGraphics.drawString("- RESERVER INFORMATION -----", 20, 330);
                this.screen.canvasGraphics.drawString("- DYNAMIC ELEMENT RESERVER SYSTEM ( DERS )", 35, 355);
                this.screen.canvasGraphics.drawString("Status = " + this.screen.isDynamicElementReserverSystem(), 55, 375);
                this.screen.canvasGraphics.drawString("- POLYGON RESERVER", 35, 400);
                this.screen.canvasGraphics.drawString("Stage = " + this.screen.getPolygonReserverStage(), 55, 420);
                this.screen.canvasGraphics.drawString("Capacity = " + this.screen.getPolygonReserverCapacity() + " [Polygons]", 55, 440);
                this.screen.canvasGraphics.drawString("- LIGHT RESERVER", 35, 465);
                this.screen.canvasGraphics.drawString("Stage = " + this.screen.getLightReserverStage(), 55, 485);
                this.screen.canvasGraphics.drawString("Capacity = " + this.screen.getLightReserverCapacity() + " [Lights]", 55, 505);
            }
            this.repaintStartTime = System.currentTimeMillis();
            graphics.drawImage(this.screen.canvas, 0, 0, this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void add(CoordinateSystem3DEG coordinateSystem3DEG) {
        this.world.add(coordinateSystem3DEG);
    }

    public void add(Element3DEG element3DEG) {
        this.world.add(element3DEG);
        this.screen.request(element3DEG);
    }

    public void add(Vector3DEG vector3DEG) {
        this.world.add(vector3DEG);
    }

    public void add(Element3DEG[] element3DEGArray) {
        this.world.add(element3DEGArray);
        this.screen.request(element3DEGArray);
    }

    public void add(Element3DEG[][] element3DEGArray) {
        this.add(element3DEGArray);
    }

    public void add(Element3DEG[][][] element3DEGArray) {
        this.add(element3DEGArray);
    }

    public void add(Model3DEG model3DEG) {
        this.world.add(model3DEG);
        this.screen.request(model3DEG);
    }

    public void add(Model3DEG[] model3DEGArray) {
        this.world.add(model3DEGArray);
    }

    public void add(Model3DEG[][] model3DEGArray) {
        this.world.add(model3DEGArray);
    }

    public void add(Model3DEG[][][] model3DEGArray) {
        this.world.add(model3DEGArray);
    }

    public void add(Structure3DEG structure3DEG) {
        this.add(structure3DEG.model);
    }

    public void add(Structure3DEG[] structure3DEGArray) {
        this.add(structure3DEGArray);
    }

    public void add(Structure3DEG[][] structure3DEGArray) {
        this.add(structure3DEGArray);
    }

    public void add(Structure3DEG[][][] structure3DEGArray) {
        this.add(structure3DEGArray);
    }

    public void remove(Element3DEG element3DEG) {
        this.screen.cancel(element3DEG);
    }

    public void remove(Element3DEG[] element3DEGArray) {
        this.screen.cancel(element3DEGArray);
    }

    public void remove(Element3DEG[][] element3DEGArray) {
        this.screen.cancel(element3DEGArray);
    }

    public void remove(Element3DEG[][][] element3DEGArray) {
        this.screen.cancel(element3DEGArray);
    }

    public void remove(Model3DEG model3DEG) {
        this.screen.cancel(model3DEG);
    }

    public void remove(Model3DEG[] model3DEGArray) {
        this.screen.cancel(model3DEGArray);
    }

    public void remove(Model3DEG[][] model3DEGArray) {
        this.screen.cancel(model3DEGArray);
    }

    public void remove(Model3DEG[][][] model3DEGArray) {
        this.screen.cancel(model3DEGArray);
    }

    public void remove(Structure3DEG structure3DEG) {
        this.screen.cancel(structure3DEG);
    }

    public void remove(Structure3DEG[] structure3DEGArray) {
        this.screen.cancel(structure3DEGArray);
    }

    public void remove(Structure3DEG[][] structure3DEGArray) {
        this.screen.cancel(structure3DEGArray);
    }

    public void remove(Structure3DEG[][][] structure3DEGArray) {
        this.screen.cancel(structure3DEGArray);
    }

    public void cancel(Element3DEG element3DEG) {
        this.screen.cancel(element3DEG);
    }

    public void cancel(Element3DEG[] element3DEGArray) {
        this.screen.cancel(element3DEGArray);
    }

    public void cancel(Element3DEG[][] element3DEGArray) {
        this.screen.cancel(element3DEGArray);
    }

    public void cancel(Element3DEG[][][] element3DEGArray) {
        this.screen.cancel(element3DEGArray);
    }

    public void cancel(Model3DEG model3DEG) {
        this.screen.cancel(model3DEG);
    }

    public void cancel(Model3DEG[] model3DEGArray) {
        this.screen.cancel(model3DEGArray);
    }

    public void cancel(Model3DEG[][] model3DEGArray) {
        this.screen.cancel(model3DEGArray);
    }

    public void cancel(Model3DEG[][][] model3DEGArray) {
        this.screen.cancel(model3DEGArray);
    }

    public void cancel(Structure3DEG structure3DEG) {
        this.screen.cancel(structure3DEG);
    }

    public void cancel(Structure3DEG[] structure3DEGArray) {
        this.screen.cancel(structure3DEGArray);
    }

    public void cancel(Structure3DEG[][] structure3DEGArray) {
        this.screen.cancel(structure3DEGArray);
    }

    public void cancel(Structure3DEG[][][] structure3DEGArray) {
        this.screen.cancel(structure3DEGArray);
    }

    public void format() {
        this.screen.format();
    }
}

