/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.system3d.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import rxvesapi.system3d.geometry.CoordinateSystem3DEG;
import rxvesapi.system3d.geometry.Element3DEG;
import rxvesapi.system3d.geometry.Model3DEG;
import rxvesapi.system3d.geometry.Structure3DEG;
import rxvesapi.system3d.geometry.Vector3DEG;
import rxvesapi.system3d.renderer.FastTrigonometricFunctionGenerator;
import rxvesapi.system3d.renderer.LightElement3DEG;

public class ScreenSystem3DEG
extends CoordinateSystem3DEG
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    public Component eventComponent;
    private CoordinateSystem3DEG world;
    int mouseDraggingInt = 0;
    private double rotLimit = 200.0;
    private double dragSpeed = 0.015;
    double valueX;
    double valueY;
    int mouse_sx;
    int mouse_sy;
    int mouse_ex;
    int mouse_ey;
    double mouse_dx;
    double mouse_dy;
    double x1;
    double x2;
    double y1;
    double y2;
    double R1;
    double d_r;
    double d_theta;
    public int width = 640;
    public int height = 490;
    public double magnification = 400.0;
    public int ox = this.width / 2;
    public int oy = this.height / 2;
    public Color bgcolor = Color.lightGray;
    public double DissRate = 1.0;
    public double[] camXYZ = new double[]{0.0, 0.0, 0.0};
    public double[] camAngle = new double[]{0.0, 0.0, 0.0};
    public int camD = 0;
    public double nearlimit = 2.0;
    public double farlimit = 1000000.0;
    public int Uclip = -200000000;
    public int Dclip = this.height + 20000000;
    public int Lclip = -20000000;
    public int Rclip = this.width + 20000000;
    public int[] ambientLightRGB = new int[]{255, 255, 255, 255};
    private int polygonReserverCapacity = 8;
    private int lightReserverCapacity = 8;
    private int polygonReserverCapacity_lowerStage = 4;
    private int lightReserverCapacity_lowerStage = 4;
    private int polygonReserverStage = 3;
    private int lightReserverStage = 3;
    FastTrigonometricFunctionGenerator ftfg = new FastTrigonometricFunctionGenerator();
    public Image canvas;
    public BufferedImage bufferedImage;
    public Graphics2D canvasGraphics;
    public LightElement3DEG SUN;
    private Color[] drawColor;
    private double[][][] absoluteList;
    private double[][] depthOffsetList;
    private double[][] depthOffsetViewList;
    private int totalNumberOfPolygon = 0;
    private int[] requestChart;
    private int requested = 0;
    private double[] Xbuffer;
    private double[] Ybuffer;
    private double[] Zbuffer;
    private double[] Rbuffer;
    private double[] Nearest;
    private double[][] lightList;
    private double[][] lightTarget;
    private double[] lightness;
    private Color[] lightColor;
    private int totalNumberOfLight = 0;
    private int[] lightType;
    private Element3DEG[] element;
    private int[] xPoints = new int[4];
    private int[] yPoints = new int[4];
    private double cx = 1.0;
    private double cy = 1.0;
    private double cr = 1.0;
    private double ch = 1.0;
    private double cw = 1.0;
    private double offx = 1.0;
    private double offy = 1.0;
    private Font drawfont = new Font("Serif", 0, 20);
    private double inv_stock = 1.0;
    private boolean dinamicElementReserverSystemStatus = true;
    public boolean processBusy = false;
    Element3DEG projectedElement = new Element3DEG();
    Element3DEG projectedElement2 = new Element3DEG();
    int lightIndex = 0;
    double[] lowRGBA = new double[4];
    double[] nvec = new double[3];
    double[] lvec = new double[3];
    double[] refvec = new double[3];
    double cross = 0.0;
    double[] direct = new double[4];
    double[] diffract = new double[4];
    double[] diffuse = new double[4];
    double[] shin = new double[4];
    double[] ambient = new double[4];
    double[] emiss = new double[4];
    double rate;
    double abs2_nvec_rev;
    double k1;
    double cos = 0.0;
    double specularCos = 0.0;
    double cosPlus = 0.0;
    double[] lightRGBA = new double[4];
    double[] retRGBA = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] vertexDistance = new double[4];
    double vertexDistanceMinIndex;
    double[][] vertex = new double[4][4];
    boolean rev = false;
    double crx;
    double cry;

    public void setEventSource(Component component, CoordinateSystem3DEG coordinateSystem3DEG) {
        this.world = coordinateSystem3DEG;
        this.eventComponent = component;
        this.eventComponent.addMouseListener(this);
        this.eventComponent.addMouseMotionListener(this);
        this.eventComponent.addMouseWheelListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_sx = mouseEvent.getX();
        this.mouse_sy = mouseEvent.getY();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseDraggingInt = 1;
        this.mouse_ex = mouseEvent.getX();
        this.mouse_ey = mouseEvent.getY();
        this.mouse_dx = ((double)this.mouse_sx - (double)this.mouse_ex) * this.dragSpeed;
        this.mouse_dy = ((double)this.mouse_sy - (double)this.mouse_ey) * this.dragSpeed;
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.x1 = this.mouse_sx - this.ox;
            this.y1 = -this.mouse_sy + this.oy;
            this.x2 = this.mouse_ex - this.ox;
            this.y2 = -this.mouse_ey + this.oy;
            this.R1 = Math.sqrt(this.x1 * this.x1 + this.y1 * this.y1);
            double[] dArray = new double[]{this.x1, this.y1, 0.0};
            double[] dArray2 = new double[]{-this.y1, this.x1, 0.0};
            double[] dArray3 = new double[]{this.x2 - this.x1, this.y2 - this.y1, 0.0};
            if (this.R1 != 0.0 && (this.x2 - this.x1 != 0.0 || this.y2 - this.y1 != 0.0)) {
                this.d_r = this.getCosin(dArray, dArray3);
                this.d_theta = this.getCosin(dArray2, dArray3);
                this.world.rot(-this.mouse_dx * Math.abs(this.d_r), 0.0, 1.0, 0.0, this.world.getOriginX(), this.world.getOriginY(), this.world.getOriginZ());
                this.world.rot(-this.mouse_dy * Math.abs(this.d_r), 1.0, 0.0, 0.0, this.world.getOriginX(), this.world.getOriginY(), this.world.getOriginZ());
                this.world.rot(this.d_theta * this.dragSpeed * 1.5 * (Math.sqrt(this.x1 * this.x1 + this.y1 * this.y1) / this.rotLimit), 0.0, 0.0, 1.0, this.world.getOriginX(), this.world.getOriginY(), this.world.getOriginZ());
            }
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.setScreenCenter(this.getScreenCenterX() + (this.mouse_ex - this.mouse_sx), this.getScreenCenterY() + (this.mouse_ey - this.mouse_sy));
        }
        this.mouse_sx = mouseEvent.getX();
        this.mouse_sy = mouseEvent.getY();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDraggingInt = 0;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.mouseDraggingInt = 1;
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            this.setMagnification(this.getMagnification() * 1.1);
        } else {
            this.setMagnification(this.getMagnification() / 1.1);
        }
    }

    public ScreenSystem3DEG() {
        this.mkinit();
    }

    public ScreenSystem3DEG(Component component) {
        this.mkinit();
    }

    public boolean isBusy() {
        return this.processBusy;
    }

    public Image getCanvasImage() {
        return this.canvas;
    }

    public int getCanvasWidth() {
        return this.width;
    }

    public int getCanvasHeight() {
        return this.height;
    }

    @Override
    public void disposeResource() {
        this.dispose();
    }

    public void dispose() {
        this.Xbuffer = null;
        this.Ybuffer = null;
        this.Zbuffer = null;
        this.Rbuffer = null;
        this.Nearest = null;
        this.lightList = null;
        this.lightTarget = null;
        this.lightness = null;
        this.lightColor = null;
        this.lightType = null;
        if (this.element != null) {
            for (int i = 0; i < this.element.length; ++i) {
                this.element[i] = null;
            }
        }
        this.element = null;
        this.canvas = null;
        if (this.canvasGraphics != null) {
            this.canvasGraphics.dispose();
            this.canvasGraphics = null;
        }
        this.bufferedImage = null;
        this.SUN = null;
        this.drawColor = null;
        this.absoluteList = null;
        this.depthOffsetList = null;
        this.depthOffsetViewList = null;
        this.requestChart = null;
    }

    public boolean isDynamicElementReserverSystem() {
        return this.dinamicElementReserverSystemStatus;
    }

    public void setDynamicElementReserverSystem(boolean bl) {
        this.dinamicElementReserverSystemStatus = bl;
    }

    private int getOptimizedReserverStage(int n) {
        int n2 = 0;
        int n3 = 1;
        while (n3 <= n) {
            n3 *= 2;
            ++n2;
        }
        return n2;
    }

    public void setPolygonReserverCapacity(int n) {
        int n2;
        Element3DEG[] element3DEGArray = new Element3DEG[this.polygonReserverCapacity];
        for (n2 = 0; n2 < this.polygonReserverCapacity; ++n2) {
            element3DEGArray[n2] = this.element[n2];
        }
        this.element = new Element3DEG[n];
        n2 = Math.min(this.polygonReserverCapacity, n);
        for (int i = 0; i < n2; ++i) {
            this.element[i] = element3DEGArray[i];
        }
        element3DEGArray = null;
        this.absoluteList = new double[n][4][4];
        this.depthOffsetList = new double[n][];
        this.depthOffsetViewList = new double[n][];
        this.drawColor = new Color[n];
        this.requestChart = new int[n];
        this.Xbuffer = new double[n];
        this.Ybuffer = new double[n];
        this.Zbuffer = new double[n];
        this.Rbuffer = new double[n];
        this.Nearest = new double[n];
        this.polygonReserverCapacity = n;
        this.polygonReserverCapacity_lowerStage = n / 2;
    }

    public void setLightReserverCapacity(int n) {
        this.lightList = new double[n][3];
        this.lightTarget = new double[n][3];
        this.lightType = new int[n];
        this.lightness = new double[n];
        this.lightColor = new Color[n];
        this.lightReserverCapacity = n;
        this.lightReserverCapacity_lowerStage = n / 2;
    }

    public void setPolygonReserverStage(int n) {
        if (n != this.polygonReserverStage) {
            int n2 = 1;
            int n3 = n;
            for (int i = 0; i < n3; ++i) {
                n2 *= 2;
            }
            this.setPolygonReserverCapacity(n2);
            this.polygonReserverStage = n;
        }
    }

    public void setLightReserverStage(int n) {
        if (n != this.lightReserverStage) {
            int n2 = 1;
            int n3 = n;
            for (int i = 0; i < n3; ++i) {
                n2 *= 2;
            }
            this.setLightReserverCapacity(n2);
            this.lightReserverStage = n;
        }
    }

    public int getTotalNumberOfPolygon() {
        return this.totalNumberOfPolygon;
    }

    public int getTotalNumberOfLight() {
        return this.totalNumberOfLight;
    }

    public int getPolygonReserverCapacity() {
        return this.polygonReserverCapacity;
    }

    public int getLightReserverCapacity() {
        return this.lightReserverCapacity;
    }

    public int getPolygonReserverStage() {
        return this.polygonReserverStage;
    }

    public int getLightReserverStage() {
        return this.lightReserverStage;
    }

    public Image getScreenImage() {
        return this.canvas;
    }

    public void setBackground(Color color) {
        this.bgcolor = color;
    }

    public Color getBackground() {
        return this.bgcolor;
    }

    public void setPerspectiveAngle(double d) {
        double d2 = (double)this.width / (double)this.height;
        this.setPerspectiveAngle(d, d2);
    }

    public void setPerspectiveAngle(double d, double d2) {
        this.Evector[0][0] = 1.0 / (d2 * Math.tan(d * 0.5));
        this.Evector[0][1] = 0.0;
        this.Evector[0][2] = 0.0;
        this.Evector[1][0] = 0.0;
        this.Evector[1][1] = 1.0 / Math.tan(d * 0.5);
        this.Evector[1][2] = 0.0;
    }

    public void setMagnification(double d) {
        this.magnification = d;
        double d2 = (double)this.width / (double)this.height;
        this.Evector[0][0] = this.magnification / (0.5 * (double)this.height * d2);
        this.Evector[0][1] = 0.0;
        this.Evector[0][2] = 0.0;
        this.Evector[1][0] = 0.0;
        this.Evector[1][1] = this.magnification / (0.5 * (double)this.height);
        this.Evector[1][2] = 0.0;
    }

    public double getMagnification() {
        return this.Evector[1][1] * (0.5 * (double)this.height);
    }

    public void initProjectMatrix() {
        this.setMagnification(this.magnification);
        this.setClip(this.nearlimit, this.farlimit);
    }

    public void mkinit(int n, int n2) {
        this.polygonReserverCapacity = n;
        this.lightReserverCapacity = n2;
        this.mkinit();
    }

    public void mkinit() {
        this.wVector = new double[]{0.0, 0.0, -1.0, 0.0};
        this.initProjectMatrix();
        this.setOrigin(0.0, 0.0, 0.0);
        this.makeGraphics();
        this.drawColor = new Color[this.polygonReserverCapacity];
        this.absoluteList = new double[this.polygonReserverCapacity][4][4];
        this.depthOffsetList = new double[this.polygonReserverCapacity][];
        this.depthOffsetViewList = new double[this.polygonReserverCapacity][];
        this.requestChart = new int[this.polygonReserverCapacity];
        this.Xbuffer = new double[this.polygonReserverCapacity];
        this.Ybuffer = new double[this.polygonReserverCapacity];
        this.Zbuffer = new double[this.polygonReserverCapacity];
        this.Rbuffer = new double[this.polygonReserverCapacity];
        this.Nearest = new double[this.polygonReserverCapacity];
        this.lightList = new double[this.lightReserverCapacity][3];
        this.lightTarget = new double[this.lightReserverCapacity][3];
        this.lightType = new int[this.lightReserverCapacity];
        this.lightness = new double[this.lightReserverCapacity];
        this.lightColor = new Color[this.lightReserverCapacity];
        this.element = new Element3DEG[this.polygonReserverCapacity];
    }

    public void mkclose() {
        this.canvasGraphics.dispose();
    }

    private void makeGraphics() {
        if (this.canvasGraphics == null) {
            this.bufferedImage = new BufferedImage(this.width, this.height, 2);
            this.canvas = this.bufferedImage;
            this.canvasGraphics = (Graphics2D)this.bufferedImage.getGraphics();
            this.initProjectMatrix();
        }
    }

    public void setScreenSize(int n, int n2) {
        Image image = this.canvas;
        Graphics2D graphics2D = this.canvasGraphics;
        this.width = n;
        this.height = n2;
        if (this.width < 1) {
            this.width = 100;
        }
        if (this.height < 1) {
            this.height = 100;
        }
        this.ox = n / 2;
        this.oy = n2 / 2;
        this.bufferedImage = new BufferedImage(this.width, this.height, 2);
        this.canvas = this.bufferedImage;
        this.canvasGraphics = (Graphics2D)this.bufferedImage.getGraphics();
        this.canvasGraphics.drawImage(image, 0, 0, null);
        image = null;
        if (graphics2D != null) {
            graphics2D.dispose();
            graphics2D = null;
        }
        this.initProjectMatrix();
    }

    @Override
    public double getCosin(double[] dArray, double[] dArray2) {
        double d = (dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2]) / (Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]) * Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]));
        return d;
    }

    @Override
    public double[] getCross(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]};
        return dArray3;
    }

    @Override
    public double[] getNvector_e(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[4];
        dArray4[0] = (dArray2[1] - dArray[1]) * (dArray3[2] - dArray[2]) - (dArray2[2] - dArray[2]) * (dArray3[1] - dArray[1]);
        dArray4[1] = (dArray2[2] - dArray[2]) * (dArray3[0] - dArray[0]) - (dArray2[0] - dArray[0]) * (dArray3[2] - dArray[2]);
        dArray4[2] = (dArray2[0] - dArray[0]) * (dArray3[1] - dArray[1]) - (dArray2[1] - dArray[1]) * (dArray3[0] - dArray[0]);
        double d = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
        if (d != 0.0) {
            dArray4[0] = dArray4[0] / d;
            dArray4[1] = dArray4[1] / d;
            dArray4[2] = dArray4[2] / d;
            dArray4[3] = d;
        } else {
            dArray4[0] = 0.0;
            dArray4[1] = 0.0;
            dArray4[2] = 0.0;
            dArray4[3] = d;
        }
        return dArray4;
    }

    @Override
    public double[] getNvector(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[]{(dArray2[1] - dArray[1]) * (dArray3[2] - dArray[2]) - (dArray2[2] - dArray[2]) * (dArray3[1] - dArray[1]), (dArray2[2] - dArray[2]) * (dArray3[0] - dArray[0]) - (dArray2[0] - dArray[0]) * (dArray3[2] - dArray[2]), (dArray2[0] - dArray[0]) * (dArray3[1] - dArray[1]) - (dArray2[1] - dArray[1]) * (dArray3[0] - dArray[0])};
        return dArray4;
    }

    public void getNvector(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        dArray4[0] = (dArray2[1] - dArray[1]) * (dArray3[2] - dArray[2]) - (dArray2[2] - dArray[2]) * (dArray3[1] - dArray[1]);
        dArray4[1] = (dArray2[2] - dArray[2]) * (dArray3[0] - dArray[0]) - (dArray2[0] - dArray[0]) * (dArray3[2] - dArray[2]);
        dArray4[2] = (dArray2[0] - dArray[0]) * (dArray3[1] - dArray[1]) - (dArray2[1] - dArray[1]) * (dArray3[0] - dArray[0]);
    }

    public void getNvector(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        this.vertexDistance[0] = (dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray[2] - dArray2[2]);
        this.vertexDistance[1] = (dArray2[0] - dArray3[0]) * (dArray2[0] - dArray3[0]) + (dArray2[1] - dArray3[1]) * (dArray2[1] - dArray3[1]) + (dArray2[2] - dArray3[2]) * (dArray2[2] - dArray3[2]);
        this.vertexDistance[2] = (dArray3[0] - dArray4[0]) * (dArray3[0] - dArray4[0]) + (dArray3[1] - dArray4[1]) * (dArray3[1] - dArray4[1]) + (dArray3[2] - dArray4[2]) * (dArray3[2] - dArray4[2]);
        this.vertexDistance[3] = (dArray4[0] - dArray[0]) * (dArray4[0] - dArray[0]) + (dArray4[1] - dArray[1]) * (dArray4[1] - dArray[1]) + (dArray4[2] - dArray[2]) * (dArray4[2] - dArray[2]);
        double d = Double.MAX_VALUE;
        int n = -1;
        if (this.vertexDistance[0] < d) {
            d = this.vertexDistance[0];
            n = 0;
        }
        if (this.vertexDistance[1] < d) {
            d = this.vertexDistance[1];
            n = 1;
        }
        if (this.vertexDistance[2] < d) {
            d = this.vertexDistance[2];
            n = 2;
        }
        if (this.vertexDistance[3] < d) {
            d = this.vertexDistance[3];
            n = 3;
        }
        if (n == 0) {
            this.getNvector(dArray2, dArray3, dArray4, dArray5);
        } else if (n == 1) {
            this.getNvector(dArray3, dArray4, dArray, dArray5);
        } else if (n == 2) {
            this.getNvector(dArray4, dArray, dArray2, dArray5);
        } else {
            this.getNvector(dArray, dArray2, dArray3, dArray5);
        }
    }

    @Override
    public double[] getNvector(double[][] dArray) {
        double[] dArray2 = new double[3];
        dArray2 = this.getNvector(dArray[0], dArray[1], dArray[2]);
        return dArray2;
    }

    @Override
    public double[] andVector(int n, double d, double[] dArray, double d2, double[] dArray2) {
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = d * dArray[i] + d2 * dArray2[i];
        }
        return dArray3;
    }

    public void format() {
        int n = this.element.length;
        for (int i = 0; i < n; ++i) {
            this.element[i] = null;
        }
        this.totalNumberOfPolygon = 0;
        this.totalNumberOfLight = 0;
        this.setPolygonReserverStage(3);
        this.setLightReserverStage(3);
    }

    @Override
    public void request(Element3DEG element3DEG) {
        boolean bl = true;
        if (bl) {
            if (this.dinamicElementReserverSystemStatus) {
                if (this.totalNumberOfPolygon == this.polygonReserverCapacity) {
                    this.setPolygonReserverStage(this.polygonReserverStage + 1);
                }
                if (this.totalNumberOfLight == this.lightReserverCapacity) {
                    this.setLightReserverStage(this.lightReserverStage + 1);
                }
            }
            this.element[this.totalNumberOfPolygon] = element3DEG;
        }
        ++this.totalNumberOfPolygon;
        if (element3DEG.type == -1 || element3DEG.type == -2 || element3DEG.type == -3) {
            ++this.totalNumberOfLight;
        }
    }

    public void request(Element3DEG[] element3DEGArray) {
        if (this.dinamicElementReserverSystemStatus) {
            if (this.totalNumberOfPolygon + element3DEGArray.length >= this.polygonReserverCapacity) {
                this.setPolygonReserverStage(this.getOptimizedReserverStage(this.totalNumberOfPolygon + element3DEGArray.length));
            }
            if (this.totalNumberOfLight == this.lightReserverCapacity) {
                this.setLightReserverStage(this.lightReserverStage + 1);
            }
        }
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(element3DEGArray[i]);
        }
    }

    public void request(Element3DEG[][] element3DEGArray) {
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(element3DEGArray[i]);
        }
    }

    public void request(Element3DEG[][][] element3DEGArray) {
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(element3DEGArray[i]);
        }
    }

    public void request(Model3DEG model3DEG) {
        this.request(model3DEG.element);
    }

    public void request(Model3DEG[] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(model3DEGArray[i]);
        }
    }

    public void request(Model3DEG[][] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(model3DEGArray[i]);
        }
    }

    public void request(Model3DEG[][][] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(model3DEGArray[i]);
        }
    }

    public void request(Structure3DEG structure3DEG) {
        this.request(structure3DEG.model);
    }

    public void request(Structure3DEG[] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(structure3DEGArray[i]);
        }
    }

    public void request(Structure3DEG[][] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(structure3DEGArray[i]);
        }
    }

    public void request(Structure3DEG[][][] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.request(structure3DEGArray[i]);
        }
    }

    public void cancelAll() {
        for (int i = 0; i < this.element.length; ++i) {
            this.element[i] = null;
            if (this.element[i] != null && (this.element[i].type == -1 || this.element[i].type == -2 || this.element[i].type == -3)) {
                --this.totalNumberOfLight;
            }
            --this.totalNumberOfPolygon;
        }
        this.element = new Element3DEG[0];
    }

    public void cancelAndRemoveAllElement() {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null || this.element[i].type == -1 || this.element[i].type == -2 || this.element[i].type == -3) continue;
            this.element[i].belongingSystem = null;
            this.element[i] = null;
            --this.totalNumberOfPolygon;
        }
        Element3DEG[] element3DEGArray = new Element3DEG[this.element.length];
        int n = 0;
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null) continue;
            element3DEGArray[n++] = this.element[i];
        }
        this.element = element3DEGArray;
    }

    public void cancelAndRemoveAllLight() {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] == null || this.element[i].type != -1 && this.element[i].type != -2 && this.element[i].type != -3) continue;
            this.element[i].belongingSystem = null;
            this.cancel(this.element[i]);
        }
    }

    public void cancel(Element3DEG element3DEG) {
        int n;
        int n2 = this.totalNumberOfPolygon;
        int n3 = this.element.length;
        for (n = 0; n < n3; ++n) {
            if (this.element[n] != element3DEG) continue;
            if (this.element[n] != null && (this.element[n].type == -1 || this.element[n].type == -2 || this.element[n].type == -3)) {
                --this.totalNumberOfLight;
            }
            for (int i = n; i < n2; ++i) {
                this.element[i] = null;
                this.element[i] = this.element[i + 1];
            }
            --this.totalNumberOfPolygon;
            break;
        }
        if (this.dinamicElementReserverSystemStatus) {
            if (this.totalNumberOfPolygon < this.polygonReserverCapacity_lowerStage) {
                this.setPolygonReserverStage(this.getOptimizedReserverStage(this.totalNumberOfPolygon));
            }
            if (this.totalNumberOfLight < this.lightReserverCapacity_lowerStage) {
                this.setLightReserverStage(this.getOptimizedReserverStage(this.totalNumberOfLight));
            }
        }
        for (n = this.totalNumberOfPolygon; n < this.element.length; ++n) {
            this.element[n] = null;
        }
    }

    public void cancel(Element3DEG[] element3DEGArray) {
        int n;
        int n2 = this.totalNumberOfPolygon;
        int n3 = this.element.length;
        int n4 = element3DEGArray.length;
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            if (this.element[n] != element3DEGArray[0]) continue;
            n5 = n;
            break;
        }
        for (n = n5; n < n2 - n4; ++n) {
            if (this.element[n] != null && (this.element[n].type == -1 || this.element[n].type == -2 || this.element[n].type == -3)) {
                --this.totalNumberOfLight;
            }
            this.element[n] = null;
            this.element[n] = this.element[n + n4];
        }
        this.totalNumberOfPolygon -= n4;
        if (this.dinamicElementReserverSystemStatus) {
            if (this.totalNumberOfPolygon < this.polygonReserverCapacity_lowerStage) {
                this.setPolygonReserverStage(this.getOptimizedReserverStage(this.totalNumberOfPolygon));
            }
            if (this.totalNumberOfLight < this.lightReserverCapacity_lowerStage) {
                this.setLightReserverStage(this.getOptimizedReserverStage(this.totalNumberOfLight));
            }
        }
        for (n = this.totalNumberOfPolygon; n < this.element.length; ++n) {
            this.element[n] = null;
        }
    }

    public void cancel(Element3DEG[][] element3DEGArray) {
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.cancel(element3DEGArray[i]);
        }
    }

    public void cancel(Element3DEG[][][] element3DEGArray) {
        int n = element3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.cancel(element3DEGArray[i]);
        }
    }

    public void cancel(Model3DEG model3DEG) {
        this.cancel(model3DEG.element);
    }

    public void cancel(Model3DEG[] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.cancel(model3DEGArray[i]);
        }
    }

    public void cancel(Model3DEG[][] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.cancel(model3DEGArray[i]);
        }
    }

    public void cancel(Model3DEG[][][] model3DEGArray) {
        int n = model3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.cancel(model3DEGArray[i]);
        }
    }

    public void cancel(Structure3DEG structure3DEG) {
        this.cancel(structure3DEG.model);
    }

    public void cancel(Structure3DEG[] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.cancel(structure3DEGArray[i]);
        }
    }

    public void cancel(Structure3DEG[][] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.cancel(structure3DEGArray[i]);
        }
    }

    public void cancel(Structure3DEG[][][] structure3DEGArray) {
        int n = structure3DEGArray.length;
        for (int i = 0; i < n; ++i) {
            this.cancel(structure3DEGArray[i]);
        }
    }

    private void rm(int n) {
        int n2 = this.totalNumberOfPolygon;
        for (int i = n; i <= n2; ++i) {
            this.element[i] = this.element[i + 1];
        }
        --this.totalNumberOfPolygon;
    }

    public void rmLight() {
        int n = this.totalNumberOfPolygon;
        for (int i = 0; i < n; ++i) {
            if (this.element[i].type != -1 && this.element[i].type != -2) continue;
            this.rm(i);
        }
    }

    public void setScreenCenter(int n, int n2) {
        this.ox = n;
        this.oy = n2;
    }

    public int getScreenCenterX() {
        return this.ox;
    }

    public int getScreenCenterY() {
        return this.oy;
    }

    public void setUDClipping(int n, int n2) {
        this.Uclip = n;
        this.Dclip = n2;
    }

    public void setLRClipping(int n, int n2) {
        this.Uclip = n;
        this.Rclip = n2;
    }

    public void NFclip(double d, double d2) {
        this.nearlimit = d;
        this.farlimit = d2;
        this.setClip(this.nearlimit, this.farlimit);
    }

    public void setNearClipping(double d) {
        this.nearlimit = d;
        this.setClip(this.nearlimit, this.farlimit);
    }

    public void setFarClipping(double d) {
        this.farlimit = d;
        this.setClip(this.nearlimit, this.farlimit);
    }

    public void setFrontClip(double d) {
        this.nearlimit = d;
        this.setClip(this.nearlimit, this.farlimit);
    }

    public void setBackClip(double d) {
        this.farlimit = d;
        this.setClip(this.nearlimit, this.farlimit);
    }

    public void setClip(double d, double d2) {
        this.farlimit = d2;
        this.nearlimit = d;
        double d3 = Math.abs(this.farlimit);
        double d4 = Math.abs(this.nearlimit);
        double d5 = -(d3 + d4) / (d3 - d4);
        double d6 = -2.0 * d3 * d4 / (d3 - d4);
        this.Evector[2][0] = 0.0;
        this.Evector[2][1] = 0.0;
        this.Evector[2][2] = d5;
        this.Origin[2] = d6;
    }

    public double orthoScaleX(double d, double d2) {
        return this.Evector[0][0] * d / d2;
    }

    public double orthoScaleY(double d, double d2) {
        return this.Evector[1][1] * d / d2;
    }

    private void setAbsoluteList() {
        this.lightIndex = 0;
        for (int i = 0; i < this.totalNumberOfPolygon; ++i) {
            this.see(this.element[i], this.projectedElement);
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (this.element[i].getOffset() != null) {
                d += this.projectedElement.getOffset().x;
                d2 += this.projectedElement.getOffset().y;
                d3 += this.projectedElement.getOffset().z;
            }
            if (this.element[i].getOffsetView() != null) {
                d += this.projectedElement.getOffsetView().x;
                d2 += this.projectedElement.getOffsetView().y;
                d3 += this.projectedElement.getOffsetView().z;
            }
            for (int j = 0; j < 4; ++j) {
                this.absoluteList[i][j][0] = this.projectedElement.vertex[j].x + d;
                this.absoluteList[i][j][1] = this.projectedElement.vertex[j].y + d2;
                this.absoluteList[i][j][2] = this.projectedElement.vertex[j].z + d3;
                this.absoluteList[i][j][3] = this.projectedElement.vertex[j].w;
            }
            if (this.element[i].getDepthOffset() == null) {
                this.depthOffsetList[i] = null;
            } else {
                if (this.depthOffsetList[i] == null) {
                    this.depthOffsetList[i] = new double[3];
                }
                this.depthOffsetList[i][0] = this.projectedElement.getDepthOffset().x;
                this.depthOffsetList[i][1] = this.projectedElement.getDepthOffset().y;
                this.depthOffsetList[i][2] = this.projectedElement.getDepthOffset().z;
            }
            if (this.element[i].getDepthOffsetView() == null) {
                this.depthOffsetViewList[i] = null;
            } else {
                if (this.depthOffsetViewList[i] == null) {
                    this.depthOffsetViewList[i] = new double[3];
                }
                this.depthOffsetViewList[i][0] = this.projectedElement.getDepthOffsetView().x;
                this.depthOffsetViewList[i][1] = this.projectedElement.getDepthOffsetView().y;
                this.depthOffsetViewList[i][2] = this.projectedElement.getDepthOffsetView().z;
            }
            try {
                if (this.element[i].type != -1 && this.element[i].type != -2 && this.element[i].type != -3) continue;
                this.lightList[this.lightIndex] = this.absoluteList[i][0];
                this.lightTarget[this.lightIndex] = this.absoluteList[i][1];
                this.lightness[this.lightIndex] = this.element[i].info[0];
                this.lightType[this.lightIndex] = this.element[i].type;
                this.lightColor[this.lightIndex] = this.element[i].color;
                ++this.lightIndex;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void setOrthoVertex() {
        for (int i = 0; i < this.totalNumberOfPolygon; ++i) {
            int n;
            if (this.element[i].type == -1 || this.element[i].type == -2 || this.element[i].type == -3) continue;
            for (n = 0; n < 4; ++n) {
                this.projectedElement.vertex[n].x = this.absoluteList[i][n][0];
                this.projectedElement.vertex[n].y = this.absoluteList[i][n][1];
                this.projectedElement.vertex[n].z = this.absoluteList[i][n][2];
                this.projectedElement.vertex[n].w = this.absoluteList[i][n][3];
            }
            this.transform(this.projectedElement, this.projectedElement2);
            for (n = 0; n < 4; ++n) {
                this.absoluteList[i][n][0] = this.projectedElement2.vertex[n].x / this.projectedElement2.vertex[n].w;
                this.absoluteList[i][n][1] = this.projectedElement2.vertex[n].y / this.projectedElement2.vertex[n].w;
                this.absoluteList[i][n][2] = this.projectedElement2.vertex[n].z / this.projectedElement2.vertex[n].w;
                this.absoluteList[i][n][3] = this.projectedElement2.vertex[n].w;
            }
        }
    }

    public void setUnOrthoVertex() {
        for (int i = 0; i < this.totalNumberOfPolygon; ++i) {
            int n;
            if (this.element[i].type == -1 || this.element[i].type == -2 || this.element[i].type == -3) continue;
            for (n = 0; n < 4; ++n) {
                this.projectedElement.vertex[n].x = this.absoluteList[i][n][0] * this.projectedElement.vertex[n].w;
                this.projectedElement.vertex[n].y = this.absoluteList[i][n][1] * this.projectedElement.vertex[n].w;
                this.projectedElement.vertex[n].z = this.absoluteList[i][n][2] * this.projectedElement.vertex[n].w;
            }
            this.unTransform(this.projectedElement, this.projectedElement2);
            for (n = 0; n < 4; ++n) {
                this.absoluteList[i][n][0] = this.projectedElement2.vertex[n].x;
                this.absoluteList[i][n][1] = this.projectedElement2.vertex[n].y;
                this.absoluteList[i][n][2] = this.projectedElement2.vertex[n].z;
            }
        }
    }

    public double getReverseProjectedX(int n, double d) {
        return ((double)n - (double)this.ox) * -d / 1.0 / this.magnification;
    }

    public double getReverseProjectedY(int n, double d) {
        return -((double)n - (double)this.oy) * -d / 1.0 / this.magnification;
    }

    public int getProjectedX(Vector3DEG vector3DEG) {
        return (int)((double)this.ox + vector3DEG.x * 1.0 * this.magnification / -vector3DEG.z);
    }

    public int getProjectedY(Vector3DEG vector3DEG) {
        return (int)((double)this.oy - vector3DEG.y * 1.0 * this.magnification / -vector3DEG.z);
    }

    public int getProjectedY_LU_ORIGIN(Vector3DEG vector3DEG) {
        return (int)((double)this.height - ((double)this.oy - vector3DEG.y * 1.0 * this.magnification / -vector3DEG.z));
    }

    public int getProjectedX_nopers(double[] dArray) {
        int n = (int)((double)this.ox + dArray[0] * this.magnification);
        return n;
    }

    public int getProjectedY_nopers(double[] dArray) {
        int n = (int)((double)this.oy - dArray[1] * this.magnification);
        return n;
    }

    public double[] setPerspective(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0] * 1.0 / -dArray[2], dArray[1] * 1.0 / -dArray[2], dArray[2]};
        return dArray2;
    }

    private double[] getPersPoint(double[] dArray) {
        double[] dArray2 = new double[3];
        dArray2 = this.setPerspective(dArray);
        return dArray2;
    }

    private double[][] getPersPoints(double[][] dArray) {
        double[][] dArrayArray = new double[][]{this.getPersPoint(dArray[0]), this.getPersPoint(dArray[1]), this.getPersPoint(dArray[2]), this.getPersPoint(dArray[3])};
        return dArrayArray;
    }

    public void clearCanvas() {
        this.b();
    }

    public void repaint3D() {
        this.repaint3D(null);
    }

    public void repaint3D(Component component) {
        this.canvasGraphics = this.b();
        this.repaint3D_NBG(component);
    }

    public void repaint3D_WIRE(Component component) {
        this.canvasGraphics = this.b();
        this.repaint3D_WIRE_NBG(component);
    }

    public void repaint3D_EDGE(Component component) {
        this.canvasGraphics = this.b();
        this.repaint3D_EDGE_NBG(component);
    }

    public void repaint3D_NBG(Component component) {
        if (!this.processBusy) {
            this.processBusy = true;
            try {
                this.setAbsoluteList();
                this.setXYZRbuffer();
                this.setOrthoVertex();
                this.setDrawRequest();
                this.setLight(this.absoluteList);
                int n = 0;
                this.setPriority_comb();
                for (int i = 0; i < this.requested; ++i) {
                    n = this.requestChart[i];
                    if (this.element[n].type == 4) {
                        this.fillQuadrangle(n);
                        continue;
                    }
                    if (this.element[n].type == 3) {
                        this.fillTriangle(n);
                        continue;
                    }
                    if (this.element[n].type == 2) {
                        this.drawLine(n);
                        continue;
                    }
                    if (this.element[n].type == 0) {
                        this.drawCircle(n);
                        continue;
                    }
                    if (this.element[n].type == 9) {
                        this.drawTextLayer(n);
                        continue;
                    }
                    if (this.element[n].type == 11) {
                        this.drawImageLayer(n);
                        continue;
                    }
                    if (this.element[n].type == 1) {
                        this.drawPoint(n);
                        continue;
                    }
                    if (this.element[n].type == 5) {
                        this.drawString(n);
                        continue;
                    }
                    if (this.element[n].type == 6) {
                        this.drawStringPanel(n);
                        continue;
                    }
                    if (this.element[n].type == 7) {
                        this.drawImagePanel(n);
                        continue;
                    }
                    if (this.element[n].type != 8) continue;
                    this.drawImagePanel3d(n);
                }
                if (component != null) {
                    component.repaint();
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.processBusy = false;
        }
    }

    public void repaint3D_EDGE_NBG(Component component) {
        if (!this.processBusy) {
            this.processBusy = true;
            try {
                try {
                    this.setAbsoluteList();
                    this.setXYZRbuffer();
                    this.setOrthoVertex();
                    this.setDrawRequest();
                    int n = 0;
                    this.setPriority_comb();
                    for (int i = 0; i < this.requested; ++i) {
                        n = this.requestChart[i];
                        if (this.element[n].type == 4) {
                            this.drawQuadrangle(n);
                            continue;
                        }
                        if (this.element[n].type == 3) {
                            this.drawTriangle(n);
                            continue;
                        }
                        if (this.element[n].type == 2) {
                            this.drawLine(n);
                            continue;
                        }
                        if (this.element[n].type == 0) {
                            this.drawCircle(n);
                            continue;
                        }
                        if (this.element[n].type == 9) {
                            this.drawTextLayer(n);
                            continue;
                        }
                        if (this.element[n].type == 11) {
                            this.drawImageLayer(n);
                            continue;
                        }
                        if (this.element[n].type == 1) {
                            this.drawPoint(n);
                            continue;
                        }
                        if (this.element[n].type == 5) {
                            this.drawString(n);
                            continue;
                        }
                        if (this.element[n].type == 6) {
                            this.drawStringPanel(n);
                            continue;
                        }
                        if (this.element[n].type == 7) {
                            this.drawImagePanel(n);
                            continue;
                        }
                        if (this.element[n].type != 8) continue;
                        this.drawImagePanel3d(n);
                    }
                    component.repaint();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.processBusy = false;
        }
    }

    public void repaint3D_WIRE_NBG(Component component) {
        if (!this.processBusy) {
            this.processBusy = true;
            try {
                try {
                    this.setAbsoluteList();
                    this.setOrthoVertex();
                    for (int i = 0; i < this.totalNumberOfPolygon; ++i) {
                        if (this.element[i].type == 4) {
                            this.drawQuadrangle(i);
                            continue;
                        }
                        if (this.element[i].type == 3) {
                            this.drawTriangle(i);
                            continue;
                        }
                        if (this.element[i].type == 2) {
                            this.drawLine(i);
                            continue;
                        }
                        if (this.element[i].type == 0) {
                            this.drawCircle(i);
                            continue;
                        }
                        if (this.element[i].type == 9) {
                            this.drawTextLayer(i);
                            continue;
                        }
                        if (this.element[i].type == 11) {
                            this.drawImageLayer(i);
                            continue;
                        }
                        if (this.element[i].type == 1) {
                            this.drawPoint(i);
                            continue;
                        }
                        if (this.element[i].type == 5) {
                            this.drawString(i);
                            continue;
                        }
                        if (this.element[i].type == 6) {
                            this.drawStringPanel(i);
                            continue;
                        }
                        if (this.element[i].type == 7) {
                            this.drawImagePanel(i);
                            continue;
                        }
                        if (this.element[i].type != 8) continue;
                        this.drawImagePanel3d(i);
                    }
                    component.repaint();
                }
                catch (NullPointerException nullPointerException) {}
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            this.processBusy = false;
        }
    }

    private void setLight(double[][][] dArray) {
        for (int i = 0; i < this.requested; ++i) {
            if (this.element[this.requestChart[i]].type != 3 && this.element[this.requestChart[i]].type != 4) continue;
            this.addLightness(this.requestChart[i], this.element[this.requestChart[i]].color);
        }
    }

    private void addLightness(int n, Color color) {
        int n2;
        this.lowRGBA[0] = color.getRed();
        this.lowRGBA[1] = color.getGreen();
        this.lowRGBA[2] = color.getBlue();
        this.lowRGBA[3] = color.getAlpha();
        this.retRGBA[0] = 0.0;
        this.retRGBA[1] = 0.0;
        this.retRGBA[2] = 0.0;
        this.retRGBA[3] = this.lowRGBA[3];
        if (this.element[n].type == 4) {
            this.getNvector(this.absoluteList[n][0], this.absoluteList[n][1], this.absoluteList[n][2], this.absoluteList[n][3], this.nvec);
        } else {
            this.getNvector(this.absoluteList[n][0], this.absoluteList[n][1], this.absoluteList[n][2], this.nvec);
        }
        this.rev = this.nvec[2] < 0.0;
        this.see(this.element[n], this.projectedElement);
        for (n2 = 0; n2 < 4; ++n2) {
            this.vertex[n2][0] = this.projectedElement.vertex[n2].x;
            this.vertex[n2][1] = this.projectedElement.vertex[n2].y;
            this.vertex[n2][2] = this.projectedElement.vertex[n2].z;
        }
        if (this.element[n].type == 4) {
            this.getNvector(this.vertex[0], this.vertex[1], this.vertex[2], this.vertex[3], this.nvec);
        } else {
            this.getNvector(this.vertex[0], this.vertex[1], this.vertex[2], this.nvec);
        }
        if (this.rev) {
            this.nvec[0] = this.nvec[0] * -1.0;
            this.nvec[1] = this.nvec[1] * -1.0;
            this.nvec[2] = this.nvec[2] * -1.0;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            this.emiss[n2] = this.lowRGBA[n2] * this.element[n].emissive;
            int n3 = n2;
            this.retRGBA[n3] = this.retRGBA[n3] + this.emiss[n2];
        }
        for (n2 = 0; n2 < this.totalNumberOfLight; ++n2) {
            this.lightRGBA[0] = this.lightColor[n2].getRed();
            this.lightRGBA[1] = this.lightColor[n2].getGreen();
            this.lightRGBA[2] = this.lightColor[n2].getBlue();
            this.lightRGBA[3] = this.lightColor[n2].getAlpha();
            if (this.lightType[n2] == -1) {
                this.lvec[0] = -(this.vertex[0][0] + this.vertex[1][0] + this.vertex[2][0]) * 0.333 + this.lightList[n2][0];
                this.lvec[1] = -(this.vertex[0][1] + this.vertex[1][1] + this.vertex[2][1]) * 0.333 + this.lightList[n2][1];
                this.lvec[2] = -(this.vertex[0][2] + this.vertex[1][2] + this.vertex[2][2]) * 0.333 + this.lightList[n2][2];
            }
            if (this.lightType[n2] == -2) {
                this.lvec[0] = -this.lightTarget[n2][0] + this.lightList[n2][0];
                this.lvec[1] = -this.lightTarget[n2][1] + this.lightList[n2][1] - 1.0E-5;
                this.lvec[2] = -this.lightTarget[n2][2] + this.lightList[n2][2];
            }
            if (this.lightType[n2] == -3) {
                this.lvec[0] = -(this.vertex[0][0] + this.vertex[1][0] + this.vertex[2][0]) * 0.333 + this.lightList[n2][0];
                this.lvec[1] = -(this.vertex[0][1] + this.vertex[1][1] + this.vertex[2][1]) * 0.333 + this.lightList[n2][1];
                this.lvec[2] = -(this.vertex[0][2] + this.vertex[1][2] + this.vertex[2][2]) * 0.333 + this.lightList[n2][2];
            }
            if (this.lightType[n2] == -1 || this.lightType[n2] == -2) {
                this.cos = (this.lvec[0] * this.nvec[0] + this.lvec[1] * this.nvec[1] + this.lvec[2] * this.nvec[2]) / Math.sqrt((this.lvec[0] * this.lvec[0] + this.lvec[1] * this.lvec[1] + this.lvec[2] * this.lvec[2]) * (this.nvec[0] * this.nvec[0] + this.nvec[1] * this.nvec[1] + this.nvec[2] * this.nvec[2]));
                this.cross = this.nvec[0] * this.lvec[0] + this.nvec[1] * this.lvec[1] + this.nvec[2] * this.lvec[2];
                this.abs2_nvec_rev = 1.0 / (this.nvec[0] * this.nvec[0] + this.nvec[1] * this.nvec[1] + this.nvec[2] * this.nvec[2]);
                this.k1 = 2.0 * this.cross * this.abs2_nvec_rev;
                this.refvec[0] = this.k1 * this.nvec[0] - this.lvec[0];
                this.refvec[1] = this.k1 * this.nvec[1] - this.lvec[1];
                this.refvec[2] = this.k1 * this.nvec[2] - this.lvec[2];
                this.specularCos = this.refvec[2] / Math.sqrt(this.refvec[0] * this.refvec[0] + this.refvec[1] * this.refvec[1] + this.refvec[2] * this.refvec[2]);
                this.cosPlus = this.cos < 0.0 ? 0.0 : this.cos;
                double d = this.ftfg.acos(this.cos);
                double d2 = this.ftfg.acos(this.specularCos);
                this.rate = Math.abs(this.element[n].optimumAngle) <= 1.0E-5 ? 0.0 : this.element[n].shininess * this.lightness[n2] * Math.cos(1.570796 * d2 / this.element[n].optimumAngle);
                if (this.cross < 0.0) {
                    // empty if block
                }
                if (d2 > 1.570796) {
                    this.rate = 0.0;
                }
                if (this.rate < 0.0) {
                    this.rate = 0.0;
                }
                this.retRGBA[3] = this.retRGBA[3] + 255.0 * this.rate;
                if (this.retRGBA[3] > 255.0) {
                    this.retRGBA[3] = 255.0;
                } else if (this.retRGBA[3] < 0.0) {
                    this.retRGBA[3] = 0.0;
                }
                for (int i = 0; i < 3; ++i) {
                    this.direct[i] = this.lowRGBA[i] * (this.lightRGBA[i] * 0.00392) * this.element[n].directional * this.cosPlus * this.lightness[n2];
                    this.diffract[i] = this.lowRGBA[i] * (this.lightRGBA[i] * 0.00392) * this.element[n].diffractional * (1.0 - d * 0.159) * this.lightness[n2];
                    int n4 = i;
                    this.retRGBA[n4] = this.retRGBA[n4] + (this.direct[i] + this.diffract[i] + this.diffuse[i]);
                    if (!(d2 < this.element[n].optimumAngle)) continue;
                    this.retRGBA[i] = this.lightRGBA[i] * this.rate + this.retRGBA[i] * (1.0 - this.rate);
                }
            }
            if (this.lightType[n2] == -3) {
                for (int i = 0; i < 3; ++i) {
                    this.ambient[i] = this.lowRGBA[i] * (this.lightRGBA[i] * 0.00392) * this.element[n].ambient * this.lightness[n2];
                    int n5 = i;
                    this.retRGBA[n5] = this.retRGBA[n5] + this.ambient[i];
                }
            }
            for (int i = 0; i < 3; ++i) {
                if (this.retRGBA[i] > 255.0) {
                    this.retRGBA[i] = 255.0;
                    continue;
                }
                if (!(this.retRGBA[i] < 0.0)) continue;
                this.retRGBA[i] = 0.0;
            }
        }
        this.drawColor[n] = new Color((int)this.retRGBA[0], (int)this.retRGBA[1], (int)this.retRGBA[2], (int)this.retRGBA[3]);
    }

    private void setDrawRequest() {
        double[] dArray = new double[3];
        this.requested = 0;
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < this.totalNumberOfPolygon; ++i) {
            bl = true;
            bl2 = true;
            bl = this.element[i].type == 2 && -1.0 <= this.absoluteList[i][0][2] && this.absoluteList[i][0][2] <= 1.0 && -1.0 <= this.absoluteList[i][1][2] && this.absoluteList[i][1][2] <= 1.0 ? true : (this.element[i].type == 3 && -1.0 <= this.absoluteList[i][0][2] && this.absoluteList[i][0][2] <= 1.0 && -1.0 <= this.absoluteList[i][1][2] && this.absoluteList[i][1][2] <= 1.0 && -1.0 <= this.absoluteList[i][2][2] && this.absoluteList[i][2][2] <= 1.0 ? true : (this.element[i].type == 4 && -1.0 <= this.absoluteList[i][0][2] && this.absoluteList[i][0][2] <= 1.0 && -1.0 <= this.absoluteList[i][1][2] && this.absoluteList[i][1][2] <= 1.0 && -1.0 <= this.absoluteList[i][2][2] && this.absoluteList[i][2][2] <= 1.0 && -1.0 <= this.absoluteList[i][3][2] && this.absoluteList[i][3][2] <= 1.0 ? true : -1.0 <= this.absoluteList[i][0][2] && this.absoluteList[i][0][2] <= 1.0));
            if (this.element[i].type == 3 || this.element[i].type == 4) {
                if (this.element[i].type == 4) {
                    this.getNvector(this.absoluteList[i][0], this.absoluteList[i][1], this.absoluteList[i][2], this.absoluteList[i][3], dArray);
                } else {
                    this.getNvector(this.absoluteList[i][0], this.absoluteList[i][1], this.absoluteList[i][2], dArray);
                }
                bl2 = dArray[2] >= 0.0 ? !this.element[i].frontCulling : !this.element[i].backCulling;
            }
            if (!bl || !bl2) continue;
            this.requestChart[this.requested] = i;
            ++this.requested;
        }
    }

    private void __setDrawRequest() {
        this.requested = 0;
        double[][] dArray = new double[4][3];
        dArray[0] = new double[]{0.0, 0.0, 0.0};
        dArray[1] = new double[]{0.0, 0.0, 0.0};
        dArray[2] = new double[]{0.0, 0.0, 0.0};
        dArray[3] = new double[]{0.0, 0.0, 0.0};
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        for (int i = 0; i < this.totalNumberOfPolygon; ++i) {
            double[] dArray4;
            for (int j = 0; j < 4; ++j) {
                double d = 1.0 / -this.absoluteList[i][j][2];
                dArray[j][0] = this.absoluteList[i][j][0] * 1.0 * d;
                dArray[j][1] = this.absoluteList[i][j][1] * 1.0 * d;
                dArray[j][2] = this.absoluteList[i][j][2];
            }
            dArray3[0] = this.Xbuffer[i];
            dArray3[1] = this.Ybuffer[i];
            dArray3[2] = this.Zbuffer[i];
            int n = this.getProjectedX_nopers(dArray3);
            int n2 = this.getProjectedY_nopers(dArray3);
            if (!(this.Nearest[i] < this.nearlimit) || !(this.Nearest[i] > this.farlimit) || this.Lclip >= n || n >= this.Rclip || this.Uclip >= n2 || n2 >= this.Dclip) continue;
            if (this.element[i].type == 5 || this.element[i].type == 6 || this.element[i].type == 7 || this.element[i].type == 8 || this.element[i].type == 9 || this.element[i].type == 11 || this.element[i].type == 0 || this.element[i].type == 1 || this.element[i].type == 2) {
                this.requestChart[this.requested] = i;
                ++this.requested;
                continue;
            }
            if (this.element[i].type != 3 && this.element[i].type != 4) continue;
            if (this.element[i].type == 4) {
                this.getNvector(dArray[0], dArray[1], dArray[2], dArray[3], dArray2);
            } else {
                this.getNvector(dArray[0], dArray[1], dArray[2], dArray2);
            }
            if (dArray2[2] > -2.0E-7) {
                if (this.element[i].frontCulling) continue;
                this.requestChart[this.requested] = i;
                ++this.requested;
                continue;
            }
            if (this.element[i].backCulling) continue;
            if (this.element[i].type == 3) {
                dArray4 = this.absoluteList[i][1];
                this.absoluteList[i][1] = this.absoluteList[i][2];
                this.absoluteList[i][2] = dArray4;
            } else if (this.element[i].type == 4) {
                dArray4 = this.absoluteList[i][1];
                this.absoluteList[i][1] = this.absoluteList[i][3];
                this.absoluteList[i][3] = dArray4;
            }
            this.requestChart[this.requested] = i;
            ++this.requested;
        }
    }

    private int judgeFaceDirection(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.getNvector(dArray, dArray2, dArray3)[2] < -2.0E-7) {
            return 0;
        }
        return 1;
    }

    private void setXYZRbuffer() {
        for (int i = 0; i < this.totalNumberOfPolygon; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            if (this.element[i].getDepthOffset() != null) {
                d += this.depthOffsetList[i][0];
                d2 += this.depthOffsetList[i][1];
                d3 += this.depthOffsetList[i][2];
            }
            if (this.element[i].getDepthOffsetView() != null) {
                d += this.depthOffsetViewList[i][0];
                d2 += this.depthOffsetViewList[i][1];
                d3 += this.depthOffsetViewList[i][2];
            }
            if (this.element[i].type == 3) {
                this.Nearest[i] = Math.max(this.absoluteList[i][0][2], this.absoluteList[i][1][2]);
                this.Nearest[i] = Math.max(this.Nearest[i], this.absoluteList[i][2][2]);
                this.Xbuffer[i] = (this.absoluteList[i][0][0] + this.absoluteList[i][1][0] + this.absoluteList[i][2][0]) / 3.0 + d;
                this.Ybuffer[i] = (this.absoluteList[i][0][1] + this.absoluteList[i][1][1] + this.absoluteList[i][2][1]) / 3.0 + d2;
                this.Zbuffer[i] = (this.absoluteList[i][0][2] + this.absoluteList[i][1][2] + this.absoluteList[i][2][2]) / 3.0 + d3;
                if (0.0 < this.Zbuffer[i]) {
                    this.Zbuffer[i] = 0.0;
                }
                this.Rbuffer[i] = this.Xbuffer[i] * this.Xbuffer[i] + this.Ybuffer[i] * this.Ybuffer[i] + this.Zbuffer[i] * this.Zbuffer[i];
                continue;
            }
            if (this.element[i].type == 4) {
                this.Nearest[i] = Math.max(this.absoluteList[i][0][2], this.absoluteList[i][1][2]);
                this.Nearest[i] = Math.max(this.Nearest[i], this.absoluteList[i][2][2]);
                this.Nearest[i] = Math.max(this.Nearest[i], this.absoluteList[i][3][2]);
                this.Xbuffer[i] = (this.absoluteList[i][0][0] + this.absoluteList[i][1][0] + this.absoluteList[i][2][0] + this.absoluteList[i][3][0]) * 0.25 + d;
                this.Ybuffer[i] = (this.absoluteList[i][0][1] + this.absoluteList[i][1][1] + this.absoluteList[i][2][1] + this.absoluteList[i][3][1]) * 0.25 + d2;
                this.Zbuffer[i] = (this.absoluteList[i][0][2] + this.absoluteList[i][1][2] + this.absoluteList[i][2][2] + this.absoluteList[i][3][2]) * 0.25 + d3;
                if (0.0 < this.Zbuffer[i]) {
                    this.Zbuffer[i] = 0.0;
                }
                this.Rbuffer[i] = this.Xbuffer[i] * this.Xbuffer[i] + this.Ybuffer[i] * this.Ybuffer[i] + this.Zbuffer[i] * this.Zbuffer[i];
                continue;
            }
            if (this.element[i].type == 2) {
                this.Nearest[i] = Math.max(this.absoluteList[i][0][2], this.absoluteList[i][1][2]);
                this.Xbuffer[i] = (this.absoluteList[i][0][0] + this.absoluteList[i][1][0]) * 0.5 + d;
                this.Ybuffer[i] = (this.absoluteList[i][0][1] + this.absoluteList[i][1][1]) * 0.5 + d2;
                this.Zbuffer[i] = (this.absoluteList[i][0][2] + this.absoluteList[i][1][2]) * 0.5 + d3;
                if (0.0 < this.Zbuffer[i]) {
                    this.Zbuffer[i] = 0.0;
                }
                this.Rbuffer[i] = this.Xbuffer[i] * this.Xbuffer[i] + this.Ybuffer[i] * this.Ybuffer[i] + this.Zbuffer[i] * this.Zbuffer[i];
                continue;
            }
            if (this.element[i].type != 1 && this.element[i].type != 0 && this.element[i].type != 5 && this.element[i].type != 6 && this.element[i].type != 7 && this.element[i].type != 8 && this.element[i].type != 9 && this.element[i].type != 11) continue;
            this.Nearest[i] = this.absoluteList[i][0][2];
            this.Xbuffer[i] = this.absoluteList[i][0][0] + d;
            this.Ybuffer[i] = this.absoluteList[i][0][1] + d2;
            this.Zbuffer[i] = this.absoluteList[i][0][2] + d3;
            if (0.0 < this.Zbuffer[i]) {
                this.Zbuffer[i] = 0.0;
            }
            this.Rbuffer[i] = this.Xbuffer[i] * this.Xbuffer[i] + this.Ybuffer[i] * this.Ybuffer[i] + this.Zbuffer[i] * this.Zbuffer[i];
        }
    }

    private void setPriority_comb() {
        int n;
        int n2 = this.requested * 10 / 13;
        int n3 = 0;
        int n4 = 0;
        while (n2 > 1) {
            n = 0;
            while (n + n2 < this.requested) {
                if (this.Rbuffer[this.requestChart[n]] < this.Rbuffer[this.requestChart[n + n2]]) {
                    n4 = this.requestChart[n];
                    this.requestChart[n] = this.requestChart[n + n2];
                    this.requestChart[n + n2] = n4;
                }
                ++n;
            }
            n2 = n2 * 10 / 13;
        }
        do {
            n3 = 0;
            n = 0;
            while (n + 1 < this.requested) {
                if (this.Rbuffer[this.requestChart[n]] < this.Rbuffer[this.requestChart[n + 1]]) {
                    n4 = this.requestChart[n];
                    this.requestChart[n] = this.requestChart[n + 1];
                    this.requestChart[n + 1] = n4;
                    ++n3;
                }
                ++n;
            }
        } while (n3 != 0);
    }

    private void drawTextLayer(int n) {
        this.cx = (double)this.ox + this.absoluteList[n][0][0] * (double)this.width * 0.5;
        this.cy = (double)this.oy - this.absoluteList[n][0][1] * (double)this.height * 0.5;
        this.cr = (double)this.element[n].font.getSize() * this.orthoScaleY(this.element[n].info[0], this.absoluteList[n][0][3]) * (double)this.height * 0.5;
        this.offx = this.orthoScaleX(this.element[n].offset_x, this.absoluteList[n][0][3]) * (double)this.width * 0.5;
        this.offy = this.orthoScaleY(this.element[n].offset_y, this.absoluteList[n][0][3]) * (double)this.height * 0.5;
        this.drawfont = this.element[n].perspective ? (this.element[n].font.isPlain() ? new Font(this.element[n].font.getName(), 0, (int)this.cr) : (this.element[n].font.isBold() ? new Font(this.element[n].font.getName(), 1, (int)this.cr) : (this.element[n].font.isItalic() ? new Font(this.element[n].font.getName(), 2, (int)this.cr) : new Font("Serif", 0, 10)))) : this.element[n].font;
        this.canvasGraphics.setColor(this.element[n].color);
        this.canvasGraphics.setFont(this.drawfont);
        this.canvasGraphics.drawString(this.element[n].string, (int)(this.cx + this.offx), (int)(this.cy - this.offy));
    }

    private void drawImageLayer(int n) {
        this.cx = (double)this.ox + this.absoluteList[n][0][0] * (double)this.width * 0.5;
        this.cy = (double)this.oy - this.absoluteList[n][0][1] * (double)this.height * 0.5;
        this.cw = this.orthoScaleX(this.element[n].info[0], this.absoluteList[n][0][3]) * (double)this.width * 0.5;
        this.ch = this.orthoScaleY(this.element[n].info[1], this.absoluteList[n][0][3]) * (double)this.height * 0.5;
        this.offx = this.orthoScaleX(this.element[n].offset_x, this.absoluteList[n][0][3]) * (double)this.width * 0.5;
        this.offy = this.orthoScaleY(this.element[n].offset_y, this.absoluteList[n][0][3]) * (double)this.height * 0.5;
        if (this.element[n].perspective) {
            this.canvasGraphics.drawImage(this.element[n].image, (int)(this.cx + this.offx), (int)(this.cy - this.offy - this.ch), (int)this.cw, (int)this.ch, null);
        } else {
            this.canvasGraphics.drawImage(this.element[n].image, (int)(this.cx + this.offx), (int)(this.cy - this.offy - this.ch), null);
        }
    }

    private void drawLine(int n) {
        if (0.0 < this.element[n].info[0]) {
            this.drawLine3D(n);
            return;
        }
        this.xPoints[0] = this.ox + (int)(this.absoluteList[n][0][0] * (double)this.width * 0.5);
        this.yPoints[0] = this.oy - (int)(this.absoluteList[n][0][1] * (double)this.height * 0.5);
        this.xPoints[1] = this.ox + (int)(this.absoluteList[n][1][0] * (double)this.width * 0.5);
        this.yPoints[1] = this.oy - (int)(this.absoluteList[n][1][1] * (double)this.height * 0.5);
        this.canvasGraphics.setColor(this.element[n].color);
        this.canvasGraphics.drawPolygon(this.xPoints, this.yPoints, 2);
    }

    private void drawLine3D(int n) {
        this.canvasGraphics.setColor(this.element[n].color);
        this.xPoints[0] = this.ox + (int)(this.absoluteList[n][0][0] * (double)this.width * 0.5);
        this.yPoints[0] = this.oy - (int)(this.absoluteList[n][0][1] * (double)this.height * 0.5);
        this.xPoints[1] = this.ox + (int)(this.absoluteList[n][1][0] * (double)this.width * 0.5);
        this.yPoints[1] = this.oy - (int)(this.absoluteList[n][1][1] * (double)this.height * 0.5);
        if (this.xPoints[1] == this.xPoints[0]) {
            this.cr = this.orthoScaleY(this.element[n].info[0], this.absoluteList[n][1][3]) * (double)this.height * 0.5;
            this.xPoints[2] = (int)((double)this.xPoints[1] - 0.5 * this.cr);
            this.yPoints[2] = this.yPoints[1];
            this.xPoints[3] = (int)((double)this.xPoints[1] + 0.5 * this.cr);
            this.yPoints[3] = this.yPoints[1];
            this.cr = this.orthoScaleY(this.element[n].info[0], this.absoluteList[n][0][3]) * (double)this.height * 0.5;
            this.xPoints[1] = (int)((double)this.xPoints[0] - 0.5 * this.cr);
            this.yPoints[1] = this.yPoints[0];
            this.xPoints[0] = (int)((double)this.xPoints[0] + 0.5 * this.cr);
            this.yPoints[0] = this.yPoints[0];
        } else if (this.yPoints[1] == this.yPoints[0]) {
            this.cr = this.orthoScaleY(this.element[n].info[0], this.absoluteList[n][1][3]) * (double)this.height * 0.5;
            this.xPoints[2] = this.xPoints[1];
            this.yPoints[2] = (int)((double)this.yPoints[1] - 0.5 * this.cr);
            this.xPoints[3] = this.xPoints[1];
            this.yPoints[3] = (int)((double)this.yPoints[1] + 0.5 * this.cr);
            this.cr = this.orthoScaleY(this.element[n].info[0], this.absoluteList[n][0][3]) * (double)this.height * 0.5;
            this.xPoints[1] = this.xPoints[0];
            this.yPoints[1] = (int)((double)this.yPoints[0] - 0.5 * this.cr);
            this.xPoints[0] = this.xPoints[0];
            this.yPoints[0] = (int)((double)this.yPoints[0] + 0.5 * this.cr);
        } else {
            double d = (double)(this.yPoints[1] - this.yPoints[0]) / (double)(this.xPoints[1] - this.xPoints[0]);
            double d2 = 1.0 / d;
            this.cr = this.orthoScaleY(this.element[n].info[0], this.absoluteList[n][0][3]) * (double)this.height * 0.5;
            double d3 = 0.5 * this.cr * 1.0 / Math.sqrt(1.0 + d2 * d2);
            double d4 = (double)this.xPoints[0] + d3;
            double d5 = (double)this.yPoints[0] - d3 * d2;
            double d6 = (double)this.xPoints[0] - d3;
            double d7 = (double)this.yPoints[0] + d3 * d2;
            this.cr = this.orthoScaleY(this.element[n].info[0], this.absoluteList[n][1][3]) * (double)this.height * 0.5;
            d3 = 0.5 * this.cr * 1.0 / Math.sqrt(1.0 + d2 * d2);
            double d8 = (double)this.xPoints[1] + d3;
            double d9 = (double)this.yPoints[1] - d3 * d2;
            double d10 = (double)this.xPoints[1] - d3;
            double d11 = (double)this.yPoints[1] + d3 * d2;
            this.xPoints[0] = (int)d4;
            this.yPoints[0] = (int)d5;
            this.xPoints[1] = (int)d6;
            this.yPoints[1] = (int)d7;
            this.xPoints[2] = (int)d10;
            this.yPoints[2] = (int)d11;
            this.xPoints[3] = (int)d8;
            this.yPoints[3] = (int)d9;
        }
        this.canvasGraphics.setColor(this.element[n].color);
        this.canvasGraphics.fillPolygon(this.xPoints, this.yPoints, 4);
    }

    private void drawCircle(int n) {
        this.cx = (double)this.ox + this.absoluteList[n][0][0] * (double)this.width * 0.5;
        this.cy = (double)this.oy - this.absoluteList[n][0][1] * (double)this.height * 0.5;
        if (this.element[n].perspective) {
            this.crx = this.orthoScaleX(this.element[n].info[0], this.absoluteList[n][0][3]) * (double)this.width * 0.5;
            this.cry = this.orthoScaleY(this.element[n].info[0], this.absoluteList[n][0][3]) * (double)this.height * 0.5;
        } else {
            this.crx = this.element[n].info[0];
            this.cry = this.element[n].info[0];
        }
        this.canvasGraphics.setColor(this.element[n].color);
        if ((int)this.crx <= 0 || (int)this.cry <= 0) {
            this.canvasGraphics.fillRect((int)this.cx, (int)this.cy, 1, 1);
        } else if (this.element[n].fill) {
            this.canvasGraphics.fillOval((int)(this.cx - this.crx), (int)(this.cy - this.cry), (int)(2.0 * this.crx), (int)(2.0 * this.cry));
        } else {
            this.canvasGraphics.drawOval((int)(this.cx - this.crx), (int)(this.cy - this.cry), (int)(2.0 * this.crx), (int)(2.0 * this.cry));
        }
    }

    private void fillTriangle(int n) {
        this.xPoints[0] = this.ox + (int)(this.absoluteList[n][0][0] * (double)this.width * 0.5);
        this.yPoints[0] = this.oy - (int)(this.absoluteList[n][0][1] * (double)this.height * 0.5);
        this.xPoints[1] = this.ox + (int)(this.absoluteList[n][1][0] * (double)this.width * 0.5);
        this.yPoints[1] = this.oy - (int)(this.absoluteList[n][1][1] * (double)this.height * 0.5);
        this.xPoints[2] = this.ox + (int)(this.absoluteList[n][2][0] * (double)this.width * 0.5);
        this.yPoints[2] = this.oy - (int)(this.absoluteList[n][2][1] * (double)this.height * 0.5);
        this.canvasGraphics.setColor(this.drawColor[n]);
        if (this.element[n].fill) {
            this.canvasGraphics.fillPolygon(this.xPoints, this.yPoints, 3);
        } else {
            this.canvasGraphics.drawPolygon(this.xPoints, this.yPoints, 3);
        }
    }

    private void fillQuadrangle(int n) {
        this.xPoints[0] = this.ox + (int)(this.absoluteList[n][0][0] * (double)this.width * 0.5);
        this.yPoints[0] = this.oy - (int)(this.absoluteList[n][0][1] * (double)this.height * 0.5);
        this.xPoints[1] = this.ox + (int)(this.absoluteList[n][1][0] * (double)this.width * 0.5);
        this.yPoints[1] = this.oy - (int)(this.absoluteList[n][1][1] * (double)this.height * 0.5);
        this.xPoints[2] = this.ox + (int)(this.absoluteList[n][2][0] * (double)this.width * 0.5);
        this.yPoints[2] = this.oy - (int)(this.absoluteList[n][2][1] * (double)this.height * 0.5);
        this.xPoints[3] = this.ox + (int)(this.absoluteList[n][3][0] * (double)this.width * 0.5);
        this.yPoints[3] = this.oy - (int)(this.absoluteList[n][3][1] * (double)this.height * 0.5);
        this.canvasGraphics.setColor(this.drawColor[n]);
        if (this.element[n].fill) {
            this.canvasGraphics.fillPolygon(this.xPoints, this.yPoints, 4);
        } else {
            this.canvasGraphics.drawPolygon(this.xPoints, this.yPoints, 4);
        }
    }

    private void drawTriangle(int n) {
        this.xPoints[0] = this.ox + (int)(this.absoluteList[n][0][0] * (double)this.width * 0.5);
        this.yPoints[0] = this.oy - (int)(this.absoluteList[n][0][1] * (double)this.height * 0.5);
        this.xPoints[1] = this.ox + (int)(this.absoluteList[n][1][0] * (double)this.width * 0.5);
        this.yPoints[1] = this.oy - (int)(this.absoluteList[n][1][1] * (double)this.height * 0.5);
        this.xPoints[2] = this.ox + (int)(this.absoluteList[n][2][0] * (double)this.width * 0.5);
        this.yPoints[2] = this.oy - (int)(this.absoluteList[n][2][1] * (double)this.height * 0.5);
        this.canvasGraphics.setColor(this.element[n].color);
        this.canvasGraphics.drawPolygon(this.xPoints, this.yPoints, 3);
    }

    private void drawQuadrangle(int n) {
        this.xPoints[0] = this.ox + (int)(this.absoluteList[n][0][0] * (double)this.width * 0.5);
        this.yPoints[0] = this.oy - (int)(this.absoluteList[n][0][1] * (double)this.height * 0.5);
        this.xPoints[1] = this.ox + (int)(this.absoluteList[n][1][0] * (double)this.width * 0.5);
        this.yPoints[1] = this.oy - (int)(this.absoluteList[n][1][1] * (double)this.height * 0.5);
        this.xPoints[2] = this.ox + (int)(this.absoluteList[n][2][0] * (double)this.width * 0.5);
        this.yPoints[2] = this.oy - (int)(this.absoluteList[n][2][1] * (double)this.height * 0.5);
        this.xPoints[3] = this.ox + (int)(this.absoluteList[n][3][0] * (double)this.width * 0.5);
        this.yPoints[3] = this.oy - (int)(this.absoluteList[n][3][1] * (double)this.height * 0.5);
        this.canvasGraphics.setColor(this.element[n].color);
        this.canvasGraphics.drawPolygon(this.xPoints, this.yPoints, 4);
    }

    private void drawPoint(int n) {
        this.inv_stock = 1.0 / -this.absoluteList[n][0][2];
        this.cx = (double)this.ox + this.absoluteList[n][0][0] * this.inv_stock * this.magnification;
        this.cy = (double)this.oy - this.absoluteList[n][0][1] * this.inv_stock * this.magnification;
        this.cr = this.element[n].info[0];
        this.canvasGraphics.setColor(this.element[n].color);
        this.canvasGraphics.fillArc((int)(this.cx - this.cr), (int)(this.cy - this.cr), (int)(2.0 * this.cr), (int)(2.0 * this.cr), 0, 360);
    }

    private void drawImagePanel(int n) {
        this.cx = this.getProjectedX_nopers(this.getPersPoints(this.absoluteList[n])[0]);
        this.cy = this.getProjectedY_nopers(this.getPersPoints(this.absoluteList[n])[0]);
        this.canvasGraphics.drawImage(this.element[n].image, (int)this.cx - (int)this.element[n].offset_x, (int)this.cy - (int)this.element[n].offset_y, null);
    }

    private void drawImagePanel3d(int n) {
        this.inv_stock = 1.0 / -this.absoluteList[n][0][2];
        this.cx = this.getProjectedX_nopers(this.getPersPoints(this.absoluteList[n])[0]);
        this.cy = this.getProjectedY_nopers(this.getPersPoints(this.absoluteList[n])[0]);
        this.cw = this.element[n].info[0] * 1.0 * this.inv_stock * this.magnification;
        this.ch = this.element[n].info[1] * 1.0 * this.inv_stock * this.magnification;
        this.offx = this.element[n].offset_x * 1.0 / -this.absoluteList[n][0][2] * this.magnification;
        this.offy = this.element[n].offset_y * 1.0 / -this.absoluteList[n][0][2] * this.magnification;
        this.canvasGraphics.drawImage(this.element[n].image, (int)(this.cx - this.offx), (int)(this.cy - this.offy), (int)this.cw, (int)this.ch, null);
    }

    private void drawStringPanel(int n) {
        this.inv_stock = 1.0 / -this.absoluteList[n][0][2];
        this.cx = (double)this.ox + 1.0 * this.absoluteList[n][0][0] * this.inv_stock * this.magnification;
        this.cy = (double)this.oy - 1.0 * this.absoluteList[n][0][1] * this.inv_stock * this.magnification;
        this.cr = this.element[n].info[0] * 1.0 * this.inv_stock;
        this.offx = this.element[n].offset_x * 1.0 * this.inv_stock * this.magnification;
        this.offy = this.element[n].offset_y * 1.0 * this.inv_stock * this.magnification;
        this.drawfont = this.element[n].font.isPlain() ? new Font(this.element[n].font.getName(), 0, (int)this.cr) : (this.element[n].font.isBold() ? new Font(this.element[n].font.getName(), 1, (int)this.cr) : (this.element[n].font.isItalic() ? new Font(this.element[n].font.getName(), 2, (int)this.cr) : new Font("Serif", 0, 10)));
        this.canvasGraphics.setColor(this.element[n].color);
        this.canvasGraphics.setFont(this.drawfont);
        this.canvasGraphics.drawString(this.element[n].string, (int)(this.cx - this.offx), (int)(this.cy - this.offy));
    }

    private void drawString(int n) {
        this.inv_stock = 1.0 / -this.absoluteList[n][0][2];
        this.cx = (double)this.ox + this.absoluteList[n][0][0] * this.inv_stock * this.magnification;
        this.cy = (double)this.oy - this.absoluteList[n][0][1] * this.inv_stock * this.magnification;
        this.canvasGraphics.setColor(this.element[n].color);
        this.canvasGraphics.setFont(this.element[n].font);
        this.canvasGraphics.drawString(this.element[n].string, (int)this.cx - (int)this.element[n].offset_x, (int)this.cy - (int)this.element[n].offset_y);
    }

    private synchronized Graphics2D b() {
        this.canvasGraphics.setBackground(this.bgcolor);
        this.canvasGraphics.clearRect(0, 0, this.width, this.height);
        return this.canvasGraphics;
    }
}

