/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.VnanoScriptEngineFactory;
import org.vcssl.nano.interconnect.PluginLoader;
import org.vcssl.nano.interconnect.ScriptLoader;

public final class VnanoScriptEngine
implements ScriptEngine {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private VnanoEngine vnanoEngine = null;
    private ScriptLoader libraryScriptLoader = null;
    private PluginLoader pluginLoader = null;
    private Bindings putPluginBindings = null;
    private boolean putPluginBindingsUpdated = false;
    private boolean loadedPluginUpdated = false;
    private boolean loadedLibraryUpdated = false;

    protected VnanoScriptEngine() {
        try {
            this.putPluginBindings = new SimpleBindings(new LinkedHashMap<String, Object>());
            this.libraryScriptLoader = new ScriptLoader(DEFAULT_ENCODING);
            this.pluginLoader = new PluginLoader(DEFAULT_ENCODING);
            this.vnanoEngine = new VnanoEngine();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    @Override
    public Object eval(String string) throws ScriptException {
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            this.updatePluginConnections();
            this.updateLibraryInclusions();
            Object object = this.vnanoEngine.executeScript(string);
            return object;
        }
        catch (VnanoException vnanoException) {
            String string2 = vnanoException.getMessageWithoutLocation();
            if (string2 != null) {
                ScriptException scriptException = null;
                scriptException = vnanoException.hasFileName() && vnanoException.hasLineNumber() ? new ScriptException(string2 + ":", vnanoException.getFileName(), vnanoException.getLineNumber()) : new ScriptException(string2);
                try {
                    scriptException.initCause(vnanoException);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                throw scriptException;
            }
            throw new ScriptException(vnanoException);
        }
        catch (Exception exception) {
            ScriptException scriptException = new ScriptException(exception);
            throw scriptException;
        }
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        if (reader == null) {
            throw new NullPointerException();
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = -1;
            while ((n = reader.read()) != -1) {
                stringBuilder.append((char)n);
            }
            String string = stringBuilder.toString();
            return this.eval(string);
        }
        catch (IOException iOException) {
            throw new ScriptException(iOException);
        }
    }

    private void updatePluginConnections() throws VnanoException {
        if (!this.putPluginBindingsUpdated && !this.loadedPluginUpdated) {
            return;
        }
        this.putPluginBindingsUpdated = false;
        this.loadedPluginUpdated = false;
        this.vnanoEngine.disconnectAllPlugins();
        if (this.pluginLoader.hasPlugins()) {
            String[] stringArray = this.pluginLoader.getPluginNames();
            Object[] object = this.pluginLoader.getPluginInstances();
            for (int i = 0; i < stringArray.length; ++i) {
                this.vnanoEngine.connectPlugin("___VNANO_AUTO_KEY", object[i]);
            }
        }
        for (Map.Entry entry : this.putPluginBindings.entrySet()) {
            this.vnanoEngine.connectPlugin((String)entry.getKey(), entry.getValue());
        }
    }

    private void updateLibraryInclusions() throws VnanoException {
        if (!this.loadedLibraryUpdated) {
            return;
        }
        this.loadedLibraryUpdated = false;
        this.vnanoEngine.unregisterAllLibraryScripts();
        if (this.libraryScriptLoader.hasLibraryScripts()) {
            String[] stringArray = this.libraryScriptLoader.getLibraryScriptPaths(true);
            String[] stringArray2 = this.libraryScriptLoader.getLibraryScriptContents();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.vnanoEngine.registerLibraryScript(stringArray[i], stringArray2[i]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void put(String string, Object object) {
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        if (string.equals("___VNANO_OPTION_MAP")) {
            if (!(object instanceof Map)) throw new VnanoFatalException("The type of \"___VNANO_OPTION_MAP\" should be \"Map<String,Object>\"");
            Map map = (Map)object;
            try {
                this.vnanoEngine.setOptionMap(map);
                return;
            }
            catch (VnanoException vnanoException) {
                throw new VnanoFatalException(vnanoException);
            }
        } else if (string.equals("___VNANO_PERMISSION_MAP")) {
            if (!(object instanceof Map)) throw new VnanoFatalException("The type of \"___VNANO_PERMISSION_MAP\" should be \"Map<String,String>\"");
            Map map = (Map)object;
            try {
                this.vnanoEngine.setPermissionMap(map);
                return;
            }
            catch (VnanoException vnanoException) {
                throw new VnanoFatalException(vnanoException);
            }
        } else if (string.equals("___VNANO_COMMAND")) {
            if (!(object instanceof String)) {
                throw new VnanoFatalException("Invalid command (should be a String)");
            }
            this.handleCommands((String)object);
            return;
        } else if (string.equals("___VNANO_LIBRARY_LIST_FILE")) {
            this.libraryScriptLoader.setLibraryScriptListPath((String)object);
            this.loadLibraries();
            return;
        } else if (string.equals("___VNANO_PLUGIN_LIST_FILE")) {
            this.pluginLoader.setPluginListPath((String)object);
            this.loadPlugins();
            return;
        } else {
            this.putPluginBindings.put(string, object);
            this.putPluginBindingsUpdated = true;
        }
    }

    private void loadPlugins() {
        try {
            this.pluginLoader.load();
            this.loadedPluginUpdated = true;
        }
        catch (VnanoException vnanoException) {
            throw new VnanoFatalException("Plugin loading failed", vnanoException);
        }
    }

    private void loadLibraries() {
        try {
            this.libraryScriptLoader.load();
            this.loadedLibraryUpdated = true;
        }
        catch (VnanoException vnanoException) {
            throw new VnanoFatalException("Library loading failed", vnanoException);
        }
    }

    private void handleCommands(String string) {
        switch (string) {
            case "REMOVE_PLUGIN": {
                try {
                    this.vnanoEngine.disconnectAllPlugins();
                }
                catch (VnanoException vnanoException) {
                    throw new VnanoFatalException(vnanoException);
                }
                this.pluginLoader = new PluginLoader(DEFAULT_ENCODING);
                this.loadedPluginUpdated = true;
                break;
            }
            case "REMOVE_LIBRARY": {
                this.libraryScriptLoader = new ScriptLoader(DEFAULT_ENCODING);
                this.loadedLibraryUpdated = true;
                break;
            }
            case "RELOAD_PLUGIN": {
                this.loadPlugins();
                break;
            }
            case "RELOAD_LIBRARY": {
                this.loadLibraries();
                break;
            }
            case "TERMINATE_SCRIPT": {
                this.vnanoEngine.terminateScript();
                break;
            }
            case "RESET_TERMINATOR": {
                this.vnanoEngine.resetTerminator();
                break;
            }
            default: {
                throw new VnanoFatalException("Unknown command: " + string);
            }
        }
    }

    @Override
    public Object get(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("___VNANO_PERFORMANCE_MAP")) {
            return this.vnanoEngine.getPerformanceMap();
        }
        if (string.equals("javax.script.name")) {
            return "Vnano";
        }
        if (string.equals("javax.script.language")) {
            return "Vnano";
        }
        if (string.equals("javax.script.language_version")) {
            return "1.1.2";
        }
        if (string.equals("javax.script.engine")) {
            return "RINEARN Vnano Engine";
        }
        if (string.equals("javax.script.engine_version")) {
            return "1.1.2";
        }
        return this.putPluginBindings.get(string);
    }

    @Override
    public Object eval(String string, Bindings bindings) throws ScriptException {
        throw new VnanoFatalException("This feature is unsupported");
    }

    @Override
    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        throw new VnanoFatalException("This feature is unsupported");
    }

    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        throw new VnanoFatalException("This feature is unsupported");
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        throw new VnanoFatalException("This feature is unsupported");
    }

    @Override
    public Bindings getBindings(int n) {
        return null;
    }

    @Override
    public void setBindings(Bindings bindings, int n) {
        if (bindings == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Bindings createBindings() {
        return null;
    }

    @Override
    public ScriptContext getContext() {
        return null;
    }

    @Override
    public void setContext(ScriptContext scriptContext) {
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new VnanoScriptEngineFactory();
    }
}

