/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class BlockStatementCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testScopesOfVariablesAndBlocks();
            this.testDuplicateVariableDeclarationsAndBlocks();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testScopesOfVariablesAndBlocks() throws VnanoException {
        String string = " int a = 0;       \n {                \n     a = 123;     \n }                \n a;               \n";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 123L, "int a=0; { a=123; } ", string);
        string = " {                 \n     int a = 0;    \n }                 \n a = 123;          \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("{ int a=0; } a=123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("{ int a=0; } a=123; (should be failed) ");
        }
        string = " {                 \n     int a = 0;    \n }                 \n                   \n {                 \n     a = 123;      \n }                 \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("{ int a=0; } { a=123; } (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("{ int a=0; } a=123; (should be failed) ");
        }
        string = " int a = 0;        \n {                 \n     a++;          \n     {             \n         a++;      \n     }             \n }                 \n a;                \n";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "int a=0; { a++; { a++; } } ", string);
        string = " int a = 0;        \n int b = 0;        \n {                 \n     a++;          \n     {             \n         a++;      \n     }             \n     a++;          \n     b++;          \n }                 \n a + \",\" + b;    \n";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "3,1", "int a=0; int b=0; { a++; { a++; } a++; b++; } ", string);
        string = " {                   \n     int a = 0;      \n     {               \n         int b = 0;  \n         a++;        \n     }               \n     b++;            \n }                   \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("{ int a=0; { int b=0; a++; } b++; } (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("{ int a=0; { int b=0; a++; } b++; } (should be failed) ");
        }
        string = " {                   \n     int a = 0;      \n     {               \n         int b = 0;  \n     }               \n }                   \n a = 123;            \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("{ int a=0; { int b=0; } } a=123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("{ int a=0; { int b=0; } } a=123; (should be failed) ");
        }
    }

    void testDuplicateVariableDeclarationsAndBlocks() throws VnanoException {
        String string = " {                \n     int a = 1;   \n }                \n {                \n     int a = 2;   \n }                \n";
        this.engine.executeScript(string);
        this.succeeded("{ int a=1; } { int a=2; } ");
        string = " {                \n     int a = 1;   \n     int a = 2;   \n }                \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("{ int a=1; int a=2; } (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("{ int a=1; int a=2; } (should be failed) ");
        }
        string = " {                   \n     int a = 1;      \n     {               \n         int a = 2;  \n     }               \n }                   \n";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("{ int a=1; { int a=2; } } (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("{ int a=1; { int a=2; } } (should be failed) ");
        }
    }
}

