/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class ScalarArithmeticOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAdditions();
            this.testMultiplications();
            this.testDivisions();
            this.testSubtractions();
            this.testRemainders();
            this.testDualOperations();
            this.testTripleOperations();
            this.testQuadOperations();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAdditions() throws VnanoException {
        String string = " 1 + 2 ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "int + int", string);
        string = " 1 + 2.2 ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 3.2, "int + float", string);
        string = " 1 + \"str\" ; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "1str", "int + string", string);
        string = " 1.1 + 2 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 3.1, "float + int", string);
        string = " 1.1 + 2.2 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 3.3000000000000003, "float + float", string);
        string = " 1.1 + \"str\" ; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "1.1str", "float + string", string);
        string = " \"str\" + 2 ; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "str2", "string + int", string);
        string = " \"str\" + 2.2 ; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "str2.2", "string + float", string);
        string = " \"str\" + \"ing\" ; ";
        string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "string", "string + string", string);
    }

    private void testSubtractions() throws VnanoException {
        String string = " 1 - 2 ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, -1L, "int - int (negative result)", string);
        string = " 10 - 3 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 7L, "int - int (positive result)", string);
        string = " 1 - 2.3 ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -1.2999999999999998, "int - float", string);
        string = " 1.2 - 3 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -1.8, "float - int", string);
        string = " 1.2 - 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -2.2, "float - float (negative result)", string);
        string = " 5.6 - 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 2.1999999999999997, "float - float (positive result)", string);
    }

    private void testMultiplications() throws VnanoException {
        String string = " 2 * 3 ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 6L, "int * int", string);
        string = " 2 * 2.3 ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 4.6, "int * float", string);
        string = " 2.3 * 2 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 4.6, "float * int", string);
        string = " 2.3 * 4.5 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 10.35, "float * float", string);
    }

    private void testDivisions() throws VnanoException {
        String string = " 10 / 2 ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "int / int", string);
        string = " 10 / 3 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "int / int (indivisible)", string);
        string = " 10 / 2.3 ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 4.347826086956522, "int / float", string);
        string = " 12.3 / 2 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.15, "float / int", string);
        string = " 1.2 / 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.35294117647058826, "float / float", string);
    }

    private void testRemainders() throws VnanoException {
        String string = " 10 % 3 ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 1L, "int % int", string);
        string = " 10 % 2.3 ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.8000000000000007, "int % float", string);
        string = " 12.3 % 2 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.3000000000000007, "float % int", string);
        string = " 12.3 % 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 2.100000000000001, "float % float", string);
    }

    private void testDualOperations() throws VnanoException {
        String string = " 1 + 2 + 3 ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 6L, "int + int + int", string);
        string = " 1.2 + 2.3 + 3.4 ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.9, "float + float + float", string);
        string = " 1.2 + 2 + 3 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.2, "float + int + int", string);
        string = " 1 + 2.3 + 3 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.3, "int + float + int", string);
        string = " 1 + 2 + 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.4, "int + int + float", string);
        string = " 1.2 + 2 + 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.6, "float + int + float", string);
        string = " 1.2 + 2.3 + 3 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.5, "float + float + int", string);
        string = " 1 + 2.3 + 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.699999999999999, "int + float + float", string);
        string = " 1 - 2 + 3 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "int - int + int", string);
        string = " (1 - 2) + 3 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "(int - int) + int", string);
        string = " 1 - (2 + 3) ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, -4L, "int - (int + int)", string);
        string = " 1.2 - 2.3 + 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 2.3, "float - float + float", string);
        string = " (1.2 - 2.3) + 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 2.3, "(float - float) + float", string);
        string = " 1.2 - (2.3 + 3.4) ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -4.499999999999999, "float - (float + float)", string);
        string = " 1 + 2 * 3 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 7L, "int + int * int", string);
        string = " (1 + 2) * 3 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 9L, "(int + int) * int", string);
        string = " 1 + (2 * 3) ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 7L, "int + (int * int)", string);
        string = " 1.2 + 2.3 * 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 9.02, "float + float * float", string);
        string = " (1.2 + 2.3) * 3.4 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 11.9, "(float + float) * float", string);
        string = " 1.2 + (2.3 * 3.4) ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 9.02, "float + (float * float)", string);
    }

    private void testTripleOperations() throws VnanoException {
        String string = " 1 + 2 + 3 + 4 ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "int + int + int + int", string);
        string = " 1 - 2 + 3 - 4 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, -2L, "int - int + int - int", string);
        string = " 1 - (2 + 3) - 4 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, -8L, "int - (int + int) - int", string);
        string = " 1 - (2 + 3 - 4) ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 0L, "int - (int + int - int)", string);
        string = " 1.2 + 2.3 + 3.4 + 4.5 ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 11.4, "float + float + float + float", string);
        string = " 1.2 - 2.3 + 3.4 - 4.5 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -2.2, "float - float + float - float", string);
        string = " 1.2 - (2.3 + 3.4) - 4.5 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -9.0, "float - (float + float) - float", string);
        string = " 1.2 - (2.3 + 3.4 - 4.5) ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 6.661338147750939E-16, "float - (float + float - float)", string);
        string = " 1 * 2 * 3 * 4 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 24L, "int * int * int * int", string);
        string = " 1 + 2 * 3 + 4 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 11L, "int + int * int + int", string);
        string = " 1 * 2 + 3 * 4 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 14L, "int * int + int * int", string);
        string = " 1 + 2 * 3 * 4 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 25L, "int + int * int * int", string);
        string = " 1 * 2 * 3 + 4 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "int * int * int + int", string);
        string = " 1 * 2 * (3 + 4) ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 14L, "int * int * (int + int)", string);
        string = " 1 * (2 * 3 + 4) ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 10L, "int * (int * int + int)", string);
        string = " 1.2 * 2.3 * 3.4 * 4.5 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 42.227999999999994, "float * float * float * float", string);
        string = " 1.2 + 2.3 * 3.4 + 4.5 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 13.52, "float + float * float + float", string);
        string = " 1.2 * 2.3 + 3.4 * 4.5 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 18.06, "float * float + float * float", string);
        string = " 1.2 + 2.3 * 3.4 * 4.5 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 36.39, "float + float * float * float", string);
        string = " 1.2 * 2.3 * 3.4 + 4.5 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 13.883999999999999, "float * float * float + float", string);
        string = " 1.2 * 2.3 * (3.4 + 4.5) ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 21.804, "float * float * (float + float)", string);
        string = " 1.2 * (2.3 * 3.4 + 4.5) ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 14.783999999999999, "float * (float * float + float)", string);
    }

    private void testQuadOperations() throws VnanoException {
        String string = " 1 + 2 + 3 + 4 + 5 ; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 15L, "int + int + int + int + int", string);
        string = " 1 + 2 + 3 * 4 + 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 20L, "int + int + int * int + int", string);
        string = " 1 + 2 * 3 * 4 + 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 30L, "int + int * int * int + int", string);
        string = " 1 + 2 * 3 + 4 * 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 27L, "int + int * int + int * int", string);
        string = " 1 + 2 * 3 * 4 * 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 121L, "int + int * int * int * int", string);
        string = " 1 * 2 + 3 + 4 * 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 25L, "int * int + int + int * int", string);
        string = " 1 * 2 * 3 * 4 * 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 120L, "int * int * int * int * int", string);
        string = " 10 + 20 * 30 - 40 / 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 602L, "int + int * int - int / int", string);
        string = " ((10 + 20) * 30 - 40) / 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 172L, "((int + int) * int - int) / int", string);
        string = " 10 + 20 * (30 - 40 / 5) ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 450L, "(int + int * (int - int / int)", string);
        string = " 10 + 20 * ((30 - 40) / 5) ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, -30L, "(int + int * ((int - int) / int)", string);
        string = " 10 + (20 * (30 - 40)) / 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, -30L, "(int + (int * (int - int)) / int", string);
        string = " (10 + (20 * (30 - 40))) / 5 ; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, -38L, "((int + (int * (int - int))) / int", string);
        string = " 1.2 + 2.3 + 3.4 + 4.5 + 5.6 ; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 17.0, "float + float + float + float + float", string);
        string = " 1.2 + 2.3 + 3.4 * 4.5 + 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 24.4, "float + float + float * float + float", string);
        string = " 1.2 + 2.3 * 3.4 * 4.5 + 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 41.99, "float + float * float * float + float", string);
        string = " 1.2 + 2.3 * 3.4 + 4.5 * 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 34.22, "float + float * float + float * float", string);
        string = " 1.2 + 2.3 * 3.4 * 4.5 * 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 198.26399999999995, "float + float * float * float * float", string);
        string = " 1.2 * 2.3 + 3.4 + 4.5 * 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 31.36, "float * float + float + float * float", string);
        string = " 1.2 * 2.3 * 3.4 * 4.5 * 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 236.47679999999994, "float * float * float * float * float", string);
        string = " 1.2 + 2.3 * 3.4 - 4.5 / 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 8.21642857142857, "float + float * float - float / float", string);
        string = " ((1.2 + 2.3) * 3.4 - 4.5) / 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1.3214285714285716, "((float + float) * float - float) / float", string);
        string = " 1.2 + 2.3 * (3.4 - 4.5 / 5.6) ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 7.171785714285714, "float + float * (float - float / float)", string);
        string = " 1.2 + 2.3 * ((3.4 - 4.5) / 5.6) ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.7482142857142857, "float + float * ((float - float) / float)", string);
        string = " 1.2 + (2.3 * (3.4 - 4.5)) / 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.7482142857142857, "float + (float * ((float - float) / float", string);
        string = " (1.2 + (2.3 * (3.4 - 4.5))) / 5.6 ; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -0.2375, "(float + (float * ((float - float)) / float", string);
    }
}

