/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class ScalarCompoundAssignmentOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAddAssignmentOperations();
            this.testSubAssignmentOperations();
            this.testMulAssignmentOperations();
            this.testDivAssignmentOperations();
            this.testRemAssignmentOperations();
            this.testCompoundAssignmentOperationsToConstants();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAddAssignmentOperations() throws VnanoException {
        String string = " int x = 123; x += 456; x; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 579L, "int += int", string);
        string = " int x = 123; x += 4.56; x; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 127L, "int += float", string);
        string = " float x = 1.25; x += 2.5; x; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 3.75, "float += float", string);
        string = " float x = 1.25; x += 123; x; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 124.25, "float += int", string);
        string = " string x = \"abc\"; x += \"de\"; x; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "abcde", "string += string", string);
    }

    private void testSubAssignmentOperations() throws VnanoException {
        String string = " int x = 123; x -= 456; x; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, -333L, "int += int", string);
        string = " int x = 123; x -= 4.56; x; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 118L, "int += float", string);
        string = " float x = 1.25; x -= 2.5; x; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -1.25, "float += float", string);
        string = " float x = 1.25; x -= 123; x; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -121.75, "float += int", string);
    }

    private void testMulAssignmentOperations() throws VnanoException {
        String string = " int x = 123; x *= 456; x; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 56088L, "int += int", string);
        string = " int x = 123; x *= 4.56; x; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 560L, "int += float", string);
        string = " float x = 1.25; x *= 2.5; x; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 3.125, "float += float", string);
        string = " float x = 1.25; x *= 123; x; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 153.75, "float += int", string);
    }

    private void testDivAssignmentOperations() throws VnanoException {
        String string = " int x = 123; x /= 2; x; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 61L, "int /= int", string);
        string = " int x = 123; x /= 2.5; x; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 49L, "int /= float", string);
        string = " float x = 1.25; x /= 2.5; x; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.5, "float /= float", string);
        string = " float x = 2.5; x /= 2; x; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 1.25, "float /= int", string);
    }

    private void testRemAssignmentOperations() throws VnanoException {
        String string = " int x = 123; x %= 2; x; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 1L, "int %= int", string);
        string = " int x = 123; x %= 100.5; x; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 22L, "int %= float", string);
        string = " float x = 2.25; x %= 1.0; x; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.25, "float %= float", string);
        string = " float x = 2.5; x %= 2; x; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.5, "float %= int", string);
    }

    private void testCompoundAssignmentOperationsToConstants() throws VnanoException {
        String string = "const int x; x += 123;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int x; x += 123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int x; x += 123; (should be failed) ");
        }
        string = "const int x; x -= 123;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int x; x -= 123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int x; x -= 123; (should be failed) ");
        }
        string = "const int x; x *= 123;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int x; x *= 123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int x; x *= 123; (should be failed) ");
        }
        string = "const int x; x /= 123;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int x; x /= 123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int x; x /= 123; (should be failed) ");
        }
        string = "const int x; x %= 123;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int x; x %= 123; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int x; x %= 123; (should be failed) ");
        }
    }
}

