/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class SubscriptedCompoundAssignmentOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;
    private static final String DECLVEC_INT_A = "int a[3]; a[0]=10; a[1]=50; a[2]=30; ";
    private static final String DECLVEC_INT_B = "int b[3]; b[0]=5; b[1]=50; b[2]=10; ";
    private static final String DECLVEC_FLOAT_A = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; ";
    private static final String DECLVEC_FLOAT_B = "float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; ";
    private static final String DECLVEC_STRING_A = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; ";
    private static final String DECLVEC_STRING_B = "string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; ";

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testAddAssignmentOperations();
            this.testSubAssignmentOperations();
            this.testMulAssignmentOperations();
            this.testDivAssignmentOperations();
            this.testRemAssignmentOperations();
            this.testCompoundAssignmentOperationsToConstants();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testAddAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] += b[2]; a[2]; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 40L, "int[i] += int[i]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] += b[2]; a[2]; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 42L, "int[i] += float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] += b[2]; a[2]; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 20.375, "float[i] += float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] += b[2]; a[2]; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 18.25, "float[i] += int[i]", string);
        string = "string a[3]; a[0]=\"abc\"; a[1]=\"def\"; a[2]=\"ghi\"; string b[3]; b[0]=\"aiueo\"; b[1]=\"kakikukeko\"; b[2]=\"sasisuseso\"; a[2] += b[2]; a[2]; ";
        String string2 = (String)this.engine.executeScript(string);
        super.evaluateResult(string2, "ghisasisuseso", "string[i] += string[i]", string);
    }

    private void testSubAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] -= b[2]; a[2]; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 20L, "int[i] -= int[i]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] -= b[2]; a[2]; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 17L, "int[i] -= float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] -= b[2]; a[2]; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -3.875, "float[i] -= float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] -= b[2]; a[2]; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, -1.75, "float[i] -= int[i]", string);
    }

    private void testMulAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] *= b[2]; a[2]; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 300L, "int[i] *= int[i]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] *= b[2]; a[2]; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 363L, "int[i] *= float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] *= b[2]; a[2]; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 100.03125, "float[i] *= float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] *= b[2]; a[2]; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 82.5, "float[i] *= int[i]", string);
    }

    private void testDivAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] /= b[2]; a[2]; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 3L, "int[i] /= int[i]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] /= b[2]; a[2]; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 2L, "int[i] /= float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] /= b[2]; a[2]; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.6804123711340206, "float[i] /= float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] /= b[2]; a[2]; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 0.825, "float[i] /= int[i]", string);
    }

    private void testRemAssignmentOperations() throws VnanoException {
        String string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] %= b[2]; a[2]; ";
        long l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 0L, "int[i] %= int[i]", string);
        string = "int a[3]; a[0]=10; a[1]=50; a[2]=30; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] %= b[2]; a[2]; ";
        l = (Long)this.engine.executeScript(string);
        super.evaluateResult(l, 5L, "int[i] %= float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; float b[3]; b[0]=4.25; b[1]=2.25; b[2]=12.125; a[2] %= b[2]; a[2]; ";
        double d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 8.25, "float[i] %= float[i]", string);
        string = "float a[3]; a[0]=2.5; a[1]=1.5; a[2]=8.25; int b[3]; b[0]=5; b[1]=50; b[2]=10; a[2] %= b[2]; a[2]; ";
        d = (Double)this.engine.executeScript(string);
        super.evaluateResult(d, 8.25, "float[i] %= int[i]", string);
    }

    private void testCompoundAssignmentOperationsToConstants() throws VnanoException {
        String string = "const int a[3]; a[1] += 2;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; a[1] += 2; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; a[1] += 2; (should be failed) ");
        }
        string = "const int a[3]; a[1] -= 2;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; a[1] -= 2; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; a[1] -= 2; (should be failed) ");
        }
        string = "const int a[3]; a[1] *= 2;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; a[1] *= 2; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; a[1] *= 2; (should be failed) ");
        }
        string = "const int a[3]; a[1] /= 2;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; a[1] /= 2; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; a[1] /= 2; (should be failed) ");
        }
        string = "const int a[3]; a[1] %= 2;";
        try {
            this.engine.executeScript(string);
            super.missedExpectedError("const int a[3]; a[1] %= 2; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("const int a[3]; a[1] %= 2; (should be failed) ");
        }
    }
}

