/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.combinedtest;

import org.vcssl.nano.VnanoEngine;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.combinedtest.CombinedTestElement;
import org.vcssl.nano.combinedtest.CombinedTestException;

public class VectorCastOperationCombinedTest
extends CombinedTestElement {
    VnanoEngine engine = null;

    @Override
    public void initializeTest(VnanoEngine vnanoEngine) {
        this.engine = vnanoEngine;
    }

    @Override
    public void finalizeTest() {
        this.engine = null;
    }

    @Override
    public void executeTest() {
        try {
            this.testCastInt1DToFloat1D();
            this.testCastInt1DToString1D();
            this.testCastFloat1DToInt1D();
            this.testCastFloat1DToString1D();
            this.testCastBool1DToString1D();
            this.testCastString1DToInt1D();
            this.testCastString1DToFloat1D();
            this.testCastString1DToBool1D();
            this.testCastInt2DToFloat2D();
            this.testCastInt2DToString2D();
            this.testCastFloat2DToInt2D();
            this.testCastFloat2DToString2D();
            this.testCastBool2DToString2D();
            this.testCastString2DToInt2D();
            this.testCastString2DToFloat2D();
            this.testCastString2DToBool2D();
            this.testCastBetweenIncompatibleArrays();
        }
        catch (VnanoException vnanoException) {
            throw new CombinedTestException(vnanoException);
        }
    }

    private void testCastInt1DToFloat1D() throws VnanoException {
        String string = "int i[3]; i[0] = 1; i[1] = -2; i[2] = 3; (float[]) i; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{1.0, -2.0, 3.0};
        super.evaluateResult(dArray, dArray2, "cast int[] to float[]", string);
    }

    private void testCastInt1DToString1D() throws VnanoException {
        String string = "int i[3]; i[0] = 1; i[1] = -2; i[2] = 3; (string[]) i; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"1", "-2", "3"};
        super.evaluateResult(stringArray, stringArray2, "cast int[] to string[]", string);
    }

    private void testCastFloat1DToInt1D() throws VnanoException {
        String string = "float f[3]; f[0] = 1.1; f[1] = -2.2; f[2] = 3.3; (int[]) f; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{1L, -2L, 3L};
        super.evaluateResult(lArray, lArray2, "cast float[] to int[]", string);
    }

    private void testCastFloat1DToString1D() throws VnanoException {
        String string = "float f[3]; f[0] = 1.25; f[1] = -2.25; f[2] = 3.25; (string[]) f; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"1.25", "-2.25", "3.25"};
        super.evaluateResult(stringArray, stringArray2, "cast float[] to sting[]", string);
    }

    private void testCastBool1DToString1D() throws VnanoException {
        String string = "bool b[3]; b[0] = true; b[1] = false; b[2] = true; (string[]) b; ";
        String[] stringArray = (String[])this.engine.executeScript(string);
        String[] stringArray2 = new String[]{"true", "false", "true"};
        super.evaluateResult(stringArray, stringArray2, "cast bool[] to sting[]", string);
    }

    private void testCastString1DToInt1D() throws VnanoException {
        String string = "string s[3]; s[0] = \"1\"; s[1] = \"-2\"; s[2] = \"3\"; (int[]) s; ";
        long[] lArray = (long[])this.engine.executeScript(string);
        long[] lArray2 = new long[]{1L, -2L, 3L};
        super.evaluateResult(lArray, lArray2, "cast string[] to int[]", string);
    }

    private void testCastString1DToFloat1D() throws VnanoException {
        String string = "string s[3]; s[0] = \"1.25\"; s[1] = \"-2.25\"; s[2] = \"3.25\"; (float[]) s; ";
        double[] dArray = (double[])this.engine.executeScript(string);
        double[] dArray2 = new double[]{1.25, -2.25, 3.25};
        super.evaluateResult(dArray, dArray2, "cast string[] to float[]", string);
    }

    private void testCastString1DToBool1D() throws VnanoException {
        String string = "string s[3]; s[0] = \"true\"; s[1] = \"false\"; s[2] = \"true\"; (bool[]) s; ";
        boolean[] blArray = (boolean[])this.engine.executeScript(string);
        boolean[] blArray2 = new boolean[]{true, false, true};
        super.evaluateResult(blArray, blArray2, "cast string[] to bool[]", string);
    }

    private void testCastInt2DToFloat2D() throws VnanoException {
        String string = "int i[2][3]; i[0][0] = 1;  i[0][1] = -2;  i[0][2] = 3;  i[1][0] = 11; i[1][1] = -22; i[1][2] = 33;  (float[][]) i; ";
        double[][] dArray = (double[][])this.engine.executeScript(string);
        double[][] dArrayArray = new double[][]{{1.0, -2.0, 3.0}, {11.0, -22.0, 33.0}};
        super.evaluateResult(dArray, dArrayArray, "cast int[][] to float[][]", string);
    }

    private void testCastInt2DToString2D() throws VnanoException {
        String string = "int i[2][3]; i[0][0] = 1;  i[0][1] = -2;  i[0][2] = 3;  i[1][0] = 11; i[1][1] = -22; i[1][2] = 33;  (string[][]) i; ";
        String[][] stringArray = (String[][])this.engine.executeScript(string);
        String[][] stringArray2 = new String[][]{{"1", "-2", "3"}, {"11", "-22", "33"}};
        super.evaluateResult(stringArray, stringArray2, "cast int[][] to string[][]", string);
    }

    private void testCastFloat2DToInt2D() throws VnanoException {
        String string = "float f[2][3]; f[0][0] = 1.1;  f[0][1] = -2.2;  f[0][2] = 3.3;  f[1][0] = 11.1; f[1][1] = -22.2; f[1][2] = 33.3;  (int[][]) f; ";
        long[][] lArray = (long[][])this.engine.executeScript(string);
        long[][] lArrayArray = new long[][]{{1L, -2L, 3L}, {11L, -22L, 33L}};
        super.evaluateResult(lArray, lArrayArray, "cast float[][] to int[][]", string);
    }

    private void testCastFloat2DToString2D() throws VnanoException {
        String string = "float f[2][3]; f[0][0] = 1.25;  f[0][1] = -2.25;  f[0][2] = 3.25;  f[1][0] = 11.25; f[1][1] = -22.25; f[1][2] = 33.25;  (string[][]) f; ";
        String[][] stringArray = (String[][])this.engine.executeScript(string);
        String[][] stringArray2 = new String[][]{{"1.25", "-2.25", "3.25"}, {"11.25", "-22.25", "33.25"}};
        super.evaluateResult(stringArray, stringArray2, "cast float[][] to sting[][]", string);
    }

    private void testCastBool2DToString2D() throws VnanoException {
        String string = "bool b[2][3]; b[0][0] = true;  b[0][1] = false; b[0][2] = true;  b[1][0] = false; b[1][1] = true;  b[1][2] = false; (string[][]) b; ";
        String[][] stringArray = (String[][])this.engine.executeScript(string);
        String[][] stringArray2 = new String[][]{{"true", "false", "true"}, {"false", "true", "false"}};
        super.evaluateResult(stringArray, stringArray2, "cast bool[][] to sting[][]", string);
    }

    private void testCastString2DToInt2D() throws VnanoException {
        String string = "string s[2][3]; s[0][0] = \"1\";  s[0][1] = \"-2\";  s[0][2] = \"3\";  s[1][0] = \"11\"; s[1][1] = \"-22\"; s[1][2] = \"33\"; (int[][]) s; ";
        long[][] lArray = (long[][])this.engine.executeScript(string);
        long[][] lArrayArray = new long[][]{{1L, -2L, 3L}, {11L, -22L, 33L}};
        super.evaluateResult(lArray, lArrayArray, "cast string[][] to int[][]", string);
    }

    private void testCastString2DToFloat2D() throws VnanoException {
        String string = "string s[2][3]; s[0][0] = \"1.25\";  s[0][1] = \"-2.25\";  s[0][2] = \"3.25\";  s[1][0] = \"11.25\"; s[1][1] = \"-22.25\"; s[1][2] = \"33.25\"; (float[][]) s; ";
        double[][] dArray = (double[][])this.engine.executeScript(string);
        double[][] dArrayArray = new double[][]{{1.25, -2.25, 3.25}, {11.25, -22.25, 33.25}};
        super.evaluateResult(dArray, dArrayArray, "cast string[] to float[]", string);
    }

    private void testCastString2DToBool2D() throws VnanoException {
        String string = "string s[2][3]; s[0][0] = \"true\";  s[0][1] = \"false\"; s[0][2] = \"true\";  s[1][0] = \"false\"; s[1][1] = \"true\";  s[1][2] = \"false\"; (bool[][]) s; ";
        boolean[][] blArray = (boolean[][])this.engine.executeScript(string);
        boolean[][] blArrayArray = new boolean[][]{{true, false, true}, {false, true, false}};
        super.evaluateResult(blArray, blArrayArray, "cast string[][] to bool[][]", string);
    }

    private void testCastBetweenIncompatibleArrays() throws VnanoException {
        String string;
        try {
            string = "float f; (int[]) f; ";
            this.engine.executeScript(string);
            super.missedExpectedError("cast between arrays having incompatible ranks 1; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("cast between arrays having incompatible ranks 1; (should be failed) ");
        }
        try {
            string = "float f[3]; (int) f; ";
            this.engine.executeScript(string);
            super.missedExpectedError("cast between arrays having incompatible ranks 2; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("cast between arrays having incompatible ranks 2; (should be failed) ");
        }
        try {
            string = "float f[2][3]; (int[]) f; ";
            this.engine.executeScript(string);
            super.missedExpectedError("cast between arrays having incompatible ranks 3; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("cast between arrays having incompatible ranks 3; (should be failed) ");
        }
        try {
            string = "float f[3]; (int[][]) f; ";
            this.engine.executeScript(string);
            super.missedExpectedError("cast between arrays having incompatible ranks 4; (should be failed) ", string);
        }
        catch (VnanoException vnanoException) {
            super.succeeded("cast between arrays having incompatible ranks 4; (should be failed) ");
        }
    }
}

