/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.compiler.AttributeKey;

public class AstNode
implements Cloneable {
    private static final String DEFAULT_INDENT = "  ";
    private Type type;
    private AstNode parentNode;
    private List<AstNode> childNodeList;
    private int siblingIndex = 0;
    private int depth = -1;
    private int blockDepth = -1;
    private int lineNumber = -1;
    private String fileName = null;
    private Map<AttributeKey, String> attributeMap = null;

    public AstNode(Type type, int n, String string) {
        this.type = type;
        this.childNodeList = new ArrayList<AstNode>();
        this.lineNumber = n;
        this.fileName = string;
        this.attributeMap = new LinkedHashMap<AttributeKey, String>();
    }

    public AstNode clone() {
        AstNode astNode = new AstNode(this.type, this.lineNumber, this.fileName);
        astNode.depth = this.depth;
        astNode.blockDepth = this.blockDepth;
        astNode.parentNode = this.parentNode;
        astNode.siblingIndex = this.siblingIndex;
        for (AstNode astNode2 : this.childNodeList) {
            AstNode astNode3 = astNode2.clone();
            astNode.addChildNode(astNode3);
        }
        astNode.attributeMap = new LinkedHashMap<AttributeKey, String>(this.attributeMap);
        return astNode;
    }

    public Type getType() {
        return this.type;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setAttribute(AttributeKey attributeKey, String string) {
        if (string == null) {
            throw new VnanoFatalException("null can not be the value of an attribute");
        }
        if (this.attributeMap.containsKey((Object)attributeKey)) {
            this.attributeMap.remove((Object)attributeKey);
        }
        this.attributeMap.put(attributeKey, string);
    }

    public String getAttribute(AttributeKey attributeKey) {
        return this.attributeMap.get((Object)attributeKey);
    }

    public void removeAttribute(AttributeKey attributeKey) {
        this.attributeMap.remove((Object)attributeKey);
    }

    public boolean hasAttribute(AttributeKey attributeKey) {
        return this.attributeMap.containsKey((Object)attributeKey);
    }

    public void addChildNode(AstNode astNode) {
        this.childNodeList.add(astNode);
        astNode.parentNode = this;
        astNode.siblingIndex = this.childNodeList.size() - 1;
    }

    public void addChildNodes(AstNode[] astNodeArray) {
        for (AstNode astNode : astNodeArray) {
            this.addChildNode(astNode);
        }
    }

    public AstNode[] getChildNodes() {
        return this.childNodeList.toArray(new AstNode[this.childNodeList.size()]);
    }

    public AstNode[] getChildNodes(Type type) {
        AstNode[] astNodeArray;
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        for (AstNode astNode : astNodeArray = this.getChildNodes()) {
            if (astNode.getType() != type) continue;
            arrayList.add(astNode);
        }
        AstNode[] astNodeArray2 = arrayList.toArray(new AstNode[0]);
        return astNodeArray2;
    }

    public boolean hasChildNodes() {
        return this.childNodeList.size() != 0;
    }

    public boolean hasChildNodes(Type type) {
        return this.getChildNodes(type).length != 0;
    }

    public AstNode getParentNode() {
        return this.parentNode;
    }

    public boolean hasParentNode() {
        return this.parentNode != null;
    }

    public int getSiblingIndex() {
        return this.siblingIndex;
    }

    public void updateDepths() {
        this.depth = 0;
        this.blockDepth = 0;
        if (!this.hasChildNodes()) {
            return;
        }
        AstNode astNode = this;
        do {
            astNode = astNode.getPreorderDftNextNode();
            AstNode astNode2 = astNode.getParentNode();
            astNode.depth = astNode2.depth + 1;
            astNode.blockDepth = astNode.type == Type.BLOCK ? astNode2.blockDepth + 1 : astNode2.blockDepth;
        } while (!astNode.isPreorderDftLastNode());
    }

    public int getDepth() {
        if (this.depth < 0) {
            throw new VnanoFatalException("The depth value is not set yet.Before getting the depth value of a node, call updateDepths() method of the ROOT node of the AST which initializes/updates values of depths and the block-depths of all nodes in the AST.");
        }
        return this.depth;
    }

    public int getBlockDepth() {
        if (this.blockDepth < 0) {
            throw new VnanoFatalException("The block-depth value is not set yet.Before getting the block-depth value of a node, call updateDepths() method of the ROOT node of the AST which initializes/updates values of depths and the block-depths of all nodes in the AST.");
        }
        return this.blockDepth;
    }

    public String getDataTypeName() {
        return this.attributeMap.get((Object)AttributeKey.DATA_TYPE);
    }

    public int getArrayRank() {
        String string = this.attributeMap.get((Object)AttributeKey.ARRAY_RANK);
        return Integer.parseInt(string);
    }

    public boolean hasModifier(String string) {
        return this.hasAttribute(AttributeKey.MODIFIER) && this.getAttribute(AttributeKey.MODIFIER).contains(string);
    }

    public void addModifier(String string) {
        if (this.hasAttribute(AttributeKey.MODIFIER)) {
            String string2 = this.getAttribute(AttributeKey.MODIFIER);
            string2 = string2 + "," + string;
            this.setAttribute(AttributeKey.MODIFIER, string2);
        } else {
            this.setAttribute(AttributeKey.MODIFIER, string);
        }
    }

    public AstNode getPreorderDftNextNode() {
        return this.getPreorderDftNextNode(null, null);
    }

    public boolean isPreorderDftLastNode() {
        return this.getPreorderDftNextNode() == null;
    }

    public AstNode getPreorderDftNextNode(Deque<AstNode> deque, Type[] typeArray) {
        if (this.hasChildNodes()) {
            return this.getChildNodes()[0];
        }
        AstNode astNode = this;
        AstNode astNode2 = astNode.getParentNode();
        AstNode[] astNodeArray = astNode2.getChildNodes();
        HashSet<Type> hashSet = new HashSet<Type>();
        if (typeArray != null) {
            for (Type type : typeArray) {
                hashSet.add(type);
            }
        }
        while (true) {
            if (deque != null && hashSet.contains((Object)astNode.getType())) {
                deque.push(astNode);
            }
            if (astNode.getSiblingIndex() < astNodeArray.length - 1) {
                return astNodeArray[astNode.getSiblingIndex() + 1];
            }
            if (!astNode2.hasParentNode()) break;
            astNode = astNode2;
            astNode2 = astNode.getParentNode();
            astNodeArray = astNode2.getChildNodes();
        }
        return null;
    }

    public AstNode getPostorderDftFirstNode() {
        AstNode astNode = this;
        while (astNode.hasChildNodes()) {
            astNode = astNode.getChildNodes()[0];
        }
        return astNode;
    }

    public AstNode getPostorderDftNextNode() {
        if (!this.hasParentNode()) {
            return null;
        }
        AstNode astNode = this.getParentNode();
        AstNode[] astNodeArray = astNode.getChildNodes();
        if (astNodeArray.length - 1 == this.getSiblingIndex()) {
            return astNode;
        }
        return astNodeArray[this.getSiblingIndex() + 1].getPostorderDftFirstNode();
    }

    public boolean isPostorderDftLastNode() {
        return !this.hasParentNode();
    }

    public String dump() {
        return this.dump(true, DEFAULT_INDENT);
    }

    public String dump(boolean bl, String string) {
        String string2 = System.getProperty("line.separator");
        AstNode[] astNodeArray = this.childNodeList.toArray(new AstNode[this.childNodeList.size()]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        stringBuilder.append((Object)this.type);
        Set<Map.Entry<AttributeKey, String>> set = this.attributeMap.entrySet();
        for (Map.Entry<AttributeKey, String> entry : set) {
            stringBuilder.append(" ");
            stringBuilder.append((Object)entry.getKey());
            stringBuilder.append("=\"");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("\"");
        }
        if (0 < astNodeArray.length) {
            stringBuilder.append('>');
            if (bl) {
                stringBuilder.append(string2);
                for (int i = 0; i < astNodeArray.length; ++i) {
                    stringBuilder.append(astNodeArray[i].dump(true, ""));
                }
            } else {
                stringBuilder.append("...");
            }
            stringBuilder.append("</");
            stringBuilder.append((Object)this.type);
            stringBuilder.append('>');
        } else {
            stringBuilder.append(" />");
        }
        return this.indent(stringBuilder.toString(), string) + string2;
    }

    private String indent(String string, String string2) {
        String string3 = System.getProperty("line.separator");
        String[] stringArray = string.split(string3);
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (stringArray[i].startsWith("</")) {
                --n2;
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuilder.append(string2);
                }
            } else if (stringArray[i].startsWith("<") && !stringArray[i].endsWith("/>")) {
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuilder.append(string2);
                }
                ++n2;
            } else {
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuilder.append(string2);
                }
            }
            stringBuilder.append(stringArray[i]);
            if (i == n - 1) continue;
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static enum Type {
        ROOT,
        EMPTY,
        VARIABLE,
        FUNCTION,
        EXPRESSION,
        BLOCK,
        IF,
        FOR,
        WHILE,
        ELSE,
        BREAK,
        CONTINUE,
        RETURN,
        IMPORT,
        INCLUDE,
        LEAF,
        OPERATOR,
        LENGTHS,
        PARENTHESIS,
        STACK_LID;

    }
}

