/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.compiler;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.compiler.AttributeKey;
import org.vcssl.nano.compiler.Token;

public class TokenTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetValue() {
        Token token = new Token("Hello", 123, "Test.vnano");
        Assert.assertEquals((Object)"Hello", (Object)token.getValue());
    }

    @Test
    public void testGetLineNumber() {
        Token token = new Token("Hello", 123, "Test.vnano");
        Assert.assertEquals((long)123L, (long)token.getLineNumber());
    }

    @Test
    public void testGetFileName() {
        Token token = new Token("Hello", 123, "Test.vnano");
        Assert.assertEquals((Object)"Test.vnano", (Object)token.getFileName());
    }

    @Test
    public void testSetGetType() {
        Token token = new Token("Hello", 123, "Test.vnano");
        token.setType(Token.Type.DATA_TYPE);
        Assert.assertEquals((Object)((Object)Token.Type.DATA_TYPE), (Object)((Object)token.getType()));
        token.setType(Token.Type.LEAF);
        Assert.assertEquals((Object)((Object)Token.Type.LEAF), (Object)((Object)token.getType()));
        token.setType(Token.Type.PARENTHESIS);
        Assert.assertEquals((Object)((Object)Token.Type.PARENTHESIS), (Object)((Object)token.getType()));
        token.setType(Token.Type.BLOCK);
        Assert.assertEquals((Object)((Object)Token.Type.BLOCK), (Object)((Object)token.getType()));
        token.setType(Token.Type.CONTROL);
        Assert.assertEquals((Object)((Object)Token.Type.CONTROL), (Object)((Object)token.getType()));
        token.setType(Token.Type.END_OF_STATEMENT);
        Assert.assertEquals((Object)((Object)Token.Type.END_OF_STATEMENT), (Object)((Object)token.getType()));
        token.setType(Token.Type.OPERATOR);
        Assert.assertEquals((Object)((Object)Token.Type.OPERATOR), (Object)((Object)token.getType()));
    }

    @Test
    public void testSetGetHasAttribute() {
        Token token = new Token("Hello", 123, "Test.vnano");
        Assert.assertFalse((boolean)token.hasAttribute(AttributeKey.IDENTIFIER_VALUE));
        token.setAttribute(AttributeKey.IDENTIFIER_VALUE, "world");
        Assert.assertTrue((boolean)token.hasAttribute(AttributeKey.IDENTIFIER_VALUE));
        Assert.assertEquals((Object)"world", (Object)token.getAttribute(AttributeKey.IDENTIFIER_VALUE));
    }

    @Test
    public void testSetGetOperatorPrecedence() {
        Token token = new Token("Hello", 123, "Test.vnano");
        token.setPrecedence(3100);
        Assert.assertEquals((long)3100L, (long)token.getPrecedence());
    }

    @Test
    public void testToString() {
        Token token = new Token("+", 123, "Test.vnano");
        token.setType(Token.Type.OPERATOR);
        token.setAttribute(AttributeKey.DATA_TYPE, "int");
        token.setAttribute(AttributeKey.OPERATOR_SYMBOL, "+");
        token.setPrecedence(1);
        Assert.assertEquals((Object)"[Token word=\"+\", lineNumber=123, fileName=\"Test.vnano\", type=OPERATOR, precedence=1, DATA_TYPE=\"int\", OPERATOR_SYMBOL=\"+\"]", (Object)token.toString());
    }
}

