/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.interconnect.IdentifierMapManager;

public class IdentifierMapManagerTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testConstructor() {
        new IdentifierMapManager();
    }

    @Test
    public void testPutToMap() {
        LinkedHashMap map = new LinkedHashMap();
        IdentifierMapManager.putToMap(map, "a", "A0");
        IdentifierMapManager.putToMap(map, "b", "B0");
        IdentifierMapManager.putToMap(map, "b", "B1");
        IdentifierMapManager.putToMap(map, "c", "C0");
        IdentifierMapManager.putToMap(map, "c", "C1");
        IdentifierMapManager.putToMap(map, "c", "C2");
        Assert.assertTrue((boolean)map.containsKey("a"));
        Assert.assertTrue((boolean)map.containsKey("b"));
        Assert.assertTrue((boolean)map.containsKey("c"));
        Assert.assertFalse((boolean)map.containsKey("d"));
        Assert.assertFalse((boolean)map.containsKey("e"));
        Assert.assertEquals((long)1L, (long)((LinkedList)map.get("a")).size());
        Assert.assertEquals((Object)"A0", ((LinkedList)map.get("a")).get(0));
        Assert.assertEquals((long)2L, (long)((LinkedList)map.get("b")).size());
        Assert.assertEquals((Object)"B0", ((LinkedList)map.get("b")).get(0));
        Assert.assertEquals((Object)"B1", ((LinkedList)map.get("b")).get(1));
        Assert.assertEquals((long)3L, (long)((LinkedList)map.get("c")).size());
        Assert.assertEquals((Object)"C0", ((LinkedList)map.get("c")).get(0));
        Assert.assertEquals((Object)"C1", ((LinkedList)map.get("c")).get(1));
        Assert.assertEquals((Object)"C2", ((LinkedList)map.get("c")).get(2));
    }

    @Test
    public void testGetFromMap() {
        LinkedHashMap map = new LinkedHashMap();
        IdentifierMapManager.putToMap(map, "a", "A0");
        IdentifierMapManager.putToMap(map, "b", "B0");
        IdentifierMapManager.putToMap(map, "b", "B1");
        IdentifierMapManager.putToMap(map, "c", "C0");
        IdentifierMapManager.putToMap(map, "c", "C1");
        IdentifierMapManager.putToMap(map, "c", "C2");
        Assert.assertEquals((Object)"A0", IdentifierMapManager.getLastFromMap(map, "a"));
        Assert.assertEquals((Object)"B1", IdentifierMapManager.getLastFromMap(map, "b"));
        Assert.assertEquals((Object)"C2", IdentifierMapManager.getLastFromMap(map, "c"));
    }

    @Test
    public void testRemoveFromMap() {
        LinkedHashMap map = new LinkedHashMap();
        IdentifierMapManager.putToMap(map, "a", "A0");
        IdentifierMapManager.putToMap(map, "b", "B0");
        IdentifierMapManager.putToMap(map, "b", "B1");
        IdentifierMapManager.putToMap(map, "c", "C0");
        IdentifierMapManager.putToMap(map, "c", "C1");
        IdentifierMapManager.putToMap(map, "c", "C2");
        IdentifierMapManager.removeLastFromMap(map, "a");
        IdentifierMapManager.removeLastFromMap(map, "b");
        IdentifierMapManager.removeLastFromMap(map, "c");
        Assert.assertFalse((boolean)map.containsKey("a"));
        Assert.assertTrue((boolean)map.containsKey("b"));
        Assert.assertTrue((boolean)map.containsKey("c"));
        Assert.assertEquals((long)1L, (long)((LinkedList)map.get("b")).size());
        Assert.assertEquals((Object)"B0", ((LinkedList)map.get("b")).get(0));
        Assert.assertEquals((long)2L, (long)((LinkedList)map.get("c")).size());
        Assert.assertEquals((Object)"C0", ((LinkedList)map.get("c")).get(0));
        Assert.assertEquals((Object)"C1", ((LinkedList)map.get("c")).get(1));
    }
}

