/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.interconnect;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.spec.ErrorType;

public class MetaQualifiedFileLoader {
    private static final String[] ENCODING_DECLARATION_LINE_HEAD = new String[]{"coding", "#coding", "encoding", "#encoding", "encode", "#encode"};

    public static final String load(String string, String string2) throws VnanoException {
        if (!new File(string).exists()) {
            throw new VnanoException(ErrorType.META_QUALIFIED_FILE_DOES_NOT_EXIST, string);
        }
        Charset charset = MetaQualifiedFileLoader.determinCharset(string, string2);
        List<String> list = null;
        try {
            list = Files.readAllLines(Paths.get(string, new String[0]), charset);
        }
        catch (IOException iOException) {
            throw new VnanoException(ErrorType.META_QUALIFIED_FILE_IS_NOT_ACCESSIBLE, string, (Throwable)iOException);
        }
        String string3 = String.join((CharSequence)"\n", list.toArray(new String[0]));
        string3 = MetaQualifiedFileLoader.postprocess(string, string3);
        return string3;
    }

    public static final String postprocess(String string, String string2) throws VnanoException {
        string2 = MetaQualifiedFileLoader.normalize(string2);
        string2 = MetaQualifiedFileLoader.removeEncodingDeclaration(string, string2);
        return string2;
    }

    private static final Charset determinCharset(String string, String string2) throws VnanoException {
        String string3 = MetaQualifiedFileLoader.readDeclaredEncodingName(string, string2);
        if (string3 == null) {
            return Charset.forName(string2);
        }
        try {
            return Charset.forName(string3);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw new VnanoException(ErrorType.DECLARED_ENCODING_IS_UNSUPPORTED, new String[]{string3, string}, (Throwable)illegalArgumentException);
        }
    }

    private static final String readDeclaredEncodingName(String string, String string2) throws VnanoException {
        String string3 = null;
        Charset charset = Charset.forName(string2);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), charset));){
            string3 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw new VnanoException(ErrorType.META_QUALIFIED_FILE_IS_NOT_ACCESSIBLE, string, (Throwable)iOException);
        }
        string3 = MetaQualifiedFileLoader.normalize(string3);
        return MetaQualifiedFileLoader.extractDeclaredEncodingName(string, string3);
    }

    private static final String extractDeclaredEncodingName(String string, String string2) throws VnanoException {
        if (string2.length() == 0) {
            return null;
        }
        string2 = MetaQualifiedFileLoader.normalize(string2);
        String string3 = string2.split("\\n", -1)[0];
        string3 = string3.replaceAll("\\s", "").replaceAll("\\t", "");
        String string4 = null;
        String[] stringArray = ENCODING_DECLARATION_LINE_HEAD;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string5 = stringArray[i];
            if (!string3.startsWith(string5)) continue;
            int n2 = string3.indexOf(";");
            if (n2 != -1) {
                string4 = string3.substring(string5.length(), n2);
                break;
            }
            throw new VnanoException(ErrorType.NO_ENCODING_DECLARATION_END, string);
        }
        for (String string6 : stringArray = new String[]{"//", "/*", "*/", Character.toString('\"'), Character.toString('\'')}) {
            if (string4 == null || !string4.contains(string6)) continue;
            throw new VnanoException(ErrorType.ENCODING_DECLARATION_CONTAINS_INVALID_SYMBOL, new String[]{string6, string});
        }
        return string4;
    }

    private static final boolean existsEncodingDeclaration(String string, String string2) throws VnanoException {
        return MetaQualifiedFileLoader.extractDeclaredEncodingName(string, string2) != null;
    }

    private static final String removeEncodingDeclaration(String string, String string2) throws VnanoException {
        if (MetaQualifiedFileLoader.existsEncodingDeclaration(string, string2)) {
            int n = string2.indexOf(";");
            return string2.substring(n + 1, string2.length());
        }
        return string2;
    }

    private static final String normalize(String string) {
        if (string == null) {
            return "";
        }
        string = string.replaceAll("\\r\\n", "\n");
        if (0 < (string = string.replaceAll("\\r", "\n")).length() && string.charAt(0) == '\ufeff') {
            string = string.substring(1, string.length());
        }
        return string;
    }
}

