/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorDataManagementUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionType;
import org.vcssl.nano.vm.accelerator.AcceleratorExtendedOperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.BoolCachedScalarMultipleTransferUnit;
import org.vcssl.nano.vm.accelerator.Float64CachedScalarDualArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Float64CachedScalarMultipleTransferUnit;
import org.vcssl.nano.vm.accelerator.Int64CachedScalarDualArithmeticUnit;
import org.vcssl.nano.vm.accelerator.Int64CachedScalarMultipleTransferUnit;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;

public class AcceleratorOptimizationUnit {
    protected static final int OPT_LEVEL_CACHE_DISABLED = 0;
    protected static final int OPT_LEVEL_CACHE_ENABLED = 1;
    protected static final int OPT_LEVEL_ORVERHEAD_TUNED = 2;
    protected static final int OPT_LEVEL_STRUCTURE_TUNED = 3;
    private static final List<Object> LIST_OF_NULL = Arrays.asList(new Object[]{null});
    private static final int MAX_INLINE_EXPANSIBLE_FUNCTION_CODE_LENGTH = 64;
    private List<AcceleratorInstruction> acceleratorInstructionList;
    private Map<Integer, Integer> addressReorderingMap;
    private Map<Integer, Integer> expandedAddressReorderingMap;
    private int[] registerWrittenPointCount;
    private int[] registerReadPointCount;
    private boolean[] registerReferenceMaybeLinked;
    private Map<Integer, InternalFunctionInfo> functionInfoMap;
    private Set<Integer> unnecessaryRegisterSet;
    private static final HashSet<OperationCode> movReducableOpcodeSet = new HashSet();

    public AcceleratorInstruction[] optimize(AcceleratorInstruction[] acceleratorInstructionArray, Memory memory, AcceleratorDataManagementUnit acceleratorDataManagementUnit, int n) {
        this.acceleratorInstructionList = new ArrayList<AcceleratorInstruction>();
        for (AcceleratorInstruction acceleratorInstruction : acceleratorInstructionArray) {
            this.acceleratorInstructionList.add(acceleratorInstruction.clone());
        }
        this.unnecessaryRegisterSet = new HashSet<Integer>();
        this.extractInternalFunctionInfo(memory);
        this.updateReorderedAddresses();
        this.generateAddressReorderingMap();
        this.resolveReorderedLabelAddress(memory);
        if (2 <= n) {
            this.modifyCodeToTransferArgumentsDirectly(memory);
            this.generateReturnedInstructions();
            this.updateReorderedAddresses();
            this.generateAddressReorderingMap();
            this.resolveReorderedLabelAddress(memory);
            this.updateInternalFunctionInfo();
        }
        if (3 <= n) {
            if (n < 2) {
                throw new VnanoFatalException("For inline expansion of functions, some overhead tunings are required as preprocessing.");
            }
            this.expandFunctionCodeInline(memory);
            this.updateReorderedAddresses();
            this.generateAddressReorderingMap();
            this.resolveReorderedLabelAddress(memory);
        }
        this.countRegisterWrittenPoints(memory);
        this.countRegisterReadPoints(memory);
        this.detectRegisterReferenceLinks(memory);
        if (2 <= n) {
            this.reorderAllocAndAllocrInstructions(acceleratorDataManagementUnit);
            this.removeMovInstructionsToUnreadRegisters(acceleratorDataManagementUnit);
            this.reduceMovInstructionsCopyingOperationResults(acceleratorDataManagementUnit);
            this.removeAllocInstructionsToUnusedRegisters();
            this.checkRemovedRegistersAreUnused();
            this.updateReorderedAddresses();
            this.generateAddressReorderingMap();
            this.resolveReorderedLabelAddress(memory);
            this.fuseArithmeticInstructions(AcceleratorExecutionType.F64CS_ARITHMETIC, AcceleratorExecutionType.F64CS_DUAL_ARITHMETIC);
            this.fuseArithmeticInstructions(AcceleratorExecutionType.I64CS_ARITHMETIC, AcceleratorExecutionType.I64CS_DUAL_ARITHMETIC);
            this.fuseTransferInstructions();
            this.fuseComparisonAndBranchInstructions();
            this.updateReorderedAddresses();
            this.generateAddressReorderingMap();
            this.resolveReorderedLabelAddress(memory);
        }
        if (2 <= n) {
            this.removeLabelInstructions();
            this.updateReorderedAddresses();
            this.generateAddressReorderingMap();
        }
        return this.acceleratorInstructionList.toArray(new AcceleratorInstruction[0]);
    }

    private void extractInternalFunctionInfo(Memory memory) {
        int n;
        int n2 = this.acceleratorInstructionList.size();
        this.functionInfoMap = new LinkedHashMap<Integer, InternalFunctionInfo>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < n2; ++n) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(n);
            if (acceleratorInstruction.getOperationCode() != OperationCode.CALL) continue;
            DataContainer<?> dataContainer = memory.getDataContainer(acceleratorInstruction.getOperandPartitions()[1], acceleratorInstruction.getOperandAddresses()[1]);
            if (!(dataContainer.getArrayData() instanceof long[])) {
                throw new VnanoFatalException("Unexpected data type of the function address detected.");
            }
            int n3 = (int)((long[])dataContainer.getArrayData())[0];
            arrayList.add(n3);
        }
        n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AcceleratorInstruction acceleratorInstruction;
            OperationCode operationCode;
            int n4 = (Integer)arrayList.get(i);
            if (this.functionInfoMap.containsKey(n4)) continue;
            InternalFunctionInfo internalFunctionInfo = new InternalFunctionInfo(n4);
            boolean bl = false;
            int n5 = -1;
            int n6 = n4;
            while (true) {
                if ((operationCode = (acceleratorInstruction = this.acceleratorInstructionList.get(n6)).getOperationCode()) == OperationCode.MOVPOP || operationCode == OperationCode.REFPOP) {
                    DataType dataType = acceleratorInstruction.getDataTypes()[0];
                    Memory.Partition partition = acceleratorInstruction.getOperandPartitions()[0];
                    int n7 = acceleratorInstruction.getOperandAddresses()[0];
                    boolean bl2 = operationCode == OperationCode.REFPOP;
                    boolean bl3 = bl;
                    int n8 = n5;
                    bl = false;
                    n5 = -1;
                    internalFunctionInfo.addParameter(dataType, partition, n7, bl2, bl3, n8);
                } else if (operationCode == OperationCode.ALLOCT) {
                    bl = acceleratorInstruction.getOperandLength() == 1;
                    n5 = acceleratorInstruction.getOperandLength() - 1;
                } else if (operationCode != OperationCode.ALLOC && operationCode != OperationCode.ALLOCP && operationCode != OperationCode.ALLOCR && operationCode != OperationCode.LABEL) {
                    if (operationCode == OperationCode.ENDPRM) break;
                    throw new VnanoFatalException("Unexpected instruction detected before ENDPRM instruction: " + (Object)((Object)operationCode));
                }
                ++n6;
            }
            internalFunctionInfo.setBodyBeginAddress(n6 + 1);
            internalFunctionInfo.reverseParameterOrder();
            n6 = internalFunctionInfo.getBodyBeginAddress();
            while (true) {
                if ((operationCode = (acceleratorInstruction = this.acceleratorInstructionList.get(n6)).getOperationCode()) == OperationCode.ENDFUN) break;
                if (operationCode == OperationCode.CALL) {
                    internalFunctionInfo.incrementCallCount();
                } else if (operationCode == OperationCode.RET) {
                    internalFunctionInfo.incrementRetCount();
                    if (2 < acceleratorInstruction.getOperandAddresses().length) {
                        internalFunctionInfo.setLastRetValue(acceleratorInstruction.getOperandPartitions()[2], acceleratorInstruction.getOperandAddresses()[2]);
                    }
                }
                ++n6;
            }
            internalFunctionInfo.setBodyEndAddress(n6 - 1);
            internalFunctionInfo.setLastInstructionRet(this.acceleratorInstructionList.get(n6 - 1).getOperationCode() == OperationCode.RET);
            this.functionInfoMap.put(n4, internalFunctionInfo);
        }
    }

    void updateInternalFunctionInfo() {
        Set<Map.Entry<Integer, InternalFunctionInfo>> set = this.functionInfoMap.entrySet();
        for (Map.Entry<Integer, InternalFunctionInfo> entry : set) {
            InternalFunctionInfo internalFunctionInfo = entry.getValue();
            int n = internalFunctionInfo.getBodyBeginAddress();
            int n2 = internalFunctionInfo.getBodyEndAddress();
            n = this.addressReorderingMap.get(n);
            n2 = this.addressReorderingMap.get(n2);
            internalFunctionInfo.setBodyBeginAddress(n);
            internalFunctionInfo.setBodyEndAddress(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    void modifyCodeToTransferArgumentsDirectly(Memory memory) {
        void var6_12;
        int n;
        int n2;
        Object object;
        int n3 = this.acceleratorInstructionList.size();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < n3; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            if (acceleratorInstruction.getOperationCode() == OperationCode.CALL) {
                Memory.Partition[] object2 = acceleratorInstruction.getOperandPartitions();
                object = acceleratorInstruction.getOperandAddresses();
                n2 = acceleratorInstruction.getOperandLength();
                n = n2 - 2;
                DataContainer<?> dataContainer = memory.getDataContainer(acceleratorInstruction.getOperandPartitions()[1], acceleratorInstruction.getOperandAddresses()[1]);
                if (!(dataContainer.getArrayData() instanceof long[])) {
                    throw new VnanoFatalException("Unexpected data type of the function address detected.");
                }
                int n4 = (int)((long[])dataContainer.getArrayData())[0];
                InternalFunctionInfo internalFunctionInfo = this.functionInfoMap.get(n4);
                for (int j = 0; j < n; ++j) {
                    AcceleratorInstruction acceleratorInstruction2;
                    Instruction instruction;
                    Object[] objectArray;
                    Memory.Partition[] partitionArray;
                    int n5 = j + 2;
                    if (internalFunctionInfo.isParameterReference(j) || !internalFunctionInfo.isParameterScalar(j)) {
                        int n6 = internalFunctionInfo.getParameterRank(j);
                        partitionArray = new Memory.Partition[n6 + 1];
                        objectArray = new int[n6 + 1];
                        Arrays.fill((Object[])partitionArray, (Object)Memory.Partition.NONE);
                        Arrays.fill(objectArray, 0);
                        partitionArray[0] = internalFunctionInfo.getParameterPertition(j);
                        objectArray[0] = internalFunctionInfo.getParameterAddress(j);
                        instruction = new Instruction(OperationCode.ALLOCT, new DataType[]{internalFunctionInfo.getParameterDataType(j)}, partitionArray, (int[])objectArray, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress());
                        acceleratorInstruction2 = new AcceleratorInstruction(instruction);
                        acceleratorInstruction2.setUnreorderedAddress(i);
                        arrayList.add(acceleratorInstruction2);
                    }
                    Memory.Partition[] partitionArray2 = new Memory.Partition[]{internalFunctionInfo.getParameterPertition(j), object2[n5]};
                    partitionArray = (Memory.Partition[])new int[]{internalFunctionInfo.getParameterAddress(j), (int)object[n5]};
                    objectArray = (Object[])new DataType[]{internalFunctionInfo.getParameterDataType(j)};
                    if (internalFunctionInfo.isParameterReference(j)) {
                        instruction = new Instruction(OperationCode.REF, (DataType[])objectArray, partitionArray2, (int[])partitionArray, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress());
                        acceleratorInstruction2 = new AcceleratorInstruction(instruction);
                        acceleratorInstruction2.setUnreorderedAddress(i);
                        arrayList.add(acceleratorInstruction2);
                        continue;
                    }
                    instruction = null;
                    instruction = internalFunctionInfo.isParameterScalar(j) ? new Instruction(OperationCode.ALLOC, (DataType[])objectArray, new Memory.Partition[]{partitionArray2[0]}, new int[]{(int)partitionArray[0]}, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress()) : new Instruction(OperationCode.ALLOCR, (DataType[])objectArray, partitionArray2, (int[])partitionArray, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress());
                    acceleratorInstruction2 = new AcceleratorInstruction(instruction);
                    acceleratorInstruction2.setUnreorderedAddress(i);
                    arrayList.add(acceleratorInstruction2);
                    Instruction instruction2 = new Instruction(OperationCode.MOV, (DataType[])objectArray, partitionArray2, (int[])partitionArray, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress());
                    AcceleratorInstruction acceleratorInstruction3 = new AcceleratorInstruction(instruction2);
                    acceleratorInstruction3.setUnreorderedAddress(i);
                    arrayList.add(acceleratorInstruction3);
                }
                Instruction instruction = new Instruction(OperationCode.CALL, acceleratorInstruction.getDataTypes(), new Memory.Partition[]{object2[0], object2[1]}, new int[]{(int)object[0], (int)object[1]}, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress());
                AcceleratorInstruction acceleratorInstruction4 = new AcceleratorInstruction(instruction);
                acceleratorInstruction4.setUnreorderedAddress(i);
                arrayList.add(acceleratorInstruction4);
                continue;
            }
            arrayList.add(acceleratorInstruction);
        }
        Set<Map.Entry<Integer, InternalFunctionInfo>> set = this.functionInfoMap.entrySet();
        for (Map.Entry entry : set) {
            object = (InternalFunctionInfo)entry.getValue();
            n2 = (Integer)entry.getKey();
            n = ((InternalFunctionInfo)object).getBodyBeginAddress();
            for (int i = n2 + 1; i < n; ++i) {
                arrayList.set(i, null);
            }
        }
        this.acceleratorInstructionList = new ArrayList<AcceleratorInstruction>();
        int n7 = arrayList.size();
        boolean bl = false;
        while (var6_12 < n7) {
            object = (AcceleratorInstruction)arrayList.get((int)var6_12);
            if (object != null) {
                this.acceleratorInstructionList.add((AcceleratorInstruction)object);
            }
            ++var6_12;
        }
    }

    private void expandFunctionCodeInline(Memory memory) {
        int n = this.acceleratorInstructionList.size();
        ArrayList<AcceleratorInstruction> arrayList = new ArrayList<AcceleratorInstruction>();
        block0: for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object[] objectArray;
            Memory.Partition[] partitionArray;
            Object object3;
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            if (acceleratorInstruction.getOperationCode() != OperationCode.CALL) {
                arrayList.add(acceleratorInstruction);
                continue;
            }
            DataContainer<?> dataContainer = memory.getDataContainer(acceleratorInstruction.getOperandPartitions()[1], acceleratorInstruction.getOperandAddresses()[1]);
            if (!(dataContainer.getArrayData() instanceof long[])) {
                throw new VnanoFatalException("Unexpected data type of the function address detected.");
            }
            int n2 = (int)((long[])dataContainer.getArrayData())[0];
            InternalFunctionInfo internalFunctionInfo = this.functionInfoMap.get(n2);
            if (64 < internalFunctionInfo.getBodyEndAddress() - internalFunctionInfo.getBodyBeginAddress()) {
                arrayList.add(acceleratorInstruction);
                continue;
            }
            if (1 <= internalFunctionInfo.getCallCount()) {
                arrayList.add(acceleratorInstruction);
                continue;
            }
            if (internalFunctionInfo.getRetCount() == 1) {
                if (!internalFunctionInfo.isLastInstructionRet()) {
                    arrayList.add(acceleratorInstruction);
                    continue;
                }
            } else {
                arrayList.add(acceleratorInstruction);
                continue;
            }
            int n3 = internalFunctionInfo.getBodyBeginAddress();
            int n4 = internalFunctionInfo.getBodyEndAddress();
            for (int j = n3; j < n4; ++j) {
                object3 = this.acceleratorInstructionList.get(j).clone();
                object3.setExpandedAddress(arrayList.size());
                partitionArray = object3.getOperationCode();
                if (partitionArray == OperationCode.JMP || partitionArray == OperationCode.JMPN) {
                    objectArray = object3.getOperandPartitions();
                    object2 = object3.getOperandAddresses();
                    object = memory.getDataContainer(objectArray[1], object2[1]);
                    int n5 = (int)((long[])((DataContainer)object).getArrayData())[0];
                    n5 = this.addressReorderingMap.get(n5);
                    int n6 = n5 - j;
                    int n7 = object3.getExpandedAddress() + n6;
                    object3.setExpandedLabelAddress(n7);
                }
                arrayList.add((AcceleratorInstruction)object3);
            }
            if (!internalFunctionInfo.hasRetValue()) continue;
            ++i;
            if (internalFunctionInfo.hasReferenceParameters()) {
                arrayList.add(this.acceleratorInstructionList.get(i).clone());
            }
            ++i;
            while (i < n) {
                AcceleratorInstruction acceleratorInstruction2 = this.acceleratorInstructionList.get(i);
                object3 = acceleratorInstruction2.getOperationCode();
                if (object3 == OperationCode.ALLOCP || object3 == OperationCode.MOVPOP) {
                    partitionArray = new Memory.Partition[]{acceleratorInstruction2.getOperandPartitions()[0], internalFunctionInfo.getLastRetValuePartition()};
                    objectArray = new int[]{acceleratorInstruction2.getOperandAddresses()[0], internalFunctionInfo.getLastRetValueAddress()};
                    object2 = (Object)(object3 == OperationCode.ALLOCP ? OperationCode.ALLOCR : OperationCode.MOV);
                    object = new AcceleratorInstruction(new Instruction((OperationCode)((Object)object2), acceleratorInstruction2.getDataTypes(), partitionArray, (int[])objectArray, acceleratorInstruction2.getMetaPartition(), acceleratorInstruction2.getMetaAddress()));
                    ((AcceleratorInstruction)object).setUnreorderedAddress(acceleratorInstruction2.getUnreorderedAddress());
                    arrayList.add((AcceleratorInstruction)object);
                    if (object3 == OperationCode.MOVPOP) {
                        continue block0;
                    }
                } else {
                    if (object3 == OperationCode.POP) continue block0;
                    arrayList.add(acceleratorInstruction2);
                }
                ++i;
            }
        }
        this.acceleratorInstructionList = arrayList;
    }

    private void generateReturnedInstructions() {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            if (acceleratorInstruction.getOperationCode() != OperationCode.CALL) continue;
            Memory.Partition[] partitionArray = acceleratorInstruction.getOperandPartitions();
            int[] nArray = acceleratorInstruction.getOperandAddresses();
            int n2 = nArray.length - 2;
            Memory.Partition[] partitionArray2 = new Memory.Partition[n2 + 1];
            int[] nArray2 = new int[n2 + 1];
            partitionArray2[0] = Memory.Partition.NONE;
            nArray2[0] = 0;
            for (int j = 0; j < n2; ++j) {
                partitionArray2[j + 1] = partitionArray[j + 2];
                nArray2[j + 1] = nArray[j + 2];
            }
            AcceleratorInstruction acceleratorInstruction2 = new AcceleratorInstruction(new Instruction(OperationCode.EX, acceleratorInstruction.getDataTypes(), partitionArray2, nArray2, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress()));
            acceleratorInstruction2.setExtendedOperationCode(AcceleratorExtendedOperationCode.RETURNED);
            acceleratorInstruction2.setUnreorderedAddress(acceleratorInstruction.getUnreorderedAddress() + 1);
            this.acceleratorInstructionList.set(i + 1, acceleratorInstruction2);
        }
    }

    private boolean isDataWritingOperationCode(OperationCode operationCode) {
        return operationCode != OperationCode.ALLOC && operationCode != OperationCode.ALLOCT && operationCode != OperationCode.ALLOCP && operationCode != OperationCode.ALLOCR && operationCode != OperationCode.FREE && operationCode != OperationCode.JMP && operationCode != OperationCode.JMPN && operationCode != OperationCode.RET && operationCode != OperationCode.POP && operationCode != OperationCode.NOP && operationCode != OperationCode.LABEL && operationCode != OperationCode.END && operationCode != OperationCode.ENDFUN;
    }

    private void countRegisterWrittenPoints(Memory memory) {
        int n = memory.getSize(Memory.Partition.REGISTER);
        this.registerWrittenPointCount = new int[n];
        Arrays.fill(this.registerWrittenPointCount, 0);
        int n2 = this.acceleratorInstructionList.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            Memory.Partition partition;
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            if (!this.isDataWritingOperationCode(acceleratorInstruction.getOperationCode()) || (partition = acceleratorInstruction.getOperandPartitions()[0]) != Memory.Partition.REGISTER) continue;
            int n4 = n3 = acceleratorInstruction.getOperandAddresses()[0];
            this.registerWrittenPointCount[n4] = this.registerWrittenPointCount[n4] + 1;
        }
    }

    private boolean isDataReadingOperationCode(OperationCode operationCode) {
        return operationCode != OperationCode.ALLOC && operationCode != OperationCode.ALLOCT && operationCode != OperationCode.ALLOCP && operationCode != OperationCode.ALLOCR && operationCode != OperationCode.FREE && operationCode != OperationCode.POP && operationCode != OperationCode.MOVPOP && operationCode != OperationCode.REFPOP && operationCode != OperationCode.NOP && operationCode != OperationCode.LABEL && operationCode != OperationCode.ENDFUN;
    }

    private void countRegisterReadPoints(Memory memory) {
        int n = memory.getSize(Memory.Partition.REGISTER);
        this.registerReadPointCount = new int[n];
        Arrays.fill(this.registerReadPointCount, 0);
        int n2 = this.acceleratorInstructionList.size();
        for (int i = 0; i < n2; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            OperationCode operationCode = acceleratorInstruction.getOperationCode();
            if (!this.isDataReadingOperationCode(operationCode)) continue;
            int n3 = acceleratorInstruction.getOperandLength();
            int n4 = 1;
            if (n3 < 2) continue;
            Memory.Partition[] partitionArray = acceleratorInstruction.getOperandPartitions();
            int[] nArray = acceleratorInstruction.getOperandAddresses();
            for (int j = n4; j < n3; ++j) {
                int n5;
                if (partitionArray[j] != Memory.Partition.REGISTER) continue;
                int n6 = n5 = nArray[j];
                this.registerReadPointCount[n6] = this.registerReadPointCount[n6] + 1;
            }
        }
    }

    private void detectRegisterReferenceLinks(Memory memory) {
        int n = memory.getSize(Memory.Partition.REGISTER);
        this.registerReferenceMaybeLinked = new boolean[n];
        Arrays.fill(this.registerReferenceMaybeLinked, false);
        int n2 = this.acceleratorInstructionList.size();
        for (int i = 0; i < n2; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            OperationCode operationCode = acceleratorInstruction.getOperationCode();
            Memory.Partition[] partitionArray = acceleratorInstruction.getOperandPartitions();
            int[] nArray = acceleratorInstruction.getOperandAddresses();
            if (operationCode == OperationCode.REF) {
                if (partitionArray[0] == Memory.Partition.REGISTER) {
                    this.registerReferenceMaybeLinked[nArray[0]] = true;
                }
                if (partitionArray[1] != Memory.Partition.REGISTER) continue;
                this.registerReferenceMaybeLinked[nArray[1]] = true;
                continue;
            }
            if (operationCode == OperationCode.REFELM) {
                if (partitionArray[0] == Memory.Partition.REGISTER) {
                    this.registerReferenceMaybeLinked[nArray[0]] = true;
                }
                if (partitionArray[1] != Memory.Partition.REGISTER) continue;
                this.registerReferenceMaybeLinked[nArray[1]] = true;
                continue;
            }
            if (operationCode == OperationCode.REFPOP) {
                if (partitionArray[0] != Memory.Partition.REGISTER) continue;
                this.registerReferenceMaybeLinked[nArray[0]] = true;
                continue;
            }
            if (operationCode == OperationCode.CALL) {
                for (int j = 2; j < nArray.length; ++j) {
                    if (partitionArray[j] != Memory.Partition.REGISTER) continue;
                    this.registerReferenceMaybeLinked[nArray[j]] = true;
                }
                continue;
            }
            if (operationCode != OperationCode.RET && operationCode != OperationCode.CALLX) continue;
        }
    }

    private void resolveReorderedLabelAddress(Memory memory) {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            boolean bl;
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            OperationCode operationCode = acceleratorInstruction.getOperationCode();
            OperationCode[] operationCodeArray = acceleratorInstruction.isFused() ? acceleratorInstruction.getFusedOperationCodes() : null;
            boolean bl2 = operationCode == OperationCode.JMP || operationCode == OperationCode.JMPN || operationCode == OperationCode.CALL || operationCode == OperationCode.RET;
            boolean bl3 = bl = acceleratorInstruction.isFused() && (operationCodeArray[1] == OperationCode.JMP || operationCodeArray[1] == OperationCode.JMPN);
            if (!bl2 && !bl) continue;
            if (acceleratorInstruction.isLabelAddressExpanded()) {
                int n3 = acceleratorInstruction.getExpandedLabelAddress();
                n2 = this.expandedAddressReorderingMap.get(n3);
                acceleratorInstruction.setReorderedLabelAddress(n2);
                continue;
            }
            DataContainer<?> dataContainer = null;
            dataContainer = operationCode != OperationCode.EX ? memory.getDataContainer(acceleratorInstruction.getOperandPartitions()[1], acceleratorInstruction.getOperandAddresses()[1]) : memory.getDataContainer(acceleratorInstruction.getOperandPartitions()[4], acceleratorInstruction.getOperandAddresses()[4]);
            n2 = -1;
            Object obj = dataContainer.getArrayData();
            if (!(obj instanceof long[])) {
                throw new VnanoFatalException("Non-integer instruction address (label) operand detected.");
            }
            n2 = (int)((long[])obj)[dataContainer.getArrayOffset()];
            int n4 = this.addressReorderingMap.get(n2);
            acceleratorInstruction.setReorderedLabelAddress(n4);
        }
    }

    private void reorderAllocAndAllocrInstructions(AcceleratorDataManagementUnit acceleratorDataManagementUnit) {
        AcceleratorInstruction acceleratorInstruction;
        int n;
        int n2 = this.acceleratorInstructionList.size();
        ArrayList<AcceleratorInstruction> arrayList = new ArrayList<AcceleratorInstruction>();
        boolean[] blArray = new boolean[n2];
        Arrays.fill(blArray, false);
        for (n = 0; n < n2; ++n) {
            acceleratorInstruction = this.acceleratorInstructionList.get(n);
            OperationCode operationCode = acceleratorInstruction.getOperationCode();
            if (operationCode != OperationCode.ALLOC && operationCode != OperationCode.ALLOCR || !acceleratorDataManagementUnit.isScalar(acceleratorInstruction.getOperandPartitions()[0], acceleratorInstruction.getOperandAddresses()[0])) continue;
            arrayList.add(acceleratorInstruction);
            blArray[n] = true;
        }
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            acceleratorInstruction = this.acceleratorInstructionList.get(n);
            arrayList.add(acceleratorInstruction);
        }
        this.acceleratorInstructionList = arrayList;
    }

    private void removeMovInstructionsToUnreadRegisters(AcceleratorDataManagementUnit acceleratorDataManagementUnit) {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n - 1; ++i) {
            int n2;
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            if (acceleratorInstruction.getOperationCode() != OperationCode.MOV || acceleratorInstruction.getOperandPartitions()[0] != Memory.Partition.REGISTER || this.registerReadPointCount[n2 = acceleratorInstruction.getOperandAddresses()[0]] != 0 || this.registerWrittenPointCount[n2] != 1 || this.registerReferenceMaybeLinked[n2]) continue;
            this.acceleratorInstructionList.set(i, null);
            this.unnecessaryRegisterSet.add(n2);
        }
        this.acceleratorInstructionList.removeAll(LIST_OF_NULL);
    }

    private void reduceMovInstructionsCopyingOperationResults(AcceleratorDataManagementUnit acceleratorDataManagementUnit) {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n - 1; ++i) {
            int n2;
            int n3;
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            AcceleratorInstruction acceleratorInstruction2 = this.acceleratorInstructionList.get(i + 1);
            if (!this.isDataWritingOperationCode(acceleratorInstruction.getOperationCode()) || acceleratorInstruction.getOperandPartitions()[0] != Memory.Partition.REGISTER || acceleratorInstruction2.getOperationCode() != OperationCode.MOV || acceleratorInstruction2.getOperandPartitions()[1] != Memory.Partition.REGISTER || (n3 = acceleratorInstruction.getOperandAddresses()[0]) != (n2 = acceleratorInstruction2.getOperandAddresses()[1]) || this.registerWrittenPointCount[n3] != 1 || this.registerReadPointCount[n3] != 1 || this.registerReferenceMaybeLinked[n3]) continue;
            Memory.Partition partition = acceleratorInstruction2.getOperandPartitions()[0];
            int n4 = acceleratorInstruction2.getOperandAddresses()[0];
            if (acceleratorDataManagementUnit.isScalar(Memory.Partition.REGISTER, n3) != acceleratorDataManagementUnit.isScalar(partition, n4) || acceleratorDataManagementUnit.isCachingEnabled(Memory.Partition.REGISTER, n3) != acceleratorDataManagementUnit.isCachingEnabled(partition, n4) || !movReducableOpcodeSet.contains((Object)acceleratorInstruction.getOperationCode())) continue;
            int n5 = acceleratorInstruction.getOperandLength();
            Memory.Partition[] partitionArray = new Memory.Partition[n5];
            System.arraycopy(acceleratorInstruction.getOperandPartitions(), 0, partitionArray, 0, n5);
            int[] nArray = new int[n5];
            System.arraycopy(acceleratorInstruction.getOperandAddresses(), 0, nArray, 0, n5);
            partitionArray[0] = partition;
            nArray[0] = n4;
            AcceleratorInstruction acceleratorInstruction3 = new AcceleratorInstruction(acceleratorInstruction, partitionArray, nArray);
            this.acceleratorInstructionList.set(i, acceleratorInstruction3);
            this.acceleratorInstructionList.set(i + 1, null);
            this.unnecessaryRegisterSet.add(n3);
            ++i;
        }
        this.acceleratorInstructionList.removeAll(LIST_OF_NULL);
    }

    private void removeAllocInstructionsToUnusedRegisters() {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n - 1; ++i) {
            int n2;
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            if (acceleratorInstruction.getOperationCode() != OperationCode.ALLOC && acceleratorInstruction.getOperationCode() != OperationCode.ALLOCR && acceleratorInstruction.getOperationCode() != OperationCode.ALLOCP && acceleratorInstruction.getOperationCode() != OperationCode.ALLOCT || acceleratorInstruction.getOperandPartitions()[0] != Memory.Partition.REGISTER || !this.unnecessaryRegisterSet.contains(n2 = acceleratorInstruction.getOperandAddresses()[0])) continue;
            this.acceleratorInstructionList.set(i, null);
        }
        this.acceleratorInstructionList.removeAll(LIST_OF_NULL);
    }

    private void checkRemovedRegistersAreUnused() {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n - 1; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            Memory.Partition[] partitionArray = acceleratorInstruction.getOperandPartitions();
            int[] nArray = acceleratorInstruction.getOperandAddresses();
            int n2 = acceleratorInstruction.getOperandLength();
            for (int j = 0; j < n2; ++j) {
                if (partitionArray[j] != Memory.Partition.REGISTER || !this.unnecessaryRegisterSet.contains(nArray[j])) continue;
                throw new VnanoFatalException("Optimization error (removed register \"R" + nArray[j] + "\" is accessed)");
            }
        }
    }

    private void fuseArithmeticInstructions(AcceleratorExecutionType acceleratorExecutionType, AcceleratorExecutionType acceleratorExecutionType2) {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n - 1; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            AcceleratorInstruction acceleratorInstruction2 = this.acceleratorInstructionList.get(i + 1);
            AcceleratorExecutionType acceleratorExecutionType3 = acceleratorInstruction.getAccelerationType();
            AcceleratorExecutionType acceleratorExecutionType4 = acceleratorInstruction2.getAccelerationType();
            if (acceleratorExecutionType3 != acceleratorExecutionType || acceleratorExecutionType4 != acceleratorExecutionType || acceleratorExecutionType == AcceleratorExecutionType.F64CS_ARITHMETIC && (!Float64CachedScalarDualArithmeticUnit.AVAILABLE_OPERAND_SET.contains((Object)acceleratorInstruction.getOperationCode()) || !Float64CachedScalarDualArithmeticUnit.AVAILABLE_OPERAND_SET.contains((Object)acceleratorInstruction2.getOperationCode())) || acceleratorExecutionType == AcceleratorExecutionType.I64CS_ARITHMETIC && (!Int64CachedScalarDualArithmeticUnit.AVAILABLE_OPERAND_SET.contains((Object)acceleratorInstruction.getOperationCode()) || !Int64CachedScalarDualArithmeticUnit.AVAILABLE_OPERAND_SET.contains((Object)acceleratorInstruction2.getOperationCode()))) continue;
            Memory.Partition[] partitionArray = acceleratorInstruction.getOperandPartitions();
            int[] nArray = acceleratorInstruction.getOperandAddresses();
            int n2 = acceleratorInstruction2.getOperandLength();
            Memory.Partition[] partitionArray2 = acceleratorInstruction2.getOperandPartitions();
            int[] nArray2 = acceleratorInstruction2.getOperandAddresses();
            int n3 = -1;
            int n4 = 0;
            for (int j = 1; j < n2; ++j) {
                if (partitionArray2[j] != partitionArray[0] || nArray2[j] != nArray[0]) continue;
                n3 = j;
                ++n4;
            }
            if (n4 != 1) continue;
            AcceleratorInstruction acceleratorInstruction3 = acceleratorInstruction.fuse(acceleratorInstruction2, acceleratorExecutionType2);
            acceleratorInstruction3.setFusedInputOperandIndices(new int[]{n3});
            this.acceleratorInstructionList.set(i, acceleratorInstruction3);
            this.acceleratorInstructionList.set(i + 1, null);
            ++i;
        }
        this.acceleratorInstructionList.removeAll(LIST_OF_NULL);
    }

    private void fuseTransferInstructions() {
        ArrayList<AcceleratorInstruction> arrayList = new ArrayList<AcceleratorInstruction>();
        ArrayList<AcceleratorInstruction> arrayList2 = new ArrayList<AcceleratorInstruction>();
        DataType dataType = null;
        Set<OperationCode> set = Float64CachedScalarMultipleTransferUnit.AVAILABLE_OPERAND_SET;
        Set<OperationCode> set2 = Int64CachedScalarMultipleTransferUnit.AVAILABLE_OPERAND_SET;
        Set<OperationCode> set3 = BoolCachedScalarMultipleTransferUnit.AVAILABLE_OPERAND_SET;
        int n = 10;
        int n2 = 10;
        int n3 = 10;
        for (AcceleratorInstruction acceleratorInstruction : this.acceleratorInstructionList) {
            boolean bl;
            AcceleratorExecutionType acceleratorExecutionType = acceleratorInstruction.getAccelerationType();
            OperationCode operationCode = acceleratorInstruction.getOperationCode();
            boolean bl2 = acceleratorExecutionType == AcceleratorExecutionType.F64CS_TRANSFER && set.contains((Object)operationCode);
            boolean bl3 = acceleratorExecutionType == AcceleratorExecutionType.I64CS_TRANSFER && set2.contains((Object)operationCode);
            boolean bl4 = acceleratorExecutionType == AcceleratorExecutionType.BCS_TRANSFER && set3.contains((Object)operationCode);
            boolean bl5 = bl2 || bl3 || bl4;
            int n4 = arrayList2.size();
            boolean bl6 = dataType == DataType.FLOAT64 && n4 == n;
            boolean bl7 = dataType == DataType.INT64 && n4 == n2;
            boolean bl8 = dataType == DataType.BOOL && n4 == n3;
            boolean bl9 = bl = bl6 || bl7 || bl8;
            if ((!bl5 || acceleratorInstruction.getDataTypes()[0] != dataType || bl) && arrayList2.size() != 0) {
                arrayList.add(this.toFusedTransferInstruction(arrayList2));
                arrayList2.clear();
            }
            if (bl5) {
                arrayList2.add(acceleratorInstruction);
                dataType = acceleratorInstruction.getDataTypes()[0];
                continue;
            }
            arrayList.add(acceleratorInstruction);
        }
        if (arrayList2.size() != 0) {
            arrayList.add(this.toFusedTransferInstruction(arrayList2));
            arrayList2.clear();
        }
        this.acceleratorInstructionList = arrayList;
    }

    private AcceleratorInstruction toFusedTransferInstruction(List<AcceleratorInstruction> list) {
        int n = list.size();
        if (n == 0) {
            throw new VnanoFatalException("The passed transfer instruction list for fusing is empty.");
        }
        if (n == 1) {
            return list.get(0);
        }
        Memory.Partition[] partitionArray = new Memory.Partition[n * 2];
        int[] nArray = new int[n * 2];
        int n2 = 0;
        for (AcceleratorInstruction acceleratorInstruction : list) {
            System.arraycopy(acceleratorInstruction.getOperandPartitions(), 0, partitionArray, n2, 2);
            System.arraycopy(acceleratorInstruction.getOperandAddresses(), 0, nArray, n2, 2);
            n2 += 2;
        }
        OperationCode[] operationCodeArray = new OperationCode[n];
        for (int i = 0; i < n; ++i) {
            operationCodeArray[i] = list.get(i).getOperationCode();
        }
        AcceleratorInstruction acceleratorInstruction = list.get(0);
        Instruction instruction = new Instruction(OperationCode.EX, acceleratorInstruction.getDataTypes(), partitionArray, nArray, acceleratorInstruction.getMetaPartition(), acceleratorInstruction.getMetaAddress());
        AcceleratorInstruction acceleratorInstruction2 = new AcceleratorInstruction(instruction);
        acceleratorInstruction2.setUnreorderedAddress(acceleratorInstruction.getUnreorderedAddress());
        acceleratorInstruction2.setFusedOperationCodes(operationCodeArray);
        switch (acceleratorInstruction.getDataTypes()[0]) {
            case INT64: {
                acceleratorInstruction2.setAccelerationType(AcceleratorExecutionType.I64CS_MULTIPLE_TRANSFER);
                break;
            }
            case FLOAT64: {
                acceleratorInstruction2.setAccelerationType(AcceleratorExecutionType.F64CS_MULTIPLE_TRANSFER);
                break;
            }
            case BOOL: {
                acceleratorInstruction2.setAccelerationType(AcceleratorExecutionType.BCS_MULTIPLE_TRANSFER);
                break;
            }
            default: {
                throw new VnanoFatalException("Infusible data type detected: " + (Object)((Object)acceleratorInstruction.getDataTypes()[0]));
            }
        }
        return acceleratorInstruction2;
    }

    private void fuseComparisonAndBranchInstructions() {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n - 1; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            AcceleratorInstruction acceleratorInstruction2 = this.acceleratorInstructionList.get(i + 1);
            if (acceleratorInstruction.getAccelerationType() != AcceleratorExecutionType.F64CS_COMPARISON && acceleratorInstruction.getAccelerationType() != AcceleratorExecutionType.I64CS_COMPARISON || acceleratorInstruction2.getAccelerationType() != AcceleratorExecutionType.BCS_BRANCH) continue;
            Memory.Partition[] partitionArray = acceleratorInstruction.getOperandPartitions();
            int[] nArray = acceleratorInstruction.getOperandAddresses();
            Memory.Partition[] partitionArray2 = acceleratorInstruction2.getOperandPartitions();
            int[] nArray2 = acceleratorInstruction2.getOperandAddresses();
            if (partitionArray[0] != partitionArray2[2] || nArray[0] != nArray2[2]) continue;
            AcceleratorInstruction acceleratorInstruction3 = acceleratorInstruction.fuse(acceleratorInstruction2, AcceleratorExecutionType.BCS_BRANCH);
            acceleratorInstruction3.setFusedInputOperandIndices(new int[]{2});
            acceleratorInstruction3.setReorderedLabelAddress(acceleratorInstruction2.getReorderedLabelAddress());
            acceleratorInstruction3.setExpandedLabelAddress(acceleratorInstruction2.getExpandedLabelAddress());
            this.acceleratorInstructionList.set(i, acceleratorInstruction3);
            this.acceleratorInstructionList.set(i + 1, null);
            ++i;
        }
        this.acceleratorInstructionList.removeAll(LIST_OF_NULL);
    }

    private void removeLabelInstructions() {
        int n = this.acceleratorInstructionList.size();
        ArrayList<AcceleratorInstruction> arrayList = new ArrayList<AcceleratorInstruction>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < n; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            if (acceleratorInstruction.getOperationCode() == OperationCode.LABEL) {
                int n2 = arrayList.size();
                hashMap.put(i, n2);
                continue;
            }
            arrayList.add(acceleratorInstruction);
        }
        for (AcceleratorInstruction acceleratorInstruction : this.acceleratorInstructionList) {
            int n3;
            boolean bl;
            OperationCode operationCode = acceleratorInstruction.getOperationCode();
            OperationCode[] operationCodeArray = acceleratorInstruction.isFused() ? acceleratorInstruction.getFusedOperationCodes() : null;
            boolean bl2 = operationCode == OperationCode.JMP || operationCode == OperationCode.JMPN || operationCode == OperationCode.CALL || operationCode == OperationCode.RET;
            boolean bl3 = bl = acceleratorInstruction.isFused() && (operationCodeArray[1] == OperationCode.JMP || operationCodeArray[1] == OperationCode.JMPN);
            if (!bl2 && !bl || !hashMap.containsKey(n3 = acceleratorInstruction.getReorderedLabelAddress())) continue;
            int n4 = (Integer)hashMap.get(n3);
            acceleratorInstruction.setReorderedLabelAddress(n4);
        }
        this.acceleratorInstructionList = arrayList;
    }

    private void updateReorderedAddresses() {
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n; ++i) {
            this.acceleratorInstructionList.get(i).setReorderedAddress(i);
        }
    }

    private void generateAddressReorderingMap() {
        this.addressReorderingMap = new HashMap<Integer, Integer>();
        this.expandedAddressReorderingMap = new HashMap<Integer, Integer>();
        int n = this.acceleratorInstructionList.size();
        for (int i = 0; i < n; ++i) {
            AcceleratorInstruction acceleratorInstruction = this.acceleratorInstructionList.get(i);
            if (acceleratorInstruction.isExpanded()) {
                this.expandedAddressReorderingMap.put(acceleratorInstruction.getExpandedAddress(), acceleratorInstruction.getReorderedAddress());
                continue;
            }
            this.addressReorderingMap.put(acceleratorInstruction.getUnreorderedAddress(), acceleratorInstruction.getReorderedAddress());
        }
    }

    static {
        movReducableOpcodeSet.add(OperationCode.ADD);
        movReducableOpcodeSet.add(OperationCode.SUB);
        movReducableOpcodeSet.add(OperationCode.MUL);
        movReducableOpcodeSet.add(OperationCode.DIV);
        movReducableOpcodeSet.add(OperationCode.REM);
        movReducableOpcodeSet.add(OperationCode.NEG);
        movReducableOpcodeSet.add(OperationCode.EQ);
        movReducableOpcodeSet.add(OperationCode.NEQ);
        movReducableOpcodeSet.add(OperationCode.GT);
        movReducableOpcodeSet.add(OperationCode.LT);
        movReducableOpcodeSet.add(OperationCode.GEQ);
        movReducableOpcodeSet.add(OperationCode.LEQ);
        movReducableOpcodeSet.add(OperationCode.ANDM);
        movReducableOpcodeSet.add(OperationCode.ORM);
        movReducableOpcodeSet.add(OperationCode.NOT);
        movReducableOpcodeSet.add(OperationCode.CAST);
        movReducableOpcodeSet.add(OperationCode.MOVPOP);
        movReducableOpcodeSet.add(OperationCode.MOVELM);
    }

    private class InternalFunctionInfo {
        private int functionAddress = -1;
        private int bodyBeginAddress = -1;
        private int bodyEndAddress = -1;
        private int retCount = 0;
        private int callCount = 0;
        private boolean isLastInstructionRet = false;
        private boolean hasReferenceParameters = false;
        private List<DataType> parameterDataTypeList = new ArrayList<DataType>();
        private List<Memory.Partition> parameterPartitionList = new ArrayList<Memory.Partition>();
        private List<Integer> parameterAddressList = new ArrayList<Integer>();
        private List<Boolean> parameterReferencenessList = new ArrayList<Boolean>();
        private List<Boolean> parameterScalarityList = new ArrayList<Boolean>();
        private List<Integer> parameterRankList = new ArrayList<Integer>();
        private Memory.Partition lastReturnValuePartition = null;
        private int lastReturnValueAddress = -1;

        public InternalFunctionInfo(int n) {
            this.functionAddress = n;
        }

        public void setBodyBeginAddress(int n) {
            this.bodyBeginAddress = n;
        }

        public int getBodyBeginAddress() {
            return this.bodyBeginAddress;
        }

        public void setBodyEndAddress(int n) {
            this.bodyEndAddress = n;
        }

        public int getBodyEndAddress() {
            return this.bodyEndAddress;
        }

        public int incrementRetCount() {
            return this.retCount++;
        }

        public int getRetCount() {
            return this.retCount;
        }

        public void setLastRetValue(Memory.Partition partition, int n) {
            this.lastReturnValuePartition = partition;
            this.lastReturnValueAddress = n;
        }

        public boolean hasRetValue() {
            return this.lastReturnValuePartition != null;
        }

        public Memory.Partition getLastRetValuePartition() {
            return this.lastReturnValuePartition;
        }

        public int getLastRetValueAddress() {
            return this.lastReturnValueAddress;
        }

        public int incrementCallCount() {
            return this.callCount++;
        }

        public int getCallCount() {
            return this.callCount;
        }

        public boolean isLastInstructionRet() {
            return this.isLastInstructionRet;
        }

        public void setLastInstructionRet(boolean bl) {
            this.isLastInstructionRet = bl;
        }

        public void addParameter(DataType dataType, Memory.Partition partition, int n, boolean bl, boolean bl2, int n2) {
            this.parameterDataTypeList.add(dataType);
            this.parameterPartitionList.add(partition);
            this.parameterAddressList.add(n);
            this.parameterReferencenessList.add(bl);
            this.parameterScalarityList.add(bl2);
            this.parameterRankList.add(n2);
            if (bl) {
                this.hasReferenceParameters = true;
            }
        }

        public void reverseParameterOrder() {
            Collections.reverse(this.parameterDataTypeList);
            Collections.reverse(this.parameterPartitionList);
            Collections.reverse(this.parameterAddressList);
            Collections.reverse(this.parameterReferencenessList);
            Collections.reverse(this.parameterScalarityList);
            Collections.reverse(this.parameterRankList);
        }

        public DataType getParameterDataType(int n) {
            return this.parameterDataTypeList.get(n);
        }

        public Memory.Partition getParameterPertition(int n) {
            return this.parameterPartitionList.get(n);
        }

        public int getParameterAddress(int n) {
            return this.parameterAddressList.get(n);
        }

        public boolean isParameterReference(int n) {
            return this.parameterReferencenessList.get(n);
        }

        public boolean isParameterScalar(int n) {
            return this.parameterScalarityList.get(n);
        }

        public int getParameterRank(int n) {
            return this.parameterRankList.get(n);
        }

        public boolean hasReferenceParameters() {
            return this.hasReferenceParameters;
        }

        public String toString() {
            int n = this.parameterAddressList.size();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[ InternalFunctionInfo address=");
            stringBuilder.append(this.functionAddress);
            stringBuilder.append(" bodyBegin=");
            stringBuilder.append(this.bodyBeginAddress);
            stringBuilder.append(" bodyEnd=");
            stringBuilder.append(this.bodyEndAddress);
            stringBuilder.append(" param={ ");
            for (int i = 0; i < n; ++i) {
                if (this.parameterReferencenessList.get(i).booleanValue()) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(this.parameterPartitionList.get(i).toString().charAt(0));
                stringBuilder.append(this.parameterAddressList.get(i));
                stringBuilder.append(' ');
            }
            stringBuilder.append("} ]");
            return stringBuilder.toString();
        }
    }
}

