/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.HashSet;
import java.util.Set;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.BoolScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolCachedScalarMultipleTransferUnit
extends AcceleratorExecutionUnit {
    public static final Set<OperationCode> AVAILABLE_OPERAND_SET = new HashSet<OperationCode>();
    public static final int MAX_AVAILABLE_TRANSFER_COUNT = 10;

    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        OperationCode[] operationCodeArray = acceleratorInstruction.getFusedOperationCodes();
        boolean bl = true;
        for (OperationCode operationCode : operationCodeArray) {
            bl &= operationCode == OperationCode.MOV;
        }
        if (bl) {
            int n = dataContainerArray.length / 2;
            switch (n) {
                case 2: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX2Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], acceleratorExecutionNode);
                    break;
                }
                case 3: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX3Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], (BoolScalarCache)objectArray[4], (BoolScalarCache)objectArray[5], acceleratorExecutionNode);
                    break;
                }
                case 4: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX4Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], (BoolScalarCache)objectArray[4], (BoolScalarCache)objectArray[5], (BoolScalarCache)objectArray[6], (BoolScalarCache)objectArray[7], acceleratorExecutionNode);
                    break;
                }
                case 5: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX5Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], (BoolScalarCache)objectArray[4], (BoolScalarCache)objectArray[5], (BoolScalarCache)objectArray[6], (BoolScalarCache)objectArray[7], (BoolScalarCache)objectArray[8], (BoolScalarCache)objectArray[9], acceleratorExecutionNode);
                    break;
                }
                case 6: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX6Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], (BoolScalarCache)objectArray[4], (BoolScalarCache)objectArray[5], (BoolScalarCache)objectArray[6], (BoolScalarCache)objectArray[7], (BoolScalarCache)objectArray[8], (BoolScalarCache)objectArray[9], (BoolScalarCache)objectArray[10], (BoolScalarCache)objectArray[11], acceleratorExecutionNode);
                    break;
                }
                case 7: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX7Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], (BoolScalarCache)objectArray[4], (BoolScalarCache)objectArray[5], (BoolScalarCache)objectArray[6], (BoolScalarCache)objectArray[7], (BoolScalarCache)objectArray[8], (BoolScalarCache)objectArray[9], (BoolScalarCache)objectArray[10], (BoolScalarCache)objectArray[11], (BoolScalarCache)objectArray[12], (BoolScalarCache)objectArray[13], acceleratorExecutionNode);
                    break;
                }
                case 8: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX8Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], (BoolScalarCache)objectArray[4], (BoolScalarCache)objectArray[5], (BoolScalarCache)objectArray[6], (BoolScalarCache)objectArray[7], (BoolScalarCache)objectArray[8], (BoolScalarCache)objectArray[9], (BoolScalarCache)objectArray[10], (BoolScalarCache)objectArray[11], (BoolScalarCache)objectArray[12], (BoolScalarCache)objectArray[13], (BoolScalarCache)objectArray[14], (BoolScalarCache)objectArray[15], acceleratorExecutionNode);
                    break;
                }
                case 9: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX9Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], (BoolScalarCache)objectArray[4], (BoolScalarCache)objectArray[5], (BoolScalarCache)objectArray[6], (BoolScalarCache)objectArray[7], (BoolScalarCache)objectArray[8], (BoolScalarCache)objectArray[9], (BoolScalarCache)objectArray[10], (BoolScalarCache)objectArray[11], (BoolScalarCache)objectArray[12], (BoolScalarCache)objectArray[13], (BoolScalarCache)objectArray[14], (BoolScalarCache)objectArray[15], (BoolScalarCache)objectArray[16], (BoolScalarCache)objectArray[17], acceleratorExecutionNode);
                    break;
                }
                case 10: {
                    acceleratorExecutionNode2 = new BoolCachedScalarMovX10Node((BoolScalarCache)objectArray[0], (BoolScalarCache)objectArray[1], (BoolScalarCache)objectArray[2], (BoolScalarCache)objectArray[3], (BoolScalarCache)objectArray[4], (BoolScalarCache)objectArray[5], (BoolScalarCache)objectArray[6], (BoolScalarCache)objectArray[7], (BoolScalarCache)objectArray[8], (BoolScalarCache)objectArray[9], (BoolScalarCache)objectArray[10], (BoolScalarCache)objectArray[11], (BoolScalarCache)objectArray[12], (BoolScalarCache)objectArray[13], (BoolScalarCache)objectArray[14], (BoolScalarCache)objectArray[15], (BoolScalarCache)objectArray[16], (BoolScalarCache)objectArray[17], (BoolScalarCache)objectArray[18], (BoolScalarCache)objectArray[19], acceleratorExecutionNode);
                    break;
                }
                default: {
                    throw new VnanoFatalException("The plural transfer x" + n + " is not supported by " + this.getClass().getCanonicalName());
                }
            }
        } else {
            throw new VnanoFatalException("Unsupported fused operation codes has been detected in " + this.getClass().getCanonicalName());
        }
        return acceleratorExecutionNode2;
    }

    static {
        AVAILABLE_OPERAND_SET.add(OperationCode.MOV);
    }

    private class BoolCachedScalarMovX2Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;

        public BoolCachedScalarMovX2Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 2);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            return this.nextNode;
        }
    }

    private class BoolCachedScalarMovX3Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;
        protected final BoolScalarCache dest2;
        protected final BoolScalarCache src2;

        public BoolCachedScalarMovX3Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, BoolScalarCache boolScalarCache5, BoolScalarCache boolScalarCache6, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 3);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.src2 = boolScalarCache6;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
            this.dest2 = boolScalarCache5;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            return this.nextNode;
        }
    }

    private class BoolCachedScalarMovX4Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;
        protected final BoolScalarCache dest2;
        protected final BoolScalarCache src2;
        protected final BoolScalarCache dest3;
        protected final BoolScalarCache src3;

        public BoolCachedScalarMovX4Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, BoolScalarCache boolScalarCache5, BoolScalarCache boolScalarCache6, BoolScalarCache boolScalarCache7, BoolScalarCache boolScalarCache8, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 4);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.src2 = boolScalarCache6;
            this.src3 = boolScalarCache8;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
            this.dest2 = boolScalarCache5;
            this.dest3 = boolScalarCache7;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            return this.nextNode;
        }
    }

    private class BoolCachedScalarMovX5Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;
        protected final BoolScalarCache dest2;
        protected final BoolScalarCache src2;
        protected final BoolScalarCache dest3;
        protected final BoolScalarCache src3;
        protected final BoolScalarCache dest4;
        protected final BoolScalarCache src4;

        public BoolCachedScalarMovX5Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, BoolScalarCache boolScalarCache5, BoolScalarCache boolScalarCache6, BoolScalarCache boolScalarCache7, BoolScalarCache boolScalarCache8, BoolScalarCache boolScalarCache9, BoolScalarCache boolScalarCache10, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 5);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.src2 = boolScalarCache6;
            this.src3 = boolScalarCache8;
            this.src4 = boolScalarCache10;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
            this.dest2 = boolScalarCache5;
            this.dest3 = boolScalarCache7;
            this.dest4 = boolScalarCache9;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            return this.nextNode;
        }
    }

    private class BoolCachedScalarMovX6Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;
        protected final BoolScalarCache dest2;
        protected final BoolScalarCache src2;
        protected final BoolScalarCache dest3;
        protected final BoolScalarCache src3;
        protected final BoolScalarCache dest4;
        protected final BoolScalarCache src4;
        protected final BoolScalarCache dest5;
        protected final BoolScalarCache src5;

        public BoolCachedScalarMovX6Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, BoolScalarCache boolScalarCache5, BoolScalarCache boolScalarCache6, BoolScalarCache boolScalarCache7, BoolScalarCache boolScalarCache8, BoolScalarCache boolScalarCache9, BoolScalarCache boolScalarCache10, BoolScalarCache boolScalarCache11, BoolScalarCache boolScalarCache12, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 6);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.src2 = boolScalarCache6;
            this.src3 = boolScalarCache8;
            this.src4 = boolScalarCache10;
            this.src5 = boolScalarCache12;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
            this.dest2 = boolScalarCache5;
            this.dest3 = boolScalarCache7;
            this.dest4 = boolScalarCache9;
            this.dest5 = boolScalarCache11;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            return this.nextNode;
        }
    }

    private class BoolCachedScalarMovX7Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;
        protected final BoolScalarCache dest2;
        protected final BoolScalarCache src2;
        protected final BoolScalarCache dest3;
        protected final BoolScalarCache src3;
        protected final BoolScalarCache dest4;
        protected final BoolScalarCache src4;
        protected final BoolScalarCache dest5;
        protected final BoolScalarCache src5;
        protected final BoolScalarCache dest6;
        protected final BoolScalarCache src6;

        public BoolCachedScalarMovX7Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, BoolScalarCache boolScalarCache5, BoolScalarCache boolScalarCache6, BoolScalarCache boolScalarCache7, BoolScalarCache boolScalarCache8, BoolScalarCache boolScalarCache9, BoolScalarCache boolScalarCache10, BoolScalarCache boolScalarCache11, BoolScalarCache boolScalarCache12, BoolScalarCache boolScalarCache13, BoolScalarCache boolScalarCache14, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 7);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.src2 = boolScalarCache6;
            this.src3 = boolScalarCache8;
            this.src4 = boolScalarCache10;
            this.src5 = boolScalarCache12;
            this.src6 = boolScalarCache14;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
            this.dest2 = boolScalarCache5;
            this.dest3 = boolScalarCache7;
            this.dest4 = boolScalarCache9;
            this.dest5 = boolScalarCache11;
            this.dest6 = boolScalarCache13;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            this.dest6.data = this.src6.data;
            return this.nextNode;
        }
    }

    private class BoolCachedScalarMovX8Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;
        protected final BoolScalarCache dest2;
        protected final BoolScalarCache src2;
        protected final BoolScalarCache dest3;
        protected final BoolScalarCache src3;
        protected final BoolScalarCache dest4;
        protected final BoolScalarCache src4;
        protected final BoolScalarCache dest5;
        protected final BoolScalarCache src5;
        protected final BoolScalarCache dest6;
        protected final BoolScalarCache src6;
        protected final BoolScalarCache dest7;
        protected final BoolScalarCache src7;

        public BoolCachedScalarMovX8Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, BoolScalarCache boolScalarCache5, BoolScalarCache boolScalarCache6, BoolScalarCache boolScalarCache7, BoolScalarCache boolScalarCache8, BoolScalarCache boolScalarCache9, BoolScalarCache boolScalarCache10, BoolScalarCache boolScalarCache11, BoolScalarCache boolScalarCache12, BoolScalarCache boolScalarCache13, BoolScalarCache boolScalarCache14, BoolScalarCache boolScalarCache15, BoolScalarCache boolScalarCache16, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 8);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.src2 = boolScalarCache6;
            this.src3 = boolScalarCache8;
            this.src4 = boolScalarCache10;
            this.src5 = boolScalarCache12;
            this.src6 = boolScalarCache14;
            this.src7 = boolScalarCache16;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
            this.dest2 = boolScalarCache5;
            this.dest3 = boolScalarCache7;
            this.dest4 = boolScalarCache9;
            this.dest5 = boolScalarCache11;
            this.dest6 = boolScalarCache13;
            this.dest7 = boolScalarCache15;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            this.dest6.data = this.src6.data;
            this.dest7.data = this.src7.data;
            return this.nextNode;
        }
    }

    private class BoolCachedScalarMovX9Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;
        protected final BoolScalarCache dest2;
        protected final BoolScalarCache src2;
        protected final BoolScalarCache dest3;
        protected final BoolScalarCache src3;
        protected final BoolScalarCache dest4;
        protected final BoolScalarCache src4;
        protected final BoolScalarCache dest5;
        protected final BoolScalarCache src5;
        protected final BoolScalarCache dest6;
        protected final BoolScalarCache src6;
        protected final BoolScalarCache dest7;
        protected final BoolScalarCache src7;
        protected final BoolScalarCache dest8;
        protected final BoolScalarCache src8;

        public BoolCachedScalarMovX9Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, BoolScalarCache boolScalarCache5, BoolScalarCache boolScalarCache6, BoolScalarCache boolScalarCache7, BoolScalarCache boolScalarCache8, BoolScalarCache boolScalarCache9, BoolScalarCache boolScalarCache10, BoolScalarCache boolScalarCache11, BoolScalarCache boolScalarCache12, BoolScalarCache boolScalarCache13, BoolScalarCache boolScalarCache14, BoolScalarCache boolScalarCache15, BoolScalarCache boolScalarCache16, BoolScalarCache boolScalarCache17, BoolScalarCache boolScalarCache18, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 9);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.src2 = boolScalarCache6;
            this.src3 = boolScalarCache8;
            this.src4 = boolScalarCache10;
            this.src5 = boolScalarCache12;
            this.src6 = boolScalarCache14;
            this.src7 = boolScalarCache16;
            this.src8 = boolScalarCache18;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
            this.dest2 = boolScalarCache5;
            this.dest3 = boolScalarCache7;
            this.dest4 = boolScalarCache9;
            this.dest5 = boolScalarCache11;
            this.dest6 = boolScalarCache13;
            this.dest7 = boolScalarCache15;
            this.dest8 = boolScalarCache17;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            this.dest6.data = this.src6.data;
            this.dest7.data = this.src7.data;
            this.dest8.data = this.src8.data;
            return this.nextNode;
        }
    }

    private class BoolCachedScalarMovX10Node
    extends AcceleratorExecutionNode {
        protected final BoolScalarCache dest0;
        protected final BoolScalarCache src0;
        protected final BoolScalarCache dest1;
        protected final BoolScalarCache src1;
        protected final BoolScalarCache dest2;
        protected final BoolScalarCache src2;
        protected final BoolScalarCache dest3;
        protected final BoolScalarCache src3;
        protected final BoolScalarCache dest4;
        protected final BoolScalarCache src4;
        protected final BoolScalarCache dest5;
        protected final BoolScalarCache src5;
        protected final BoolScalarCache dest6;
        protected final BoolScalarCache src6;
        protected final BoolScalarCache dest7;
        protected final BoolScalarCache src7;
        protected final BoolScalarCache dest8;
        protected final BoolScalarCache src8;
        protected final BoolScalarCache dest9;
        protected final BoolScalarCache src9;

        public BoolCachedScalarMovX10Node(BoolScalarCache boolScalarCache, BoolScalarCache boolScalarCache2, BoolScalarCache boolScalarCache3, BoolScalarCache boolScalarCache4, BoolScalarCache boolScalarCache5, BoolScalarCache boolScalarCache6, BoolScalarCache boolScalarCache7, BoolScalarCache boolScalarCache8, BoolScalarCache boolScalarCache9, BoolScalarCache boolScalarCache10, BoolScalarCache boolScalarCache11, BoolScalarCache boolScalarCache12, BoolScalarCache boolScalarCache13, BoolScalarCache boolScalarCache14, BoolScalarCache boolScalarCache15, BoolScalarCache boolScalarCache16, BoolScalarCache boolScalarCache17, BoolScalarCache boolScalarCache18, BoolScalarCache boolScalarCache19, BoolScalarCache boolScalarCache20, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 10);
            this.src0 = boolScalarCache2;
            this.src1 = boolScalarCache4;
            this.src2 = boolScalarCache6;
            this.src3 = boolScalarCache8;
            this.src4 = boolScalarCache10;
            this.src5 = boolScalarCache12;
            this.src6 = boolScalarCache14;
            this.src7 = boolScalarCache16;
            this.src8 = boolScalarCache18;
            this.src9 = boolScalarCache20;
            this.dest0 = boolScalarCache;
            this.dest1 = boolScalarCache3;
            this.dest2 = boolScalarCache5;
            this.dest3 = boolScalarCache7;
            this.dest4 = boolScalarCache9;
            this.dest5 = boolScalarCache11;
            this.dest6 = boolScalarCache13;
            this.dest7 = boolScalarCache15;
            this.dest8 = boolScalarCache17;
            this.dest9 = boolScalarCache19;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.dest0.data = this.src0.data;
            this.dest1.data = this.src1.data;
            this.dest2.data = this.src2.data;
            this.dest3.data = this.src3.data;
            this.dest4.data = this.src4.data;
            this.dest5.data = this.src5.data;
            this.dest6.data = this.src6.data;
            this.dest7.data = this.src7.data;
            this.dest8.data = this.src8.data;
            this.dest9.data = this.src9.data;
            return this.nextNode;
        }
    }
}

