/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.ErrorType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Boolx1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolScalarVectorTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        BoolScalarVectorMovNode boolScalarVectorMovNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: {
                Boolx1ScalarCacheSynchronizer boolx1ScalarCacheSynchronizer = new Boolx1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray, 0);
                boolScalarVectorMovNode = new BoolScalarVectorMovNode(dataContainerArray[0], dataContainerArray[1], boolx1ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return boolScalarVectorMovNode;
    }

    private final class BoolScalarVectorMovNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<boolean[]> container1;
        protected final Boolx1ScalarCacheSynchronizer synchronizer;

        public BoolScalarVectorMovNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx1ScalarCacheSynchronizer boolx1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = boolx1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() throws VnanoException {
            if (this.container1.getArraySize() != 1) {
                throw new VnanoException(ErrorType.ARRAY_SIZE_IS_TOO_LARGE_TO_BE_ASSIGNED_TO_SCALAR_VARIABLE);
            }
            boolean[] blArray = this.container0.getArrayData();
            boolean[] blArray2 = this.container1.getArrayData();
            blArray[this.container0.getArrayOffset()] = blArray2[0];
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

