/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.Arrays;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Boolx1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class BoolVectorScalarTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        BoolVectorScalarFillNode boolVectorScalarFillNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case FILL: {
                Boolx1ScalarCacheSynchronizer boolx1ScalarCacheSynchronizer = new Boolx1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray, 1);
                boolVectorScalarFillNode = new BoolVectorScalarFillNode(dataContainerArray[0], dataContainerArray[1], boolx1ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return boolVectorScalarFillNode;
    }

    private final class BoolVectorScalarFillNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<boolean[]> container1;
        protected final Boolx1ScalarCacheSynchronizer synchronizer;

        public BoolVectorScalarFillNode(DataContainer<boolean[]> dataContainer, DataContainer<boolean[]> dataContainer2, Boolx1ScalarCacheSynchronizer boolx1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = boolx1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean bl = this.container1.getArrayData()[this.container1.getArrayOffset()];
            int n = this.container0.getArrayOffset();
            int n2 = n + this.container0.getArraySize();
            Arrays.fill(this.container0.getArrayData(), n, n2, bl);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

