/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64x2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Float64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64ScalarArithmeticUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<?>[] dataContainerArray2 = dataContainerArray;
        Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer = null;
        Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer = null;
        if (dataContainerArray.length == 2) {
            float64x2ScalarCacheSynchronizer = new Float64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        } else if (dataContainerArray.length == 3) {
            float64x3ScalarCacheSynchronizer = new Float64x3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        } else {
            throw new VnanoFatalException("Unexpected number of operands detected.");
        }
        Float64ScalarArithmeticNode float64ScalarArithmeticNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ADD: {
                float64ScalarArithmeticNode = new Float64ScalarAddNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case SUB: {
                float64ScalarArithmeticNode = new Float64ScalarSubNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case MUL: {
                float64ScalarArithmeticNode = new Float64ScalarMulNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case DIV: {
                float64ScalarArithmeticNode = new Float64ScalarDivNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case REM: {
                float64ScalarArithmeticNode = new Float64ScalarRemNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case NEG: {
                float64ScalarArithmeticNode = new Float64ScalarNegNode(dataContainerArray2[0], dataContainerArray2[1], float64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return float64ScalarArithmeticNode;
    }

    private final class Float64ScalarAddNode
    extends Float64ScalarArithmeticNode {
        public Float64ScalarAddNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            ((double[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((double[])this.container1.getArrayData())[this.container1.getArrayOffset()] + ((double[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64ScalarSubNode
    extends Float64ScalarArithmeticNode {
        public Float64ScalarSubNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            ((double[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((double[])this.container1.getArrayData())[this.container1.getArrayOffset()] - ((double[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64ScalarMulNode
    extends Float64ScalarArithmeticNode {
        public Float64ScalarMulNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            ((double[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((double[])this.container1.getArrayData())[this.container1.getArrayOffset()] * ((double[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64ScalarDivNode
    extends Float64ScalarArithmeticNode {
        public Float64ScalarDivNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            ((double[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((double[])this.container1.getArrayData())[this.container1.getArrayOffset()] / ((double[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64ScalarRemNode
    extends Float64ScalarArithmeticNode {
        public Float64ScalarRemNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            ((double[])this.container0.getArrayData())[this.container0.getArrayOffset()] = ((double[])this.container1.getArrayData())[this.container1.getArrayOffset()] % ((double[])this.container2.getArrayData())[this.container2.getArrayOffset()];
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64ScalarNegNode
    extends Float64ScalarArithmeticNode {
        public Float64ScalarNegNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, float64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x2.synchronizeFromCacheToMemory();
            ((double[])this.container0.getArrayData())[this.container0.getArrayOffset()] = -((double[])this.container1.getArrayData())[this.container1.getArrayOffset()];
            this.synchronizerF64x2.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private abstract class Float64ScalarArithmeticNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container0;
        protected final DataContainer<double[]> container1;
        protected final DataContainer<double[]> container2;
        protected final Float64x2ScalarCacheSynchronizer synchronizerF64x2;
        protected final Float64x3ScalarCacheSynchronizer synchronizerF64x3;

        public Float64ScalarArithmeticNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = dataContainer3;
            this.synchronizerF64x2 = null;
            this.synchronizerF64x3 = float64x3ScalarCacheSynchronizer;
        }

        public Float64ScalarArithmeticNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = null;
            this.synchronizerF64x2 = float64x2ScalarCacheSynchronizer;
            this.synchronizerF64x3 = null;
        }
    }
}

