/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64x2ScalarCacheSynchronizer;
import org.vcssl.nano.vm.accelerator.Float64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64VectorArithmeticUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<?>[] dataContainerArray2 = dataContainerArray;
        Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer = null;
        Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer = null;
        if (dataContainerArray.length == 2) {
            float64x2ScalarCacheSynchronizer = new Float64x2ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        } else if (dataContainerArray.length == 3) {
            float64x3ScalarCacheSynchronizer = new Float64x3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        } else {
            throw new VnanoFatalException("Unexpected number of operands detected.");
        }
        Float64VectorArithmeticNode float64VectorArithmeticNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case ADD: {
                float64VectorArithmeticNode = new Float64VectorAddNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case SUB: {
                float64VectorArithmeticNode = new Float64VectorSubNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case MUL: {
                float64VectorArithmeticNode = new Float64VectorMulNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case DIV: {
                float64VectorArithmeticNode = new Float64VectorDivNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case REM: {
                float64VectorArithmeticNode = new Float64VectorRemNode(dataContainerArray2[0], dataContainerArray2[1], dataContainerArray2[2], float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case NEG: {
                float64VectorArithmeticNode = new Float64VectorNegNode(dataContainerArray2[0], dataContainerArray2[1], float64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return float64VectorArithmeticNode;
    }

    private final class Float64VectorAddNode
    extends Float64VectorArithmeticNode {
        public Float64VectorAddNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            double[] dArray = (double[])this.container0.getArrayData();
            double[] dArray2 = (double[])this.container1.getArrayData();
            double[] dArray3 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray[i] = dArray2[i] + dArray3[i];
            }
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorSubNode
    extends Float64VectorArithmeticNode {
        public Float64VectorSubNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            double[] dArray = (double[])this.container0.getArrayData();
            double[] dArray2 = (double[])this.container1.getArrayData();
            double[] dArray3 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray[i] = dArray2[i] - dArray3[i];
            }
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorMulNode
    extends Float64VectorArithmeticNode {
        public Float64VectorMulNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            double[] dArray = (double[])this.container0.getArrayData();
            double[] dArray2 = (double[])this.container1.getArrayData();
            double[] dArray3 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray[i] = dArray2[i] * dArray3[i];
            }
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorDivNode
    extends Float64VectorArithmeticNode {
        public Float64VectorDivNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            double[] dArray = (double[])this.container0.getArrayData();
            double[] dArray2 = (double[])this.container1.getArrayData();
            double[] dArray3 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray[i] = dArray2[i] / dArray3[i];
            }
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorRemNode
    extends Float64VectorArithmeticNode {
        public Float64VectorRemNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x3.synchronizeFromCacheToMemory();
            double[] dArray = (double[])this.container0.getArrayData();
            double[] dArray2 = (double[])this.container1.getArrayData();
            double[] dArray3 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray[i] = dArray2[i] % dArray3[i];
            }
            this.synchronizerF64x3.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorNegNode
    extends Float64VectorArithmeticNode {
        public Float64VectorNegNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, float64x2ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizerF64x2.synchronizeFromCacheToMemory();
            double[] dArray = (double[])this.container0.getArrayData();
            double[] dArray2 = (double[])this.container1.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                dArray[i] = -dArray2[i];
            }
            this.synchronizerF64x2.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private abstract class Float64VectorArithmeticNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container0;
        protected final DataContainer<double[]> container1;
        protected final DataContainer<double[]> container2;
        protected final Float64x3ScalarCacheSynchronizer synchronizerF64x3;
        protected final Float64x2ScalarCacheSynchronizer synchronizerF64x2;

        public Float64VectorArithmeticNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = dataContainer3;
            this.synchronizerF64x2 = null;
            this.synchronizerF64x3 = float64x3ScalarCacheSynchronizer;
        }

        public Float64VectorArithmeticNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Float64x2ScalarCacheSynchronizer float64x2ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = null;
            this.synchronizerF64x2 = float64x2ScalarCacheSynchronizer;
            this.synchronizerF64x3 = null;
        }
    }
}

