/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64x3ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64VectorComparisonUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        DataContainer<boolean[]> dataContainer = dataContainerArray[0];
        DataContainer<double[]> dataContainer2 = dataContainerArray[1];
        DataContainer<double[]> dataContainer3 = dataContainerArray[2];
        Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer = new Float64x3ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray);
        Float64VectorComparisonNode float64VectorComparisonNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case LT: {
                float64VectorComparisonNode = new Float64VectorLtNode(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case GT: {
                float64VectorComparisonNode = new Float64VectorGtNode(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case LEQ: {
                float64VectorComparisonNode = new Float64VectorLeqNode(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case GEQ: {
                float64VectorComparisonNode = new Float64VectorGeqNode(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case EQ: {
                float64VectorComparisonNode = new Float64VectorEqNode(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            case NEQ: {
                float64VectorComparisonNode = new Float64VectorNeqNode(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return float64VectorComparisonNode;
    }

    private final class Float64VectorLtNode
    extends Float64VectorComparisonNode {
        public Float64VectorLtNode(DataContainer<boolean[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            double[] dArray = (double[])this.container1.getArrayData();
            double[] dArray2 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = dArray[i] < dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorGtNode
    extends Float64VectorComparisonNode {
        public Float64VectorGtNode(DataContainer<boolean[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            double[] dArray = (double[])this.container1.getArrayData();
            double[] dArray2 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = dArray[i] > dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorLeqNode
    extends Float64VectorComparisonNode {
        public Float64VectorLeqNode(DataContainer<boolean[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            double[] dArray = (double[])this.container1.getArrayData();
            double[] dArray2 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = dArray[i] <= dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorGeqNode
    extends Float64VectorComparisonNode {
        public Float64VectorGeqNode(DataContainer<boolean[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            double[] dArray = (double[])this.container1.getArrayData();
            double[] dArray2 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = dArray[i] >= dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorEqNode
    extends Float64VectorComparisonNode {
        public Float64VectorEqNode(DataContainer<boolean[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            double[] dArray = (double[])this.container1.getArrayData();
            double[] dArray2 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = dArray[i] == dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private final class Float64VectorNeqNode
    extends Float64VectorComparisonNode {
        public Float64VectorNeqNode(DataContainer<boolean[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(dataContainer, dataContainer2, dataContainer3, float64x3ScalarCacheSynchronizer, acceleratorExecutionNode);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            boolean[] blArray = (boolean[])this.container0.getArrayData();
            double[] dArray = (double[])this.container1.getArrayData();
            double[] dArray2 = (double[])this.container2.getArrayData();
            int n = this.container0.getArraySize();
            for (int i = 0; i < n; ++i) {
                blArray[i] = dArray[i] != dArray2[i];
            }
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }

    private abstract class Float64VectorComparisonNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<boolean[]> container0;
        protected final DataContainer<double[]> container1;
        protected final DataContainer<double[]> container2;
        protected final Float64x3ScalarCacheSynchronizer synchronizer;

        public Float64VectorComparisonNode(DataContainer<boolean[]> dataContainer, DataContainer<double[]> dataContainer2, DataContainer<double[]> dataContainer3, Float64x3ScalarCacheSynchronizer float64x3ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.container2 = dataContainer3;
            this.synchronizer = float64x3ScalarCacheSynchronizer;
        }
    }
}

