/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.Arrays;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64x1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Float64VectorScalarTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        Float64VectorScalarFillNode float64VectorScalarFillNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case FILL: {
                Float64x1ScalarCacheSynchronizer float64x1ScalarCacheSynchronizer = new Float64x1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray, 1);
                float64VectorScalarFillNode = new Float64VectorScalarFillNode(dataContainerArray[0], dataContainerArray[1], float64x1ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return float64VectorScalarFillNode;
    }

    private final class Float64VectorScalarFillNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<double[]> container0;
        protected final DataContainer<double[]> container1;
        protected final Float64x1ScalarCacheSynchronizer synchronizer;

        public Float64VectorScalarFillNode(DataContainer<double[]> dataContainer, DataContainer<double[]> dataContainer2, Float64x1ScalarCacheSynchronizer float64x1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = float64x1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            double d = this.container1.getArrayData()[this.container1.getArrayOffset()];
            int n = this.container0.getArrayOffset();
            int n2 = n + this.container0.getArraySize();
            Arrays.fill(this.container0.getArrayData(), n, n2, d);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

