/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Float64ScalarCache;
import org.vcssl.nano.vm.accelerator.Int64ScalarCache;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64CachedScalarTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        AcceleratorExecutionNode acceleratorExecutionNode2 = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case MOV: {
                acceleratorExecutionNode2 = new Int64CachedScalarMovNode((Int64ScalarCache)objectArray[0], (Int64ScalarCache)objectArray[1], acceleratorExecutionNode);
                break;
            }
            case CAST: {
                if (acceleratorInstruction.getDataTypes()[1] == DataType.INT64) {
                    acceleratorExecutionNode2 = new Int64CachedScalarMovNode((Int64ScalarCache)objectArray[0], (Int64ScalarCache)objectArray[1], acceleratorExecutionNode);
                    break;
                }
                if (acceleratorInstruction.getDataTypes()[1] == DataType.FLOAT64) {
                    acceleratorExecutionNode2 = new Int64FromFloat64CachedScalarCastNode((Int64ScalarCache)objectArray[0], (Float64ScalarCache)objectArray[1], acceleratorExecutionNode);
                    break;
                }
                throw new VnanoFatalException((Object)((Object)acceleratorInstruction.getDataTypes()[1]) + "-type operand of " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " instruction is invalid for " + this.getClass().getCanonicalName());
            }
            case FILL: {
                acceleratorExecutionNode2 = new Int64CachedScalarMovNode((Int64ScalarCache)objectArray[0], (Int64ScalarCache)objectArray[1], acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return acceleratorExecutionNode2;
    }

    private class Int64CachedScalarMovNode
    extends AcceleratorExecutionNode {
        protected final Int64ScalarCache cache0;
        protected final Int64ScalarCache cache1;

        public Int64CachedScalarMovNode(Int64ScalarCache int64ScalarCache, Int64ScalarCache int64ScalarCache2, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = int64ScalarCache;
            this.cache1 = int64ScalarCache2;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = this.cache1.data;
            return this.nextNode;
        }
    }

    private class Int64FromFloat64CachedScalarCastNode
    extends AcceleratorExecutionNode {
        protected final Int64ScalarCache cache0;
        protected final Float64ScalarCache cache1;

        public Int64FromFloat64CachedScalarCastNode(Int64ScalarCache int64ScalarCache, Float64ScalarCache float64ScalarCache, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.cache0 = int64ScalarCache;
            this.cache1 = float64ScalarCache;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.cache0.data = (long)this.cache1.data;
            return this.nextNode;
        }
    }
}

