/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.GeneralScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.processor.ExecutionUnit;

public class Int64MemoryAllocationUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        if (acceleratorInstruction.getOperationCode() == OperationCode.ALLOC) {
            int n = dataContainerArray.length - 1;
            if (n == 0) {
                return new Int64ScalarAllocNode(dataContainerArray[0], acceleratorExecutionNode);
            }
            return new Int64VectorAllocNode(dataContainerArray, objectArray, blArray, n, acceleratorExecutionNode);
        }
        if (acceleratorInstruction.getOperationCode() == OperationCode.ALLOCR) {
            return new Int64AllocrNode(dataContainerArray, acceleratorExecutionNode);
        }
        throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
    }

    private final class Int64ScalarAllocNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<?> container0;

        public Int64ScalarAllocNode(DataContainer<?> dataContainer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            Object obj = this.container0.getArrayData();
            if (obj instanceof long[] && ((long[])obj).length != 0) {
                return this.nextNode;
            }
            this.container0.setArrayData(new long[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
            return this.nextNode;
        }
    }

    private final class Int64VectorAllocNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<?> targetContainer;
        protected final DataContainer<?>[] lengthsContainers;
        protected final Object[] lengthsCaches;
        protected final GeneralScalarCacheSynchronizer lengthsCacheSynchronizer;
        int rank;

        public Int64VectorAllocNode(DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, int n, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.rank = n;
            this.targetContainer = dataContainerArray[0];
            this.lengthsContainers = new DataContainer[this.rank];
            this.lengthsCaches = new Object[this.rank];
            boolean[] blArray2 = new boolean[this.rank];
            System.arraycopy(dataContainerArray, 1, this.lengthsContainers, 0, this.rank);
            System.arraycopy(objectArray, 1, this.lengthsCaches, 0, this.rank);
            System.arraycopy(blArray, 1, blArray2, 0, this.rank);
            this.lengthsCacheSynchronizer = new GeneralScalarCacheSynchronizer(this.lengthsContainers, this.lengthsCaches, blArray2);
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.lengthsCacheSynchronizer.synchronizeFromCacheToMemory();
            int n = 1;
            for (int i = 0; i < this.rank; ++i) {
                long[] lArray = (long[])this.lengthsContainers[i].getArrayData();
                n *= (int)lArray[this.lengthsContainers[i].getArrayOffset()];
            }
            Object obj = this.targetContainer.getArrayData();
            if (obj instanceof long[] && ((long[])obj).length == n) {
                return this.nextNode;
            }
            new ExecutionUnit().allocVector(DataType.INT64, this.targetContainer, this.lengthsContainers);
            return this.nextNode;
        }
    }

    private final class Int64AllocrNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<?> targetContainer;
        protected final DataContainer<?> sameLengthContainer;

        public Int64AllocrNode(DataContainer<?>[] dataContainerArray, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.targetContainer = dataContainerArray[0];
            this.sameLengthContainer = dataContainerArray[1];
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            new ExecutionUnit().allocSameLengths(DataType.INT64, this.targetContainer, this.sameLengthContainer);
            return this.nextNode;
        }
    }
}

