/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.accelerator;

import java.util.Arrays;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionNode;
import org.vcssl.nano.vm.accelerator.AcceleratorExecutionUnit;
import org.vcssl.nano.vm.accelerator.AcceleratorInstruction;
import org.vcssl.nano.vm.accelerator.Int64x1ScalarCacheSynchronizer;
import org.vcssl.nano.vm.memory.DataContainer;

public class Int64VectorScalarTransferUnit
extends AcceleratorExecutionUnit {
    @Override
    public AcceleratorExecutionNode generateNode(AcceleratorInstruction acceleratorInstruction, DataContainer<?>[] dataContainerArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3, AcceleratorExecutionNode acceleratorExecutionNode) {
        Int64VectorScalarFillNode int64VectorScalarFillNode = null;
        switch (acceleratorInstruction.getOperationCode()) {
            case FILL: {
                Int64x1ScalarCacheSynchronizer int64x1ScalarCacheSynchronizer = new Int64x1ScalarCacheSynchronizer(dataContainerArray, objectArray, blArray, 1);
                int64VectorScalarFillNode = new Int64VectorScalarFillNode(dataContainerArray[0], dataContainerArray[1], int64x1ScalarCacheSynchronizer, acceleratorExecutionNode);
                break;
            }
            default: {
                throw new VnanoFatalException("Operation code " + (Object)((Object)acceleratorInstruction.getOperationCode()) + " is invalid for " + this.getClass().getCanonicalName());
            }
        }
        return int64VectorScalarFillNode;
    }

    private final class Int64VectorScalarFillNode
    extends AcceleratorExecutionNode {
        protected final DataContainer<long[]> container0;
        protected final DataContainer<long[]> container1;
        protected final Int64x1ScalarCacheSynchronizer synchronizer;

        public Int64VectorScalarFillNode(DataContainer<long[]> dataContainer, DataContainer<long[]> dataContainer2, Int64x1ScalarCacheSynchronizer int64x1ScalarCacheSynchronizer, AcceleratorExecutionNode acceleratorExecutionNode) {
            super(acceleratorExecutionNode, 1);
            this.container0 = dataContainer;
            this.container1 = dataContainer2;
            this.synchronizer = int64x1ScalarCacheSynchronizer;
        }

        @Override
        public final AcceleratorExecutionNode execute() {
            this.synchronizer.synchronizeFromCacheToMemory();
            long l = this.container1.getArrayData()[this.container1.getArrayOffset()];
            int n = this.container0.getArrayOffset();
            int n2 = n + this.container0.getArraySize();
            Arrays.fill(this.container0.getArrayData(), n, n2, l);
            this.synchronizer.synchronizeFromMemoryToCache();
            return this.nextNode;
        }
    }
}

