/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.memory;

import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.vm.memory.DataContainer;

public class DataContainerTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() {
        this.testDefaultState(new DataContainer());
        this.testInitialize();
        this.testSetGetArrayData();
        this.testGetArrayOffset();
        this.testGetArrayLengths();
        this.testGetArrayRank();
        this.testSetGetFloat64ScalarData();
        this.testSetGetInt64ScalarData();
        this.testSetGetBoolScalarData();
        this.testSetGetStringScalarData();
        this.testGetDataType();
    }

    private void testDefaultState(DataContainer<?> container) {
        if (container.getArrayData() != null) {
            Assert.fail((String)"Incorrect data");
        }
        if (container.getArraySize() != 1) {
            Assert.fail((String)"Incorrect size");
        }
        if (container.getArrayRank() != 0 || container.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect rank");
        }
        if (container.getArrayOffset() != 0) {
            Assert.fail((String)"Incorrect offset");
        }
        if (container.getDataType() != DataType.VOID) {
            Assert.fail((String)"Incorrect data type");
        }
    }

    private void testInitialize() {
        DataContainer<long[]> container = new DataContainer<long[]>();
        int[] lengths = new int[]{5};
        container.setArrayData(new long[4], 0, lengths);
        container.initialize();
        this.testDefaultState(container);
        container = new DataContainer();
        int offset = 1;
        container.setArrayData(new long[4], offset, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        container.initialize();
        this.testDefaultState(container);
    }

    private void testSetGetArrayData() {
        DataContainer<long[]> container = new DataContainer<long[]>();
        long[] data = new long[]{1L, 2L, 3L};
        container.setArrayData(data, 0, new int[]{3});
        if (container.getArrayData() != data) {
            Assert.fail((String)"Incorrect data");
        }
        DataContainer<long[]> refContainer = new DataContainer<long[]>();
        refContainer.refer(container);
        if (refContainer.getArrayData() != data) {
            Assert.fail((String)"Incorrect data");
        }
        long[] newData = new long[]{4L, 5L, 6L};
        refContainer.setArrayData(newData, 0, new int[]{3});
        if (refContainer.getArrayData() != newData) {
            Assert.fail((String)"Incorrect data");
        }
        if (container.getArrayData() != newData) {
            Assert.fail((String)"Incorrect data");
        }
    }

    private void testGetArrayOffset() {
        DataContainer<long[]> container = new DataContainer<long[]>();
        int offset = 3;
        container.setArrayData(new long[5], offset, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        if (container.getArrayOffset() != offset) {
            Assert.fail((String)"Incorrect offset");
        }
        DataContainer<long[]> refContainer = new DataContainer<long[]>();
        refContainer.refer(container);
        if (refContainer.getArrayOffset() != offset) {
            Assert.fail((String)"Incorrect offset");
        }
        refContainer.setArrayData(new long[5], 4, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        int newOffset = 4;
        if (refContainer.getArrayOffset() != newOffset) {
            Assert.fail((String)"Incorrect offset");
        }
        if (container.getArrayOffset() != newOffset) {
            Assert.fail((String)"Incorrect offset");
        }
    }

    private void testGetArrayLengths() {
        int[] lengths = new int[]{1, 2, 3};
        DataContainer<long[]> container = new DataContainer<long[]>();
        container.setArrayData(new long[]{1L, 2L, 3L, 4L, 5L, 6L}, 0, lengths);
        if (container.getArrayLengths().length != 3 || container.getArrayLengths()[0] != 1 || container.getArrayLengths()[1] != 2 || container.getArrayLengths()[2] != 3) {
            Assert.fail((String)"Incorrect lengths");
        }
        DataContainer<long[]> refContainer = new DataContainer<long[]>();
        refContainer.refer(container);
        if (refContainer.getArrayLengths() != lengths) {
            Assert.fail((String)"Incorrect lengths");
        }
        int[] newLengths = new int[]{3, 2, 1};
        refContainer.setArrayData(new long[]{1L, 2L, 3L, 4L, 5L, 6L}, 0, newLengths);
        if (refContainer.getArrayLengths() != newLengths) {
            Assert.fail((String)"Incorrect lengths");
        }
        if (container.getArrayLengths() != newLengths) {
            Assert.fail((String)"Incorrect lengths");
        }
    }

    private void testGetArrayRank() {
        int[] lengths = new int[]{1, 2, 3};
        int rank = lengths.length;
        DataContainer<long[]> container = new DataContainer<long[]>();
        container.setArrayData(new long[]{1L, 2L, 3L, 4L, 5L, 6L}, 0, lengths);
        if (container.getArrayRank() != rank) {
            Assert.fail((String)"Incorrect rank");
        }
        DataContainer<long[]> refContainer = new DataContainer<long[]>();
        refContainer.refer(container);
        if (refContainer.getArrayRank() != rank) {
            Assert.fail((String)"Incorrect rank");
        }
        int[] newLengths = new int[]{1, 2, 3, 1};
        int newRank = newLengths.length;
        refContainer.setArrayData(new long[]{1L, 2L, 3L, 4L, 5L, 6L}, 0, newLengths);
        if (refContainer.getArrayRank() != newRank) {
            Assert.fail((String)"Incorrect rank");
        }
        if (container.getArrayRank() != newRank) {
            Assert.fail((String)"Incorrect rank");
        }
    }

    private void testSetGetFloat64ScalarData() {
        DataContainer container = new DataContainer();
        try {
            container.getFloat64ScalarData();
            Assert.fail((String)"Expected exception did not occurred");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        container.setFloat64ScalarData(1.25);
        Assert.assertTrue((1.25 == container.getFloat64ScalarData() ? 1 : 0) != 0);
        container.setFloat64ScalarData(2.5);
        Assert.assertTrue((2.5 == container.getFloat64ScalarData() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)container.getArrayRank());
        Assert.assertTrue((boolean)Arrays.equals(DataContainer.ARRAY_LENGTHS_OF_SCALAR, container.getArrayLengths()));
        Assert.assertEquals((long)0L, (long)container.getArrayOffset());
        DataContainer container2 = new DataContainer();
        container2.setInt64ScalarData(123L);
        try {
            container2.setFloat64ScalarData(1.25);
            Assert.fail((String)"Expected exception did not occurred");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    private void testSetGetInt64ScalarData() {
        DataContainer container = new DataContainer();
        try {
            container.getFloat64ScalarData();
            Assert.fail((String)"Expected exception did not occurred");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        container.setInt64ScalarData(123L);
        Assert.assertEquals((long)123L, (long)container.getInt64ScalarData());
        container.setInt64ScalarData(456L);
        Assert.assertEquals((long)456L, (long)container.getInt64ScalarData());
        Assert.assertEquals((long)0L, (long)container.getArrayRank());
        Assert.assertTrue((boolean)Arrays.equals(DataContainer.ARRAY_LENGTHS_OF_SCALAR, container.getArrayLengths()));
        Assert.assertEquals((long)0L, (long)container.getArrayOffset());
        DataContainer container2 = new DataContainer();
        container2.setFloat64ScalarData(1.25);
        try {
            container2.setInt64ScalarData(123L);
            Assert.fail((String)"Expected exception did not occurred");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    private void testSetGetBoolScalarData() {
        DataContainer container = new DataContainer();
        try {
            container.getFloat64ScalarData();
            Assert.fail((String)"Expected exception did not occurred");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        container.setBoolScalarData(true);
        Assert.assertTrue((boolean)container.getBoolScalarData());
        container.setBoolScalarData(false);
        Assert.assertFalse((boolean)container.getBoolScalarData());
        Assert.assertEquals((long)0L, (long)container.getArrayRank());
        Assert.assertTrue((boolean)Arrays.equals(DataContainer.ARRAY_LENGTHS_OF_SCALAR, container.getArrayLengths()));
        Assert.assertEquals((long)0L, (long)container.getArrayOffset());
        DataContainer container2 = new DataContainer();
        container2.setFloat64ScalarData(123.0);
        try {
            container2.setBoolScalarData(true);
            Assert.fail((String)"Expected exception did not occurred");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    private void testSetGetStringScalarData() {
        DataContainer container = new DataContainer();
        try {
            container.getStringScalarData();
            Assert.fail((String)"Expected exception did not occurred");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
        container.setStringScalarData("aiueo");
        Assert.assertEquals((Object)"aiueo", (Object)container.getStringScalarData());
        container.setStringScalarData("kakikukeko");
        Assert.assertEquals((Object)"kakikukeko", (Object)container.getStringScalarData());
        Assert.assertEquals((long)0L, (long)container.getArrayRank());
        Assert.assertTrue((boolean)Arrays.equals(DataContainer.ARRAY_LENGTHS_OF_SCALAR, container.getArrayLengths()));
        Assert.assertEquals((long)0L, (long)container.getArrayOffset());
        DataContainer container2 = new DataContainer();
        container2.setFloat64ScalarData(123.0);
        try {
            container2.setStringScalarData("aiueo");
            Assert.fail((String)"Expected exception did not occurred");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    private void testGetDataType() {
        DataContainer<Object[]> container = new DataContainer<Object[]>();
        DataContainer<Object[]> refContainer = new DataContainer<Object[]>();
        if (container.getDataType() != DataType.VOID) {
            Assert.fail((String)"Incorrect data type");
        }
        refContainer.refer(container);
        if (refContainer.getDataType() != DataType.VOID) {
            Assert.fail((String)"Incorrect data type");
        }
        container.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        if (container.getDataType() != DataType.INT64) {
            Assert.fail((String)"Incorrect data type");
        }
        refContainer.refer(container);
        if (refContainer.getDataType() != DataType.INT64) {
            Assert.fail((String)"Incorrect data type");
        }
        container.setArrayData(new double[]{1.0}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        if (container.getDataType() != DataType.FLOAT64) {
            Assert.fail((String)"Incorrect data type");
        }
        refContainer.refer(container);
        if (refContainer.getDataType() != DataType.FLOAT64) {
            Assert.fail((String)"Incorrect data type");
        }
        container.setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        if (container.getDataType() != DataType.BOOL) {
            Assert.fail((String)"Incorrect data type");
        }
        refContainer.refer(container);
        if (refContainer.getDataType() != DataType.BOOL) {
            Assert.fail((String)"Incorrect data type");
        }
        container.setArrayData(new String[]{"Hello"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        if (container.getDataType() != DataType.STRING) {
            Assert.fail((String)"Incorrect data type");
        }
        refContainer.refer(container);
        if (refContainer.getDataType() != DataType.STRING) {
            Assert.fail((String)"Incorrect data type");
        }
        container.setArrayData(null, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        if (container.getDataType() != DataType.VOID) {
            Assert.fail((String)"Incorrect data type");
        }
        refContainer.refer(container);
        if (refContainer.getDataType() != DataType.VOID) {
            Assert.fail((String)"Incorrect data type");
        }
    }
}

