/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.memory;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;

public class MemoryTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() {
        this.testGetSize(Memory.Partition.REGISTER);
        this.testGetSize(Memory.Partition.LOCAL);
        this.testGetSize(Memory.Partition.GLOBAL);
        this.testGetSize(Memory.Partition.CONSTANT);
        this.testSetGetDataContainer(Memory.Partition.REGISTER);
        this.testSetGetDataContainer(Memory.Partition.LOCAL);
        this.testSetGetDataContainer(Memory.Partition.GLOBAL);
        this.testSetGetDataContainer(Memory.Partition.CONSTANT);
        this.testSetGetDataContainers(Memory.Partition.REGISTER);
        this.testSetGetDataContainers(Memory.Partition.LOCAL);
        this.testSetGetDataContainers(Memory.Partition.GLOBAL);
        this.testSetGetDataContainers(Memory.Partition.CONSTANT);
    }

    private void testGetSize(Memory.Partition partition) {
        Memory memory = new Memory();
        if (memory.getSize(partition) != 0) {
            Assert.fail((String)"Incorrect value");
        }
        memory.setDataContainer(partition, 255, new DataContainer());
        if (memory.getSize(partition) != 256) {
            Assert.fail((String)"Incorrect value");
        }
        memory.setDataContainer(partition, 100, new DataContainer());
        if (memory.getSize(partition) != 256) {
            Assert.fail((String)"Incorrect value");
        }
        memory.setDataContainer(partition, 1000, new DataContainer());
        if (memory.getSize(partition) != 1001) {
            Assert.fail((String)"Incorrect value");
        }
    }

    private void testSetGetDataContainer(Memory.Partition partition) {
        Memory memory = new Memory();
        DataContainer containerA = new DataContainer();
        DataContainer containerB = new DataContainer();
        DataContainer containerC = new DataContainer();
        DataContainer containerD = new DataContainer();
        memory.setDataContainer(partition, 8, containerA);
        try {
            if (containerA != memory.getDataContainer(partition, 8)) {
                Assert.fail((String)"Incorrect container");
            }
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        memory.setDataContainer(partition, 2, containerB);
        try {
            if (containerB != memory.getDataContainer(partition, 2)) {
                Assert.fail((String)"Incorrect container");
            }
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        memory.setDataContainer(partition, 1000, containerC);
        try {
            if (containerC != memory.getDataContainer(partition, 1000)) {
                Assert.fail((String)"Incorrect container");
            }
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        memory.setDataContainer(partition, 1001, containerD);
        try {
            if (containerD != memory.getDataContainer(partition, 1001)) {
                Assert.fail((String)"Incorrect container");
            }
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        try {
            if (containerA != memory.getDataContainer(partition, 8) || containerB != memory.getDataContainer(partition, 2) || containerC != memory.getDataContainer(partition, 1000)) {
                Assert.fail((String)"Incorrect container");
            }
        }
        catch (VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occured");
        }
        try {
            DataContainer<?> c = memory.getDataContainer(partition, 2000);
            Assert.fail((String)"Expected exception did not occured");
        }
        catch (VnanoFatalException vnanoFatalException) {
            // empty catch block
        }
    }

    private void testSetGetDataContainers(Memory.Partition partition) {
        DataContainer[] beforeContainers = new DataContainer[]{new DataContainer(), new DataContainer(), new DataContainer(), new DataContainer(), new DataContainer()};
        Memory memory = new Memory();
        memory.setDataContainers(partition, beforeContainers);
        DataContainer<?>[] afterContainers = memory.getDataContainers(partition);
        if (beforeContainers[0] != afterContainers[0] || beforeContainers[1] != afterContainers[1] || beforeContainers[2] != afterContainers[2] || beforeContainers[3] != afterContainers[3] || beforeContainers[4] != afterContainers[4]) {
            Assert.fail((String)"Incorrect container");
        }
    }
}

