/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.processor;

import java.lang.reflect.Method;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.VnanoFatalException;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.DispatchUnit;
import org.vcssl.nano.vm.processor.ExecutionUnit;
import org.vcssl.nano.vm.processor.Instruction;

public class DispatchUnitTest {
    private Memory memory;
    private DataContainer<long[]> int64Output;
    private DataContainer<long[]> int64InputA;
    private DataContainer<long[]> int64InputB;
    private DataContainer<boolean[]> boolOutput;
    private DataContainer<boolean[]> boolInputA;
    private DataContainer<boolean[]> boolInputB;
    private static final int INT64_OUTPUT_ADDR = 1;
    private static final int INT64_INPUT_A_ADDR = 2;
    private static final int INT64_INPUT_B_ADDR = 3;
    private static final int BOOL_OUTPUT_ADDR = 101;
    private static final int BOOL_INPUT_A_ADDR = 102;
    private static final int BOOL_INPUT_B_ADDR = 103;
    private static final int TMP_A_ADDR = 1001;
    private static final int TMP_B_ADDR = 1002;
    private static final int TMP_C_ADDR = 1003;
    private static final int TMP_D_ADDR = 1004;
    private static final int META_ADDR = 0;
    private static final Memory.Partition INT64_OUTPUT_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition INT64_INPUT_A_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition INT64_INPUT_B_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition BOOL_OUTPUT_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition BOOL_INPUT_A_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition BOOL_INPUT_B_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition TMP_A_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition TMP_B_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition TMP_C_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition TMP_D_PART = Memory.Partition.REGISTER;
    private static final Memory.Partition META_PART = Memory.Partition.CONSTANT;
    private static final DataType[] INT64_TYPE = new DataType[]{DataType.INT64};
    private static final DataType[] BOOL_TYPE = new DataType[]{DataType.BOOL};
    private static final DataType[] VOID_TYPE = new DataType[]{DataType.VOID};
    private static final int[] INT64X2_ADDRS = new int[]{1, 2};
    private static final int[] INT64X3_ADDRS = new int[]{1, 2, 3};
    private static final int[] BOOLX1_INT64X2_ADDRS = new int[]{101, 2, 3};
    private static final int[] BOOLX2_ADDRS = new int[]{101, 102};
    private static final int[] BOOLX3_ADDRS = new int[]{101, 102, 103};
    private static final Memory.Partition[] INT64X2_PARTS = new Memory.Partition[]{INT64_OUTPUT_PART, INT64_INPUT_A_PART};
    private static final Memory.Partition[] INT64X3_PARTS = new Memory.Partition[]{INT64_OUTPUT_PART, INT64_INPUT_A_PART, INT64_INPUT_B_PART};
    private static final Memory.Partition[] BOOLX1_INT64X2_PARTS = new Memory.Partition[]{BOOL_OUTPUT_PART, INT64_INPUT_A_PART, INT64_INPUT_B_PART};
    private static final Memory.Partition[] BOOLX2_PARTS = new Memory.Partition[]{BOOL_OUTPUT_PART, BOOL_INPUT_A_PART};
    private static final Memory.Partition[] BOOLX3_PARTS = new Memory.Partition[]{BOOL_OUTPUT_PART, BOOL_INPUT_A_PART, BOOL_INPUT_B_PART};
    private boolean connectedMethodCalled = false;

    @Before
    public void setUp() throws Exception {
        this.int64Output = new DataContainer();
        this.int64InputA = new DataContainer();
        this.int64InputB = new DataContainer();
        this.int64Output.setArrayData(new long[3], 0, new int[]{3});
        this.int64InputA.setArrayData(new long[3], 0, new int[]{3});
        this.int64InputB.setArrayData(new long[3], 0, new int[]{3});
        this.boolOutput = new DataContainer();
        this.boolInputA = new DataContainer();
        this.boolInputB = new DataContainer();
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        this.boolInputA.setArrayData(new boolean[3], 0, new int[]{3});
        this.boolInputB.setArrayData(new boolean[3], 0, new int[]{3});
        this.memory = new Memory();
        this.memory.setDataContainer(INT64_OUTPUT_PART, 1, this.int64Output);
        this.memory.setDataContainer(INT64_INPUT_A_PART, 2, this.int64InputA);
        this.memory.setDataContainer(INT64_INPUT_B_PART, 3, this.int64InputB);
        this.memory.setDataContainer(BOOL_OUTPUT_PART, 101, this.boolOutput);
        this.memory.setDataContainer(BOOL_INPUT_A_PART, 102, this.boolInputA);
        this.memory.setDataContainer(BOOL_INPUT_B_PART, 103, this.boolInputB);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() {
        this.testDispatchAdd();
        this.testDispatchSub();
        this.testDispatchMul();
        this.testDispatchDiv();
        this.testDispatchRem();
        this.testDispatchNeg();
        this.testDispatchEq();
        this.testDispatchNeq();
        this.testDispatchGeq();
        this.testDispatchLeq();
        this.testDispatchGt();
        this.testDispatchLt();
        this.testDispatchAnd();
        this.testDispatchOr();
        this.testDispatchNot();
        this.testDispatchMov();
        this.testDispatchCast();
        this.testDispatchFill();
        this.testDispatchMovelm();
        this.testDispatchRefelm();
        this.testDispatchFree();
        this.testDispatchJmp();
        this.testDispatchJmpn();
        this.testDispatchAllocScalar();
        this.testDispatchAllocArray();
        this.testCallx();
        this.testDispatchNop();
        this.testDispatchLabel();
    }

    private Instruction generateInt64x2Instruction(OperationCode operationCode) {
        return new Instruction(operationCode, INT64_TYPE, INT64X2_PARTS, INT64X2_ADDRS, META_PART, 0);
    }

    private Instruction generateInt64x3Instruction(OperationCode operationCode) {
        return new Instruction(operationCode, INT64_TYPE, INT64X3_PARTS, INT64X3_ADDRS, META_PART, 0);
    }

    private Instruction generateBoolx1Int64x2Instruction(OperationCode operationCode) {
        return new Instruction(operationCode, INT64_TYPE, BOOLX1_INT64X2_PARTS, BOOLX1_INT64X2_ADDRS, META_PART, 0);
    }

    private Instruction generateBoolx3Instruction(OperationCode operationCode) {
        return new Instruction(operationCode, BOOL_TYPE, BOOLX3_PARTS, BOOLX3_ADDRS, META_PART, 0);
    }

    private Instruction generateBoolx2Instruction(OperationCode operationCode) {
        return new Instruction(operationCode, BOOL_TYPE, BOOLX2_PARTS, BOOLX2_ADDRS, META_PART, 0);
    }

    private int dispatch(Instruction instruction, int pc) throws VnanoException, VnanoFatalException {
        return new DispatchUnit().dispatch(instruction, this.memory, new Interconnect(), new ExecutionUnit(), new boolean[1], pc);
    }

    private int dispatch(Instruction instruction, Interconnect interconnect, int pc) throws VnanoException, VnanoFatalException {
        return new DispatchUnit().dispatch(instruction, this.memory, interconnect, new ExecutionUnit(), new boolean[1], pc);
    }

    private void testDispatchAdd() {
        long[] output;
        this.int64InputA.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{4L, 5L, 6L}, 0, new int[]{3});
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        Instruction instruction = this.generateInt64x3Instruction(OperationCode.ADD);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != 5L || output[1] != 7L || output[2] != 9L) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.ADD);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchSub() {
        long[] output;
        this.int64InputA.setArrayData(new long[]{10L, 5L, 3L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{2L, 5L, 7L}, 0, new int[]{3});
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        Instruction instruction = this.generateInt64x3Instruction(OperationCode.SUB);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != 8L || output[1] != 0L || output[2] != -4L) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.SUB);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchMul() {
        long[] output;
        this.int64InputA.setArrayData(new long[]{1L, 2L, 3L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{4L, 5L, 6L}, 0, new int[]{3});
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        Instruction instruction = this.generateInt64x3Instruction(OperationCode.MUL);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != 4L || output[1] != 10L || output[2] != 18L) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.MUL);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchDiv() {
        long[] output;
        this.int64InputA.setArrayData(new long[]{10L, 11L, 100L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{5L, 3L, 20L}, 0, new int[]{3});
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        Instruction instruction = this.generateInt64x3Instruction(OperationCode.DIV);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != 2L || output[1] != 3L || output[2] != 5L) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.DIV);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchRem() {
        long[] output;
        this.int64InputA.setArrayData(new long[]{10L, 11L, 100L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{5L, 3L, 20L}, 0, new int[]{3});
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        Instruction instruction = this.generateInt64x3Instruction(OperationCode.REM);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != 0L || output[1] != 2L || output[2] != 0L) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.REM);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchNeg() {
        long[] output;
        this.int64InputA.setArrayData(new long[]{1L, -2L, 3L}, 0, new int[]{3});
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        Instruction instruction = this.generateInt64x2Instruction(OperationCode.NEG);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != -1L || output[1] != 2L || output[2] != -3L) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x3Instruction(OperationCode.NEG);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchEq() {
        boolean[] output;
        this.int64InputA.setArrayData(new long[]{200L, 500L, 700L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{100L, 500L, 800L}, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx1Int64x2Instruction(OperationCode.EQ);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.boolOutput.getArrayData())[0] || !output[1] || output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.EQ);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchNeq() {
        boolean[] output;
        this.int64InputA.setArrayData(new long[]{200L, 500L, 700L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{100L, 500L, 800L}, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx1Int64x2Instruction(OperationCode.NEQ);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if (!(output = this.boolOutput.getArrayData())[0] || output[1] || !output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.NEQ);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchGeq() {
        boolean[] output;
        this.int64InputA.setArrayData(new long[]{200L, 500L, 700L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{100L, 500L, 800L}, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx1Int64x2Instruction(OperationCode.GEQ);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if (!(output = this.boolOutput.getArrayData())[0] || !output[1] || output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.GEQ);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchLeq() {
        boolean[] output;
        this.int64InputA.setArrayData(new long[]{200L, 500L, 700L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{100L, 500L, 800L}, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx1Int64x2Instruction(OperationCode.LEQ);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.boolOutput.getArrayData())[0] || !output[1] || !output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.LEQ);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchGt() {
        boolean[] output;
        this.int64InputA.setArrayData(new long[]{200L, 500L, 700L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{100L, 500L, 800L}, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx1Int64x2Instruction(OperationCode.GT);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if (!(output = this.boolOutput.getArrayData())[0] || output[1] || output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.GT);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchLt() {
        boolean[] output;
        this.int64InputA.setArrayData(new long[]{200L, 500L, 700L}, 0, new int[]{3});
        this.int64InputB.setArrayData(new long[]{100L, 500L, 800L}, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx1Int64x2Instruction(OperationCode.LT);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.boolOutput.getArrayData())[0] || output[1] || !output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.LT);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchAnd() {
        boolean[] output;
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        blArray[2] = true;
        this.boolInputA.setArrayData(blArray, 0, new int[]{3});
        boolean[] blArray2 = new boolean[3];
        blArray2[2] = true;
        this.boolInputB.setArrayData(blArray2, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx3Instruction(OperationCode.ANDM);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.boolOutput.getArrayData())[0] || output[1] || !output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.ANDM);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchOr() {
        boolean[] output;
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        blArray[2] = true;
        this.boolInputA.setArrayData(blArray, 0, new int[]{3});
        boolean[] blArray2 = new boolean[3];
        blArray2[2] = true;
        this.boolInputB.setArrayData(blArray2, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx3Instruction(OperationCode.ORM);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.boolOutput.getArrayData())[0] || !output[1] || !output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.ORM);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchNot() {
        boolean[] output;
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        this.boolInputA.setArrayData(blArray, 0, new int[]{3});
        this.boolOutput.setArrayData(new boolean[3], 0, new int[]{3});
        Instruction instruction = this.generateBoolx2Instruction(OperationCode.NOT);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if (!(output = this.boolOutput.getArrayData())[0] || output[1] || !output[2]) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x2Instruction(OperationCode.NOT);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchMov() {
        long[] output;
        this.int64InputA.setArrayData(new long[]{11L, 22L, 33L}, 0, new int[]{3});
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        Instruction instruction = this.generateInt64x2Instruction(OperationCode.MOV);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != 11L || output[1] != 22L || output[2] != 33L) {
            Assert.fail((String)"Incorrect output");
        }
        try {
            instruction = this.generateInt64x3Instruction(OperationCode.MOV);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchCast() {
        long[] output;
        DataContainer<double[]> float64Input = new DataContainer<double[]>();
        this.memory.setDataContainer(TMP_A_PART, 1001, float64Input);
        float64Input.setArrayData(new double[]{1.25, 2.25, 3.5}, 0, new int[]{3});
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        Instruction instruction = new Instruction(OperationCode.CAST, new DataType[]{DataType.INT64, DataType.FLOAT64}, new Memory.Partition[]{INT64_OUTPUT_PART, TMP_A_PART}, new int[]{1, 1001}, META_PART, 0);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != 1L || output[1] != 2L || output[2] != 3L) {
            Assert.fail((String)"Incorrect output");
        }
    }

    private void testDispatchFill() {
        long[] output;
        DataContainer<long[]> scalar = new DataContainer<long[]>();
        this.memory.setDataContainer(TMP_A_PART, 1001, scalar);
        this.int64Output.setArrayData(new long[]{-1L, -1L, -1L}, 0, new int[]{3});
        scalar.setArrayData(new long[]{123L}, 0, new int[]{3});
        Instruction instruction = new Instruction(OperationCode.FILL, INT64_TYPE, new Memory.Partition[]{INT64_OUTPUT_PART, TMP_A_PART}, new int[]{1, 1001}, META_PART, 0);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if ((output = this.int64Output.getArrayData())[0] != 123L || output[1] != 123L || output[2] != 123L) {
            Assert.fail((String)"Incorrect output");
        }
    }

    private void testDispatchMovelm() {
        DataContainer<long[]> element = new DataContainer<long[]>();
        DataContainer<long[]> index = new DataContainer<long[]>();
        this.memory.setDataContainer(TMP_A_PART, 1001, element);
        this.memory.setDataContainer(TMP_B_PART, 1002, index);
        this.int64InputA.setArrayData(new long[]{11L, 22L, 33L}, 0, new int[]{3});
        index.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        element.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Instruction instruction = new Instruction(OperationCode.MOVELM, INT64_TYPE, new Memory.Partition[]{TMP_A_PART, INT64_INPUT_A_PART, TMP_B_PART}, new int[]{1001, 2, 1002}, META_PART, 0);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if (((long[])element.getArrayData())[element.getArrayOffset()] != 22L) {
            Assert.fail((String)"Incorrect output");
        }
    }

    private void testDispatchRefelm() {
        DataContainer<long[]> element = new DataContainer<long[]>();
        DataContainer<long[]> index = new DataContainer<long[]>();
        this.memory.setDataContainer(TMP_A_PART, 1001, element);
        this.memory.setDataContainer(TMP_B_PART, 1002, index);
        this.int64InputA.setArrayData(new long[]{11L, 22L, 33L}, 0, new int[]{3});
        index.setArrayData(new long[]{1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        element.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Instruction instruction = new Instruction(OperationCode.REFELM, INT64_TYPE, new Memory.Partition[]{TMP_A_PART, INT64_INPUT_A_PART, TMP_B_PART}, new int[]{1001, 2, 1002}, META_PART, 0);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if (((long[])element.getArrayData())[element.getArrayOffset()] != 22L) {
            Assert.fail((String)"Incorrect output");
        }
    }

    private void testDispatchFree() {
        DataContainer<long[]> target = new DataContainer<long[]>();
        int[] targetLengths = new int[]{4};
        this.memory.setDataContainer(TMP_A_PART, 1001, target);
        long[] data = new long[]{1L, 2L, 3L, 4L, 5L};
        target.setArrayData(data, 0, targetLengths);
        Instruction instruction = new Instruction(OperationCode.FREE, INT64_TYPE, new Memory.Partition[]{TMP_A_PART}, new int[]{1001}, META_PART, 0);
        if (target.getArrayData() != data || target.getArrayOffset() != 0 || target.getArraySize() != 4 || target.getArrayLengths()[0] != 4) {
            Assert.fail((String)"Incorrect output");
        }
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        if (target.getArrayData() != null || target.getArraySize() != 1 || target.getArrayLengths().length != 0 || target.getArrayOffset() != 0) {
            Assert.fail((String)"Incorrect output");
        }
    }

    private void testDispatchJmp() {
        DataContainer<boolean[]> condition = new DataContainer<boolean[]>();
        DataContainer<long[]> jumpAddress = new DataContainer<long[]>();
        this.memory.setDataContainer(TMP_A_PART, 1001, jumpAddress);
        this.memory.setDataContainer(TMP_B_PART, 1002, condition);
        condition.setArrayData(new boolean[]{true}, 0, new int[]{3});
        jumpAddress.setArrayData(new long[]{256L}, 0, new int[]{3});
        int[] nArray = new int[3];
        nArray[1] = 1001;
        nArray[2] = 1002;
        Instruction instruction = new Instruction(OperationCode.JMP, BOOL_TYPE, new Memory.Partition[]{Memory.Partition.NONE, TMP_A_PART, TMP_B_PART}, nArray, META_PART, 0);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 256) {
            Assert.fail((String)"Incorrect program counter");
        }
        condition.setArrayData(new boolean[1], 0, new int[]{3});
        programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
    }

    private void testDispatchJmpn() {
        DataContainer<boolean[]> condition = new DataContainer<boolean[]>();
        DataContainer<long[]> jumpAddress = new DataContainer<long[]>();
        this.memory.setDataContainer(TMP_A_PART, 1001, jumpAddress);
        this.memory.setDataContainer(TMP_B_PART, 1002, condition);
        condition.setArrayData(new boolean[]{true}, 0, new int[]{3});
        jumpAddress.setArrayData(new long[]{256L}, 0, new int[]{3});
        int[] nArray = new int[3];
        nArray[1] = 1001;
        nArray[2] = 1002;
        Instruction instruction = new Instruction(OperationCode.JMPN, BOOL_TYPE, new Memory.Partition[]{Memory.Partition.NONE, TMP_A_PART, TMP_B_PART}, nArray, META_PART, 0);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        condition.setArrayData(new boolean[1], 0, new int[]{3});
        programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 256) {
            Assert.fail((String)"Incorrect program counter");
        }
    }

    private void testDispatchAllocScalar() {
        long[] targetData;
        DataContainer target = new DataContainer();
        this.memory.setDataContainer(TMP_A_PART, 1001, target);
        Instruction instruction = new Instruction(OperationCode.ALLOC, INT64_TYPE, new Memory.Partition[]{TMP_A_PART}, new int[]{1001}, META_PART, 0);
        int programCounter = 10;
        this.connectedMethodCalled = false;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (!(target.getArrayData() instanceof long[])) {
            Assert.fail((String)"Incorrect type of data");
        }
        if (target.getArraySize() != 1) {
            Assert.fail((String)"Incorrect size");
        }
        if (target.getArrayRank() != 0) {
            Assert.fail((String)"Incorrect rank");
        }
        if (target.getArrayLengths().length != 0) {
            Assert.fail((String)"Incorrect lengths");
        }
        if ((targetData = (long[])target.getArrayData()).length <= 0 || target.getArraySize() + target.getArrayOffset() > targetData.length) {
            Assert.fail((String)"Incorrect length of data");
        }
    }

    private void testDispatchAllocArray() {
        long[] targetData;
        DataContainer target = new DataContainer();
        DataContainer<long[]> len0 = new DataContainer<long[]>();
        DataContainer<long[]> len1 = new DataContainer<long[]>();
        DataContainer<long[]> len2 = new DataContainer<long[]>();
        this.memory.setDataContainer(TMP_A_PART, 1001, target);
        this.memory.setDataContainer(TMP_B_PART, 1002, len0);
        this.memory.setDataContainer(TMP_C_PART, 1003, len1);
        this.memory.setDataContainer(TMP_D_PART, 1004, len2);
        len0.setArrayData(new long[]{2L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len1.setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        len2.setArrayData(new long[]{4L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Instruction instruction = new Instruction(OperationCode.ALLOC, INT64_TYPE, new Memory.Partition[]{TMP_A_PART, TMP_B_PART, TMP_C_PART, TMP_D_PART}, new int[]{1001, 1002, 1003, 1004}, META_PART, 0);
        int programCounter = 10;
        this.connectedMethodCalled = false;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (!(target.getArrayData() instanceof long[])) {
            Assert.fail((String)"Incorrect type of instance");
        }
        if (target.getArraySize() != 24) {
            Assert.fail((String)"Incorrect size");
        }
        if (target.getArrayRank() != 3) {
            Assert.fail((String)"Incorrect rank");
        }
        if (target.getArrayLengths()[0] != 2 || (long)target.getArrayLengths()[1] != 3L || (long)target.getArrayLengths()[2] != 4L) {
            Assert.fail((String)"Incorrect lengths");
        }
        if ((targetData = (long[])target.getArrayData()).length <= 0 || target.getArraySize() + target.getArrayOffset() > targetData.length) {
            Assert.fail((String)"Incorrect actual length of data");
        }
    }

    public long methodToConnect(long a, long b) {
        this.connectedMethodCalled = true;
        return a + b;
    }

    private void testCallx() {
        Method method = null;
        try {
            method = this.getClass().getMethod("methodToConnect", Long.TYPE, Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            Assert.fail((String)"Reflection failed");
        }
        Interconnect interconnect = new Interconnect();
        try {
            interconnect.connectPlugin("___VNANO_AUTO_KEY", new Object[]{method, this});
        }
        catch (VnanoException e) {
            Assert.fail((String)"Connection failed");
        }
        DataContainer<long[]> argA = new DataContainer<long[]>();
        DataContainer<long[]> argB = new DataContainer<long[]>();
        DataContainer<long[]> ret = new DataContainer<long[]>();
        DataContainer<long[]> functionAddressContainer = new DataContainer<long[]>();
        this.memory.setDataContainer(TMP_A_PART, 1001, argA);
        this.memory.setDataContainer(TMP_B_PART, 1002, argB);
        this.memory.setDataContainer(TMP_C_PART, 1003, ret);
        this.memory.setDataContainer(TMP_D_PART, 1004, functionAddressContainer);
        argA.setArrayData(new long[]{123L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        argB.setArrayData(new long[]{456L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        ret.setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        int functionAddress = 0;
        functionAddressContainer.setArrayData(new long[]{functionAddress}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Instruction instruction = new Instruction(OperationCode.CALLX, INT64_TYPE, new Memory.Partition[]{TMP_C_PART, TMP_D_PART, TMP_A_PART, TMP_B_PART}, new int[]{1003, 1004, 1001, 1002}, META_PART, 0);
        int programCounter = 10;
        this.connectedMethodCalled = false;
        try {
            programCounter = this.dispatch(instruction, interconnect, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (!this.connectedMethodCalled) {
            Assert.fail((String)"Method did not called");
        }
        if (((long[])ret.getArrayData())[0] != 579L) {
            Assert.fail((String)"Incorrect returned value");
        }
    }

    private void testDispatchNop() {
        Instruction instruction = new Instruction(OperationCode.NOP, VOID_TYPE, new Memory.Partition[]{Memory.Partition.NONE}, new int[1], META_PART, 0);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        try {
            instruction = this.generateInt64x3Instruction(OperationCode.NOP);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }

    private void testDispatchLabel() {
        Instruction instruction = new Instruction(OperationCode.LABEL, VOID_TYPE, new Memory.Partition[]{Memory.Partition.NONE}, new int[1], META_PART, 0);
        int programCounter = 10;
        try {
            programCounter = this.dispatch(instruction, programCounter);
        }
        catch (VnanoException | VnanoFatalException e) {
            e.printStackTrace();
            Assert.fail((String)"Expected exception has not occurred");
        }
        if (programCounter != 11) {
            Assert.fail((String)"Incorrect program counter");
        }
        try {
            instruction = this.generateInt64x3Instruction(OperationCode.LABEL);
            programCounter = this.dispatch(instruction, programCounter);
            Assert.fail((String)"Expected exception has not occurred");
        }
        catch (VnanoException | VnanoFatalException exception) {
            // empty catch block
        }
    }
}

