/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.nano.vm.processor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcssl.nano.VnanoException;
import org.vcssl.nano.interconnect.Interconnect;
import org.vcssl.nano.spec.DataType;
import org.vcssl.nano.spec.OperationCode;
import org.vcssl.nano.spec.OptionValue;
import org.vcssl.nano.vm.memory.DataContainer;
import org.vcssl.nano.vm.memory.Memory;
import org.vcssl.nano.vm.processor.Instruction;
import org.vcssl.nano.vm.processor.Processor;

public class ProcessorTest {
    private static final int REGISTER_N = 200;
    private Interconnect interconnect;
    private Memory memory;
    private DataContainer<?>[] registers;
    private static final int META_ADDR = 888;
    private static final Memory.Partition META_PART = Memory.Partition.CONSTANT;
    private boolean connectedMethodCalled = false;

    public long methodToConnect(long a, long b) {
        this.connectedMethodCalled = true;
        return a + b;
    }

    @Before
    public void setUp() throws Exception {
        this.interconnect = new Interconnect();
        this.memory = new Memory();
        this.registers = new DataContainer[200];
        int addr = 0;
        while (addr < 200) {
            this.registers[addr] = new DataContainer();
            this.memory.setDataContainer(Memory.Partition.REGISTER, addr, this.registers[addr]);
            ++addr;
        }
        DataContainer<String[]> metaContainer = new DataContainer<String[]>();
        metaContainer.setArrayData(new String[]{"meta"}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.memory.setDataContainer(META_PART, 888, metaContainer);
        Map<String, Object> optionMap = new LinkedHashMap<String, Object>();
        optionMap = OptionValue.normalizeValuesOf(optionMap);
        this.interconnect.setOptionMap(optionMap);
    }

    @After
    public void tearDown() throws Exception {
    }

    private void initializeRegisters() {
        DataContainer<?>[] dataContainerArray = this.registers;
        int n = this.registers.length;
        int n2 = 0;
        while (n2 < n) {
            DataContainer<?> register = dataContainerArray[n2];
            register.initialize();
            ++n2;
        }
    }

    private Instruction generateInstruction(OperationCode operationCode, DataType dataType, int ... addresses) {
        int operandLength = addresses.length;
        Memory.Partition[] partitions = new Memory.Partition[operandLength];
        Arrays.fill((Object[])partitions, (Object)Memory.Partition.REGISTER);
        Instruction instruction = new Instruction(operationCode, new DataType[]{dataType}, partitions, addresses, META_PART, 888);
        return instruction;
    }

    @Test
    public void testProcessSingleInstruction() {
        this.initializeRegisters();
        this.registers[0].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[1].setArrayData(new long[]{123L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[2].setArrayData(new long[]{456L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Instruction instruction = this.generateInstruction(OperationCode.ADD, DataType.INT64, 0, 1, 2);
        int programCounter = 10;
        try {
            programCounter = new Processor().process(instruction, this.memory, this.interconnect, programCounter);
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occurred");
        }
        Assert.assertEquals((long)11L, (long)programCounter);
        Assert.assertEquals((long)579L, (long)((long[])this.registers[0].getArrayData())[0]);
    }

    @Test
    public void testProcessSerialInstructions() {
        this.initializeRegisters();
        this.registers[0].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[1].setArrayData(new long[]{123L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[2].setArrayData(new long[]{456L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[3].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[4].setArrayData(new long[]{200L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[5].setArrayData(new long[]{100L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[6].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Instruction[] instructions = new Instruction[]{this.generateInstruction(OperationCode.ADD, DataType.INT64, 0, 1, 2), this.generateInstruction(OperationCode.MOV, DataType.INT64, 3, 0), this.generateInstruction(OperationCode.SUB, DataType.INT64, 0, 4, 5), this.generateInstruction(OperationCode.MOV, DataType.INT64, 6, 0), this.generateInstruction(OperationCode.MUL, DataType.INT64, 0, 3, 6)};
        try {
            new Processor().process(instructions, this.memory, this.interconnect);
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occurred");
        }
        Assert.assertEquals((long)57900L, (long)((long[])this.registers[0].getArrayData())[0]);
    }

    @Test
    public void testProcessBranchedInstructions() {
        this.initializeRegisters();
        this.registers[1].setArrayData(new long[]{111L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[2].setArrayData(new long[]{222L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[3].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[4].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[10].setArrayData(new long[]{3L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Instruction[] instructions = new Instruction[]{this.generateInstruction(OperationCode.MOV, DataType.INT64, 3, 1), this.generateInstruction(OperationCode.JMP, DataType.BOOL, 100, 10, 0), this.generateInstruction(OperationCode.MOV, DataType.INT64, 3, 2), this.generateInstruction(OperationCode.MOV, DataType.INT64, 4, 3)};
        this.registers[0].setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new Processor().process(instructions, this.memory, this.interconnect);
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occurred");
        }
        Assert.assertEquals((long)111L, (long)((long[])this.registers[4].getArrayData())[0]);
        this.registers[0].setArrayData(new boolean[1], 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new Processor().process(instructions, this.memory, this.interconnect);
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occurred");
        }
        Assert.assertEquals((long)222L, (long)((long[])this.registers[4].getArrayData())[0]);
        this.registers[4].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[10].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[0].setArrayData(new boolean[]{true}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        try {
            new Processor().process(instructions, this.memory, this.interconnect);
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occurred");
        }
        Assert.assertEquals((long)-1L, (long)((long[])this.registers[4].getArrayData())[0]);
    }

    @Test
    public void testProcessCallInstructions() {
        this.initializeRegisters();
        this.registers[0].setArrayData(new long[]{-1L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[1].setArrayData(new long[]{123L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        this.registers[2].setArrayData(new long[]{456L}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Interconnect interconnect = new Interconnect();
        try {
            Method method = this.getClass().getMethod("methodToConnect", Long.TYPE, Long.TYPE);
            interconnect.connectPlugin("___VNANO_AUTO_KEY", new Object[]{method, this});
        }
        catch (NoSuchMethodException | SecurityException | VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occurred");
        }
        int functionAddress = 0;
        this.registers[10].setArrayData(new long[]{functionAddress}, 0, DataContainer.ARRAY_LENGTHS_OF_SCALAR);
        Instruction[] instructions = new Instruction[]{this.generateInstruction(OperationCode.CALLX, DataType.INT64, 0, 10, 1, 2)};
        try {
            new Processor().process(instructions, this.memory, interconnect);
        }
        catch (VnanoException e) {
            e.printStackTrace();
            Assert.fail((String)"Unexpected exception occurred");
        }
        Assert.assertEquals((Object)true, (Object)this.connectedMethodCalled);
        Assert.assertEquals((long)579L, (long)((long[])this.registers[0].getArrayData())[0]);
    }
}

