/*
 * Decompiled with CFR 0.152.
 */
package Coder;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import rxvesapi.io.TSVVertexReader;
import rxvesapi.io.TSVVertexWriter;
import rxvesapi.process.ProcessEngineDriveInterface;
import rxvesapi.process.ProcessErrorEvent;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.decode.ProcessCodeEncodeDetector;
import rxvesapi.system.kernel.process.SystemScriptProcess;

public class CoderMainFrame
implements ActionListener,
MenuListener,
ComponentListener,
WindowListener,
TextListener,
MouseListener,
ProcessEngineDriveInterface,
KeyListener,
MouseWheelListener {
    public String version = ScriptProcessor.SCRIPT_VERSION + "." + ScriptProcessor.SCRIPT_REVISION;
    public static String buffPath = "etc/Untitled.vcssl";
    private static String settingFilePath = "etc/VCSSL_Editor.ini";
    public boolean play = false;
    public boolean mouseOnPlayButton = false;
    public boolean ONLINE = false;
    public String ONLINE_PROGRAM_DIRECTORY = ".";
    public SystemScriptProcess shell;
    public File currentDirectory = new File(".");
    public File currentFile = null;
    public String currentFileReplacedPath = null;
    public String currentEncode = "Shift_JIS";
    public boolean currentFileModified = false;
    public JFrame frame;
    public JPanel mainPanel;
    public JPanel underPanel;
    public JPanel explainPanel;
    public JLabel numberLabel;
    public JLabel explainLabel;
    public TextArea textArea;
    public TextArea numberArea;
    public JButton playButton;
    public JLabel driveLabel;
    public Font menuFont;
    public JLabel factoryLogoLabel;
    public Image factoryLogoImage;
    public JMenuBar menuBar;
    public JMenu fileMenu;
    public JMenu settingMenu;
    public JMenu infoMenu;
    public JPopupMenu filePopupMenu;
    public JPopupMenu settingPopupMenu;
    public JPopupMenu infoPopupMenu;
    public boolean menuSelecting = false;
    public JMenuItem openFileMenuItem;
    public JMenuItem saveFileMenuItem;
    public JMenuItem overwriteFileMenuItem;
    public JMenuItem fontUpMenuItem;
    public JMenuItem fontDownMenuItem;
    private ImageIcon playButtonIcon_MouseOut;
    private ImageIcon playButtonIcon_MouseOn;
    private ImageIcon stopButtonIcon_MouseOut;
    private ImageIcon stopButtonIcon_MouseOn;
    private Graphics driveGageGraphics;
    private Image driveGageImage;
    private ImageIcon driveGageIcon;
    private JLabel driveGageLabel;
    private JLabel scriptInfoLabel;
    private JLabel engineInfoLabel;
    public int closeOperation = DISPOSE_ON_CLOSE;
    public static int EXIT_ON_CLOSE = 1;
    public static int DISPOSE_ON_CLOSE = 2;
    public int NUMBER_AREA_WIDTH = 0;
    public Font MAIN_FONT;
    public Font NUMBER_FONT;
    public Font EXPLAIN_FONT;
    public Font DRIVE_FONT;
    public Font SCRIPT_INFO_FONT;
    public Font ENGINE_INFO_FONT;
    public int TITLE_HEIGHT = 0;
    public int X_OFFSET = 10;
    public int Y_OFFSET = 10;
    public int WIDTH_OFFSET = 20;
    public int HEIGHT_OFFSET = 78;
    public int UNDER_PANEL_HEIGHT = 75;
    public int DRIVE_GAGE_WIDTH = 500;
    public int DRIVE_GAGE_HEIGHT = 10;
    public long lastDrive = 0L;
    public boolean GENERATE_FRAME = true;
    double fontSize = 20.0;
    int fontStyle = 0;
    public boolean KEY_PRESSING_CTRL = false;
    private static final String VCSSL_SETTING_FILE = "VCSSL_Setting.ini";
    static final String SETTING_FILE_ENCODING = "Shift_JIS";
    String lineFeedCode = System.getProperty("line.separator");

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public CoderMainFrame() {
        this.systemInit();
        this.componentInit(540, 620);
        this.openFile(new File(buffPath), SETTING_FILE_ENCODING);
    }

    public CoderMainFrame(int n, int n2, boolean bl) {
        this.systemInit();
        this.GENERATE_FRAME = bl;
        this.componentInit(n, n2);
        this.openFile(new File(buffPath), SETTING_FILE_ENCODING);
    }

    public void setCloseOperation(int n) {
        this.closeOperation = n;
    }

    public void setTitleHeight(int n) {
        this.TITLE_HEIGHT = n;
    }

    public void loadSettingFile() {
        try {
            this.loadVCSSLSettingFile();
            if (!new File(settingFilePath).exists()) {
                return;
            }
            TSVVertexReader tSVVertexReader = new TSVVertexReader();
            tSVVertexReader.open(new File(settingFilePath).toURI().toURL(), SETTING_FILE_ENCODING);
            String string = tSVVertexReader.load();
            tSVVertexReader.close();
            tSVVertexReader = null;
            string = string.replaceAll("\r\n", "\n");
            string = string.replaceAll("\r", "\n");
            String[] stringArray = string.split("\n");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                File file;
                String[] stringArray2 = stringArray[i].split("=");
                String string2 = null;
                String string3 = null;
                if (2 <= stringArray2.length) {
                    string2 = stringArray2[0];
                    string3 = stringArray2[1];
                }
                if (3 <= stringArray2.length) {
                    for (int j = 2; j < stringArray2.length; ++j) {
                        string3 = string3 + "=" + stringArray2[j];
                    }
                }
                if (string2.equals("FONT_SIZE")) {
                    try {
                        this.fontSize = Double.parseDouble(string3);
                        this.MAIN_FONT = new Font("Dialog", this.fontStyle, (int)this.fontSize);
                        this.textArea.setFont(this.MAIN_FONT);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!string2.equals("LAST_FILE")) continue;
                if (string3.equals(new File(buffPath).getCanonicalPath()) || !(file = new File(string3)).exists()) continue;
                String[] stringArray3 = new String[]{"\u524d\u56de\u958b\u3044\u3066\u3044\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304d\u307e\u3059\u304b ?", "Do you open a file that was last edited?", "\u3000", "\u3000FILE=" + string3, "\u3000"};
                int n2 = JOptionPane.showConfirmDialog(null, stringArray3, "!", 0);
                if (n2 == 0) {
                    this.openFile(file);
                    continue;
                }
                JOptionPane.showMessageDialog(null, new String[]{"\u524d\u56de\u306e\u8a18\u8ff0\u5185\u5bb9\u3092\u63a7\u3048\u305f\u4e00\u6642\u30d5\u30a1\u30a4\u30eb Untitled.vcssl \u3092\u958b\u304d\u307e\u3059\u3002", "Open the temporary file: Untitled.vcssl"}, "!", 1);
                this.openFile(new File(buffPath), SETTING_FILE_ENCODING);
            }
            if (this.currentFile == null) {
                this.openFile(new File(buffPath), SETTING_FILE_ENCODING);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveSettingFile() {
        if (this.currentFile == null || this.currentFile.getParentFile() == null || !this.currentFile.getParentFile().exists()) {
            return;
        }
        String string = "";
        String string2 = System.getProperty("line.separator");
        String string3 = "null";
        try {
            if (!this.currentFile.getPath().equals(buffPath)) {
                string3 = this.currentFile.getCanonicalPath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = string + "LAST_FILE=" + string3 + string2;
        string = string + "FONT_SIZE=" + this.fontSize + string2;
        this.stringToFile(settingFilePath, string, SETTING_FILE_ENCODING, false);
    }

    /*
     * Unable to fully structure code
     */
    private void loadVCSSLSettingFile() {
        var1_1 = null;
        var2_2 = null;
        var3_3 = null;
        try {
            var4_4 = new File("VCSSL_Setting.ini");
            try {
                if (!new File("etc").exists() || !new File("etc").isDirectory()) ** GOTO lbl-1000
                if (new File("etc/" + "VCSSL_Setting.ini").exists()) {
                    var4_4 = new File("etc/" + "VCSSL_Setting.ini");
                } else lbl-1000:
                // 2 sources

                {
                    var4_4 = new File("VCSSL_Setting.ini");
                }
            }
            catch (Exception var5_5) {
                return;
            }
            if (!var4_4.exists()) {
                return;
            }
            var1_1 = new FileInputStream(var4_4.getPath());
            var2_2 = new InputStreamReader((InputStream)var1_1, "Shift_JIS");
            var3_3 = new BufferedReader(var2_2);
            var5_6 = null;
            while ((var5_6 = var3_3.readLine()) != null) {
                var6_8 = var5_6.indexOf("=");
                if (0 > var6_8) continue;
                var7_10 = var5_6.substring(0, var6_8);
                var8_12 = var5_6.substring(var6_8 + 1, var5_6.length());
                var9_14 = var8_12.split(";");
                if (!var7_10.equals("STANDARD_OUTPUT") || 1 > var9_14.length || var9_14[0].equals("true")) {
                    // empty if block
                }
                if (!var7_10.equals("FULL_SCREEN") || 1 > var9_14.length || var9_14[0].equals("true")) {
                    // empty if block
                }
                if (!var7_10.equals("IGNORE_COMPATIBILITY_WARNINGS") || 1 > var9_14.length || var9_14[0].equals("true")) {
                    // empty if block
                }
                if (!var7_10.equals("PROGRAM") || !(var10_15 = new File(var9_14[0])).exists()) continue;
                this.currentFile = var10_15;
                this.currentFileReplacedPath = this.currentFile.getPath().replaceAll("\\\\", "/");
                this.openFile(this.currentFile);
            }
            var3_3.close();
            var2_2.close();
            var1_1.close();
        }
        catch (Exception var5_7) {
            try {
                var3_3.close();
                var2_2.close();
                var1_1.close();
            }
            catch (Exception var6_9) {
                try {
                    var3_3.close();
                    var2_2.close();
                    var1_1.close();
                }
                catch (Exception var7_11) {
                    try {
                        var3_3.close();
                        var2_2.close();
                        var1_1.close();
                    }
                    catch (Exception var8_13) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void systemInit() {
        this.shell = new SystemScriptProcess();
        this.shell.setCloseOperation(SystemScriptProcess.HIDE_ON_CLOSE);
        this.shell.addProcessEngineDriveInterface(this);
        this.shell.disableReloadMenu();
    }

    public void menuInit() {
        if (this.GENERATE_FRAME) {
            this.menuFont = new Font("Dialog", 1, 20);
            this.menuBar = new JMenuBar();
            this.frame.setJMenuBar(this.menuBar);
            this.fileMenu = new JMenu("File");
            this.fileMenu.setFont(new Font("Dialog", 1, 20));
            this.fileMenu.addMenuListener(this);
            this.fileMenu.setFont(this.menuFont);
            this.menuBar.add(this.fileMenu);
            this.filePopupMenu = new JPopupMenu();
            this.filePopupMenu.addMouseListener(this);
            this.filePopupMenu.setLightWeightPopupEnabled(false);
            this.filePopupMenu.setFont(this.menuFont);
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.openFileMenuItem = new JMenuItem("Open File - \u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f");
            this.openFileMenuItem.setFont(this.menuFont);
            this.openFileMenuItem.addActionListener(this);
            this.saveFileMenuItem = new JMenuItem("Save File - \u4fdd\u5b58");
            this.saveFileMenuItem.setFont(this.menuFont);
            this.saveFileMenuItem.addActionListener(this);
            this.overwriteFileMenuItem = new JMenuItem("Overwrite File - \u4e0a\u66f8\u304d\u4fdd\u5b58");
            this.overwriteFileMenuItem.setFont(this.menuFont);
            this.overwriteFileMenuItem.addActionListener(this);
            this.filePopupMenu.add(this.openFileMenuItem);
            this.filePopupMenu.add(this.saveFileMenuItem);
            this.filePopupMenu.add(this.overwriteFileMenuItem);
            this.settingMenu = new JMenu("Setting");
            this.settingMenu.setFont(new Font("Dialog", 1, 20));
            this.settingMenu.addMenuListener(this);
            this.menuBar.add(this.settingMenu);
            this.settingPopupMenu = new JPopupMenu();
            this.settingPopupMenu.addMouseListener(this);
            this.settingPopupMenu.setLightWeightPopupEnabled(false);
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.fontUpMenuItem = new JMenuItem("Set Larger Font Size - \u6587\u5b57\u3092\u62e1\u5927 (Ctrl + U)");
            this.fontUpMenuItem.setFont(this.menuFont);
            this.fontUpMenuItem.addActionListener(this);
            this.fontDownMenuItem = new JMenuItem("Set Smaller Font Size - \u6587\u5b57\u3092\u7e2e\u5c0f (Ctrl + D)");
            this.fontDownMenuItem.setFont(this.menuFont);
            this.fontDownMenuItem.addActionListener(this);
            this.settingPopupMenu.add(this.fontUpMenuItem);
            this.settingPopupMenu.add(this.fontDownMenuItem);
        }
    }

    public void componentInit(int n, int n2) {
        this.MAIN_FONT = new Font("Dialog", this.fontStyle, (int)this.fontSize);
        this.NUMBER_FONT = new Font("Serif", 1, 16);
        this.EXPLAIN_FONT = new Font("Dialog", 0, 14);
        this.DRIVE_FONT = new Font("Dialog", 0, 11);
        this.SCRIPT_INFO_FONT = new Font("Dialog", 0, 16);
        this.ENGINE_INFO_FONT = new Font("Dialog", 0, 12);
        if (this.GENERATE_FRAME) {
            this.frame = new JFrame();
            this.frame.setTitle("VCSSL Editor - VCSSL " + ScriptProcessor.SCRIPT_VERSION + " REV " + ScriptProcessor.SCRIPT_REVISION);
            this.frame.getContentPane().addMouseListener(this);
            this.frame.getContentPane().setLayout(null);
        } else {
            this.frame = new JFrame();
            this.setBounds(0, 0, 100, 50);
            this.setVisible(true);
            this.setVisible(false);
        }
        this.frame.setDefaultCloseOperation(0);
        this.mainPanel = new JPanel();
        this.mainPanel.setBackground(Color.black);
        this.mainPanel.setLayout(null);
        this.mainPanel.addMouseListener(this);
        if (this.GENERATE_FRAME) {
            this.frame.getContentPane().add(this.mainPanel);
        }
        this.textArea = new TextArea();
        this.textArea.setFont(this.MAIN_FONT);
        this.textArea.setBackground(new Color(50, 50, 50));
        this.textArea.setForeground(new Color(255, 255, 255));
        this.textArea.setBackground(new Color(70, 70, 70));
        this.textArea.setForeground(new Color(255, 255, 255));
        this.textArea.addTextListener(this);
        this.textArea.addMouseListener(this);
        this.textArea.addKeyListener(new ModifyKeyListener());
        this.textArea.addKeyListener(this);
        this.textArea.addMouseWheelListener(this);
        this.mainPanel.add(this.textArea);
        this.underPanel = new JPanel();
        this.underPanel.setBackground(Color.black);
        this.underPanel.setLayout(null);
        this.underPanel.addMouseListener(this);
        this.mainPanel.add(this.underPanel);
        this.explainPanel = new JPanel();
        this.explainPanel.setLayout(null);
        this.explainPanel.setBackground(new Color(180, 180, 180));
        this.explainPanel.addMouseListener(this);
        this.underPanel.add(this.explainPanel);
        this.explainLabel = new JLabel("");
        this.explainLabel.setFont(this.EXPLAIN_FONT);
        this.explainLabel.setBackground(new Color(180, 180, 180));
        this.explainLabel.setForeground(new Color(0, 0, 255));
        this.explainLabel.addMouseListener(this);
        this.explainPanel.add(this.explainLabel);
        this.createPlayButtonIcon();
        this.createStopButtonIcon();
        this.playButton = new JButton(this.playButtonIcon_MouseOut);
        this.playButton.addMouseListener(this);
        this.playButton.setBounds(0, 25, 50, 50);
        this.underPanel.add(this.playButton);
        this.playButton.setVisible(true);
        this.explainLabel.setVisible(true);
        this.underPanel.setVisible(true);
        this.textArea.setVisible(true);
        this.mainPanel.setVisible(true);
        if (this.GENERATE_FRAME) {
            this.frame.setVisible(true);
        }
        this.driveLabel = new JLabel("");
        this.driveLabel.setBackground(Color.black);
        this.driveLabel.setForeground(Color.white);
        this.driveLabel.setBounds(55, 35, 800, 15);
        this.driveLabel.setFont(this.DRIVE_FONT);
        this.driveLabel.addMouseListener(this);
        this.underPanel.add(this.driveLabel);
        this.driveGageImage = this.frame.createImage(this.DRIVE_GAGE_WIDTH, this.DRIVE_GAGE_HEIGHT);
        this.driveGageGraphics = this.driveGageImage.getGraphics();
        this.driveGageIcon = new ImageIcon(this.driveGageImage);
        this.driveGageLabel = new JLabel(this.driveGageIcon);
        this.driveGageLabel.setBounds(55, 25, this.DRIVE_GAGE_WIDTH, this.DRIVE_GAGE_HEIGHT);
        this.driveGageLabel.addMouseListener(this);
        this.underPanel.add(this.driveGageLabel);
        StringBuilder stringBuilder = new StringBuilder().append("VCSSL ");
        this.shell.getProcessor();
        StringBuilder stringBuilder2 = stringBuilder.append(ScriptProcessor.SCRIPT_VERSION).append("   REV ");
        this.shell.getProcessor();
        this.scriptInfoLabel = new JLabel(stringBuilder2.append(ScriptProcessor.SCRIPT_REVISION).toString());
        this.scriptInfoLabel.setFont(this.SCRIPT_INFO_FONT);
        this.scriptInfoLabel.setBackground(Color.black);
        this.scriptInfoLabel.setForeground(Color.white);
        this.scriptInfoLabel.setBounds(55, 50, 500, 30);
        this.scriptInfoLabel.addMouseListener(this);
        this.underPanel.add(this.scriptInfoLabel);
        this.menuInit();
        if (this.GENERATE_FRAME) {
            this.frame.setBounds(0, 0, n, n2);
        }
        this.scriptInfoLabel.repaint();
        this.driveGageLabel.repaint();
        this.driveLabel.repaint();
        this.playButton.repaint();
        this.explainLabel.repaint();
        this.underPanel.repaint();
        this.textArea.repaint();
        this.mainPanel.repaint();
        if (this.GENERATE_FRAME) {
            this.frame.repaint();
            this.frame.addComponentListener(this);
            this.frame.addWindowListener(this);
        }
        this.resize();
        this.repaintLineCount();
        if (this.GENERATE_FRAME) {
            this.frame.setVisible(false);
            this.frame.setVisible(true);
        }
    }

    public void disposeResource() {
        if (this.shell != null) {
            try {
                this.shell.disposeResource();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.shell = null;
        }
        this.frame.dispose();
        this.frame = null;
        this.mainPanel = null;
        this.textArea = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.GENERATE_FRAME) {
            this.frame.setBounds(n, n2, n3, n4);
            this.resize(n, n2, n3, n4);
        }
    }

    public void repaintComponent() {
        this.underPanel.repaint();
        this.textArea.repaint();
        this.mainPanel.repaint();
    }

    public void resize(int n, int n2, int n3, int n4) {
        this.WIDTH_OFFSET = this.frame.getWidth() - this.frame.getContentPane().getWidth() + 10;
        this.HEIGHT_OFFSET = this.frame.getHeight() - this.frame.getContentPane().getHeight() + 10;
        this.mainPanel.setBounds(0, 0, n3, n4);
        this.textArea.setBounds(this.X_OFFSET + this.NUMBER_AREA_WIDTH, this.Y_OFFSET + this.TITLE_HEIGHT, n3 - this.WIDTH_OFFSET - this.X_OFFSET - this.NUMBER_AREA_WIDTH, n4 - this.HEIGHT_OFFSET - this.Y_OFFSET - this.TITLE_HEIGHT - this.UNDER_PANEL_HEIGHT);
        this.underPanel.setBounds(this.X_OFFSET + this.NUMBER_AREA_WIDTH, (int)((double)(this.Y_OFFSET + this.TITLE_HEIGHT) + this.textArea.getBounds().getHeight()), n3 - this.WIDTH_OFFSET - this.X_OFFSET - this.NUMBER_AREA_WIDTH, this.UNDER_PANEL_HEIGHT);
        this.explainPanel.setBounds(0, 0, n3 - this.WIDTH_OFFSET - this.NUMBER_AREA_WIDTH, 20);
        this.explainLabel.setBounds(0, 0, n3 - this.WIDTH_OFFSET - this.NUMBER_AREA_WIDTH, 18);
        this.driveGageImage = null;
        this.driveGageGraphics.dispose();
        this.DRIVE_GAGE_WIDTH = (int)this.underPanel.getBounds().getWidth() - 55;
        this.driveGageImage = this.frame.createImage(this.DRIVE_GAGE_WIDTH, this.DRIVE_GAGE_HEIGHT);
        this.driveGageGraphics = this.driveGageImage.getGraphics();
        this.driveGageIcon = new ImageIcon(this.driveGageImage);
        this.driveGageLabel.setIcon(this.driveGageIcon);
        this.driveGageLabel.setBounds(55, 25, this.DRIVE_GAGE_WIDTH, this.DRIVE_GAGE_HEIGHT);
        this.resetDriveLabel();
        this.underPanel.repaint();
        this.textArea.repaint();
        this.mainPanel.repaint();
        if (this.GENERATE_FRAME) {
            this.frame.repaint();
        }
    }

    public void resize() {
        if (this.GENERATE_FRAME) {
            int n = (int)this.frame.getBounds().getX();
            int n2 = (int)this.frame.getBounds().getY();
            int n3 = (int)this.frame.getBounds().getWidth();
            int n4 = (int)this.frame.getBounds().getHeight();
            this.resize(n, n2, n3, n4);
        }
    }

    public void setVisible(boolean bl) {
        if (this.GENERATE_FRAME) {
            this.frame.setVisible(bl);
        }
    }

    public void repaintLineCount() {
        try {
            String string = this.textArea.getText().substring(0, this.textArea.getCaretPosition());
            int n = this.getLineCount(string);
            if (this.currentFile != null) {
                this.explainLabel.setText(" LINE = " + n + " / " + this.currentFile.getName());
            }
            this.explainLabel.repaint();
            this.underPanel.repaint();
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getLineCount(String string) {
        String[] stringArray = string.split("\n");
        String[] stringArray2 = string.split("\r");
        String[] stringArray3 = string.split("\n\r");
        String[] stringArray4 = string.split("\r\n");
        String[] stringArray5 = string.split(this.lineFeedCode);
        int n = Math.max(stringArray.length, stringArray2.length);
        n = Math.max(n, stringArray3.length);
        n = Math.max(n, stringArray4.length);
        n = Math.max(n, stringArray5.length);
        return n;
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        this.repaintLineCount();
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        this.filePopupMenu.setVisible(false);
        this.settingPopupMenu.setVisible(false);
        this.infoPopupMenu.setVisible(false);
        this.menuSelecting = false;
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object = menuEvent.getSource();
        if (object == this.fileMenu || object == this.settingMenu || object == this.infoMenu) {
            this.filePopupMenu.setVisible(false);
            this.settingPopupMenu.setVisible(false);
            if (object == this.fileMenu) {
                this.filePopupMenu.show(this.fileMenu, 0, this.fileMenu.getHeight());
            }
            if (object == this.settingMenu) {
                this.settingPopupMenu.show(this.settingMenu, 0, this.settingMenu.getHeight());
            }
            if (object == this.infoMenu) {
                this.infoPopupMenu.show(this.infoMenu, 0, this.infoMenu.getHeight());
            }
            this.menuSelecting = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fontUpMenuItem) {
            this.largeFont();
        }
        if (object == this.fontDownMenuItem) {
            this.smallFont();
        }
        if (object == this.openFileMenuItem || !this.currentFile.exists()) {
            boolean bl;
            String[] stringArray;
            int n;
            if (this.currentFileModified && this.currentFileReplacedPath != null && !this.currentFileReplacedPath.equals(buffPath) && ((n = JOptionPane.showConfirmDialog(this.frame, stringArray = new String[]{"\u73fe\u5728\u958b\u3044\u3066\u3044\u308b\u30d5\u30a1\u30a4\u30eb\u306e\u7de8\u96c6\u5185\u5bb9\u306f\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u4e0a\u66f8\u304d\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f", "The content of the current opening file have not been saved. Do you want to overwrite it?", "\u3000", "FILE = " + this.currentFile.getPath()}, "!", 0)) == 0 ? !(bl = this.overWrite()) : (n = JOptionPane.showConfirmDialog(this.frame, stringArray = new String[]{"\u672c\u5f53\u306b\u4fdd\u5b58\u305b\u305a\u306b\u5225\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304d\u307e\u3059\u304b\uff1f", "Are you sure to open another file without saving?"}, "!", 0)) == 1)) {
                return;
            }
            this.filePopupMenu.setVisible(false);
            this.openFile();
        }
        if (object == this.saveFileMenuItem || !this.currentFile.exists()) {
            this.filePopupMenu.setVisible(false);
            this.saveFile();
        }
        if (object == this.overwriteFileMenuItem) {
            this.filePopupMenu.setVisible(false);
            this.overWrite();
        }
    }

    public void smallFont() {
        this.fontSize -= 1.0;
        if (this.fontSize < 1.0) {
            this.fontSize = 1.0;
        }
        this.MAIN_FONT = new Font("Dialog", this.fontStyle, (int)this.fontSize);
        this.textArea.setFont(this.MAIN_FONT);
    }

    public void largeFont() {
        this.fontSize += 1.0;
        this.MAIN_FONT = new Font("Dialog", this.fontStyle, (int)this.fontSize);
        this.textArea.setFont(this.MAIN_FONT);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            this.KEY_PRESSING_CTRL = true;
            this.explainLabel.setText("STRL+S=SAVE | CTRL+C=COPY | CTRL+X=CUT | CTRL+V=PASTE | CTRL+WHEEL_UP=SMALLFONT | CTRL+WHEEL_DOWN=BIGFONT");
        }
        if (this.KEY_PRESSING_CTRL && keyEvent.getKeyCode() == 83) {
            this.KEY_PRESSING_CTRL = false;
            this.overWrite();
        }
        if (this.KEY_PRESSING_CTRL) {
            if (keyEvent.getKeyCode() == 68) {
                this.smallFont();
            }
            if (keyEvent.getKeyCode() == 85) {
                this.largeFont();
            }
            if (keyEvent.getKeyCode() == 38) {
                this.smallFont();
            }
            if (keyEvent.getKeyCode() == 40) {
                this.largeFont();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            this.KEY_PRESSING_CTRL = false;
            this.repaintLineCount();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.KEY_PRESSING_CTRL) {
            this.fontSize = 0 < mouseWheelEvent.getWheelRotation() ? (this.fontSize /= 1.028) : (this.fontSize *= 1.028);
            if (this.fontSize < 1.0) {
                this.fontSize = 1.0;
            }
            this.MAIN_FONT = new Font("Dialog", this.fontStyle, (int)this.fontSize);
            this.textArea.setFont(this.MAIN_FONT);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (this.GENERATE_FRAME && object != this.fileMenu && object != this.settingMenu && object != this.infoMenu) {
            try {
                this.filePopupMenu.setVisible(false);
                this.settingPopupMenu.setVisible(false);
                this.menuSelecting = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.textArea) {
            this.repaintLineCount();
        }
        if (object == this.playButton) {
            this.playButtonPressed();
        }
    }

    public void playButtonPressed() {
        if (this.play) {
            this.play = false;
            this.playButton.setIcon(this.playButtonIcon_MouseOn);
            this.playButton.repaint();
            this.underPanel.repaint();
            this.mainPanel.repaint();
            this.shell.exit();
            this.resetDriveLabel();
        } else {
            this.play = true;
            this.playButton.setIcon(this.stopButtonIcon_MouseOn);
            this.playButton.repaint();
            this.underPanel.repaint();
            this.mainPanel.repaint();
            if (this.ONLINE) {
                try {
                    System.out.println("[ CODER ] ONLINE DIR = " + this.ONLINE_PROGRAM_DIRECTORY);
                    this.shell.setOnlineProgramDirectory(this.ONLINE_PROGRAM_DIRECTORY);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
            String string = null;
            if (this.currentFile == null) {
                string = ScriptProcessor.getUntitledProgramName();
            } else {
                string = this.currentFile.getName();
                String string2 = this.currentFile.getPath().replaceAll("\\\\", "/");
                if (string2.equals(buffPath)) {
                    string = ScriptProcessor.getUntitledProgramName();
                }
            }
            this.shell.executeProgram(this.textArea.getText(), this.currentDirectory, string);
        }
    }

    @Override
    public String processCodeUpdateRequested() {
        return this.textArea.getText();
    }

    @Override
    public String processFileNameUpdateRequested() {
        return this.currentFile.getName();
    }

    @Override
    public File processCurrentDirectoryUpdateRequested() {
        return this.currentDirectory;
    }

    @Override
    public void processPrint(String string) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.playButton) {
            if (this.play) {
                this.playButton.setIcon(this.stopButtonIcon_MouseOn);
                this.playButton.repaint();
                this.underPanel.repaint();
                this.mainPanel.repaint();
            } else {
                this.playButton.setIcon(this.playButtonIcon_MouseOn);
                this.playButton.repaint();
                this.underPanel.repaint();
                this.mainPanel.repaint();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.playButton) {
            if (this.play) {
                this.playButton.setIcon(this.stopButtonIcon_MouseOut);
                this.playButton.repaint();
                this.underPanel.repaint();
                this.mainPanel.repaint();
            } else {
                this.playButton.setIcon(this.playButtonIcon_MouseOut);
                this.playButton.repaint();
                this.underPanel.repaint();
                this.mainPanel.repaint();
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.resize();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.currentFileModified && this.currentFileReplacedPath != null) {
            if (!this.currentFileReplacedPath.equals(buffPath)) {
                String[] stringArray = new String[]{"\u73fe\u5728\u958b\u3044\u3066\u3044\u308b\u30d5\u30a1\u30a4\u30eb\u306e\u7de8\u96c6\u5185\u5bb9\u306f\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u4e0a\u66f8\u304d\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f", "The content of the current opening file have not been saved. Do you want to overwrite it?", "\u3000", "FILE = " + this.currentFile.getPath()};
                int n = JOptionPane.showConfirmDialog(this.frame, stringArray, "!", 0);
                if (n == 0) {
                    boolean bl = this.overWrite();
                    if (!bl) {
                        return;
                    }
                } else {
                    stringArray = new String[]{"\u672c\u5f53\u306b\u4fdd\u5b58\u305b\u305a\u306b\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f", "Are you sure to exit without saving?"};
                    n = JOptionPane.showConfirmDialog(this.frame, stringArray, "!", 0);
                    if (n == 1) {
                        this.frame.setVisible(true);
                        return;
                    }
                }
            }
        }
        if (!this.ONLINE) {
            try {
                if (buffPath != null) {
                    if (new File(buffPath).exists() && this.textArea.getText() != null) {
                        this.stringToFile(buffPath, this.textArea.getText(), SETTING_FILE_ENCODING, false);
                    }
                }
                this.saveSettingFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.closeOperation == DISPOSE_ON_CLOSE) {
            this.disposeResource();
        }
        if (this.closeOperation == EXIT_ON_CLOSE) {
            this.disposeResource();
            System.exit(0);
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void createPlayButtonIcon() {
        Color color;
        int n;
        int n2;
        int n3;
        this.frame.setVisible(true);
        double d = 1.0;
        int n4 = 10;
        int n5 = 12;
        Image image = this.frame.createImage(50, 50);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 50, 50);
        graphics.setColor(new Color(140, 160, 180));
        for (n3 = 6; n3 <= 22; ++n3) {
            graphics.drawLine(n5, n3, (int)(14.0 + d * (double)(n3 - 7)) + n4, n3);
        }
        for (n3 = 22; n3 <= 27; ++n3) {
            graphics.drawLine(n5, n3, (int)(14.0 + d * 15.0) + n4, n3);
        }
        for (n3 = 27; n3 <= 43; ++n3) {
            graphics.drawLine(n5, n3, (int)(14.0 + d * (double)(15 - (n3 - 27))) + n4, n3);
        }
        for (n3 = 8; n3 <= 22; ++n3) {
            n2 = 200 - (23 - n3) * 20;
            n = 220 - (23 - n3) * 12;
            if (n2 < 0) {
                n2 = 0;
            }
            color = new Color(n2, n, 255);
            graphics.setColor(color);
            graphics.drawLine(n5 + 2, n3, (int)(12.0 + d * (double)(n3 - 7)) + n4, n3);
        }
        for (n3 = 22; n3 <= 27; ++n3) {
            color = new Color(0, 0, 255 - (41 - n3) * 10);
            graphics.setColor(color);
            graphics.drawLine(n5 + 2, n3, (int)(12.0 + d * 15.0) + n4, n3);
        }
        for (n3 = 27; n3 <= 41; ++n3) {
            color = new Color(0, 0, 255 - (41 - n3) * 10);
            graphics.setColor(color);
            graphics.drawLine(n5 + 2, n3, (int)(12.0 + d * (double)(15 - (n3 - 27))) + n4, n3);
        }
        this.playButtonIcon_MouseOut = new ImageIcon(image);
        image = this.frame.createImage(50, 50);
        graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 50, 50);
        graphics.setColor(new Color(140, 160, 180));
        for (n3 = 6; n3 <= 22; ++n3) {
            graphics.drawLine(n5, n3, (int)(14.0 + d * (double)(n3 - 7)) + n4, n3);
        }
        for (n3 = 22; n3 <= 27; ++n3) {
            graphics.drawLine(n5, n3, (int)(14.0 + d * 15.0) + n4, n3);
        }
        for (n3 = 27; n3 <= 43; ++n3) {
            graphics.drawLine(n5, n3, (int)(14.0 + d * (double)(15 - (n3 - 27))) + n4, n3);
        }
        for (n3 = 8; n3 <= 22; ++n3) {
            n2 = 255 - (23 - n3) * 12;
            n = 255 - (23 - n3) * 5;
            if (n2 < 0) {
                n2 = 0;
            }
            color = new Color(n2, n, 255);
            graphics.setColor(color);
            graphics.drawLine(n5 + 2, n3, (int)(12.0 + d * (double)(n3 - 7)) + n4, n3);
        }
        for (n3 = 22; n3 <= 27; ++n3) {
            color = new Color(0, 115, 255);
            graphics.setColor(color);
            graphics.drawLine(n5 + 2, n3, (int)(12.0 + d * 15.0) + n4, n3);
        }
        for (n3 = 27; n3 <= 41; ++n3) {
            color = new Color(0, 255 - (41 - n3) * 10, 255);
            graphics.setColor(color);
            graphics.drawLine(n5 + 2, n3, (int)(12.0 + d * (double)(15 - (n3 - 27))) + n4, n3);
        }
        this.playButtonIcon_MouseOn = new ImageIcon(image);
        graphics.dispose();
        graphics = null;
        this.frame.setVisible(false);
    }

    private void createStopButtonIcon() {
        Color color;
        int n;
        int n2;
        int n3;
        this.frame.setVisible(true);
        Image image = this.frame.createImage(50, 50);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 50, 50);
        double d = 1.0;
        int n4 = 8;
        graphics.setColor(new Color(140, 160, 180));
        graphics.fillRect(8, 6, 11, 37);
        for (n3 = 7; n3 <= 22; ++n3) {
            n2 = 200 - (23 - n3) * 20;
            n = 220 - (23 - n3) * 12;
            if (n2 < 0) {
                n2 = 0;
            }
            color = new Color(n2, n, 255);
            graphics.setColor(color);
            graphics.drawLine(9, n3, 17, n3);
        }
        for (n3 = 22; n3 <= 27; ++n3) {
            color = new Color(0, 0, 255 - (41 - n3) * 10);
            graphics.setColor(color);
            graphics.drawLine(9, n3, 17, n3);
        }
        for (n3 = 27; n3 <= 41; ++n3) {
            color = new Color(0, 0, 255 - (41 - n3) * 10);
            graphics.setColor(color);
            graphics.drawLine(9, n3, 17, n3);
        }
        graphics.setColor(new Color(140, 160, 180));
        graphics.fillRect(30, 6, 11, 37);
        for (n3 = 7; n3 <= 22; ++n3) {
            n2 = 200 - (23 - n3) * 20;
            n = 220 - (23 - n3) * 12;
            if (n2 < 0) {
                n2 = 0;
            }
            color = new Color(n2, n, 255);
            graphics.setColor(color);
            graphics.drawLine(31, n3, 39, n3);
        }
        for (n3 = 22; n3 <= 27; ++n3) {
            color = new Color(0, 0, 255 - (41 - n3) * 10);
            graphics.setColor(color);
            graphics.drawLine(31, n3, 39, n3);
        }
        for (n3 = 27; n3 <= 41; ++n3) {
            color = new Color(0, 0, 255 - (41 - n3) * 10);
            graphics.setColor(color);
            graphics.drawLine(31, n3, 39, n3);
        }
        this.stopButtonIcon_MouseOut = new ImageIcon(image);
        image = this.frame.createImage(50, 50);
        graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 50, 50);
        graphics.setColor(new Color(140, 160, 180));
        graphics.fillRect(8, 6, 11, 37);
        for (n3 = 7; n3 <= 22; ++n3) {
            n2 = 255 - (23 - n3) * 12;
            n = 255 - (23 - n3) * 5;
            if (n2 < 0) {
                n2 = 0;
            }
            color = new Color(n2, n, 255);
            graphics.setColor(color);
            graphics.drawLine(9, n3, 17, n3);
        }
        for (n3 = 22; n3 <= 27; ++n3) {
            color = new Color(0, 115, 255);
            graphics.setColor(color);
            graphics.drawLine(9, n3, 17, n3);
        }
        for (n3 = 27; n3 <= 41; ++n3) {
            color = new Color(0, 255 - (41 - n3) * 10, 255);
            graphics.setColor(color);
            graphics.drawLine(9, n3, 17, n3);
        }
        graphics.setColor(new Color(140, 160, 180));
        graphics.fillRect(30, 6, 11, 37);
        for (n3 = 7; n3 <= 22; ++n3) {
            n2 = 255 - (23 - n3) * 12;
            n = 255 - (23 - n3) * 5;
            if (n2 < 0) {
                n2 = 0;
            }
            color = new Color(n2, n, 255);
            graphics.setColor(color);
            graphics.drawLine(31, n3, 39, n3);
        }
        for (n3 = 22; n3 <= 27; ++n3) {
            color = new Color(0, 115, 255);
            graphics.setColor(color);
            graphics.drawLine(31, n3, 39, n3);
        }
        for (n3 = 27; n3 <= 41; ++n3) {
            color = new Color(0, 255 - (41 - n3) * 10, 255);
            graphics.setColor(color);
            graphics.drawLine(31, n3, 39, n3);
        }
        this.stopButtonIcon_MouseOn = new ImageIcon(image);
        graphics.dispose();
        graphics = null;
        this.frame.setVisible(false);
    }

    public void setDriveLabel(long l) {
        String string = "           RAM   " + this.getMemoryLine();
        if (l != this.lastDrive) {
            if (l > 1000000L) {
                this.driveLabel.setText("DRIVE   " + (float)(0.1 * (double)((int)(l / 100000L))) + " MHz" + string);
            } else if (l > 1000L) {
                this.driveLabel.setText("DRIVE   " + (float)(0.1 * (double)((int)(l / 100L))) + " KHz" + string);
            } else {
                this.driveLabel.setText("DRIVE   " + l + " Hz" + string);
            }
            this.repaintDriveGageLabel(l);
            this.driveLabel.repaint();
            this.underPanel.repaint();
        }
        this.lastDrive = l;
    }

    public void resetDriveLabel() {
        String string = "           RAM   " + this.getMemoryLine();
        this.driveLabel.setText("DRIVE   0 Hz" + string);
        this.repaintDriveGageLabel(0L);
    }

    public String getMemoryLine() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        String string = "";
        string = l3 > 1000000000L ? "" + (float)(0.1 * (double)((int)(l3 / 100000000L))) + " GB" : (l3 > 1000000L ? "" + (float)(0.1 * (double)((int)(l3 / 100000L))) + " MB" : (l3 > 1000L ? "" + (float)(0.1 * (double)((int)(l3 / 100L))) + " KB" : "" + l3 + " B"));
        long l4 = Runtime.getRuntime().maxMemory();
        String string2 = "";
        string2 = l4 > 1000000000L ? "" + (float)(0.1 * (double)((int)(l4 / 100000000L))) + " GB" : (l3 > 1000000L ? "" + (float)(0.1 * (double)((int)(l4 / 100000L))) + " MB" : (l3 > 1000L ? "" + (float)(0.1 * (double)((int)(l4 / 100L))) + " KB" : "" + l4 + " B"));
        return string + "  /  " + string2;
    }

    public void repaintDriveGageLabel(long l) {
        block13: {
            try {
                int n;
                Color color;
                int n2;
                double d = Math.log(l) / Math.log(10.0) / 9.0;
                double d2 = 0.6666666666666666;
                double d3 = 0.6666666666666666;
                for (n2 = 0; n2 < this.DRIVE_GAGE_HEIGHT; ++n2) {
                    color = new Color(0, (12 - n2) * 7, (12 - n2) * 7 + 170);
                    this.driveGageGraphics.setColor(color);
                    this.driveGageGraphics.drawLine(0, n2, this.DRIVE_GAGE_WIDTH, n2);
                }
                for (n2 = 0; n2 < this.DRIVE_GAGE_HEIGHT; ++n2) {
                    for (n = 1; n <= 10; ++n) {
                        color = new Color((12 - n2) * 7 + 40, (12 - n2) * 7 + 40, (12 - n2) * 7 + 40, (int)(255.0 * (0.1 * (double)n)));
                        this.driveGageGraphics.setColor(color);
                        this.driveGageGraphics.drawLine((int)((double)this.DRIVE_GAGE_WIDTH * d3) + (int)((double)this.DRIVE_GAGE_WIDTH * (d2 - d3) * (0.1 * (double)(n - 1))) + 1, n2, (int)((double)this.DRIVE_GAGE_WIDTH * d3) + (int)((double)this.DRIVE_GAGE_WIDTH * (d2 - d3) * (0.1 * (double)n)), n2);
                    }
                }
                for (n2 = 0; n2 < this.DRIVE_GAGE_HEIGHT; ++n2) {
                    color = new Color((12 - n2) * 7 + 40, (12 - n2) * 7 + 40, (12 - n2) * 7 + 40);
                    this.driveGageGraphics.setColor(color);
                    this.driveGageGraphics.drawLine((int)((double)this.DRIVE_GAGE_WIDTH * d2), n2, this.DRIVE_GAGE_WIDTH, n2);
                }
                for (n2 = 0; n2 < this.DRIVE_GAGE_HEIGHT; ++n2) {
                    color = new Color(0, (12 - n2) * 20 + 0, 255);
                    this.driveGageGraphics.setColor(color);
                    this.driveGageGraphics.drawLine(0, n2, (int)((double)this.DRIVE_GAGE_WIDTH * d), n2);
                }
                if (d3 <= d) {
                    for (n2 = 0; n2 < this.DRIVE_GAGE_HEIGHT; ++n2) {
                        for (n = 1; n <= 10; ++n) {
                            color = new Color((12 - n2) * 12 + 100, (12 - n2) * 8, (12 - n2) * 10 + 30, (int)(255.0 * (0.1 * (double)n)));
                            this.driveGageGraphics.setColor(color);
                            this.driveGageGraphics.drawLine((int)((double)this.DRIVE_GAGE_WIDTH * d3) + (int)((double)this.DRIVE_GAGE_WIDTH * (d2 - d3) * (0.1 * (double)(n - 1))) + 1, n2, (int)((double)this.DRIVE_GAGE_WIDTH * d3) + (int)((double)this.DRIVE_GAGE_WIDTH * (d2 - d3) * (0.1 * (double)n)), n2);
                        }
                    }
                }
                if (d2 <= d) {
                    for (n2 = 0; n2 < this.DRIVE_GAGE_HEIGHT; ++n2) {
                        color = new Color((12 - n2) * 12 + 100, (12 - n2) * 8, (12 - n2) * 10 + 30);
                        this.driveGageGraphics.setColor(color);
                        this.driveGageGraphics.drawLine((int)((double)this.DRIVE_GAGE_WIDTH * d2), n2, (int)((double)this.DRIVE_GAGE_WIDTH * d), n2);
                    }
                }
                this.driveGageGraphics.setColor(new Color(140, 140, 255, 120));
                this.driveGageGraphics.drawLine(this.DRIVE_GAGE_WIDTH / 3 - 1, 0, this.DRIVE_GAGE_WIDTH / 3 - 1, this.DRIVE_GAGE_HEIGHT);
                this.driveGageGraphics.drawLine(this.DRIVE_GAGE_WIDTH * 2 / 3 - 1, 0, this.DRIVE_GAGE_WIDTH * 2 / 3 - 1, this.DRIVE_GAGE_HEIGHT);
                this.driveGageGraphics.setColor(new Color(80, 80, 255, 120));
                this.driveGageGraphics.drawLine(this.DRIVE_GAGE_WIDTH / 3, 0, this.DRIVE_GAGE_WIDTH / 3, this.DRIVE_GAGE_HEIGHT);
                this.driveGageGraphics.drawLine(this.DRIVE_GAGE_WIDTH * 2 / 3, 0, this.DRIVE_GAGE_WIDTH * 2 / 3, this.DRIVE_GAGE_HEIGHT);
                this.driveGageLabel.repaint();
            }
            catch (Exception exception) {
                this.frame.setVisible(false);
                this.frame.setVisible(true);
                this.driveGageImage = null;
                if (this.driveGageImage != null) {
                    this.driveGageGraphics.dispose();
                    this.driveGageGraphics = null;
                }
                this.driveGageImage = this.frame.createImage(this.DRIVE_GAGE_WIDTH, this.DRIVE_GAGE_HEIGHT);
                this.driveGageGraphics = this.driveGageImage.getGraphics();
                this.driveGageIcon = new ImageIcon(this.driveGageImage);
                this.driveGageLabel.setIcon(this.driveGageIcon);
                this.resetDriveLabel();
                this.frame.setVisible(false);
                if (!this.GENERATE_FRAME) break block13;
                this.frame.setVisible(true);
            }
        }
    }

    @Override
    public void processEngineDriving(long l) {
        this.setDriveLabel(l);
    }

    @Override
    public void processResetting(URL uRL, String[] stringArray) {
    }

    @Override
    public void processErrorDetected(ProcessErrorEvent processErrorEvent) {
    }

    @Override
    public void processFunctionDecoded(String string) {
    }

    @Override
    public void processProgramDecoded() {
    }

    @Override
    public void processNormallyEnded() {
        this.play = false;
        this.playButton.setIcon(this.playButtonIcon_MouseOut);
        this.playButton.repaint();
        this.underPanel.repaint();
        this.mainPanel.repaint();
        this.shell.exit();
        this.resetDriveLabel();
    }

    @Override
    public void processAbnormallyEnded() {
        this.play = false;
        this.playButton.setIcon(this.playButtonIcon_MouseOut);
        this.playButton.repaint();
        this.underPanel.repaint();
        this.mainPanel.repaint();
        this.resetDriveLabel();
    }

    @Override
    public String processConsoleRequested() {
        return "";
    }

    public void openFile(URL uRL, String string) {
        boolean bl = false;
        String string2 = string;
        TSVVertexReader tSVVertexReader = new TSVVertexReader();
        tSVVertexReader.open(uRL, string);
        string2 = tSVVertexReader.load();
        tSVVertexReader.close();
        tSVVertexReader = null;
        String string3 = string2;
        this.textArea.setText(string3);
        this.currentFile = new File("./ONLINE_PROGRAM.vcssl");
        this.currentFileReplacedPath = this.currentFile.getPath().replaceAll("\\\\", "/");
        this.currentDirectory = new File(".");
        this.currentEncode = string;
        this.currentFileModified = false;
    }

    public void openFile(File file) {
        String string = "AUTO";
        ProcessCodeEncodeDetector processCodeEncodeDetector = new ProcessCodeEncodeDetector();
        String string2 = processCodeEncodeDetector.loadEncodeTag(file);
        processCodeEncodeDetector = null;
        if (string2 != null) {
            string = string2;
        }
        Object object = JOptionPane.showInputDialog(null, "", "SELECT ENCODE", 1, null, new String[]{"AUTO", "UTF-8", "UTF-16", "UTF-32", SETTING_FILE_ENCODING, "EUC-JP"}, string);
        String string3 = (String)object;
        this.openFile(file, string3);
    }

    public void openFile(File file, String string) {
        if (file.exists()) {
            boolean bl = false;
            String string2 = "";
            if (string == null) {
                return;
            }
            if (string.equals("AUTO")) {
                TSVVertexReader tSVVertexReader = new TSVVertexReader();
                tSVVertexReader.open(file);
                string2 = tSVVertexReader.load();
                tSVVertexReader.close();
                tSVVertexReader = null;
            } else {
                TSVVertexReader tSVVertexReader = new TSVVertexReader();
                tSVVertexReader.open(file, string);
                string2 = tSVVertexReader.load();
                tSVVertexReader.close();
                tSVVertexReader = null;
            }
            if (string.equals("UTF-8") && 0 < string2.length() && string2.charAt(0) == '\ufeff') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            String string3 = string2;
            this.textArea.setText(string3);
            this.currentFile = file;
            this.currentFileReplacedPath = this.currentFile.getPath().replaceAll("\\\\", "/");
            this.currentDirectory = file.getParentFile();
            if (this.currentDirectory == null) {
                this.currentDirectory = new File(".");
            }
            this.currentEncode = string;
            this.currentFileModified = false;
        }
    }

    public void openFile() {
        FileDialog fileDialog = new FileDialog(this.frame);
        fileDialog.setMode(0);
        fileDialog.setTitle("Choose the file to open.");
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        File file = new File(string, string2);
        this.openFile(file);
        fileDialog.dispose();
        fileDialog = null;
    }

    public boolean saveFile() {
        FileDialog fileDialog = new FileDialog(this.frame);
        fileDialog.setMode(1);
        fileDialog.setTitle("Choose the file to save.");
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        fileDialog.dispose();
        fileDialog = null;
        if (string2 == null) {
            return false;
        }
        String string3 = "AUTO";
        ProcessCodeEncodeDetector processCodeEncodeDetector = new ProcessCodeEncodeDetector();
        String string4 = processCodeEncodeDetector.loadEncodeTag(this.textArea.getText());
        processCodeEncodeDetector = null;
        if (string4 != null) {
            string3 = string4;
        }
        Object object = JOptionPane.showInputDialog(null, "", "SELECT ENCODE", 1, null, new String[]{"AUTO", "UTF-8", "UTF-16", "UTF-32", SETTING_FILE_ENCODING, "EUC-JP"}, string3);
        String string5 = (String)object;
        String[] stringArray = string2.split("\\.");
        String string6 = stringArray[stringArray.length - 1];
        if (stringArray.length == 1) {
            string2 = string2 + ".vcssl";
        }
        File file = new File(string, string2);
        boolean bl = false;
        bl = string5.equals("AUTO") ? this.stringToFile(file.getPath(), this.textArea.getText()) : this.stringToFile(file.getPath(), this.textArea.getText(), string5);
        this.currentEncode = string5;
        this.currentFile = file;
        this.currentFileReplacedPath = this.currentFile.getPath().replaceAll("\\\\", "/");
        this.currentDirectory = file.getParentFile();
        return bl;
    }

    public String fileToString(String string) {
        TSVVertexReader tSVVertexReader = new TSVVertexReader();
        tSVVertexReader.openFile(string);
        String string2 = tSVVertexReader.load();
        tSVVertexReader.close();
        tSVVertexReader = null;
        return string2;
    }

    public boolean stringToFile(String string, String string2, String string3) {
        return this.stringToFile(string, string2, string3, true);
    }

    public boolean stringToFile(String string, String string2, String string3, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string3);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
            if (bl) {
                JOptionPane.showMessageDialog(this.frame, "Saved\uff1a " + string, "Saved", -1);
            }
            this.currentFileModified = false;
            return true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "\u4f55\u3089\u304b\u306e\u30a8\u30e9\u30fc\u306e\u305f\u3081\u3001\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n\nError: Save failed !\n\n FILE=" + string, "!", 0);
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stringToFile(String string, String string2) {
        return this.stringToFile(string, string2, true);
    }

    public boolean stringToFile(String string, String string2, boolean bl) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2);
            fileWriter.close();
            if (bl) {
                JOptionPane.showMessageDialog(this.frame, "Saved\uff1a " + string, "Saved", -1);
            }
            this.currentFileModified = false;
            return true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "\u4f55\u3089\u304b\u306e\u30a8\u30e9\u30fc\u306e\u305f\u3081\u3001\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n\nError: Save failed !\n\n FILE=" + string, "!", 0);
            exception.printStackTrace();
            return false;
        }
    }

    public void __stringToFile(String string, String string2, String string3) {
        TSVVertexWriter tSVVertexWriter = new TSVVertexWriter();
        tSVVertexWriter.openFile(string, string3);
        tSVVertexWriter.write(string2);
        tSVVertexWriter.close();
        tSVVertexWriter = null;
        this.explainLabel.setText("Wrote  " + string);
    }

    public void __stringToFile(String string, String string2) {
        TSVVertexWriter tSVVertexWriter = new TSVVertexWriter();
        tSVVertexWriter.openFile(string);
        tSVVertexWriter.write(string2);
        tSVVertexWriter.close();
        tSVVertexWriter = null;
        this.explainLabel.setText("Wrote  " + string);
    }

    public boolean overWrite() {
        if (this.currentFile == null || !this.currentFile.exists()) {
            return this.saveFile();
        }
        if (this.currentFile.getName().equals("UNKNOWN_PROGRAM.vcssl")) {
            return this.saveFile();
        }
        if (this.currentFile.getName().equals(buffPath)) {
            return this.saveFile();
        }
        try {
            if (this.currentEncode.equals("AUTO")) {
                return this.stringToFile(this.currentFile.getPath(), this.textArea.getText());
            }
            return this.stringToFile(this.currentFile.getPath(), this.textArea.getText(), this.currentEncode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.saveFile();
        }
    }

    public void __overWrite() {
        if (this.currentFile == null || !this.currentFile.exists()) {
            this.saveFile();
        } else if (this.currentFile.getName().equals("UNKNOWN_PROGRAM.vcssl")) {
            this.saveFile();
        } else if (this.currentFile.getName().equals(buffPath)) {
            this.saveFile();
        } else {
            try {
                if (this.currentEncode.equals("AUTO")) {
                    this.stringToFile(this.currentFile.getPath(), this.textArea.getText());
                } else {
                    this.stringToFile(this.currentFile.getPath(), this.textArea.getText(), this.currentEncode);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.saveFile();
            }
        }
    }

    private class ModifyKeyListener
    implements KeyListener {
        private ModifyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (CoderMainFrame.this.currentFile != null && !CoderMainFrame.this.currentFile.getPath().equals(buffPath)) {
                CoderMainFrame.this.currentFileModified = true;
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

