/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.graph2d;

import com.rinearn.graph2d.RinearnGraph2DOptionItem;
import com.rinearn.graph2d.RinearnGraph2DOptionParameter;
import com.rinearn.graph2d.event.RinearnGraph2DEventDispatcher;
import com.rinearn.graph2d.event.RinearnGraph2DPlottingListener;
import com.rinearn.graph2d.renderer.RinearnGraph2DRenderer;
import com.rinearn.rxg2dlegacyimpl.Graph2DCommandController;
import com.rinearn.rxg2dlegacyimpl.ProcessDrivenGraph2DWindow;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JMenuBar;

public class RinearnGraph2D {
    private ProcessDrivenGraph2DWindow core = new ProcessDrivenGraph2DWindow();
    private boolean asynchronousPlottingEnabled = false;
    private RinearnGraph2DRenderer renderer = null;
    private RinearnGraph2DEventDispatcher dispatcher = new RinearnGraph2DEventDispatcher(this);
    private RinearnGraph2DWindowListener windowListener = null;

    public static void main(String[] stringArray) {
        RinearnGraph2D rinearnGraph2D = new RinearnGraph2D();
        rinearnGraph2D.core.waitForInterruptable();
        try {
            rinearnGraph2D.windowListener.setAutoExittingEnabled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rinearnGraph2D.core.waitForInterruptable();
        Graph2DCommandController graph2DCommandController = new Graph2DCommandController(rinearnGraph2D);
        graph2DCommandController.processCommands(stringArray);
    }

    public RinearnGraph2D() {
        try {
            this.core.setDefaultCloseOperation(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.windowListener = new RinearnGraph2DWindowListener(this, this.core);
        this.core.addWindowListener(this.windowListener);
    }

    public void dispose() {
        if (this.core != null) {
            this.core.disposeResource();
            this.core = null;
        }
    }

    public RinearnGraph2DRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new RinearnGraph2DRenderer();
            try {
                Field field = RinearnGraph2DRenderer.class.getDeclaredField("core");
                field.setAccessible(true);
                field.set(this.renderer, this.core);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            this.core.setPeriodicRerenderingEnabled(false);
        }
        return this.renderer;
    }

    public void openDataFile(File file) throws FileNotFoundException, IOException {
        this.core.waitForInterruptable();
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.core.plotFile(file.getPath());
        this.core.waitForInterruptable();
    }

    public void openDataFiles(File[] fileArray) throws FileNotFoundException, IOException {
        this.core.waitForInterruptable();
        int n = fileArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].exists()) {
                throw new FileNotFoundException();
            }
            stringArray[i] = fileArray[i].getPath();
        }
        this.core.plotFile(stringArray);
        this.core.waitForInterruptable();
    }

    public void clear() {
        this.core.format();
        this.core.waitForInterruptable();
    }

    public Image getImage() {
        this.core.waitForInterruptable();
        return this.core.getImage();
    }

    public void setWindowBounds(int n, int n2, int n3, int n4) {
        this.core.waitForInterruptable();
        this.core.setBounds(n, n2, n3, n4);
        this.core.waitForInterruptable();
    }

    public void setWindowTitle(String string) {
        this.core.setTitle(string);
    }

    public void setWindowVisible(boolean bl) {
        this.core.setVisible(bl);
    }

    public void setScreenSize(int n, int n2) {
        this.core.setWindowSizeByScreenSize(n, n2);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setAutoDisposingEnabled(boolean bl) {
        this.windowListener.setAutoDisposingEnabled(bl);
    }

    public void setAutoExittingEnabled(boolean bl) {
        this.windowListener.setAutoExittingEnabled(bl);
    }

    public void setXRange(double d, double d2) {
        this.core.setXRange(d, d2);
    }

    public void setYRange(double d, double d2) {
        this.core.setYRange(d, d2);
    }

    public void setXAutoRangingEnabled(boolean bl) {
        this.core.setAutomaticSetRangeX(bl);
    }

    public void setYAutoRangingEnabled(boolean bl) {
        this.core.setAutomaticSetRangeY(bl);
    }

    public boolean isXAutoRangingEnabled() {
        return this.core.isAutomaticSetRangeX();
    }

    public boolean isYAutoRangingEnabled() {
        return this.core.isAutomaticSetRangeY();
    }

    public void setXLabel(String string) {
        this.core.setXName(string);
    }

    public void setYLabel(String string) {
        this.core.setYName(string);
    }

    public void setTitle(String string) {
        this.core.setGraphTitle(string, false, false);
        if (this.asynchronousPlottingEnabled) {
            this.core.scheduleInterruptionTimer();
        } else {
            this.core.waitForInterruptable();
            this.core.repaintGraph();
        }
    }

    public void setXTicks(BigDecimal[] bigDecimalArray, String[] stringArray) {
        int n = bigDecimalArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimalArray[i].doubleValue();
        }
        this.setXTicks(dArray, stringArray);
    }

    public void setXTicks(double[] dArray, String[] stringArray) {
        this.core.waitForInterruptable();
        this.core.setXTicks(dArray, stringArray);
        this.core.waitForInterruptable();
    }

    public void setYTicks(BigDecimal[] bigDecimalArray, String[] stringArray) {
        int n = bigDecimalArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimalArray[i].doubleValue();
        }
        this.setYTicks(dArray, stringArray);
    }

    public void setYTicks(double[] dArray, String[] stringArray) {
        this.core.waitForInterruptable();
        this.core.setYTicks(dArray, stringArray);
        this.core.waitForInterruptable();
    }

    public void setLegends(String[] stringArray) {
        this.core.setGraphLegend(stringArray);
        if (this.asynchronousPlottingEnabled) {
            this.core.scheduleInterruptionTimer();
        } else {
            this.core.waitForInterruptable();
            this.core.repaintGraph();
        }
    }

    public void setOptionSelected(RinearnGraph2DOptionItem rinearnGraph2DOptionItem, boolean bl) {
        switch (rinearnGraph2DOptionItem) {
            case POINT: {
                this.core.withPointsStatusStock = bl;
                this.core.setWithPointsState(bl);
                break;
            }
            case LINE: {
                this.core.withLinesStatusStock = bl;
                this.core.setWithLinesState(bl);
                break;
            }
            case LOG_X: {
                this.core.lnXBox.setState(bl);
                break;
            }
            case LOG_Y: {
                this.core.lnYBox.setState(bl);
                break;
            }
            case GRAY_SCREEN: {
                this.core.withGrayScreenBox.setState(bl);
                break;
            }
            case GRID: {
                this.core.withGridLineBox.setState(bl);
                break;
            }
            case FRAME: {
                this.core.withFrameBox.setState(bl);
                break;
            }
            case SCALE: {
                this.core.withScaleBox.setState(bl);
            }
        }
    }

    public boolean isOptionSelected(RinearnGraph2DOptionItem rinearnGraph2DOptionItem) {
        switch (rinearnGraph2DOptionItem) {
            case POINT: {
                return this.core.withPointsBox.getState();
            }
            case LINE: {
                return this.core.withLinesBox.getState();
            }
            case DOT: {
                return this.core.withDotsBox.getState();
            }
            case LOG_X: {
                return this.core.lnXBox.getState();
            }
            case LOG_Y: {
                return this.core.lnYBox.getState();
            }
            case GRAY_SCREEN: {
                return this.core.withGrayScreenBox.getState();
            }
            case GRID: {
                return this.core.withGridLineBox.getState();
            }
            case FRAME: {
                return this.core.withFrameBox.getState();
            }
            case SCALE: {
                return this.core.withScaleBox.getState();
            }
        }
        return false;
    }

    public void setOptionParameter(RinearnGraph2DOptionParameter rinearnGraph2DOptionParameter) {
        this.core.setLineWidth(rinearnGraph2DOptionParameter.getLineWidth());
        this.core.setPointRadius(rinearnGraph2DOptionParameter.getPointRadius());
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setAsynchronousPlottingEnabled(boolean bl) {
        this.asynchronousPlottingEnabled = true;
    }

    public boolean isAsynchronousPlottingEnabled() {
        return this.asynchronousPlottingEnabled;
    }

    public void setData(double[] dArray, double[] dArray2) {
        boolean bl;
        boolean bl2 = bl = this.core.xDataBuffer == null || this.core.xDataBuffer.length != 1 || this.core.xDataBuffer[0].length != dArray.length;
        if (bl) {
            this.core.xDataBuffer = new double[1][dArray.length];
            this.core.yDataBuffer = new double[1][dArray2.length];
        }
        System.arraycopy(dArray, 0, this.core.xDataBuffer[0], 0, dArray.length);
        System.arraycopy(dArray2, 0, this.core.yDataBuffer[0], 0, dArray2.length);
        if (this.asynchronousPlottingEnabled) {
            this.core.dataBuffered = true;
            this.core.scheduleInterruptionTimer();
            return;
        }
        this.core.dataBuffered = false;
        this.core.format();
        this.core.addSystem(this.core.xDataBuffer[0], this.core.yDataBuffer[0]);
        this.core.fitRange(dArray, dArray2, true, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setData(double[][] dArray, double[][] dArray2) {
        int n;
        boolean bl = false;
        if (this.core.xDataBuffer == null) {
            bl = true;
        } else if (this.core.xDataBuffer.length != dArray.length) {
            bl = true;
        } else {
            for (n = 0; n < this.core.xDataBuffer.length; ++n) {
                if (this.core.xDataBuffer[n].length == dArray[n].length) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.core.xDataBuffer = new double[dArray.length][];
            this.core.yDataBuffer = new double[dArray2.length][];
            for (n = 0; n < dArray.length; ++n) {
                this.core.xDataBuffer[n] = new double[dArray[n].length];
            }
            for (n = 0; n < dArray2.length; ++n) {
                this.core.yDataBuffer[n] = new double[dArray2[n].length];
            }
        }
        for (n = 0; n < dArray.length; ++n) {
            System.arraycopy(dArray[n], 0, this.core.xDataBuffer[n], 0, dArray[n].length);
        }
        for (n = 0; n < dArray2.length; ++n) {
            System.arraycopy(dArray2[n], 0, this.core.yDataBuffer[n], 0, dArray2[n].length);
        }
        if (this.asynchronousPlottingEnabled) {
            this.core.dataBuffered = true;
            this.core.scheduleInterruptionTimer();
            return;
        }
        this.core.dataBuffered = false;
        this.core.format();
        for (n = 0; n < this.core.xDataBuffer.length; ++n) {
            this.core.addSystem(this.core.xDataBuffer[n], this.core.yDataBuffer[n]);
        }
        this.core.fitRange(dArray, dArray2, true, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void appendData(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray4, 0, dArray2.length);
        this.core.addSystem(dArray3, dArray4);
        this.core.fitRange(dArray, dArray2, false, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void appendData(double[][] dArray, double[][] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = new double[dArray[i].length];
            double[] dArray4 = new double[dArray2[i].length];
            System.arraycopy(dArray[i], 0, dArray3, 0, dArray[i].length);
            System.arraycopy(dArray2[i], 0, dArray4, 0, dArray2[i].length);
            this.core.addSystem(dArray3, dArray4);
        }
        this.core.fitRange(dArray, dArray2, false, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void loadConfigurationFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.core.waitForInterruptable();
        this.core.loadConfigurationFile(file.getPath());
        this.core.waitForInterruptable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportImageFile(File file, double d) throws IOException {
        if (file == null) {
            throw new IOException();
        }
        String string = null;
        String string2 = file.getPath();
        int n = string2.lastIndexOf(".");
        if (0 > n || n + 1 >= string2.length()) {
            throw new IOException();
        }
        string = string2.substring(n + 1, string2.length());
        if (string.equals("jpg")) {
            string = "JPEG";
        }
        if (string.equals("jpeg")) {
            string = "JPEG";
        }
        if (string.equals("JPG")) {
            string = "JPEG";
        }
        if (string.equals("png")) {
            string = "PNG";
        }
        if (string.equals("bmp")) {
            string = "BMP";
        }
        if (d <= 1.0) {
            d *= 100.0;
        }
        this.core.waitForInterruptable();
        Image image = this.core.getImage();
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = null;
        bufferedImage = string.equals("PNG") ? new BufferedImage(n2, n3, 2) : new BufferedImage(n2, n3, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        boolean bl = true;
        if (bl) {
            if (string == null) throw new IOException();
            if (string.equals("JPEG")) {
                float f = 1.0f;
                try {
                    f = (float)(d / 100.0);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
                ImageWriter imageWriter = iterator.next();
                ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
                imageWriter.setOutput(imageOutputStream);
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                if (imageWriteParam.canWriteCompressed()) {
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionQuality(f);
                    imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
                    imageWriter.dispose();
                    imageOutputStream.close();
                    return;
                }
            }
            if (string.equals("JPEG")) {
                ImageIO.write((RenderedImage)bufferedImage, "jpeg", file);
            } else if (string.equals("BMP")) {
                ImageIO.write((RenderedImage)bufferedImage, "bmp", file);
            } else {
                if (!string.equals("PNG")) throw new IOException();
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
        }
        this.core.waitForInterruptable();
    }

    public void setMenuVisible(boolean bl) {
        this.core.setMenuVisible(bl);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.core.getContentPane().setVisible(false);
        this.core.setWindowMenuBar(jMenuBar);
        this.core.getContentPane().setVisible(true);
    }

    public void addPlottingListener(RinearnGraph2DPlottingListener rinearnGraph2DPlottingListener) {
        this.dispatcher.addPlottingListener(rinearnGraph2DPlottingListener);
    }

    public void addWindowListener(WindowListener windowListener) {
        this.core.addWindowListener(windowListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.core.addKeyListener(keyListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.core.addMouseListener(mouseListener);
    }

    public void setDefaultMouseListenerEnabled(boolean bl) {
        this.core.setDefaultMouseListenerEnabled(bl);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.core.addMouseMotionListener(mouseMotionListener);
    }

    public void setDefaultMouseMotionListenerEnabled(boolean bl) {
        this.core.setDefaultMouseMotionListenerEnabled(bl);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.core.addMouseWheelListener(mouseWheelListener);
    }

    public void setDefaultMouseWheelListenerEnabled(boolean bl) {
        this.core.setDefaultMouseWheelListenerEnabled(bl);
    }

    private class RinearnGraph2DWindowListener
    implements WindowListener {
        private boolean autoExittingEnabled = false;
        private boolean autoDisposingEnabled = true;
        private ProcessDrivenGraph2DWindow core;
        private RinearnGraph2D graph;

        private RinearnGraph2DWindowListener(RinearnGraph2D rinearnGraph2D2, ProcessDrivenGraph2DWindow processDrivenGraph2DWindow) {
            this.graph = rinearnGraph2D2;
            this.core = processDrivenGraph2DWindow;
        }

        public void setAutoDisposingEnabled(boolean bl) {
            this.autoDisposingEnabled = bl;
        }

        public void setAutoExittingEnabled(boolean bl) {
            this.autoExittingEnabled = bl;
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (this.autoDisposingEnabled) {
                this.graph.dispose();
            }
            if (this.autoExittingEnabled) {
                this.graph.dispose();
                System.exit(0);
            }
        }
    }
}

