/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.graph3d;

import com.rinearn.graph3d.RinearnGraph3DDataFileFormat;
import com.rinearn.graph3d.RinearnGraph3DOptionItem;
import com.rinearn.graph3d.RinearnGraph3DOptionParameter;
import com.rinearn.graph3d.event.RinearnGraph3DEventDispatcher;
import com.rinearn.graph3d.event.RinearnGraph3DPlottingListener;
import com.rinearn.graph3d.renderer.RinearnGraph3DRenderer;
import com.rinearn.rxg3dlegacyimpl.Graph3DCommandController;
import com.rinearn.rxg3dlegacyimpl.ProcessDrivenGraph3DWindow;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;

public class RinearnGraph3D {
    private static final Map<RinearnGraph3DDataFileFormat, String> DATA_FILE_FORMAT_INTERNALNAME_MAP = new HashMap<RinearnGraph3DDataFileFormat, String>(){
        {
            this.put(RinearnGraph3DDataFileFormat.AUTO, "AUTO");
            this.put(RinearnGraph3DDataFileFormat.MATRIX_STSV, "MATRIX(TSV)");
            this.put(RinearnGraph3DDataFileFormat.MATRIX_CSV, "MATRIX(CSV)");
            this.put(RinearnGraph3DDataFileFormat.THREE_COLUMNS_STSV, "3-COLUMNS(TSV)");
            this.put(RinearnGraph3DDataFileFormat.THREE_COLUMNS_CSV, "3-COLUMNS(CSV)");
            this.put(RinearnGraph3DDataFileFormat.FOUR_COLUMNS_STSV, "4-COLUMNS(TSV)");
            this.put(RinearnGraph3DDataFileFormat.FOUR_COLUMNS_CSV, "4-COLUMNS(CSV)");
        }
    };
    private ProcessDrivenGraph3DWindow core = new ProcessDrivenGraph3DWindow();
    private boolean AsynchronousPlottingEnabled = false;
    private RinearnGraph3DRenderer renderer = null;
    private RinearnGraph3DEventDispatcher dispatcher = new RinearnGraph3DEventDispatcher(this);
    private RinearnGraph3DWindowListener windowListener = null;

    public static void main(String[] stringArray) {
        RinearnGraph3D rinearnGraph3D = new RinearnGraph3D();
        rinearnGraph3D.core.waitForInterruptable();
        try {
            rinearnGraph3D.windowListener.setAutoExittingEnabled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rinearnGraph3D.core.waitForInterruptable();
        Graph3DCommandController graph3DCommandController = new Graph3DCommandController(rinearnGraph3D);
        graph3DCommandController.processCommands(stringArray);
    }

    public RinearnGraph3D() {
        try {
            this.core.setDefaultCloseOperation(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.windowListener = new RinearnGraph3DWindowListener(this, this.core);
        this.core.addWindowListener(this.windowListener);
    }

    public void dispose() {
        if (this.core != null) {
            this.core.disposeResource();
            this.core = null;
        }
    }

    public RinearnGraph3DRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new RinearnGraph3DRenderer();
            try {
                Field field = RinearnGraph3DRenderer.class.getDeclaredField("core");
                field.setAccessible(true);
                field.set(this.renderer, this.core);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return this.renderer;
    }

    public void openDataFile(File file) throws FileNotFoundException, IOException {
        this.core.waitForInterruptable();
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.core.plotFile(file.getPath());
        this.core.waitForInterruptable();
    }

    public void openDataFiles(File[] fileArray) throws FileNotFoundException, IOException {
        this.core.waitForInterruptable();
        int n = fileArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].exists()) {
                throw new FileNotFoundException();
            }
            stringArray[i] = fileArray[i].getPath();
        }
        this.core.plotFile(stringArray);
        this.core.waitForInterruptable();
    }

    public void openDataFile(File file, RinearnGraph3DDataFileFormat rinearnGraph3DDataFileFormat) throws FileNotFoundException, IOException {
        this.core.waitForInterruptable();
        if (!file.exists()) {
            throw new FileNotFoundException("The specified data file does not exist: " + file);
        }
        String string = file.getPath();
        if (!DATA_FILE_FORMAT_INTERNALNAME_MAP.containsKey((Object)rinearnGraph3DDataFileFormat)) {
            throw new FileNotFoundException("Unsupported format: " + (Object)((Object)rinearnGraph3DDataFileFormat));
        }
        String string2 = DATA_FILE_FORMAT_INTERNALNAME_MAP.get((Object)rinearnGraph3DDataFileFormat);
        this.core.plotFile(string, string2);
        this.core.waitForInterruptable();
    }

    public void openDataFiles(File[] fileArray, RinearnGraph3DDataFileFormat[] rinearnGraph3DDataFileFormatArray) throws FileNotFoundException, IOException {
        this.core.waitForInterruptable();
        int n = fileArray.length;
        if (n != rinearnGraph3DDataFileFormatArray.length) {
            throw new IOException("The number of data files and formats don't match");
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].exists()) {
                throw new FileNotFoundException("The specified data file does not exist: " + fileArray[i]);
            }
            stringArray[i] = fileArray[i].getPath();
        }
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            if (!DATA_FILE_FORMAT_INTERNALNAME_MAP.containsKey((Object)rinearnGraph3DDataFileFormatArray[i])) {
                throw new FileNotFoundException("Unsupported format: " + (Object)((Object)rinearnGraph3DDataFileFormatArray[i]));
            }
            stringArray2[i] = DATA_FILE_FORMAT_INTERNALNAME_MAP.get((Object)rinearnGraph3DDataFileFormatArray[i]);
        }
        this.core.plotFile(stringArray, stringArray2);
        this.core.waitForInterruptable();
    }

    public void clear() {
        this.core.format();
        this.core.waitForInterruptable();
    }

    public Image getImage() {
        this.core.waitForInterruptable();
        return this.core.getImage();
    }

    public void setWindowBounds(int n, int n2, int n3, int n4) {
        this.core.waitForInterruptable();
        if (SwingUtilities.isEventDispatchThread()) {
            new WindowBoundsSetter(n, n2, n3, n4).run();
        } else {
            try {
                SwingUtilities.invokeAndWait(new WindowBoundsSetter(n, n2, n3, n4));
            }
            catch (Error | InterruptedException | InvocationTargetException throwable) {
                new WindowBoundsSetter(n, n2, n3, n4).run();
            }
        }
        this.core.graphResizeOnUIThread(true);
        this.core.waitForInterruptable();
    }

    public void setWindowTitle(String string) {
        this.core.setTitle(string);
    }

    public void setWindowVisible(boolean bl) {
        this.core.setVisible(bl);
    }

    public void setScreenSize(int n, int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            new ScreenResizer(n, n2).run();
        } else {
            try {
                SwingUtilities.invokeAndWait(new ScreenResizer(n, n2));
            }
            catch (Error | InterruptedException | InvocationTargetException throwable) {
                new ScreenResizer(n, n2).run();
            }
        }
        this.core.graphResizeOnUIThread(true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setAutoDisposingEnabled(boolean bl) {
        this.windowListener.setAutoDisposingEnabled(bl);
    }

    public void setAutoExittingEnabled(boolean bl) {
        this.windowListener.setAutoExittingEnabled(bl);
    }

    public void setXRange(double d, double d2) {
        this.core.setXRange(d, d2);
    }

    public void setYRange(double d, double d2) {
        this.core.setYRange(d, d2);
    }

    public void setZRange(double d, double d2) {
        this.core.setZRange(d, d2);
    }

    public void setXAutoRangingEnabled(boolean bl) {
        this.core.setAutomaticSetRangeX(bl);
    }

    public void setYAutoRangingEnabled(boolean bl) {
        this.core.setAutomaticSetRangeY(bl);
    }

    public void setZAutoRangingEnabled(boolean bl) {
        this.core.setAutomaticSetRangeZ(bl);
    }

    public boolean isXAutoRangingEnabled() {
        return this.core.isAutomaticSetRangeX();
    }

    public boolean isYAutoRangingEnabled() {
        return this.core.isAutomaticSetRangeY();
    }

    public boolean isZAutoRangingEnabled() {
        return this.core.isAutomaticSetRangeZ();
    }

    public void setXLabel(String string) {
        this.core.waitForInterruptable();
        this.core.setXName(string);
        this.core.waitForInterruptable();
    }

    public void setYLabel(String string) {
        this.core.waitForInterruptable();
        this.core.setYName(string);
        this.core.waitForInterruptable();
    }

    public void setZLabel(String string) {
        this.core.waitForInterruptable();
        this.core.setZName(string);
        this.core.waitForInterruptable();
    }

    public void setXZenithCameraAngle(double d, double d2) {
        this.core.setCameraAngle(d, d2, "X");
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setYZenithCameraAngle(double d, double d2) {
        this.core.setCameraAngle(d, d2, "Y");
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setZZenithCameraAngle(double d, double d2) {
        this.core.setCameraAngle(d, d2, "Z");
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setCameraMagnification(double d) {
        this.core.setCameraMagnification(d);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setCameraDistance(double d) {
        this.core.setCameraDistance(d);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setCameraPerspectiveEnabled(boolean bl) {
        this.core.setCameraPerspectiveEnabled(bl);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setXTicks(BigDecimal[] bigDecimalArray, String[] stringArray) {
        int n = bigDecimalArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimalArray[i].doubleValue();
        }
        this.setXTicks(dArray, stringArray);
    }

    public void setXTicks(double[] dArray, String[] stringArray) {
        this.core.waitForInterruptable();
        this.core.setXTicks(dArray, stringArray);
        this.core.waitForInterruptable();
    }

    public void setYTicks(BigDecimal[] bigDecimalArray, String[] stringArray) {
        int n = bigDecimalArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimalArray[i].doubleValue();
        }
        this.setYTicks(dArray, stringArray);
    }

    public void setYTicks(double[] dArray, String[] stringArray) {
        this.core.waitForInterruptable();
        this.core.setYTicks(dArray, stringArray);
        this.core.waitForInterruptable();
    }

    public void setZTicks(BigDecimal[] bigDecimalArray, String[] stringArray) {
        int n = bigDecimalArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimalArray[i].doubleValue();
        }
        this.setZTicks(dArray, stringArray);
    }

    public void setZTicks(double[] dArray, String[] stringArray) {
        this.core.waitForInterruptable();
        this.core.setZTicks(dArray, stringArray);
        this.core.waitForInterruptable();
    }

    public void setColorBarTicks(BigDecimal[] bigDecimalArray, String[] stringArray) {
        int n = bigDecimalArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimalArray[i].doubleValue();
        }
        this.setColorBarTicks(dArray, stringArray);
    }

    public void setColorBarTicks(double[] dArray, String[] stringArray) {
        this.core.setColorBarTicks(dArray, stringArray);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setOptionSelected(RinearnGraph3DOptionItem rinearnGraph3DOptionItem, boolean bl) {
        switch (rinearnGraph3DOptionItem) {
            case POINT: {
                this.core.setWithPointsState(bl);
                break;
            }
            case LINE: {
                this.core.setWithLinesState(bl);
                break;
            }
            case DOT: {
                this.core.withDotsBox.setState(bl);
                break;
            }
            case MESH: {
                this.core.setWithMeshesState(bl);
                break;
            }
            case MEMBRANE: {
                this.core.setWithMembranesState(bl);
                break;
            }
            case CONTOUR: {
                this.core.setWithContoursState(bl);
                break;
            }
            case LOG_X: {
                this.core.lnXBox.setState(bl);
                break;
            }
            case LOG_Y: {
                this.core.lnYBox.setState(bl);
                break;
            }
            case LOG_Z: {
                this.core.lnZBox.setState(bl);
                break;
            }
            case REVERSE_X: {
                this.core.revXBox.setState(bl);
                break;
            }
            case REVERSE_Y: {
                this.core.revYBox.setState(bl);
                break;
            }
            case REVERSE_Z: {
                this.core.revZBox.setState(bl);
                break;
            }
            case FLAT: {
                this.core.flatBox.setState(bl);
                break;
            }
            case BLACK_SCREEN: {
                this.core.withBlackScreenBox.setState(bl);
                break;
            }
            case GRID: {
                this.core.withGridLineBox.setState(bl);
                break;
            }
            case FRAME: {
                this.core.withFrameBox.setState(bl);
                break;
            }
            case SCALE: {
                this.core.withScaleBox.setState(bl);
                break;
            }
            case GRADATION: {
                this.core.withRainbowBox.setState(bl);
            }
        }
    }

    public boolean isOptionSelected(RinearnGraph3DOptionItem rinearnGraph3DOptionItem) {
        switch (rinearnGraph3DOptionItem) {
            case POINT: {
                return this.core.withPointsBox.getState();
            }
            case LINE: {
                return this.core.withLinesBox.getState();
            }
            case DOT: {
                return this.core.withDotsBox.getState();
            }
            case MESH: {
                return this.core.withMeshesBox.getState();
            }
            case MEMBRANE: {
                return this.core.withMembranesBox.getState();
            }
            case CONTOUR: {
                return this.core.withContourBox.getState();
            }
            case LOG_X: {
                return this.core.lnXBox.getState();
            }
            case LOG_Y: {
                return this.core.lnYBox.getState();
            }
            case LOG_Z: {
                return this.core.lnZBox.getState();
            }
            case REVERSE_X: {
                return this.core.revXBox.getState();
            }
            case REVERSE_Y: {
                return this.core.revYBox.getState();
            }
            case REVERSE_Z: {
                return this.core.revZBox.getState();
            }
            case FLAT: {
                return this.core.flatBox.getState();
            }
            case BLACK_SCREEN: {
                return this.core.withBlackScreenBox.getState();
            }
            case GRID: {
                return this.core.withGridLineBox.getState();
            }
            case FRAME: {
                return this.core.withFrameBox.getState();
            }
            case SCALE: {
                return this.core.withScaleBox.getState();
            }
            case GRADATION: {
                return this.core.withRainbowBox.getState();
            }
        }
        return false;
    }

    public void setOptionParameter(RinearnGraph3DOptionParameter rinearnGraph3DOptionParameter) {
        this.core.setLineWidth(rinearnGraph3DOptionParameter.getLineWidth());
        this.core.setPointRadius(rinearnGraph3DOptionParameter.getPointRadius());
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setAsynchronousPlottingEnabled(boolean bl) {
        this.AsynchronousPlottingEnabled = bl;
    }

    public boolean isAsynchronousPlottingEnabled() {
        return this.AsynchronousPlottingEnabled;
    }

    public void setData(double[] dArray, double[] dArray2, double[] dArray3) {
        boolean bl;
        boolean bl2 = bl = this.core.xDataBuffer == null || this.core.xDataBuffer.length != 1 || this.core.xDataBuffer[0].length != 1 || this.core.xDataBuffer[0][0].length != dArray.length;
        if (bl) {
            this.core.xDataBuffer = new double[1][1][dArray.length];
            this.core.yDataBuffer = new double[1][1][dArray2.length];
            this.core.zDataBuffer = new double[1][1][dArray3.length];
        }
        System.arraycopy(dArray, 0, this.core.xDataBuffer[0][0], 0, dArray.length);
        System.arraycopy(dArray2, 0, this.core.yDataBuffer[0][0], 0, dArray2.length);
        System.arraycopy(dArray3, 0, this.core.zDataBuffer[0][0], 0, dArray3.length);
        if (this.AsynchronousPlottingEnabled) {
            this.core.dataBuffered = true;
            this.core.scheduleInterruptionTimer();
            return;
        }
        this.core.dataBuffered = false;
        this.core.format_NOREPAINT();
        this.core.addSystem(this.core.xDataBuffer[0], this.core.yDataBuffer[0], this.core.zDataBuffer[0]);
        this.core.fitRange(dArray, dArray2, dArray3, true, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        boolean bl;
        boolean bl2 = bl = this.core.xDataBuffer == null || this.core.xDataBuffer.length != 1 || this.core.xDataBuffer[0].length != 1 || this.core.xDataBuffer[0][0].length != dArray.length;
        if (bl) {
            this.core.xDataBuffer = new double[1][1][dArray.length];
            this.core.yDataBuffer = new double[1][1][dArray2.length];
            this.core.zDataBuffer = new double[1][1][dArray3.length];
        }
        String[][][] stringArray = new String[1][1][dArray4.length];
        System.arraycopy(dArray, 0, this.core.xDataBuffer[0][0], 0, dArray.length);
        System.arraycopy(dArray2, 0, this.core.yDataBuffer[0][0], 0, dArray2.length);
        System.arraycopy(dArray3, 0, this.core.zDataBuffer[0][0], 0, dArray3.length);
        for (int i = 0; i < dArray4.length; ++i) {
            stringArray[0][0][i] = Double.toString(dArray4[i]);
        }
        if (this.AsynchronousPlottingEnabled) {
            this.core.dataBuffered = true;
            this.core.scheduleInterruptionTimer();
            return;
        }
        this.core.dataBuffered = false;
        this.core.format_NOREPAINT();
        this.core.addSystem(this.core.xDataBuffer[0], this.core.yDataBuffer[0], this.core.zDataBuffer[0], stringArray[0]);
        this.core.fitRange(dArray, dArray2, dArray3, true, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setData(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        boolean bl = false;
        if (this.core.xDataBuffer == null) {
            bl = true;
        } else if (this.core.xDataBuffer.length != 1) {
            bl = true;
        } else if (this.core.xDataBuffer[0].length != dArray.length) {
            bl = true;
        } else {
            for (n = 0; n < this.core.xDataBuffer[0].length; ++n) {
                if (this.core.xDataBuffer[0][n].length == dArray[n].length) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.core.xDataBuffer = new double[1][dArray.length][];
            this.core.yDataBuffer = new double[1][dArray2.length][];
            this.core.zDataBuffer = new double[1][dArray3.length][];
            for (n = 0; n < dArray.length; ++n) {
                this.core.xDataBuffer[0][n] = new double[dArray[n].length];
            }
            for (n = 0; n < dArray2.length; ++n) {
                this.core.yDataBuffer[0][n] = new double[dArray2[n].length];
            }
            for (n = 0; n < dArray3.length; ++n) {
                this.core.zDataBuffer[0][n] = new double[dArray3[n].length];
            }
        }
        for (n = 0; n < dArray.length; ++n) {
            System.arraycopy(dArray[n], 0, this.core.xDataBuffer[0][n], 0, dArray[n].length);
        }
        for (n = 0; n < dArray2.length; ++n) {
            System.arraycopy(dArray2[n], 0, this.core.yDataBuffer[0][n], 0, dArray2[n].length);
        }
        for (n = 0; n < dArray3.length; ++n) {
            System.arraycopy(dArray3[n], 0, this.core.zDataBuffer[0][n], 0, dArray3[n].length);
        }
        if (this.AsynchronousPlottingEnabled) {
            this.core.dataBuffered = true;
            this.core.scheduleInterruptionTimer();
            return;
        }
        this.core.dataBuffered = false;
        this.core.format_NOREPAINT();
        this.core.addSystem(this.core.xDataBuffer[0], this.core.yDataBuffer[0], this.core.zDataBuffer[0]);
        this.core.fitRange(dArray, dArray2, dArray3, true, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setData(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4) {
        int n;
        int n2;
        boolean bl = false;
        if (this.core.xDataBuffer == null) {
            bl = true;
        } else if (this.core.xDataBuffer.length != 1) {
            bl = true;
        } else if (this.core.xDataBuffer[0].length != dArray.length) {
            bl = true;
        } else {
            for (n2 = 0; n2 < this.core.xDataBuffer[0].length; ++n2) {
                if (this.core.xDataBuffer[0][n2].length == dArray[n2].length) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.core.xDataBuffer = new double[1][dArray.length][];
            this.core.yDataBuffer = new double[1][dArray2.length][];
            this.core.zDataBuffer = new double[1][dArray3.length][];
            for (n2 = 0; n2 < dArray.length; ++n2) {
                this.core.xDataBuffer[0][n2] = new double[dArray[n2].length];
            }
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                this.core.yDataBuffer[0][n2] = new double[dArray2[n2].length];
            }
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                this.core.zDataBuffer[0][n2] = new double[dArray3[n2].length];
            }
        }
        String[][][] stringArray = new String[1][dArray4.length][];
        for (n = 0; n < dArray4.length; ++n) {
            stringArray[0][n] = new String[dArray4[n].length];
        }
        for (n = 0; n < dArray.length; ++n) {
            System.arraycopy(dArray[n], 0, this.core.xDataBuffer[0][n], 0, dArray[n].length);
        }
        for (n = 0; n < dArray2.length; ++n) {
            System.arraycopy(dArray2[n], 0, this.core.yDataBuffer[0][n], 0, dArray2[n].length);
        }
        for (n = 0; n < dArray3.length; ++n) {
            System.arraycopy(dArray3[n], 0, this.core.zDataBuffer[0][n], 0, dArray3[n].length);
        }
        for (n = 0; n < dArray4.length; ++n) {
            for (int i = 0; i < dArray4[n].length; ++i) {
                stringArray[0][n][i] = Double.toString(dArray4[n][i]);
            }
        }
        if (this.AsynchronousPlottingEnabled) {
            this.core.dataBuffered = true;
            this.core.scheduleInterruptionTimer();
            return;
        }
        this.core.dataBuffered = false;
        this.core.format_NOREPAINT();
        this.core.addSystem(this.core.xDataBuffer[0], this.core.yDataBuffer[0], this.core.zDataBuffer[0], stringArray[0]);
        this.core.fitRange(dArray, dArray2, dArray3, true, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setData(double[][][] dArray, double[][][] dArray2, double[][][] dArray3) {
        int n;
        int n2;
        boolean bl = false;
        if (this.core.xDataBuffer == null) {
            bl = true;
        } else if (this.core.xDataBuffer.length != dArray.length) {
            bl = true;
        } else {
            for (n2 = 0; n2 < this.core.xDataBuffer.length; ++n2) {
                if (this.core.xDataBuffer[n2].length != dArray[n2].length) {
                    bl = true;
                    break;
                }
                for (n = 0; n < this.core.xDataBuffer[n2].length; ++n) {
                    if (this.core.xDataBuffer[n2][n].length == dArray[n2][n].length) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        if (bl) {
            this.core.xDataBuffer = new double[dArray.length][][];
            this.core.yDataBuffer = new double[dArray2.length][][];
            this.core.zDataBuffer = new double[dArray3.length][][];
            for (n2 = 0; n2 < dArray.length; ++n2) {
                this.core.xDataBuffer[n2] = new double[dArray[n2].length][];
                for (n = 0; n < dArray[n2].length; ++n) {
                    this.core.xDataBuffer[n2][n] = new double[dArray[n2][n].length];
                }
            }
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                this.core.yDataBuffer[n2] = new double[dArray2[n2].length][];
                for (n = 0; n < dArray2[n2].length; ++n) {
                    this.core.yDataBuffer[n2][n] = new double[dArray2[n2][n].length];
                }
            }
            for (n2 = 0; n2 < dArray3.length; ++n2) {
                this.core.zDataBuffer[n2] = new double[dArray3[n2].length][];
                for (n = 0; n < dArray3[n2].length; ++n) {
                    this.core.zDataBuffer[n2][n] = new double[dArray3[n2][n].length];
                }
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                System.arraycopy(dArray[n2][n], 0, this.core.xDataBuffer[n2][n], 0, dArray[n2][n].length);
            }
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < dArray2[n2].length; ++n) {
                System.arraycopy(dArray2[n2][n], 0, this.core.yDataBuffer[n2][n], 0, dArray2[n2][n].length);
            }
        }
        for (n2 = 0; n2 < dArray3.length; ++n2) {
            for (n = 0; n < dArray3[n2].length; ++n) {
                System.arraycopy(dArray3[n2][n], 0, this.core.zDataBuffer[n2][n], 0, dArray3[n2][n].length);
            }
        }
        if (this.AsynchronousPlottingEnabled) {
            this.core.dataBuffered = true;
            this.core.scheduleInterruptionTimer();
            return;
        }
        this.core.dataBuffered = false;
        this.core.format_NOREPAINT();
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this.core.addSystem(this.core.xDataBuffer[n2], this.core.yDataBuffer[n2], this.core.zDataBuffer[n2]);
        }
        this.core.fitRange(dArray, dArray2, dArray3, true, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void setData(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4) {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        if (this.core.xDataBuffer == null) {
            bl = true;
        } else if (this.core.xDataBuffer.length != dArray.length) {
            bl = true;
        } else {
            for (n3 = 0; n3 < this.core.xDataBuffer.length; ++n3) {
                if (this.core.xDataBuffer[n3].length != dArray[n3].length) {
                    bl = true;
                    break;
                }
                for (n2 = 0; n2 < this.core.xDataBuffer[n3].length; ++n2) {
                    if (this.core.xDataBuffer[n3][n2].length == dArray[n3][n2].length) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
        }
        if (bl) {
            this.core.xDataBuffer = new double[dArray.length][][];
            this.core.yDataBuffer = new double[dArray2.length][][];
            this.core.zDataBuffer = new double[dArray3.length][][];
            for (n3 = 0; n3 < dArray.length; ++n3) {
                this.core.xDataBuffer[n3] = new double[dArray[n3].length][];
                for (n2 = 0; n2 < dArray[n3].length; ++n2) {
                    this.core.xDataBuffer[n3][n2] = new double[dArray[n3][n2].length];
                }
            }
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                this.core.yDataBuffer[n3] = new double[dArray2[n3].length][];
                for (n2 = 0; n2 < dArray2[n3].length; ++n2) {
                    this.core.yDataBuffer[n3][n2] = new double[dArray2[n3][n2].length];
                }
            }
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                this.core.zDataBuffer[n3] = new double[dArray3[n3].length][];
                for (n2 = 0; n2 < dArray3[n3].length; ++n2) {
                    this.core.zDataBuffer[n3][n2] = new double[dArray3[n3][n2].length];
                }
            }
        }
        String[][][] stringArrayArray = new String[dArray4.length][][];
        for (n2 = 0; n2 < dArray4.length; ++n2) {
            stringArrayArray[n2] = new String[dArray4[n2].length][];
            for (n = 0; n < dArray4[n2].length; ++n) {
                stringArrayArray[n2][n] = new String[dArray4[n2][n].length];
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = 0; n < dArray[n2].length; ++n) {
                System.arraycopy(dArray[n2][n], 0, this.core.xDataBuffer[n2][n], 0, dArray[n2][n].length);
            }
        }
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            for (n = 0; n < dArray2[n2].length; ++n) {
                System.arraycopy(dArray2[n2][n], 0, this.core.yDataBuffer[n2][n], 0, dArray2[n2][n].length);
            }
        }
        for (n2 = 0; n2 < dArray3.length; ++n2) {
            for (n = 0; n < dArray3[n2].length; ++n) {
                System.arraycopy(dArray3[n2][n], 0, this.core.zDataBuffer[n2][n], 0, dArray3[n2][n].length);
            }
        }
        for (n2 = 0; n2 < dArray4.length; ++n2) {
            for (n = 0; n < dArray4[n2].length; ++n) {
                for (int i = 0; i < dArray4[n2][n].length; ++i) {
                    stringArrayArray[n2][n][i] = Double.toString(dArray4[n2][n][i]);
                }
            }
        }
        if (this.AsynchronousPlottingEnabled) {
            this.core.dataBuffered = true;
            this.core.scheduleInterruptionTimer();
            return;
        }
        this.core.dataBuffered = false;
        this.core.format_NOREPAINT();
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this.core.addSystem(this.core.xDataBuffer[n2], this.core.yDataBuffer[n2], this.core.zDataBuffer[n2], stringArrayArray[n2]);
        }
        this.core.fitRange(dArray, dArray2, dArray3, true, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void appendData(double[] dArray, double[] dArray2, double[] dArray3) {
        double[][] dArray4 = new double[1][dArray.length];
        double[][] dArray5 = new double[1][dArray2.length];
        double[][] dArray6 = new double[1][dArray3.length];
        System.arraycopy(dArray, 0, dArray4[0], 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray5[0], 0, dArray2.length);
        System.arraycopy(dArray3, 0, dArray6[0], 0, dArray3.length);
        this.core.addSystem(dArray4, dArray5, dArray6);
        this.core.fitRange(dArray, dArray2, dArray3, false, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void appendData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double[][] dArray5 = new double[1][dArray.length];
        double[][] dArray6 = new double[1][dArray2.length];
        double[][] dArray7 = new double[1][dArray3.length];
        String[][] stringArray = new String[1][dArray4.length];
        System.arraycopy(dArray, 0, dArray5[0], 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray6[0], 0, dArray2.length);
        System.arraycopy(dArray3, 0, dArray7[0], 0, dArray3.length);
        for (int i = 0; i < dArray4.length; ++i) {
            stringArray[0][i] = Double.toString(dArray4[i]);
        }
        this.core.addSystem(dArray5, dArray6, dArray7, stringArray);
        this.core.fitRange(dArray, dArray2, dArray3, false, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void appendData(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        double[][] dArrayArray = new double[dArray.length][];
        double[][] dArrayArray2 = new double[dArray2.length][];
        double[][] dArrayArray3 = new double[dArray3.length][];
        for (n = 0; n < dArray.length; ++n) {
            dArrayArray[n] = new double[dArray[n].length];
            System.arraycopy(dArray[n], 0, dArrayArray[n], 0, dArray[n].length);
        }
        for (n = 0; n < dArray2.length; ++n) {
            dArrayArray2[n] = new double[dArray2[n].length];
            System.arraycopy(dArray2[n], 0, dArrayArray2[n], 0, dArray2[n].length);
        }
        for (n = 0; n < dArray3.length; ++n) {
            dArrayArray3[n] = new double[dArray3[n].length];
            System.arraycopy(dArray3[n], 0, dArrayArray3[n], 0, dArray3[n].length);
        }
        this.core.addSystem(dArrayArray, dArrayArray2, dArrayArray3);
        this.core.fitRange(dArray, dArray2, dArray3, false, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void appendData(double[][] dArray, double[][] dArray2, double[][] dArray3, double[][] dArray4) {
        int n;
        double[][] dArrayArray = new double[dArray.length][];
        double[][] dArrayArray2 = new double[dArray2.length][];
        double[][] dArrayArray3 = new double[dArray3.length][];
        String[][] stringArray = new String[dArray4.length][];
        for (n = 0; n < dArray.length; ++n) {
            dArrayArray[n] = new double[dArray[n].length];
            System.arraycopy(dArray[n], 0, dArrayArray[n], 0, dArray[n].length);
        }
        for (n = 0; n < dArray2.length; ++n) {
            dArrayArray2[n] = new double[dArray2[n].length];
            System.arraycopy(dArray2[n], 0, dArrayArray2[n], 0, dArray2[n].length);
        }
        for (n = 0; n < dArray3.length; ++n) {
            dArrayArray3[n] = new double[dArray3[n].length];
            System.arraycopy(dArray3[n], 0, dArrayArray3[n], 0, dArray3[n].length);
        }
        for (n = 0; n < dArray4.length; ++n) {
            stringArray[n] = new String[dArray4[n].length];
            for (int i = 0; i < dArray4[n].length; ++i) {
                stringArray[n][i] = Double.toString(dArray4[n][i]);
            }
        }
        this.core.addSystem((double[][])dArrayArray, (double[][])dArrayArray2, (double[][])dArrayArray3, stringArray);
        this.core.fitRange(dArray, dArray2, dArray3, false, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void appendData(double[][][] dArray, double[][][] dArray2, double[][][] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            int n;
            double[][] dArrayArray = new double[dArray[i].length][];
            double[][] dArrayArray2 = new double[dArray2[i].length][];
            double[][] dArrayArray3 = new double[dArray3[i].length][];
            for (n = 0; n < dArray[i].length; ++n) {
                dArrayArray[n] = new double[dArray[i][n].length];
                System.arraycopy(dArray[i][n], 0, dArrayArray[n], 0, dArray[i][n].length);
            }
            for (n = 0; n < dArray2[i].length; ++n) {
                dArrayArray2[n] = new double[dArray2[i][n].length];
                System.arraycopy(dArray2[i][n], 0, dArrayArray2[n], 0, dArray2[i][n].length);
            }
            for (n = 0; n < dArray3[i].length; ++n) {
                dArrayArray3[n] = new double[dArray3[i][n].length];
                System.arraycopy(dArray3[i][n], 0, dArrayArray3[n], 0, dArray3[i][n].length);
            }
            this.core.addSystem(dArrayArray, dArrayArray2, dArrayArray3);
        }
        this.core.fitRange(dArray, dArray2, dArray3, false, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void appendData(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4) {
        for (int i = 0; i < dArray.length; ++i) {
            int n;
            double[][] dArrayArray = new double[dArray[i].length][];
            double[][] dArrayArray2 = new double[dArray2[i].length][];
            double[][] dArrayArray3 = new double[dArray3[i].length][];
            String[][] stringArray = new String[dArray4[i].length][];
            for (n = 0; n < dArray[i].length; ++n) {
                dArrayArray[n] = new double[dArray[i][n].length];
                System.arraycopy(dArray[i][n], 0, dArrayArray[n], 0, dArray[i][n].length);
            }
            for (n = 0; n < dArray2[i].length; ++n) {
                dArrayArray2[n] = new double[dArray2[i][n].length];
                System.arraycopy(dArray2[i][n], 0, dArrayArray2[n], 0, dArray2[i][n].length);
            }
            for (n = 0; n < dArray3[i].length; ++n) {
                dArrayArray3[n] = new double[dArray3[i][n].length];
                System.arraycopy(dArray3[i][n], 0, dArrayArray3[n], 0, dArray3[i][n].length);
            }
            for (n = 0; n < dArray4.length; ++n) {
                stringArray[n] = new String[dArray4[n].length];
                for (int j = 0; j < dArray4[n].length; ++j) {
                    stringArray[n][j] = Double.toString(dArray4[i][n][j]);
                }
            }
            this.core.addSystem((double[][])dArrayArray, (double[][])dArrayArray2, (double[][])dArrayArray3, stringArray);
        }
        this.core.fitRange(dArray, dArray2, dArray3, false, true);
        this.core.waitForInterruptable();
        this.core.repaintGraph();
    }

    public void loadConfigurationFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.core.waitForInterruptable();
        this.core.loadConfigurationFileAPI(file.getPath());
        this.core.waitForInterruptable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportImageFile(File file, double d) throws IOException {
        if (file == null) {
            throw new IOException();
        }
        String string = null;
        String string2 = file.getPath();
        int n = string2.lastIndexOf(".");
        if (0 > n || n + 1 >= string2.length()) {
            throw new IOException();
        }
        string = string2.substring(n + 1, string2.length());
        if (string.equals("jpg")) {
            string = "JPEG";
        }
        if (string.equals("jpeg")) {
            string = "JPEG";
        }
        if (string.equals("JPG")) {
            string = "JPEG";
        }
        if (string.equals("png")) {
            string = "PNG";
        }
        if (string.equals("bmp")) {
            string = "BMP";
        }
        if (d <= 1.0) {
            d *= 100.0;
        }
        this.core.waitForInterruptable();
        Image image = this.core.getImage();
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = null;
        bufferedImage = string.equals("PNG") ? new BufferedImage(n2, n3, 2) : new BufferedImage(n2, n3, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        boolean bl = true;
        if (bl) {
            if (string == null) throw new IOException();
            if (string.equals("JPEG")) {
                float f = 1.0f;
                try {
                    f = (float)(d / 100.0);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
                ImageWriter imageWriter = iterator.next();
                ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
                imageWriter.setOutput(imageOutputStream);
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                if (imageWriteParam.canWriteCompressed()) {
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionQuality(f);
                    imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
                    imageWriter.dispose();
                    imageOutputStream.close();
                    return;
                }
            }
            if (string.equals("JPEG")) {
                ImageIO.write((RenderedImage)bufferedImage, "jpeg", file);
            } else if (string.equals("BMP")) {
                ImageIO.write((RenderedImage)bufferedImage, "bmp", file);
            } else {
                if (!string.equals("PNG")) throw new IOException();
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
            }
        }
        this.core.waitForInterruptable();
    }

    public void setMenuVisible(boolean bl) {
        this.core.setMenuVisible(bl);
    }

    public void setScreenSideUIVisible(boolean bl) {
        this.core.setScreenSideUIVisible(bl);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.core.getContentPane().setVisible(false);
        this.core.setWindowMenuBar(jMenuBar);
        this.core.getContentPane().setVisible(true);
    }

    public void addPlottingListener(RinearnGraph3DPlottingListener rinearnGraph3DPlottingListener) {
        this.dispatcher.addPlottingListener(rinearnGraph3DPlottingListener);
    }

    public void addWindowListener(WindowListener windowListener) {
        this.core.addWindowListener(windowListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.core.addKeyListener(keyListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.core.addMouseListener(mouseListener);
    }

    public void setDefaultMouseListenerEnabled(boolean bl) {
        this.core.setDefaultMouseListenerEnabled(bl);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.core.addMouseMotionListener(mouseMotionListener);
    }

    public void setDefaultMouseMotionListenerEnabled(boolean bl) {
        this.core.setDefaultMouseMotionListenerEnabled(bl);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.core.addMouseWheelListener(mouseWheelListener);
    }

    public void setDefaultMouseWheelListenerEnabled(boolean bl) {
        this.core.setDefaultMouseWheelListenerEnabled(bl);
    }

    private class RinearnGraph3DWindowListener
    implements WindowListener {
        private boolean autoExittingEnabled = false;
        private boolean autoDisposingEnabled = true;
        private ProcessDrivenGraph3DWindow core;
        private RinearnGraph3D graph;

        private RinearnGraph3DWindowListener(RinearnGraph3D rinearnGraph3D2, ProcessDrivenGraph3DWindow processDrivenGraph3DWindow) {
            this.graph = rinearnGraph3D2;
            this.core = processDrivenGraph3DWindow;
        }

        public void setAutoDisposingEnabled(boolean bl) {
            this.autoDisposingEnabled = bl;
        }

        public void setAutoExittingEnabled(boolean bl) {
            this.autoExittingEnabled = bl;
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (this.autoDisposingEnabled) {
                this.graph.dispose();
            }
            if (this.autoExittingEnabled) {
                this.graph.dispose();
                System.exit(0);
            }
        }
    }

    private class WindowBoundsSetter
    implements Runnable {
        int x;
        int y;
        int width;
        int height;

        public WindowBoundsSetter(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }

        @Override
        public void run() {
            RinearnGraph3D.this.core.setBounds(this.x, this.y, this.width, this.height);
        }
    }

    private class ScreenResizer
    implements Runnable {
        int width;
        int height;

        public ScreenResizer(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        @Override
        public void run() {
            RinearnGraph3D.this.core.setPreferredWindowSize(this.width, this.height);
        }
    }
}

