/*
 * Decompiled with CFR 0.152.
 */
package com.rinearn.rxg3dlegacyimpl;

import com.rinearn.graph3d.RinearnGraph3D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;

public class Graph3DCommandController {
    private final RinearnGraph3D graph3D;
    static boolean isJapanese;
    private static String EOL;

    private static void err(String string) {
        if (isJapanese) {
            System.err.print("\u30a8\u30e9\u30fc: ");
        } else {
            System.err.print("Error: ");
        }
        System.err.println(string);
    }

    private static void exit(int n) {
        System.exit(n);
    }

    public Graph3DCommandController(RinearnGraph3D rinearnGraph3D) {
        this.graph3D = rinearnGraph3D;
    }

    public void processCommands(String[] stringArray) {
        Object[] objectArray;
        Object object;
        ParsedCommandContainer parsedCommandContainer = this.parseCommands(stringArray);
        this.validateOptionValueExistances(parsedCommandContainer);
        this.validateAndSupplementOptionValues(parsedCommandContainer);
        if (parsedCommandContainer.isHelpSpecified) {
            object = "";
            if (isJapanese) {
                object = (String)object + "" + EOL;
                object = (String)object + " - RINEARN Graph 3D / \u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9 -" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + " * \u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u306e\u69cb\u6587:" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   --option1 value1 ... --optionN valueN   dataFile1 ... dataFileN" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + " * \u4f7f\u7528\u4f8b:" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   exam_data.csv" + EOL;
                object = (String)object + "    (\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb \"exam_data.csv\" \u3092\u30d7\u30ed\u30c3\u30c8\u3057\u307e\u3059\u3002)" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   --config exam_config.ini  --saveimg exam_image.png  exam_data.csv" + EOL;
                object = (String)object + "    (\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb \"exam_config.ini\" \u3092\u8aad\u307f\u8fbc\u3093\u3067 \"exam_data.csv\" \u3092\u30d7\u30ed\u30c3\u30c8\u3057\u3001\u753b\u50cf\u3092 \"exam_image.png\" \u306b\u4fdd\u5b58\u3057\u307e\u3059\u3002)" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   --quick QuickSetting1.ini  --saveimg exam_image.png  exam_data.csv" + EOL;
                object = (String)object + "    (\u4e0a\u8a18\u306e \"exam_config.ini\" \u306e\u4ee3\u308f\u308a\u306b\u3001\"RinearnGraph3DQuickSetting\" \u30d5\u30a9\u30eb\u30c0\u5185\u306e\u8a2d\u5b9a \"QuickSetting1.ini\" \u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002)" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   --quick QuickSetting1.ini  --saveimg exam_image.png  --quit  exam_data.csv" + EOL;
                object = (String)object + "    (\u4e0a\u8a18\u306b\u52a0\u3048\u3066\u3001\u753b\u50cf\u51fa\u529b\u306e\u5b8c\u4e86\u5f8c\u306b RINEARN Graph 3D \u3092\u7d42\u4e86\u3057\u307e\u3059\u3002)" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + " * \u30aa\u30d7\u30b7\u30e7\u30f3:" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --config <configFile>" + EOL;
                object = (String)object + "        \u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002" + EOL;
                object = (String)object + "        \u5024\u306b\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u540d\u304b\u3001\u307e\u305f\u306f\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304b\u3089\u898b\u305f\u76f8\u5bfe\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --quick <configFile>" + EOL;
                object = (String)object + "        \"RinearnGraph3DQuickSetting\" \u30d5\u30a9\u30eb\u30c0\u5185\u304b\u3089\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u307e\u3059\u3002" + EOL;
                object = (String)object + "        \u5024\u306b\u306f\u3001\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u540d\u524d\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --saveimg <imageFile>" + EOL;
                object = (String)object + "        \u30b0\u30e9\u30d5\u3092\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58\u3057\u307e\u3059\u3002" + EOL;
                object = (String)object + "        \u5024\u306b\u306f\u3001\u30d5\u30a1\u30a4\u30eb\u540d\u304b\u3001\u307e\u305f\u306f\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304b\u3089\u898b\u305f\u76f8\u5bfe\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --imgqual <imageFile>" + EOL;
                object = (String)object + "        \u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u306e\u54c1\u8cea\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002" + EOL;
                object = (String)object + "        \u5024\u306b\u306f\u30010.0 \u304b\u3089 1.0 \u306e\u7bc4\u56f2\u306e\u6570\u5024\u304b\u3001\u307e\u305f\u306f\u30d1\u30fc\u30bb\u30f3\u30c8\u5358\u4f4d\u3067 1.0 \u304b\u3089 100.0 \u307e\u3067\u306e\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --overwrite" + EOL;
                object = (String)object + "        \u30d5\u30a1\u30a4\u30eb\u306e\u4e0a\u66f8\u304d\u3092\u3001\u78ba\u8a8d\u306a\u3057\u3067\u884c\u3044\u307e\u3059\u3002" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --quit" + EOL;
                object = (String)object + "        \u4ed6\u306e\u5168\u3066\u306e\u30b3\u30de\u30f3\u30c9\u3092\u51e6\u7406\u3057\u305f\u5f8c\u306b\u3001RINEARN Graph 3D \u3092\u7d42\u4e86\u3057\u307e\u3059\u3002" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --version" + EOL;
                object = (String)object + "        RINEARN Graph 3D \u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u8868\u793a\u3057\u307e\u3059\u3002" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --help" + EOL;
                object = (String)object + "        \u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u8868\u793a\u3057\u307e\u3059\u3002" + EOL;
                object = (String)object + "" + EOL;
            } else {
                object = (String)object + "" + EOL;
                object = (String)object + " - RINEARN Graph 3D / Command Line Mode -" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + " * Syntax of Command Lines:" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   --option1 value1 ... --optionN valueN   dataFile1 ... dataFileN" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + " * Example:" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   exam_data.csv" + EOL;
                object = (String)object + "    (Plot the data file \"exam_data.csv\".)" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   --config exam_config.ini  --saveimg exam_image.png  exam_data.csv" + EOL;
                object = (String)object + "    (Load the config file \"exam_config.ini\" and plot \"exam_data.csv\", then save \"exam_image.png\")" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   --quick QuickSetting1.ini  --saveimg exam_image.png  exam_data.csv" + EOL;
                object = (String)object + "    (Instead of \"exam_config.ini\", load \"QuickSetting1.ini\" from \"RinearnGraph3DQuickSetting\" folder.)" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    ring3d   --quick QuickSetting1.ini  --saveimg exam_image.png  --quit  exam_data.csv" + EOL;
                object = (String)object + "    (In addition to the previous example, quit the application after saving the image file.)" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + " * Options:" + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --config <configFile>" + EOL;
                object = (String)object + "        Loads the configuration file." + EOL;
                object = (String)object + "        Specify the file name, or the relative file path from the current directory, of the config file." + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --quick <configFile>" + EOL;
                object = (String)object + "        Loads the configuration file stored in RinearnGraph3DQuickSetting folder (directory)." + EOL;
                object = (String)object + "        Specify the name of the config file." + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --saveimg <imageFile>" + EOL;
                object = (String)object + "        Saves the plotted graph image as the specified image file." + EOL;
                object = (String)object + "        Specify the file name, or the relative file path from the current directory." + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --imgqual <imageFile>" + EOL;
                object = (String)object + "        Sets the quality of the image file." + EOL;
                object = (String)object + "        Specify the numeric value from 0.0 to 1.0, or 1.0 to 100.0 in percentage." + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --overwrite" + EOL;
                object = (String)object + "        Overwrites files without confirmation." + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --quit" + EOL;
                object = (String)object + "        Quits RINEARN Graph 3D afterwhen all the other commands are processed." + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --version" + EOL;
                object = (String)object + "        Displays the version of RINEARN Graph 3D." + EOL;
                object = (String)object + "" + EOL;
                object = (String)object + "    --help" + EOL;
                object = (String)object + "        Displays this message." + EOL;
                object = (String)object + "" + EOL;
            }
            System.out.println((String)object);
            Graph3DCommandController.exit(0);
        }
        if (parsedCommandContainer.isVersionSpecified) {
            object = new File(".");
            objectArray = ((File)object).list();
            for (String string : objectArray) {
                String string2;
                if (string.startsWith("RinearnGraph3D_") && string.endsWith(".bat")) {
                    string2 = string.substring("RinearnGraph3D_".length(), string.length() - ".bat".length());
                    System.out.println("RINEARN Graph 3D Ver." + string2);
                    System.exit(0);
                }
                if (!string.startsWith("RINEARN_Graph_3D_") || !string.endsWith(".bat")) continue;
                string2 = string.substring("RINEARN_Graph_3D_".length(), string.length() - ".bat".length());
                System.out.println("RINEARN Graph 3D Ver." + string2);
                System.exit(0);
            }
            System.out.println("RINEARN Graph 3D Ver.?.?.?");
            System.exit(0);
        }
        if (parsedCommandContainer.isDirSpecified) {
            // empty if block
        }
        if (parsedCommandContainer.isConfigSpecified) {
            try {
                this.graph3D.loadConfigurationFile(new File(parsedCommandContainer.configFilePath));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (parsedCommandContainer.isQuickSpecified) {
            try {
                this.graph3D.loadConfigurationFile(new File(parsedCommandContainer.quickFilePath));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (parsedCommandContainer.dataFilePathList.size() != 0) {
            int n = parsedCommandContainer.dataFilePathList.size();
            objectArray = new File[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = new File(parsedCommandContainer.dataFilePathList.get(i));
            }
            try {
                this.graph3D.openDataFiles((File[])objectArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (parsedCommandContainer.isSaveimgSpecified) {
            double d = parsedCommandContainer.isImgqualSpecified ? parsedCommandContainer.imgqualRatio : 100.0;
            try {
                this.graph3D.exportImageFile(new File(parsedCommandContainer.saveimgFilePath), d);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (parsedCommandContainer.isQuitSpecified) {
            this.graph3D.getImage();
            System.exit(0);
        }
    }

    private ParsedCommandContainer parseCommands(String[] stringArray) {
        ParsedCommandContainer parsedCommandContainer = new ParsedCommandContainer();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.toLowerCase().equals("--quit")) {
                parsedCommandContainer.isQuitSpecified = true;
                ++n2;
                continue;
            }
            if (string.toLowerCase().equals("--version")) {
                parsedCommandContainer.isVersionSpecified = true;
                ++n2;
                continue;
            }
            if (string.toLowerCase().equals("--help")) {
                parsedCommandContainer.isHelpSpecified = true;
                ++n2;
                continue;
            }
            if (string.toLowerCase().equals("--overwrite")) {
                parsedCommandContainer.isOverwriteSpecified = true;
                ++n2;
                continue;
            }
            if (string.toLowerCase().equals("--dir")) {
                parsedCommandContainer.isDirSpecified = true;
                if (++n2 < n) {
                    parsedCommandContainer.dirPath = stringArray[n2];
                }
                ++n2;
                continue;
            }
            if (string.toLowerCase().equals("--saveimg")) {
                parsedCommandContainer.isSaveimgSpecified = true;
                if (++n2 < n) {
                    parsedCommandContainer.saveimgFilePath = stringArray[n2];
                }
                ++n2;
                continue;
            }
            if (string.toLowerCase().equals("--config")) {
                parsedCommandContainer.isConfigSpecified = true;
                if (++n2 < n) {
                    parsedCommandContainer.configFilePath = stringArray[n2];
                }
                ++n2;
                continue;
            }
            if (string.toLowerCase().equals("--quick")) {
                parsedCommandContainer.isQuickSpecified = true;
                if (++n2 < n) {
                    parsedCommandContainer.quickFilePath = stringArray[n2];
                }
                ++n2;
                continue;
            }
            if (string.toLowerCase().equals("--imgqual")) {
                parsedCommandContainer.isImgqualSpecified = true;
                if (++n2 < n) {
                    parsedCommandContainer.imgqualText = stringArray[n2];
                }
                ++n2;
                continue;
            }
            parsedCommandContainer.dataFilePathList.add(stringArray[n2]);
            ++n2;
        }
        return parsedCommandContainer;
    }

    private void validateOptionValueExistances(ParsedCommandContainer parsedCommandContainer) {
        if (parsedCommandContainer.isDirSpecified && parsedCommandContainer.dirPath == null) {
            if (isJapanese) {
                Graph3DCommandController.err("\u300c --dir \u300d\u306e\u76f4\u5f8c\u306b\u3001\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                Graph3DCommandController.err("Just after \"--dir\", please specify the path of the current directory.");
            }
            Graph3DCommandController.exit(2);
        }
        if (parsedCommandContainer.isConfigSpecified && parsedCommandContainer.isQuickSpecified) {
            if (isJapanese) {
                Graph3DCommandController.err("\u300c --config \u300d\u3068\u300c --quick \u300d\u306f\u4f75\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
            } else {
                Graph3DCommandController.err("Cannot specify both \"--config\" and \"--quick\".");
            }
            Graph3DCommandController.exit(2);
        }
        if (parsedCommandContainer.isConfigSpecified && parsedCommandContainer.configFilePath == null) {
            if (isJapanese) {
                Graph3DCommandController.err("\u300c --config \u300d\u306e\u76f4\u5f8c\u306b\u3001\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                Graph3DCommandController.err("Just after \"--config\", please specify the configuration file to be loaded.");
            }
            Graph3DCommandController.exit(2);
        }
        if (parsedCommandContainer.isQuickSpecified && parsedCommandContainer.quickFilePath == null) {
            if (isJapanese) {
                Graph3DCommandController.err("\u300c --quick \u300d\u306e\u76f4\u5f8c\u306b\u3001\u30af\u30a4\u30c3\u30af\u8a2d\u5b9a\u30d5\u30a9\u30eb\u30c0\u5185\u306e\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                Graph3DCommandController.err("Just after \"--quick\", please specify the configuration file (in quick-setting folder) to be loaded.");
            }
            Graph3DCommandController.exit(2);
        }
        if (parsedCommandContainer.isSaveimgSpecified && parsedCommandContainer.saveimgFilePath == null) {
            if (isJapanese) {
                Graph3DCommandController.err("\u300c --saveimg \u300d\u306e\u76f4\u5f8c\u306b\u3001\u51fa\u529b\u3059\u308b\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                Graph3DCommandController.err("Just after \"--config\", please specify the image file to be saved.");
            }
            Graph3DCommandController.exit(2);
        }
        if (parsedCommandContainer.isImgqualSpecified && parsedCommandContainer.imgqualText == null) {
            if (isJapanese) {
                Graph3DCommandController.err("\u300c --imgqual \u300d\u306e\u76f4\u5f8c\u306b\u3001\u51fa\u529b\u753b\u50cf\u306e\u54c1\u8cea\u3092\u30010.0 \u304b\u3089 1.0 (\u307e\u305f\u306f 1.0 \u304b\u3089 100.0)\u306e\u7bc4\u56f2\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else {
                Graph3DCommandController.err("Just after \"--imgqual\", please specify the quality of the saved image file from 0.0 to 1.0 (or from 1.0 to 100.0).");
            }
            Graph3DCommandController.exit(2);
        }
    }

    private String getNormalizedFilePath(File file) {
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.isAbsolute() ? file.getPath() : file.getAbsolutePath();
        }
        return string;
    }

    private void validateAndSupplementOptionValues(ParsedCommandContainer parsedCommandContainer) {
        Object object;
        Object object2;
        File file;
        File file2 = null;
        if (parsedCommandContainer.isDirSpecified) {
            file2 = new File(parsedCommandContainer.dirPath);
            if (file2.exists()) {
                parsedCommandContainer.dirPath = this.getNormalizedFilePath(file2);
            } else {
                if (isJapanese) {
                    Graph3DCommandController.err("\u300c --dir \u300d\u306b\u6307\u5b9a\u3055\u308c\u305f\u30d1\u30b9\u304c\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u4f7f\u7528\u53ef\u80fd\u306a\u30d5\u30a9\u30eb\u30c0\uff08\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff09\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + file2.getPath());
                } else {
                    Graph3DCommandController.err("The path specified to \"--dir\" does not exist, or is not available folder (directory): " + file2.getPath());
                }
                Graph3DCommandController.exit(2);
            }
        }
        if (parsedCommandContainer.isConfigSpecified) {
            if (parsedCommandContainer.configFilePath.startsWith("-")) {
                if (isJapanese) {
                    Graph3DCommandController.err("\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u3067\u306f\u3001\u300c-\u300d\u3067\u59cb\u307e\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u3068\u306e\u533a\u5225\u304c\u7d1b\u3089\u308f\u3057\u3044\u305f\u3081\u3001\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093: " + parsedCommandContainer.configFilePath + EOL + "(\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u53ef\u89e3\u306a\u5834\u5408\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u304c\u629c\u3051\u3066\u3044\u3066\u3001\u6b21\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u304c\u30d5\u30a1\u30a4\u30eb\u6307\u5b9a\u3068\u8aa4\u8a8d\u8b58\u3055\u308c\u3066\u3044\u308b\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002\u307e\u305f\u306f\u3001\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u304c\u9593\u9055\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u3082\u3042\u308a\u307e\u3059\u3002)");
                } else {
                    Graph3DCommandController.err("In command-line mode, cannot specify the file of which name starts with \"-\", because it is confusing with an option name: " + parsedCommandContainer.configFilePath + EOL + "(If this message is strange for you, probably you forgot to specify a file so the next option name is regarded as a file name. Or, the specified option name may be incorrect.)");
                }
                Graph3DCommandController.exit(2);
            }
            if (!(file = new File(parsedCommandContainer.configFilePath)).isAbsolute() && file2 != null) {
                file = new File(file2, parsedCommandContainer.configFilePath);
            }
            if (file.exists()) {
                parsedCommandContainer.configFilePath = this.getNormalizedFilePath(file);
            } else {
                if (isJapanese) {
                    Graph3DCommandController.err("\u300c --config \u300d\u306b\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + file.getPath());
                } else {
                    Graph3DCommandController.err("The config file specified to \"--config\" does not exist: " + file.getPath());
                }
                Graph3DCommandController.exit(2);
            }
        }
        if (parsedCommandContainer.isQuickSpecified) {
            if (parsedCommandContainer.quickFilePath.startsWith("-")) {
                if (isJapanese) {
                    Graph3DCommandController.err("\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u3067\u306f\u3001\u300c-\u300d\u3067\u59cb\u307e\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u3068\u306e\u533a\u5225\u304c\u7d1b\u3089\u308f\u3057\u3044\u305f\u3081\u3001\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093: " + parsedCommandContainer.quickFilePath + EOL + "(\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u53ef\u89e3\u306a\u5834\u5408\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u304c\u629c\u3051\u3066\u3044\u3066\u3001\u6b21\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u304c\u30d5\u30a1\u30a4\u30eb\u6307\u5b9a\u3068\u8aa4\u8a8d\u8b58\u3055\u308c\u3066\u3044\u308b\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002)");
                } else {
                    Graph3DCommandController.err("In command-line mode, cannot specify the file of which name starts with \"-\", because it is confusing with an option name: " + parsedCommandContainer.quickFilePath + EOL + "(If this message is strange for you, probably you forgot to specify a file so the next option name is regarded as a file name.)");
                }
                Graph3DCommandController.exit(2);
            }
            if (((File)(object2 = new File(file = new File("RinearnGraph3DQuickSetting"), parsedCommandContainer.quickFilePath))).exists()) {
                parsedCommandContainer.quickFilePath = this.getNormalizedFilePath((File)object2);
            } else {
                if (isJapanese) {
                    Graph3DCommandController.err("\u300c --quick \u300d\u306b\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + ((File)object2).getPath());
                } else {
                    Graph3DCommandController.err("The config file specified to \"--quick\" does not exist: " + ((File)object2).getPath());
                }
                Graph3DCommandController.exit(2);
            }
        }
        if (parsedCommandContainer.isSaveimgSpecified) {
            if (parsedCommandContainer.saveimgFilePath.startsWith("-")) {
                if (isJapanese) {
                    Graph3DCommandController.err("\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u3067\u306f\u3001\u300c-\u300d\u3067\u59cb\u307e\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u3068\u306e\u533a\u5225\u304c\u7d1b\u3089\u308f\u3057\u3044\u305f\u3081\u3001\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093: " + parsedCommandContainer.saveimgFilePath + EOL + "(\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u53ef\u89e3\u306a\u5834\u5408\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u304c\u629c\u3051\u3066\u3044\u3066\u3001\u6b21\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u304c\u30d5\u30a1\u30a4\u30eb\u6307\u5b9a\u3068\u8aa4\u8a8d\u8b58\u3055\u308c\u3066\u3044\u308b\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002)");
                } else {
                    Graph3DCommandController.err("In command-line mode, cannot specify the file of which name starts with \"-\", because it is confusing with an option name: " + parsedCommandContainer.saveimgFilePath + EOL + "(If this message is strange for you, probably you forgot to specify a file so the next option name is regarded as a file name.)");
                }
                Graph3DCommandController.exit(2);
            }
            if (!(file = new File(parsedCommandContainer.saveimgFilePath)).isAbsolute() && file2 != null) {
                file = new File(file2, parsedCommandContainer.saveimgFilePath);
            }
            parsedCommandContainer.saveimgFilePath = this.getNormalizedFilePath(file);
            if (file.exists() && !parsedCommandContainer.isOverwriteSpecified) {
                if (isJapanese) {
                    System.out.print(EOL + "\u300c --saveimg \u300d\u5bfe\u8c61\u306e\u4ee5\u4e0b\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u3001\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059: " + parsedCommandContainer.saveimgFilePath + EOL + EOL + "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f yes \u304b no\u3001\u307e\u305f\u306f y \u304b n \u3092\u5165\u529b:");
                } else {
                    System.out.print(EOL + "The file specified to \"--saveimg\" option is already exists." + EOL + parsedCommandContainer.saveimgFilePath + EOL + EOL + " Do you overwrite this file? Please answer yes/no, or y/n:");
                }
                object2 = new Scanner(System.in);
                object = ((Scanner)object2).nextLine().toLowerCase().trim();
                if (!((String)object).equals("yes") && !((String)object).equals("y")) {
                    if (isJapanese) {
                        Graph3DCommandController.err("\u30d5\u30a1\u30a4\u30eb\u306e\u4e0a\u66f8\u304d\u304c\u62d2\u5426\u3055\u308c\u307e\u3057\u305f\u3002");
                    } else {
                        Graph3DCommandController.err("Overwriting the file has been denied.");
                    }
                    Graph3DCommandController.exit(2);
                }
            }
        }
        if (parsedCommandContainer.isImgqualSpecified) {
            try {
                parsedCommandContainer.imgqualRatio = Double.parseDouble(parsedCommandContainer.imgqualText);
            }
            catch (NumberFormatException numberFormatException) {
                if (isJapanese) {
                    Graph3DCommandController.err("\u300c --imgqual \u300d\u306e\u5024\u304c\u7121\u52b9\u3067\u3059\u3002 0.0 \u304b\u3089 1.0 (\u307e\u305f\u306f 1.0 \u304b\u3089 100.0)\u306e\u7bc4\u56f2\u3067\u3001\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                } else {
                    Graph3DCommandController.err("The value specified to \"--imgqual\" is invalid. Please specify a numerical value from 0.0 to 1.0 (or from 1.0 to 100.0).");
                }
                Graph3DCommandController.exit(2);
            }
            if (parsedCommandContainer.imgqualRatio < 0.0 || 100.0 < parsedCommandContainer.imgqualRatio) {
                if (isJapanese) {
                    Graph3DCommandController.err("\u300c --imgqual \u300d\u306e\u5024\u304c\u7121\u52b9\u3067\u3059\u3002 0.0 \u304b\u3089 1.0 (\u307e\u305f\u306f 1.0 \u304b\u3089 100.0)\u306e\u7bc4\u56f2\u3067\u3001\u6570\u5024\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                } else {
                    Graph3DCommandController.err("The value specified to \"--imgqual\" is invalid. Please specify a numerical value from 0.0 to 1.0 (or from 1.0 to 100.0).");
                }
                Graph3DCommandController.exit(2);
            }
        }
        for (int i = 0; i < parsedCommandContainer.dataFilePathList.size(); ++i) {
            object2 = parsedCommandContainer.dataFilePathList.get(i);
            if (((String)object2).startsWith("-")) {
                if (isJapanese) {
                    Graph3DCommandController.err("\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u30e2\u30fc\u30c9\u3067\u306f\u3001\u300c-\u300d\u3067\u59cb\u307e\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u3068\u306e\u533a\u5225\u304c\u7d1b\u3089\u308f\u3057\u3044\u305f\u3081\u3001\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093: " + (String)object2 + EOL + "(\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u53ef\u89e3\u306a\u5834\u5408\u3001\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u304c\u629c\u3051\u3066\u3044\u3066\u3001\u6b21\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u540d\u304c\u30d5\u30a1\u30a4\u30eb\u6307\u5b9a\u3068\u8aa4\u8a8d\u8b58\u3055\u308c\u3066\u3044\u308b\u304b\u3082\u3057\u308c\u307e\u305b\u3093\u3002)");
                } else {
                    Graph3DCommandController.err("In command-line mode, cannot specify the file of which name starts with \"-\", because it is confusing with an option name: " + (String)object2 + EOL + "(If this message is strange for you, probably you forgot to specify a file so the next option name is regarded as a file name.)");
                }
                Graph3DCommandController.exit(2);
            }
            if (!((File)(object = new File((String)object2))).isAbsolute() && file2 != null) {
                object = new File(file2, (String)object2);
            }
            if (((File)object).exists()) {
                parsedCommandContainer.dataFilePathList.set(i, this.getNormalizedFilePath((File)object));
                continue;
            }
            if (isJapanese) {
                Graph3DCommandController.err("\u6307\u5b9a\u3055\u308c\u305f\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + ((File)object).getPath());
            } else {
                Graph3DCommandController.err("The specified data file does not exist: " + ((File)object).getPath());
            }
            Graph3DCommandController.exit(2);
        }
    }

    static {
        Locale locale = Locale.getDefault();
        isJapanese = locale.getLanguage() != null && locale.getLanguage().toLowerCase().equals("ja") || locale.getCountry() != null && locale.getCountry().toLowerCase().equals("jp");
        EOL = System.getProperty("line.separator");
    }

    private class ParsedCommandContainer {
        public boolean isDirSpecified = false;
        public String dirPath = null;
        public boolean isConfigSpecified = false;
        public String configFilePath = null;
        public boolean isSaveimgSpecified = false;
        public String saveimgFilePath = null;
        public boolean isQuickSpecified = false;
        public String quickFilePath = null;
        public boolean isImgqualSpecified = false;
        public String imgqualText = null;
        public double imgqualRatio = Double.NaN;
        public boolean isOverwriteSpecified = false;
        public boolean isQuitSpecified = false;
        public boolean isHelpSpecified = false;
        public boolean isVersionSpecified = false;
        public List<String> dataFilePathList = new ArrayList<String>();

        private ParsedCommandContainer() {
        }

        public String dump() {
            String string = "";
            if (this.isDirSpecified) {
                string = string + "--dir ";
                string = string + this.dirPath + " ";
            }
            if (this.isConfigSpecified) {
                string = string + "--config ";
                string = string + this.configFilePath + " ";
            }
            if (this.isQuickSpecified) {
                string = string + "--quick ";
                string = string + this.quickFilePath + " ";
            }
            if (this.isSaveimgSpecified) {
                string = string + "--saveimg ";
                string = string + this.saveimgFilePath + " ";
            }
            if (this.isImgqualSpecified) {
                string = string + "--imgqual ";
                string = string + this.imgqualRatio + " ";
            }
            if (this.isOverwriteSpecified) {
                string = string + "--overwrite ";
            }
            if (this.isQuitSpecified) {
                string = string + "--quit ";
            }
            if (this.isHelpSpecified) {
                string = string + "--help ";
            }
            if (this.isVersionSpecified) {
                string = string + "--version ";
            }
            for (String string2 : this.dataFilePathList) {
                string = string + string2 + " ";
            }
            return string;
        }
    }
}

