/*
 * Decompiled with CFR 0.152.
 */
package org.vcssl.connect;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.vcssl.connect.ConnectorException;
import org.vcssl.connect.ConnectorImplementationContainer;
import org.vcssl.connect.ExternalFunctionConnectorInterface1;
import org.vcssl.connect.ExternalVariableConnectorInterface1;
import org.vcssl.connect.GeneralProcessConnectorInterface1;
import org.vcssl.connect.GeneralProcessConnectorInterface2;
import org.vcssl.connect.GeneralProcessConnectorInterface3;

public class ConnectorImplementationLoader {
    private static final String[] DEFAULT_LOADING_PATHS = new String[]{"."};
    private static final String INTERFACE_TYPE_ID_FIELD_NAME = "INTERFACE_TYPE_ID";
    private static final String INTERFACE_GENERATION_FIELD_NAME = "INTERFACE_GENERATION";
    private ClassLoader classLoader = null;
    private boolean interfaceFilterEnabled = false;

    public ConnectorImplementationLoader() {
        this.classLoader = null;
    }

    public ConnectorImplementationLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void initializeDefaultClassLoader(String[] stringArray) throws MalformedURLException {
        int n = stringArray.length;
        URL[] uRLArray = new URL[n];
        for (int i = 0; i < n; ++i) {
            URL uRL;
            File file = new File(stringArray[i]);
            uRLArray[i] = uRL = file.toURI().toURL();
        }
        this.classLoader = new URLClassLoader(uRLArray);
    }

    public void setInterfaceFilterEnabled(boolean bl) {
        this.interfaceFilterEnabled = bl;
    }

    public boolean isInterfaceFilterEnabled() {
        return this.interfaceFilterEnabled;
    }

    public ConnectorImplementationContainer load(String string) throws ConnectorException {
        Object object;
        String string2;
        String string3;
        Object var3_5;
        block11: {
            if (this.classLoader == null) {
                try {
                    this.initializeDefaultClassLoader(DEFAULT_LOADING_PATHS);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ConnectorException("ClassLoader initialization failed.", malformedURLException);
                }
            }
            Class<?> clazz = null;
            try {
                clazz = this.classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConnectorException("Loading failed: " + string, classNotFoundException);
            }
            var3_5 = null;
            try {
                var3_5 = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                throw new ConnectorException("Instantiation failed: " + string, exception);
            }
            string3 = null;
            string2 = null;
            try {
                object = clazz.getField(INTERFACE_TYPE_ID_FIELD_NAME);
                Field field = clazz.getField(INTERFACE_GENERATION_FIELD_NAME);
                string3 = ((Field)object).get(null).toString();
                string2 = field.get(null).toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                if (var3_5 instanceof GeneralProcessConnectorInterface2) {
                    string3 = "GPCI";
                    string2 = "2";
                }
                if (var3_5 instanceof GeneralProcessConnectorInterface1) {
                    string3 = "GPCI";
                    string2 = "1";
                }
                if (!this.interfaceFilterEnabled) break block11;
                throw new ConnectorException("Invalid implementation (unknown interface): " + string + " (interface-type-id: " + string3 + ", interface-generation: " + string2 + ")", exception);
            }
        }
        object = new ConnectorImplementationContainer(var3_5, string3, string2);
        this.checkImplementation((ConnectorImplementationContainer)object, string);
        return object;
    }

    private void checkImplementation(ConnectorImplementationContainer connectorImplementationContainer, String string) throws ConnectorException {
        String string2;
        String string3 = connectorImplementationContainer.getInterfaceTypeId();
        String string4 = connectorImplementationContainer.getInterfaceGeneration();
        if (string3 == null) {
            if (!this.interfaceFilterEnabled) {
                return;
            }
            throw new ConnectorException("Invalid implementation (null interface-type-id): " + string);
        }
        if (string4 == null) {
            throw new ConnectorException("Invalid implementation (null interface-generation): " + string);
        }
        Object object = connectorImplementationContainer.getConnectorImplementation();
        switch (string2 = connectorImplementationContainer.getInterfaceTypeId() + connectorImplementationContainer.getInterfaceGeneration()) {
            case "XFCI1": {
                if (object instanceof ExternalFunctionConnectorInterface1) break;
                throw new ConnectorException("Invalid implementation (should implement org.vcssl.connect.ExternalFunctionConnectorInterface1): " + string);
            }
            case "XVCI1": {
                if (object instanceof ExternalVariableConnectorInterface1) break;
                throw new ConnectorException("Invalid implementation (should implement org.vcssl.connect.ExternalVariableConnectorInterface1): " + string);
            }
            case "GPCI1": {
                if (object instanceof GeneralProcessConnectorInterface1) break;
                throw new ConnectorException("Invalid implementation (should implement org.vcssl.connect.GeneralProcessConnectorInterface1): " + string);
            }
            case "GPCI2": {
                if (object instanceof GeneralProcessConnectorInterface2) break;
                throw new ConnectorException("Invalid implementation (should implement org.vcssl.connect.GeneralProcessConnectorInterface2): " + string);
            }
            case "GPCI3": {
                if (object instanceof GeneralProcessConnectorInterface3) break;
                throw new ConnectorException("Invalid implementation (should implement org.vcssl.connect.GeneralProcessConnectorInterface3): " + string);
            }
            default: {
                if (!this.interfaceFilterEnabled) break;
                throw new ConnectorException("Invalid implementation (unsupported interface): " + string + " (interface-type-id: " + string3 + ", interface-generation: " + string4 + ")");
            }
        }
    }
}

