/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public class CSVNamedParameterReader {
    private String[][] cache;

    public CSVNamedParameterReader() {
    }

    public CSVNamedParameterReader(URL uRL) {
        this.open(uRL);
    }

    public CSVNamedParameterReader(URL uRL, String string) {
        this.open(uRL, string);
    }

    public CSVNamedParameterReader(File file) {
        this.openFile(file.getPath());
    }

    public CSVNamedParameterReader(File file, String string) {
        this.openFile(file.getPath(), string);
    }

    public CSVNamedParameterReader(String string) {
        this.decodeString(string);
    }

    private String search(String string) {
        int n = this.cache.length;
        for (int i = 0; i < n; ++i) {
            if (this.cache[i][0] == null || !this.cache[i][0].equals(string)) continue;
            return this.cache[i][1];
        }
        return null;
    }

    public long readLong(String string) {
        try {
            try {
                return Long.parseLong(this.search(string));
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        catch (NullPointerException nullPointerException) {
            return 0L;
        }
    }

    public int readInteger(String string) {
        try {
            try {
                return Integer.parseInt(this.search(string));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public short readShort(String string) {
        try {
            try {
                return Short.parseShort(this.search(string));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public byte readByte(String string) {
        try {
            try {
                return Byte.parseByte(this.search(string));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public double readDouble(String string) {
        try {
            try {
                return Double.parseDouble(this.search(string));
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        catch (NullPointerException nullPointerException) {
            return 0.0;
        }
    }

    public float readFloat(String string) {
        try {
            try {
                return Float.parseFloat(this.search(string));
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0f;
            }
        }
        catch (NullPointerException nullPointerException) {
            return 0.0f;
        }
    }

    public String readString(String string) {
        try {
            return this.search(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void decodeString(String string) {
        String string2 = this.getBestLineFeedCode(string);
        String[] stringArray = string.split(string2, -1);
        int n = stringArray.length;
        this.cache = new String[n][2];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringArray[i].replaceAll(" ", "");
            stringArray[i] = stringArray[i].replaceAll("\t", "");
            String[] stringArray2 = stringArray[i].split(",");
            if (stringArray2.length < 2) continue;
            this.cache[i][0] = stringArray2[0];
            this.cache[i][1] = stringArray2[1];
        }
    }

    public void open(String string) {
        this.decodeString(string);
    }

    public void open(File file, String string) {
        this.openFile(file.getPath(), string);
    }

    public void open(File file) {
        this.openFile(file.getPath());
    }

    public void openFile(String string) {
        BufferedReader bufferedReader;
        FileReader fileReader;
        String string2 = "";
        String string3 = System.getProperty("line.separator");
        int n = 1;
        try {
            try {
                fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader);
                n = 0;
                while (bufferedReader.readLine() != null) {
                    ++n;
                }
                fileReader.close();
                fileReader = null;
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessage(3, string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            try {
                fileReader = new FileReader(string);
                bufferedReader = new BufferedReader(fileReader);
                StringBuffer stringBuffer = new StringBuffer(100 * n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(bufferedReader.readLine());
                    stringBuffer.append(string3);
                }
                string2 = string2 + new String(stringBuffer);
                stringBuffer = null;
                fileReader.close();
                fileReader = null;
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessage(3, string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.decodeString(string2);
    }

    public void openFile(String string, String string2) {
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        String string3 = "";
        String string4 = System.getProperty("line.separator");
        int n = 1;
        try {
            try {
                fileInputStream = new FileInputStream(string);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string2);
                bufferedReader = new BufferedReader(inputStreamReader);
                n = 0;
                while (bufferedReader.readLine() != null) {
                    ++n;
                }
                fileInputStream.close();
                fileInputStream = null;
                inputStreamReader.close();
                inputStreamReader = null;
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessage(3, string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            try {
                fileInputStream = new FileInputStream(string);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string2);
                bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer(100 * n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(bufferedReader.readLine());
                    stringBuffer.append(string4);
                }
                string3 = string3 + new String(stringBuffer);
                stringBuffer = null;
                fileInputStream.close();
                fileInputStream = null;
                inputStreamReader.close();
                inputStreamReader = null;
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessage(3, string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.decodeString(string3);
    }

    public void open(URL uRL) {
        Reader reader;
        InputStream inputStream;
        URLConnection uRLConnection;
        String string = "";
        String string2 = System.getProperty("line.separator");
        int n = 1;
        try {
            try {
                uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                n = 0;
                while (((BufferedReader)reader).readLine() != null) {
                    ++n;
                }
                uRLConnection = null;
                inputStream.close();
                inputStream = null;
                ((BufferedReader)reader).close();
                reader = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessage(3, uRL.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            try {
                uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                reader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(reader);
                StringBuffer stringBuffer = new StringBuffer(100 * n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(bufferedReader.readLine());
                    stringBuffer.append(string2);
                }
                string = string + new String(stringBuffer);
                stringBuffer = null;
                uRLConnection = null;
                ((InputStreamReader)reader).close();
                reader = null;
                inputStream.close();
                inputStream = null;
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessage(3, uRL.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.decodeString(string);
    }

    public void open(URL uRL, String string) {
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        InputStream inputStream;
        URLConnection uRLConnection;
        String string2 = "";
        String string3 = System.getProperty("line.separator");
        int n = 1;
        try {
            try {
                uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream, string);
                bufferedReader = new BufferedReader(inputStreamReader);
                n = 0;
                while (bufferedReader.readLine() != null) {
                    ++n;
                }
                uRLConnection = null;
                inputStream.close();
                inputStream = null;
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessage(3, uRL.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            try {
                uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream, string);
                bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer(100 * n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(bufferedReader.readLine());
                    stringBuffer.append(string3);
                }
                string2 = string2 + new String(stringBuffer);
                stringBuffer = null;
                uRLConnection = null;
                inputStream.close();
                inputStream = null;
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessage(3, uRL.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.decodeString(string2);
    }

    private String getBestLineFeedCode(String string) {
        String string2 = System.getProperty("line.separator");
        String[] stringArray = (string = string + string2).split(string2, -1);
        if (stringArray.length <= 1) {
            stringArray = string.split("\r", -1);
            string2 = "\r";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\n", -1);
            string2 = "\n";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\n\r", -1);
            string2 = "\n\r";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\r\n", -1);
            string2 = "\r\n";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("CR", -1);
            string2 = "CR";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("LF", -1);
            string2 = "LF";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("CR+LF", -1);
            string2 = "CR+LF";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("LF+CR", -1);
            string2 = "LF+CR";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\u0000X0A", -1);
            string2 = "\u0000X0A";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\u0000X0D", -1);
            string2 = "\u0000X0D";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\u0000X0A\u0000X0D", -1);
            string2 = "\u0000X0A\u0000X0D";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\u0000X0D\u0000X0A", -1);
            string2 = "\u0000X0D\u0000X0A";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\u0000x0a", -1);
            string2 = "\u0000x0a";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\u0000x0d", -1);
            string2 = "\u0000x0d";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\u0000x0a\u0000x0d", -1);
            string2 = "\u0000x0a\u0000x0d";
        }
        if (stringArray.length <= 1) {
            stringArray = string.split("\u0000x0d\u0000x0a", -1);
            string2 = "\u0000x0d\u0000x0a";
        }
        return string2;
    }

    private void showErrorMessage(int n, String string) {
        if (n == 3) {
            System.out.println("-----------------------------------------");
            System.out.println("CSVNamedParameterReader\uff1a\u3000\u30a8\u30e9\u30fc003\uff08\u30d5\u30a1\u30a4\u30eb\u306e\u4e0d\u5728\uff09");
            System.out.println("\u30a8\u30e9\u30fc\u8a73\u7d30\uff1a \u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059\u3002\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u306f\u3001\u73fe\u5728\u4f5c\u696d\u4e2d\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\uff08\u30d5\u30a9\u30eb\u30c0\uff09\u5185\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            System.out.println("\u554f\u984c\u306e\u30d5\u30a1\u30a4\u30eb\uff1a " + string);
            System.out.println("");
        }
        if (n == 4) {
            System.out.println("-----------------------------------------");
            System.out.println("CSVNamedParameterReader\uff1a\u3000\u30a8\u30e9\u30fc004\uff08\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u4e0d\u5728\uff09");
            System.out.println("\u30a8\u30e9\u30fc\u8a73\u7d30\uff1a \u6307\u5b9a\u3055\u308c\u305f\u540d\u79f0\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u63a2\u3057\u307e\u3057\u305f\u304c\u3001\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            System.out.println("\u554f\u984c\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\uff1a " + string);
            System.out.println("");
        }
    }
}

