/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class CSVVertexReader {
    private BufferedReader br;
    private int line_N;
    private String lfc = System.getProperty("line.separator");
    private FileReader fr;
    private URLConnection connect;
    private InputStream is;
    private FileInputStream fis;
    private InputStreamReader isr;

    public CSVVertexReader() {
    }

    public CSVVertexReader(File file) {
        this.open(file);
    }

    public CSVVertexReader(URL uRL) {
        this.open(uRL);
    }

    public boolean exists() {
        return this.br != null;
    }

    public int getLineNumber() {
        return this.line_N;
    }

    public int getLineCount() {
        return this.line_N;
    }

    public double[] readDouble() {
        String string = "";
        try {
            string = this.br.readLine();
            String[] stringArray = string.split(",");
            double[] dArray = new double[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    dArray[i] = Double.parseDouble(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return dArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public float[] readFloat() {
        String string = "";
        try {
            string = this.br.readLine();
            String[] stringArray = string.split(",");
            float[] fArray = new float[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    fArray[i] = Float.parseFloat(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return fArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public long[] readLong() {
        String string = "";
        try {
            string = this.br.readLine();
            String[] stringArray = string.split(",");
            long[] lArray = new long[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    lArray[i] = Long.parseLong(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return lArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int[] readInteger() {
        String string = "";
        try {
            string = this.br.readLine();
            String[] stringArray = string.split(",");
            int[] nArray = new int[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return nArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public short[] readShort() {
        String string = "";
        try {
            string = this.br.readLine();
            String[] stringArray = string.split(",");
            short[] sArray = new short[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    sArray[i] = Short.parseShort(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return sArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] readByte() {
        String string = "";
        try {
            string = this.br.readLine();
            String[] stringArray = string.split(",");
            byte[] byArray = new byte[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    byArray[i] = Byte.parseByte(stringArray[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String[] readString() {
        String string = "";
        try {
            string = this.br.readLine();
            String[] stringArray = string.split(",");
            return stringArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String readLine() {
        String string = "";
        try {
            string = this.br.readLine();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void open(File file) {
        this.openFile(file.getPath());
    }

    public void open(File file, String string) {
        this.openFile(file.getPath(), string);
    }

    public void openFile(String string) {
        String string2 = "";
        this.line_N = 0;
        try {
            try {
                this.fr = new FileReader(string);
                this.br = new BufferedReader(this.fr);
                this.line_N = 0;
                while (this.br.readLine() != null) {
                    ++this.line_N;
                }
                this.fr.close();
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.fr = new FileReader(string);
            this.br = new BufferedReader(this.fr);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void openFile(String string, String string2) {
        String string3 = "";
        this.line_N = 0;
        try {
            try {
                this.fis = new FileInputStream(string);
                this.isr = new InputStreamReader((InputStream)this.fis, string2);
                this.br = new BufferedReader(this.isr);
                this.line_N = 0;
                while (this.br.readLine() != null) {
                    ++this.line_N;
                }
                this.fis.close();
                this.fis = null;
                this.isr.close();
                this.isr = null;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            try {
                this.fis = new FileInputStream(string);
                this.isr = new InputStreamReader((InputStream)this.fis, string2);
                this.br = new BufferedReader(this.isr);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void open(URL uRL) {
        String string = "";
        this.line_N = 0;
        try {
            try {
                this.connect = uRL.openConnection();
                this.is = this.connect.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
                this.line_N = 0;
                while (this.br.readLine() != null) {
                    ++this.line_N;
                }
                this.connect = null;
                this.is.close();
                this.is = null;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            try {
                this.connect = uRL.openConnection();
                this.is = this.connect.getInputStream();
                this.br = new BufferedReader(new InputStreamReader(this.is));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String load() {
        String string = "";
        try {
            try {
                String string2;
                while ((string2 = this.br.readLine()) != null) {
                    string = string + string2 + this.lfc;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public void close() {
        try {
            if (this.fr != null) {
                this.fr.close();
            }
            if (this.connect != null) {
                this.connect = null;
            }
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
            if (this.isr != null) {
                this.isr.close();
                this.isr = null;
            }
            this.br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.br = null;
    }
}

