/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessProgram;
import rxvesapi.process.ProcessSyntaxException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.connection.GeneralProcessConnectionInterfaceAdapter;
import rxvesapi.process.decode.ProcessCodeLoader;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.kernel.FunctionMacroKernel;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.scope.ProcessScope;
import rxvesapi.process.unit.AndUnit;
import rxvesapi.process.unit.ArrayAccessUnit;
import rxvesapi.process.unit.ArrayAccessWrapperUnit;
import rxvesapi.process.unit.ArrayAllocUnit;
import rxvesapi.process.unit.ArrayFreeUnit;
import rxvesapi.process.unit.ArrayLengthSubstitutionUnit;
import rxvesapi.process.unit.ArrayReduceUnit;
import rxvesapi.process.unit.BigComplexUnit;
import rxvesapi.process.unit.BigDecimalUnit;
import rxvesapi.process.unit.BigIntegerUnit;
import rxvesapi.process.unit.BooleanUnit;
import rxvesapi.process.unit.BracketUnit;
import rxvesapi.process.unit.CalcCallUnit;
import rxvesapi.process.unit.CastUnit;
import rxvesapi.process.unit.ComplexUnit;
import rxvesapi.process.unit.DecimalUnit;
import rxvesapi.process.unit.EqualUnit;
import rxvesapi.process.unit.EvalCallUnit;
import rxvesapi.process.unit.EvaluableUnit;
import rxvesapi.process.unit.FunctionCallUnit;
import rxvesapi.process.unit.GreaterEqualUnit;
import rxvesapi.process.unit.GreaterThanUnit;
import rxvesapi.process.unit.IntegerUnit;
import rxvesapi.process.unit.KernelCallUnit;
import rxvesapi.process.unit.LessEqualUnit;
import rxvesapi.process.unit.LessThanUnit;
import rxvesapi.process.unit.MinusUnit;
import rxvesapi.process.unit.NotEqualUnit;
import rxvesapi.process.unit.NullIntegerUnit;
import rxvesapi.process.unit.OrUnit;
import rxvesapi.process.unit.OverrideCallUnit;
import rxvesapi.process.unit.ProcessConnectionUnit;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.ReferenceUnit;
import rxvesapi.process.unit.ReverseUnit;
import rxvesapi.process.unit.SIMDAdditionUnit;
import rxvesapi.process.unit.SIMDDecrementUnit;
import rxvesapi.process.unit.SIMDDivisionUnit;
import rxvesapi.process.unit.SIMDIncrementUnit;
import rxvesapi.process.unit.SIMDMultiplicationUnit;
import rxvesapi.process.unit.SIMDPostDecrementUnit;
import rxvesapi.process.unit.SIMDPostIncrementUnit;
import rxvesapi.process.unit.SIMDPowerUnit;
import rxvesapi.process.unit.SIMDPoworUnit;
import rxvesapi.process.unit.SIMDRemainderUnit;
import rxvesapi.process.unit.SIMDSubstitutionUnit;
import rxvesapi.process.unit.SIMDSubtractionUnit;
import rxvesapi.process.unit.SISDAdditionUnit;
import rxvesapi.process.unit.SISDArraySubstitutionUnit;
import rxvesapi.process.unit.SISDDecrementUnit;
import rxvesapi.process.unit.SISDDivisionUnit;
import rxvesapi.process.unit.SISDIncrementUnit;
import rxvesapi.process.unit.SISDMultiplicationUnit;
import rxvesapi.process.unit.SISDPostDecrementUnit;
import rxvesapi.process.unit.SISDPostIncrementUnit;
import rxvesapi.process.unit.SISDPowerUnit;
import rxvesapi.process.unit.SISDRemainderUnit;
import rxvesapi.process.unit.SISDSubstitutionUnit;
import rxvesapi.process.unit.SISDSubtractionUnit;
import rxvesapi.process.unit.ScopeCallUnit;
import rxvesapi.process.unit.StringArrayUnit;
import rxvesapi.process.unit.StringUnit;
import rxvesapi.process.unit.StructAllocUnit;
import rxvesapi.process.unit.StructMemberAccessUnit;
import rxvesapi.process.unit.SystemFunctionUnit;
import rxvesapi.text.BufferedStringOperator;
import rxvesapi.text.StringSplitter;

public class ProcessCircuit {
    private boolean runtimeCompileSecurityState = false;
    public ProcessScope parentScope;
    ProcessProgram programInstance;
    public boolean constInitializer = false;
    public boolean usingFunctionCall = false;
    public boolean usingConstOnly = true;
    public boolean usingConstOnlyAtRight = true;
    public static int BINARY64 = 1064;
    public static int VARIABLE = 1010;
    public boolean usingVariable = false;
    public boolean usingBinary64 = false;
    public int processMode = BINARY64;
    public boolean FUNCTION_VARIABLE_CAST = false;
    public boolean useBracketUnit = false;
    public ProcessKernel kernel;
    private int cacheInitialCapacity;
    public int cacheCapacity = this.cacheInitialCapacity = 8;
    public int cacheRegistered = 0;
    private StringSplitter stringSplitter;
    public boolean avoidInteger = false;
    private String[] cutCode = new String[]{"SYSTEM_ESCAPE_LENGTH_EQUAL", "=", "+", "-", "*", "/", "%", "^", "&&", "||", "<", ">", "!", "$", "(", ")", "[", "]", ","};
    public ProcessUnit[] processUnit;
    public ProcessUnit rootUnit;
    public boolean error = false;
    private int counter = 0;
    public String formulaLine = "";
    public int circuitNumber = Integer.MAX_VALUE;
    public int kernelNumber = Integer.MAX_VALUE;
    public int scopeNumber = Integer.MAX_VALUE;
    public String errorMessage = "";
    public ProcessEngine processEngine;
    public String firstErrorMessage = "";
    public boolean firstErrorCalled = false;
    ProcessUnit nullIntUnit = null;
    String checkFunctionNameStock = null;
    String checkFunctionLibNameStock = null;
    FunctionCallKernel checkFunctionStock;

    public void setRuntimeCompileSecurity(boolean bl) {
        this.runtimeCompileSecurityState = bl;
    }

    void checkWarning(FunctionCallKernel functionCallKernel) {
        ProcessProgram processProgram = functionCallKernel.programInstance;
        if (processProgram != null) {
            ProcessCompatibilityException processCompatibilityException;
            String string = processProgram.getName();
            String string2 = functionCallKernel.getFunctionName();
            if (string == null || string2 == null) {
                return;
            }
            if (string.equals("Text") && string2.equals("match") && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("Text.match \u306e\u4f7f\u7528\u306f\u63a8\u5968\u3055\u308c\u307e\u305b\u3093\u3002\u540c\u3058\u4ed5\u69d8\u306e Text.matchFirst \u306b\u7f6e\u304d\u63db\u3048\u3066\u4e0b\u3055\u3044\u3002");
                } else {
                    this.error("\"Text.match\" is deprecated. Please use \"Text.matchFirst\" instead.");
                }
            }
        }
    }

    public ProcessCircuit(String string, int n, int n2, int n3, ProcessEngine processEngine) {
        this.formulaLine = string;
        this.circuitNumber = n;
        this.kernelNumber = n2;
        this.scopeNumber = n3;
        this.cacheRegistered = 0;
        this.cacheCapacity = this.cacheInitialCapacity;
        this.processEngine = processEngine;
        this.processUnit = new ProcessUnit[this.cacheCapacity];
        this.stringSplitter = new StringSplitter();
        this.rootUnit = new IntegerUnit("0", this.processEngine);
    }

    public void nullResource() {
        this.parentScope = null;
        this.programInstance = null;
        this.counter = 0;
        for (int i = 0; i < this.cacheRegistered; ++i) {
            this.processUnit[i] = null;
        }
        this.rootUnit = null;
        this.formulaLine = null;
        this.errorMessage = null;
        this.processEngine = null;
        this.stringSplitter = null;
    }

    public void disposeResource() {
        this.parentScope = null;
        this.programInstance = null;
        this.counter = 0;
        for (int i = 0; i < this.cacheRegistered; ++i) {
            this.processUnit[i].disposeResource();
            this.processUnit[i] = null;
        }
        this.rootUnit = null;
        this.formulaLine = null;
        this.errorMessage = null;
        this.processEngine = null;
        this.stringSplitter = null;
    }

    public void error(String string) {
        if (!this.firstErrorCalled) {
            this.firstErrorCalled = true;
            this.firstErrorMessage = string;
        }
        this.errorMessage = string;
        this.error = true;
        if (this.kernel != null) {
            this.kernel.error(this.errorMessage);
        }
    }

    public void useBracketUnit(boolean bl) {
        this.useBracketUnit = bl;
    }

    public void setIntegerToFloat(boolean bl) {
        this.avoidInteger = bl;
    }

    public void setConst(boolean bl) {
        this.constInitializer = bl;
    }

    public boolean isConst() {
        return this.constInitializer;
    }

    public boolean isConstOnly() {
        return this.usingConstOnly;
    }

    public boolean isRightHandConstOnly() {
        return this.usingConstOnlyAtRight;
    }

    public void setProgram(ProcessProgram processProgram) {
        this.programInstance = processProgram;
    }

    public ProcessProgram getProgram() {
        return this.programInstance;
    }

    public void setProcessKernel(ProcessKernel processKernel) {
        this.kernel = processKernel;
    }

    public ProcessUnit getRootProcessUnit() {
        return this.rootUnit;
    }

    public boolean hasError() {
        return this.error;
    }

    public String getErrorMessage() {
        String string = this.errorMessage;
        return string;
    }

    public ProcessUnit getSystemConst(String string) {
        if (string.equals("System.NULL") || string.equals("NULL")) {
            if (this.nullIntUnit == null) {
                NullIntegerUnit nullIntegerUnit = new NullIntegerUnit(this.processEngine);
                nullIntegerUnit.setIntegerValue(-1L);
                nullIntegerUnit.lockValue(true);
                nullIntegerUnit.setProcessKernel(this.kernel);
                nullIntegerUnit.setName("NULL");
                this.add(nullIntegerUnit);
                this.nullIntUnit = nullIntegerUnit;
                return nullIntegerUnit;
            }
            return this.nullIntUnit;
        }
        if (string.startsWith("___")) {
            if (string.equals("___I")) {
                ComplexUnit complexUnit = new ComplexUnit(0.0, 1.0, this.processEngine);
                complexUnit.setComplexValue(new double[]{0.0, 1.0});
                complexUnit.lockValue(true);
                complexUnit.setProcessKernel(this.kernel);
                complexUnit.setName("___I");
                this.add(complexUnit);
                return complexUnit;
            }
            if (string.equals("___VCI")) {
                BigComplexUnit bigComplexUnit = new BigComplexUnit(new BigDecimal("0.0"), new BigDecimal("1.0"), this.processEngine);
                bigComplexUnit.setBigComplexValue(new BigDecimal[]{new BigDecimal("0.0"), new BigDecimal("1.0")});
                bigComplexUnit.lockValue(true);
                bigComplexUnit.setProcessKernel(this.kernel);
                bigComplexUnit.setName("___VFI");
                this.add(bigComplexUnit);
                return bigComplexUnit;
            }
            if (string.equals("___INF")) {
                DecimalUnit decimalUnit = new DecimalUnit(0.0, this.processEngine);
                decimalUnit.setDecimalValue(Double.POSITIVE_INFINITY);
                decimalUnit.lockValue(true);
                decimalUnit.setProcessKernel(this.kernel);
                decimalUnit.setName("___INF");
                this.add(decimalUnit);
                return decimalUnit;
            }
            if (string.equals("___NAN")) {
                DecimalUnit decimalUnit = new DecimalUnit(0.0, this.processEngine);
                decimalUnit.setDecimalValue(Double.NaN);
                decimalUnit.lockValue(true);
                decimalUnit.setProcessKernel(this.kernel);
                decimalUnit.setName("___NAN");
                this.add(decimalUnit);
                return decimalUnit;
            }
            if (string.equals("___FLOAT_MAX")) {
                DecimalUnit decimalUnit = new DecimalUnit(0.0, this.processEngine);
                decimalUnit.setDecimalValue(Double.MAX_VALUE);
                decimalUnit.lockValue(true);
                decimalUnit.setProcessKernel(this.kernel);
                decimalUnit.setName("___FLOAT_MAX");
                this.add(decimalUnit);
                return decimalUnit;
            }
            if (string.equals("___FLOAT_MIN_ABS_DENORMAL")) {
                DecimalUnit decimalUnit = new DecimalUnit(0.0, this.processEngine);
                decimalUnit.setDecimalValue(Double.MIN_VALUE);
                decimalUnit.lockValue(true);
                decimalUnit.setProcessKernel(this.kernel);
                decimalUnit.setName("___FLOAT_MIN_ABS_DENORMAL");
                this.add(decimalUnit);
                return decimalUnit;
            }
            if (string.equals("___FLOAT_MIN_ABS_NORMAL")) {
                DecimalUnit decimalUnit = new DecimalUnit(0.0, this.processEngine);
                decimalUnit.setDecimalValue(Double.MIN_NORMAL);
                decimalUnit.lockValue(true);
                decimalUnit.setProcessKernel(this.kernel);
                decimalUnit.setName("___FLOAT_MIN_ABS_NORMAL");
                this.add(decimalUnit);
                return decimalUnit;
            }
            if (string.equals("___INT_MAX")) {
                IntegerUnit integerUnit = new IntegerUnit(0L, this.processEngine);
                integerUnit.setIntegerValue(Long.MAX_VALUE);
                integerUnit.lockValue(true);
                integerUnit.setProcessKernel(this.kernel);
                integerUnit.setName("___INT_MAX");
                this.add(integerUnit);
                return integerUnit;
            }
            if (string.equals("___INT_MIN")) {
                IntegerUnit integerUnit = new IntegerUnit(0L, this.processEngine);
                integerUnit.setIntegerValue(Long.MIN_VALUE);
                integerUnit.lockValue(true);
                integerUnit.setProcessKernel(this.kernel);
                integerUnit.setName("___INT_MIN");
                this.add(integerUnit);
                return integerUnit;
            }
            if (string.equals("___EOL")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue(System.getProperty("line.separator"));
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___EOL");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___CR")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue("\r");
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___CR");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___LF")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue("\n");
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___LF");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___VER")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue(ScriptProcessor.SCRIPT_VERSION);
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___VER");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___REV")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue(ScriptProcessor.SCRIPT_REVISION);
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___REV");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___OS")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue(System.getProperty("os.name"));
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___OS");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___OSVER")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue(System.getProperty("os.version"));
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___OSVER");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___SYSTEM_PROCESS_DRIVER_FILE_currentDirectory")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue(System.getProperty("user.dir"));
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___SYSTEM_PROCESS_DRIVER_FILE_currentDirectory");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___SYSTEM_PROCESS_DRIVER_FILE_homeDirectory")) {
                StringUnit stringUnit = new StringUnit("", this.processEngine);
                stringUnit.setStringValue(System.getProperty("user.home"));
                stringUnit.lockValue(true);
                stringUnit.setProcessKernel(this.kernel);
                stringUnit.setName("___SYSTEM_PROCESS_DRIVER_FILE_homeDirectory");
                this.add(stringUnit);
                return stringUnit;
            }
            if (string.equals("___SYSTEM_PROCESS_DRIVER_FILE_rootDirectory")) {
                File[] fileArray = File.listRoots();
                int[] nArray = new int[]{fileArray.length};
                StringArrayUnit stringArrayUnit = new StringArrayUnit(nArray, this.processEngine);
                stringArrayUnit.setLength(nArray);
                for (int i = 0; i < fileArray.length; ++i) {
                    stringArrayUnit.index = i;
                    ((ProcessUnit)stringArrayUnit).setStringValue(fileArray[i].getPath());
                }
                stringArrayUnit.lockValue(true);
                stringArrayUnit.setProcessKernel(this.kernel);
                stringArrayUnit.setName("___SYSTEM_PROCESS_DRIVER_FILE_rootDirectory");
                this.add(stringArrayUnit);
                return stringArrayUnit;
            }
            if (string.equals("___SYSTEM_PROCESS_DRIVER_FILE_libraryDirectory")) {
                Object object;
                Object object2;
                String[] stringArray = new String[]{""};
                try {
                    object2 = new File("lib/");
                    object = ((File)object2).toURI().toURL();
                    String string2 = ((URL)object).getPath();
                    File file = new File(string2);
                    string2 = FileSystems.getDefault().getPath(file.getPath(), new String[0]).toRealPath(new LinkOption[0]).toString();
                    stringArray = new String[]{string2};
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object2 = new int[]{stringArray.length};
                object = new StringArrayUnit((int[])object2, this.processEngine);
                ((ProcessUnit)object).setLength((int[])object2);
                for (int i = 0; i < stringArray.length; ++i) {
                    ((ProcessUnit)object).index = i;
                    ((ProcessUnit)object).setStringValue(stringArray[i]);
                }
                ((ProcessUnit)object).lockValue(true);
                ((ProcessUnit)object).setProcessKernel(this.kernel);
                ((ProcessUnit)object).setName("___SYSTEM_PROCESS_DRIVER_FILE_libraryDirectory");
                this.add((ProcessUnit)object);
                return object;
            }
        }
        return null;
    }

    public int getValueType(String string) {
        return this.getValueType(string, false);
    }

    public int getValueType(String string, boolean bl) {
        String string2;
        int n;
        ProcessUnit processUnit = this.idToProcessUnit(string);
        if (processUnit == null) {
            processUnit = this.nameToProcessUnit(string);
        }
        if (processUnit != null) {
            return processUnit.getValueType();
        }
        if (string.equals("")) {
            return 102;
        }
        int n2 = 103;
        BigDecimal bigDecimal = null;
        BigInteger bigInteger = null;
        double d = 0.0;
        long l = 0L;
        string = string.replaceAll("SYSTEM_PROCESS_ESCAPE_EMINUS", "E-");
        string = string.replaceAll("SYSTEM_PROCESS_ESCAPE_EPLUS", "E+");
        if ((string = string.replaceAll("SYSTEM_PROCESS_ESCAPE_HEADMINUS", "-")).startsWith("\"") && string.startsWith("\"")) {
            return 102;
        }
        if (string.equals("true") || string.equals("false")) {
            return 105;
        }
        if (string.endsWith("vf") || string.endsWith("VF")) {
            for (n = 0; n <= 9; ++n) {
                string2 = n + "vf";
                if (string.endsWith(string2)) {
                    return 103;
                }
                string2 = n + "VF";
                if (!string.endsWith(string2)) continue;
                return 103;
            }
        }
        if (string.endsWith("v") || string.endsWith("V")) {
            for (n = 0; n <= 9; ++n) {
                string2 = n + "v";
                if (string.endsWith(string2)) {
                    return 104;
                }
                string2 = n + "V";
                if (!string.endsWith(string2)) continue;
                return 104;
            }
        }
        if (string.endsWith("vi") || string.endsWith("VI")) {
            n = 0;
            for (int i = 0; i <= 9; ++i) {
                string2 = i + "vi";
                if (string.endsWith(string2)) {
                    n = 1;
                }
                if (!string.endsWith(string2 = i + "VI")) continue;
                n = 1;
            }
            if (n != 0) {
                return 104;
            }
        }
        if (string.endsWith("vci") || string.endsWith("VCI")) {
            for (n = 0; n <= 9; ++n) {
                string2 = n + "vci";
                if (string.endsWith(string2)) {
                    return 141;
                }
                string2 = n + "VCI";
                if (!string.endsWith(string2)) continue;
                return 141;
            }
        } else if (string.endsWith("i") || string.endsWith("I")) {
            for (n = 0; n <= 9; ++n) {
                string2 = n + "i";
                if (string.endsWith(string2)) {
                    if (this.processMode == BINARY64) {
                        return 140;
                    }
                    return 141;
                }
                string2 = n + "I";
                if (!string.endsWith(string2)) continue;
                if (this.processMode == BINARY64) {
                    return 140;
                }
                return 141;
            }
        }
        if ((string.endsWith("f") || string.endsWith("F")) && !string.startsWith("0x") && !string.startsWith("0X")) {
            for (n = 0; n <= 9; ++n) {
                string2 = n + "f";
                if (string.endsWith(string2)) {
                    return 100;
                }
                string2 = n + "F";
                if (!string.endsWith(string2)) continue;
                return 100;
            }
        }
        if ((string.endsWith("d") || string.endsWith("D")) && !string.startsWith("0x") && !string.startsWith("0X")) {
            for (n = 0; n <= 9; ++n) {
                string2 = n + "d";
                if (string.endsWith(string2)) {
                    return 100;
                }
                string2 = n + "D";
                if (!string.endsWith(string2)) continue;
                return 100;
            }
        }
        try {
            n2 = Integer.MAX_VALUE;
            if (string.startsWith("0b") || string.startsWith("0B")) {
                long l2 = Long.parseLong(string.substring(2, string.length()), 2);
                if (this.avoidInteger) {
                    this.error(new ProcessSyntaxException(this.processEngine).getInfoMessage(20));
                }
                return 101;
            }
            if (string.startsWith("0x") || string.startsWith("0X")) {
                long l3 = Long.decode(string);
                if (this.avoidInteger) {
                    this.error(new ProcessSyntaxException(this.processEngine).getInfoMessage(20));
                }
                return 101;
            }
            if (string.startsWith("0o") || string.startsWith("0O")) {
                long l4 = Long.parseLong(string.substring(2, string.length()), 8);
                if (this.avoidInteger) {
                    this.error(new ProcessSyntaxException(this.processEngine).getInfoMessage(20));
                }
                return 101;
            }
            if (string.startsWith("0") && string.indexOf(".") < 0 && 2 <= string.length()) {
                long l5 = Long.decode(string);
                if (this.avoidInteger) {
                    this.error(new ProcessSyntaxException(this.processEngine).getInfoMessage(20));
                }
                return 101;
            }
            boolean bl2 = false;
            try {
                bigInteger = new BigInteger(string);
                bl2 = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = false;
            }
            if (bl2) {
                if (this.processMode == BINARY64) {
                    l = Long.parseLong(string);
                    n2 = 101;
                } else {
                    bigInteger = new BigInteger(string);
                    n2 = 104;
                }
            }
            if (!bl2) {
                if (this.processMode == BINARY64) {
                    d = Double.parseDouble(string);
                    n2 = 100;
                } else {
                    bigDecimal = new BigDecimal(string);
                    n2 = 103;
                }
            }
            if (this.avoidInteger) {
                if (n2 == 101) {
                    n2 = 100;
                }
                if (n2 == 104) {
                    n2 = 103;
                }
            }
            this.usingBinary64 = true;
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            if (bl && !this.error) {
                this.error = true;
                if (0 < string.indexOf("SYSTEM_PROCESS_CAUTION_SEMICOLON_NOT_FOUND")) {
                    this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u884c\u672b\u306b\u30bb\u30df\u30b3\u30ed\u30f3\u8a18\u53f7\u300c ; \u300d\u304c\u7121\u3044\u305f\u3081\u3001\u5f0f\u3092\u6b63\u3057\u304f\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : this.errorMessage + "Cannot parse the expression. Probably a semi-colon \";\" at the end of the statement is lacking.";
                    this.error(this.errorMessage);
                } else if (string.startsWith("SYSTEM_PROCESS_U")) {
                    this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5f0f\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u300c ) \u300d\u306e\u5f8c\u306b\u6f14\u7b97\u5b50\uff08 + \u3084 - \u306a\u3069\u306e\u8a18\u53f7 \uff09\u304c\u629c\u3051\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" : this.errorMessage + "Cannot parse the expression. Probably an operator (\"+\", \"-\", and so on) just after the close-parenthesis \")\" is lacking.";
                    this.error(this.errorMessage);
                } else {
                    this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5ba3\u8a00\u3055\u308c\u3066\u3044\u306a\u3044\u5909\u6570\u300c " + string + " \u300d\u3092\u547c\u3073\u51fa\u3057\u3066\u3044\u307e\u3059\u3002" : this.errorMessage + "Using an undeclared variable \"" + string + "\".";
                    this.error(this.errorMessage);
                }
            }
            return Integer.MAX_VALUE;
        }
    }

    public int getCircuitNumber() {
        return this.circuitNumber;
    }

    public void setCircuitNumber(int n) {
        this.circuitNumber = n;
    }

    public int getKernelNumber() {
        return this.kernelNumber;
    }

    public void setKernelNumber(int n) {
        this.kernelNumber = n;
    }

    public int getScopeNumber() {
        return this.scopeNumber;
    }

    public void setScopeNumber(int n) {
        this.scopeNumber = n;
    }

    public void addVariable(ProcessUnit processUnit) {
        this.addVariable(processUnit, false);
    }

    public void addVariable(ProcessUnit processUnit, boolean bl) {
        if (processUnit == null) {
            return;
        }
        String string = processUnit.getName();
        ProcessUnit processUnit2 = this.nameToProcessUnit_LOCAL_ONLY(string, bl);
        if (processUnit2 != null) {
            this.replace(processUnit2, processUnit);
        } else {
            this.add(processUnit);
        }
    }

    public void add(ProcessUnit processUnit) {
        Object object;
        if (this.cacheCapacity <= this.cacheRegistered) {
            int n;
            int n2 = this.cacheRegistered;
            this.cacheCapacity *= 2;
            object = new ProcessUnit[n2];
            for (n = 0; n < n2; ++n) {
                object[n] = this.processUnit[n];
            }
            this.processUnit = new ProcessUnit[this.cacheCapacity];
            for (n = 0; n < n2; ++n) {
                this.processUnit[n] = object[n];
            }
            object = null;
        }
        String string = "SYSTEM_PROCESS_U" + this.counter + "C" + this.circuitNumber + "K" + this.kernelNumber + "S" + this.scopeNumber;
        if (this.programInstance != null) {
            object = this.programInstance.getName();
            object = ((String)object).replaceAll("\\.", "");
            string = string + "_" + (String)object;
        }
        processUnit.setID(string);
        this.processUnit[this.cacheRegistered] = processUnit;
        ++this.cacheRegistered;
        ++this.counter;
    }

    public void replace(ProcessUnit processUnit, ProcessUnit processUnit2) {
        int n = this.cacheRegistered;
        for (int i = 0; i < n; ++i) {
            if (this.processUnit[i] != processUnit) continue;
            this.processUnit[i] = processUnit2;
        }
    }

    public ProcessUnit idToProcessUnit(String string) {
        ProcessUnit processUnit = null;
        for (int i = 0; i < this.cacheRegistered; ++i) {
            if (this.processUnit[i] == null || this.processUnit[i].getID() == null || !this.processUnit[i].getID().equals(string)) continue;
            processUnit = this.processUnit[i];
        }
        if (processUnit == null && this.programInstance != null) {
            processUnit = this.programInstance.getIDVariable(string);
        }
        return processUnit;
    }

    public ProcessUnit nameToProcessUnit_LOCAL_ONLY(String string) {
        return this.nameToProcessUnit_LOCAL_ONLY_INTERNAL(string);
    }

    public ProcessUnit nameToProcessUnit_LOCAL_ONLY(String string, boolean bl) {
        return this.nameToProcessUnit_LOCAL_ONLY_INTERNAL(string, bl);
    }

    public ProcessUnit nameToProcessUnit_LOCAL_ONLY_INTERNAL(String string) {
        return this.nameToProcessUnit_LOCAL_ONLY_INTERNAL(string, false);
    }

    public ProcessUnit nameToProcessUnit_LOCAL_ONLY_INTERNAL(String string, boolean bl) {
        if (string == null || string.equals("") || string.length() == 0) {
            return null;
        }
        ProcessUnit processUnit = null;
        for (int i = 0; i < this.cacheRegistered; ++i) {
            if (this.processUnit[i] == null || this.processUnit[i].getName() == null || !this.processUnit[i].getName().equals(string) || (processUnit = this.processUnit[i]) == null || processUnit.isConst()) continue;
            this.usingConstOnly = false;
            if (bl) continue;
            this.usingConstOnlyAtRight = false;
        }
        return processUnit;
    }

    public ProcessUnit nameToProcessUnit(String string) {
        return this.nameToProcessUnit(string, false);
    }

    public ProcessUnit nameToProcessUnit(String string, boolean bl) {
        if (string == null || string.equals("") || string.length() == 0) {
            return null;
        }
        ProcessUnit processUnit = this.nameToProcessUnit_LOCAL_ONLY_INTERNAL(string, bl);
        if (processUnit != null && !processUnit.isConst()) {
            this.usingConstOnly = false;
            if (!bl) {
                this.usingConstOnlyAtRight = false;
            }
        }
        if (processUnit == null && this.programInstance != null && (processUnit = this.programInstance.getVariable(string)) != null && !processUnit.isConst()) {
            this.usingConstOnly = false;
            if (!bl) {
                this.usingConstOnlyAtRight = false;
            }
        }
        return processUnit;
    }

    public boolean isAdded(String string) {
        ProcessUnit processUnit = this.idToProcessUnit(string);
        if (processUnit == null) {
            processUnit = this.nameToProcessUnit(string);
            return processUnit != null;
        }
        return true;
    }

    public ProcessUnit memberAccess(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            return null;
        }
        if (3 <= stringArray.length) {
            String string2 = stringArray[0] + "." + stringArray[1];
            ProcessUnit processUnit = this.getProcessUnit(string2);
            String string3 = processUnit.getID();
            for (int i = 2; i < stringArray.length; ++i) {
                string3 = string3 + "." + stringArray[i];
            }
            ProcessUnit processUnit2 = this.memberAccess(string3);
            return processUnit2;
        }
        if (2 == stringArray.length) {
            int n = stringArray.length;
            String string4 = stringArray[n - 1];
            String string5 = "";
            for (int i = 0; i < n - 2; ++i) {
                string5 = string5 + stringArray[i] + ".";
            }
            string5 = string5 + stringArray[n - 2];
            try {
                ProcessUnit processUnit = this.getProcessUnit(string5);
                if (processUnit == null) {
                    return null;
                }
                if (processUnit.isArrayType()) {
                    this.error(string5 + "." + string4 + " : " + new ProcessSyntaxException(this.processEngine).getInfo(7));
                    return null;
                }
                if (processUnit.getValueType() == 200) {
                    ProcessStruct processStruct;
                    int n2;
                    String string6 = "";
                    if (0 <= string4.indexOf("[")) {
                        string6 = string4.substring(string4.indexOf("["), string4.length());
                        string4 = string4.substring(0, string4.indexOf("["));
                    }
                    if ((n2 = (processStruct = processUnit.getStruct()).getVariableIndex(string4)) < 0) {
                        this.error(processStruct.getType() + "." + string4 + " : " + new ProcessSyntaxException(this.processEngine).getInfo(5));
                        return null;
                    }
                    ProcessUnit processUnit3 = processStruct.getVariable()[n2];
                    if (processUnit3.getAccessPermission() == 200) {
                        this.error(processStruct.getType() + "." + string4 + " : " + new ProcessSyntaxException(this.processEngine).getInfo(11));
                        return null;
                    }
                    if (processUnit3.getAccessPermission() == 300 && processStruct.getProcessProgram() != this.programInstance) {
                        this.error(processStruct.getType() + "." + string4 + " : " + new ProcessSyntaxException(this.processEngine).getInfo(12));
                        return null;
                    }
                    StructMemberAccessUnit structMemberAccessUnit = new StructMemberAccessUnit(processUnit, n2);
                    structMemberAccessUnit.setProcessKernel(this.kernel);
                    this.add(structMemberAccessUnit);
                    if (string6.equals("")) {
                        return structMemberAccessUnit;
                    }
                    return this.getProcessUnit(structMemberAccessUnit.getID() + string6);
                }
                return null;
            }
            catch (ClassCastException classCastException) {
                this.error(string5 + " : " + new ProcessSyntaxException(this.processEngine).getInfo(4));
                return null;
            }
        }
        return null;
    }

    public ProcessUnit getProcessUnit(String string) {
        return this.getProcessUnit(string, false);
    }

    public ProcessUnit getProcessUnit(String string, boolean bl) {
        Object object;
        String string2;
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            String string3 = string;
            int n = string.length();
            if (n >= 2) {
                string3 = string.substring(1, n - 1);
                string3 = string3.replaceAll("\\\\\\\\", "\\\\");
                string3 = string3.replaceAll("\\\\\"", "\\\"");
            }
            StringUnit stringUnit = new StringUnit(string3, this.processEngine);
            stringUnit.lockValue(true);
            stringUnit.setProcessKernel(this.kernel);
            this.add(stringUnit);
            return stringUnit;
        }
        string = string.replaceAll("SYSTEM_PROCESS_ESCAPE_EMINUS", "E-");
        string = string.replaceAll("SYSTEM_PROCESS_ESCAPE_EPLUS", "E+");
        string = string.replaceAll("SYSTEM_PROCESS_ESCAPE_HEADMINUS", "-");
        ProcessUnit processUnit = null;
        if (string.startsWith("System.") && (processUnit = this.getSystemConst(string)) != null) {
            return processUnit;
        }
        if (0 <= string.indexOf(".") && this.getValueType(string) == Integer.MAX_VALUE) {
            if (0 <= string.indexOf("..")) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u300c " + string + " \u300d\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002\u30c9\u30c3\u30c8\u300c . \u300d\u304c 2 \u500b\u4ee5\u4e0a\u9023\u7d9a\u3057\u3066\u3044\u308b\u7b87\u6240\u304c\u5b58\u5728\u3057\u307e\u3059\u3002\u6570\u5024\u3068\u3057\u3066\u306f\u4e0d\u6b63\u306a\u8a18\u8ff0\u5f62\u5f0f\u3067\u3042\u308a\u3001\u69cb\u9020\u4f53\u306e\u30e1\u30f3\u30d0\u30a2\u30af\u30bb\u30b9\u3068\u3057\u3066\u3082\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.error("Cannot interpret \"" + string + "\". It contains multiple sequential dot-symbols \".\", but there is no valid syntax matching with it.");
                }
                return null;
            }
            String[] stringArray = string.split("\\.");
            string2 = "";
            object = "";
            if (1 == stringArray.length) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u300c " + string + " \u300d\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002\u69cb\u9020\u4f53\u306e\u30e1\u30f3\u30d0\u30a2\u30af\u30bb\u30b9\u3068\u3057\u3066\u306f\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.error("Cannot interpret \"" + string + "\". It is syntactically invalid description for accessing to a member variable of a struct.");
                }
                return null;
            }
            if (2 == stringArray.length) {
                if (!stringArray[0].equals("this") && !this.processEngine.isImported(stringArray[0])) {
                    ProcessUnit processUnit2 = this.getProcessUnit(stringArray[0]);
                    if (processUnit2 == null) {
                        if (0 <= string.indexOf("..")) {
                            if (ScriptProcessor.locale.isJapanese()) {
                                this.error("\u300c " + string + " \u300d\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002\u6570\u5024\u3068\u3057\u3066\u306f\u4e0d\u6b63\u306a\u8a18\u8ff0\u5f62\u5f0f\u3067\u3042\u308a\u3001\u69cb\u9020\u4f53\u306e\u30e1\u30f3\u30d0\u30a2\u30af\u30bb\u30b9\u3068\u3057\u3066\u3082\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002");
                            } else {
                                this.error("Cannot interpret \"" + string + "\". There is no valid syntax matching with it.");
                            }
                            return null;
                        }
                        return null;
                    }
                    ProcessUnit processUnit3 = this.memberAccess(processUnit2.getID() + "." + stringArray[1]);
                    if (processUnit3 == null) {
                        if (ScriptProcessor.locale.isJapanese()) {
                            this.error("\u300c " + string + " \u300d\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002\u6570\u5024\u3068\u3057\u3066\u306f\u4e0d\u6b63\u306a\u8a18\u8ff0\u5f62\u5f0f\u3067\u3042\u308a\u3001\u69cb\u9020\u4f53\u306e\u30e1\u30f3\u30d0\u30a2\u30af\u30bb\u30b9\u3068\u3057\u3066\u3082\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002");
                        } else {
                            this.error("Cannot interpret \"" + string + "\". There is no valid syntax matching with it.");
                        }
                    }
                    return processUnit3;
                }
            } else if (3 <= stringArray.length) {
                int n;
                if (stringArray[0].equals("this") || this.processEngine.isImported(stringArray[0])) {
                    string2 = this.getProcessUnit(stringArray[0] + "." + stringArray[1]).getID();
                    if (4 <= stringArray.length) {
                        string2 = string2 + ".";
                        for (n = 1; n < stringArray.length - 2; ++n) {
                            string2 = string2 + stringArray[n] + ".";
                        }
                        string2 = string2 + stringArray[stringArray.length - 2];
                    }
                    object = stringArray[stringArray.length - 1];
                } else {
                    string2 = "";
                    for (n = 0; n < stringArray.length - 2; ++n) {
                        string2 = string2 + stringArray[n] + ".";
                    }
                    string2 = string2 + stringArray[stringArray.length - 2];
                    object = stringArray[stringArray.length - 1];
                }
                ProcessUnit processUnit4 = null;
                processUnit4 = 0 <= string2.indexOf(".") ? this.memberAccess(string2) : this.getProcessUnit(string2);
                if (processUnit4 == null) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("\u300c " + string + " \u300d\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002\u6570\u5024\u3068\u3057\u3066\u306f\u4e0d\u6b63\u306a\u8a18\u8ff0\u5f62\u5f0f\u3067\u3042\u308a\u3001\u69cb\u9020\u4f53\u306e\u30e1\u30f3\u30d0\u30a2\u30af\u30bb\u30b9\u3068\u3057\u3066\u3082\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002");
                    } else {
                        this.error("Cannot interpret \"" + string + "\". There is no valid syntax matching with it.");
                    }
                    return null;
                }
                ProcessUnit processUnit5 = this.memberAccess(processUnit4.getID() + "." + (String)object);
                if (processUnit5 == null) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("\u300c " + string + " \u300d\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3002\u6570\u5024\u3068\u3057\u3066\u306f\u4e0d\u6b63\u306a\u8a18\u8ff0\u5f62\u5f0f\u3067\u3042\u308a\u3001\u69cb\u9020\u4f53\u306e\u30e1\u30f3\u30d0\u30a2\u30af\u30bb\u30b9\u3068\u3057\u3066\u3082\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002");
                    } else {
                        this.error("Cannot interpret \"" + string + "\". There is no valid syntax matching with it.");
                    }
                }
                return processUnit5;
            }
        }
        boolean bl2 = false;
        string2 = string;
        if (string2.indexOf("[") != -1) {
            bl2 = true;
        }
        if (bl2) {
            object = string.split("\\[");
            String[] stringArray = new String[((String[])object).length - 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = object[i + 1];
                stringArray[i] = stringArray[i].replaceAll("\\]", "");
            }
            ProcessUnit[] processUnitArray = new ProcessUnit[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            }
            string2 = object[0];
            ProcessUnit processUnit6 = this.nameToProcessUnit(string2, bl);
            if (processUnit6 == null) {
                processUnit6 = this.idToProcessUnit(string2);
            }
            if (processUnit6 == null) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u5ba3\u8a00\u3055\u308c\u3066\u3044\u306a\u3044\u914d\u5217\u300c " + string2 + " \u300d\u306e\u8981\u7d20\u3092\u547c\u3073\u51fa\u3057\u3066\u3044\u307e\u3059\u3002");
                } else {
                    this.error("Subscripting to the array \"" + string2 + "\", but this array is not declared.");
                }
                return null;
            }
            if (!processUnit6.arrayType) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.errorMessage = this.errorMessage + "\u5909\u6570\u300c " + string2 + " \u300d\u306f\u3001\u914d\u5217\u3068\u3057\u3066\u5ba3\u8a00\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
                } else {
                    this.error("Subscripting to the array \"" + string2 + "\", but \"" + string2 + "\" is declared as a scalar variable, not array.");
                }
                this.error(this.errorMessage);
            }
            if (processUnit6.getValueType() == 103 || processUnit6.getValueType() == 104 || processUnit6.getValueType() == 141) {
                this.processMode = VARIABLE;
            }
            if (processUnit6.getDimension() != processUnitArray.length) {
                int n = processUnit6.getDimension();
                int n2 = processUnitArray.length;
                ProcessCompatibilityException processCompatibilityException = new ProcessCompatibilityException();
                if (!processCompatibilityException.alert()) {
                    String string4 = processUnit6.getName();
                    if (string4 == null) {
                        string4 = "";
                    }
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error(n + " \u6b21\u5143\u306e\u914d\u5217\u300c " + string4 + " \u300d\u306b\u5bfe\u3057\u3066\u3001" + n2 + " \u6b21\u5143\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u30a2\u30af\u30bb\u30b9\u3059\u308b\u4e8b\u306f\u4ed5\u69d8\u4e0a\u8a31\u53ef\u3055\u308c\u307e\u305b\u3093\u3002\u3053\u306e\u7d50\u679c\u306e\u6319\u52d5\u306f\u5b9f\u88c5\u4f9d\u5b58\u3067\u3059\u3002");
                    } else {
                        this.error("Cannot subscripting to " + n + "-dimentional array " + string4 + " by " + n2 + "-dimentional indices. This behaviour depends on the implementation of the script engine.");
                    }
                }
            }
            if (processUnit6.getDimension() > processUnitArray.length) {
                if (processUnit6 instanceof FunctionCallUnit) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("\u95a2\u6570\u306e\u623b\u308a\u5024\u3068\u3057\u3066\u8fd4\u3055\u308c\u305f\u914d\u5217\u306b\u5bfe\u3057\u3066\u3001\u30a2\u30af\u30bb\u30b9\u3057\u3066\u3044\u308b\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u6b21\u5143\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                    } else {
                        this.error("The number of indices does not match with the number of dimensions of the array returned by the function.");
                    }
                }
                ArrayReduceUnit arrayReduceUnit = new ArrayReduceUnit(this.processEngine);
                arrayReduceUnit.setProcessKernel(this.kernel);
                arrayReduceUnit.setIndexUnit(processUnitArray);
                arrayReduceUnit.setArrayUnit(processUnit6);
                this.add(arrayReduceUnit);
                if (arrayReduceUnit.getValueType() == 103 || arrayReduceUnit.getValueType() == 104 || arrayReduceUnit.getValueType() == 141) {
                    this.processMode = VARIABLE;
                }
                return arrayReduceUnit;
            }
            ArrayAccessUnit arrayAccessUnit = new ArrayAccessUnit(this.processEngine);
            arrayAccessUnit.setProcessKernel(this.kernel);
            arrayAccessUnit.setIndexUnit(processUnitArray);
            arrayAccessUnit.setArrayUnit(processUnit6);
            this.add(arrayAccessUnit);
            if (arrayAccessUnit.getValueType() == 103 || arrayAccessUnit.getValueType() == 104 || arrayAccessUnit.getValueType() == 141) {
                this.processMode = VARIABLE;
            }
            return arrayAccessUnit;
        }
        processUnit = this.idToProcessUnit(string);
        if (processUnit != null) {
            if (processUnit.getValueType() == 103 || processUnit.getValueType() == 104 || processUnit.getValueType() == 141) {
                this.processMode = VARIABLE;
            }
            return processUnit;
        }
        processUnit = this.nameToProcessUnit(string, bl);
        if (processUnit == null && (processUnit = this.getSystemConst(string)) != null) {
            return processUnit;
        }
        if (processUnit == null) {
            int n;
            if (string.indexOf("-") != -1) {
                object = string.replaceAll("-", "");
                processUnit = this.nameToProcessUnit((String)object, bl);
                if (processUnit != null) {
                    String string5 = this.minus(processUnit.getID());
                    ProcessUnit processUnit7 = this.getProcessUnit(string5);
                    return processUnit7;
                }
                processUnit = this.idToProcessUnit((String)object);
                if (processUnit != null) {
                    String string6 = this.minus(processUnit.getID());
                    ProcessUnit processUnit8 = this.getProcessUnit(string6);
                    return processUnit8;
                }
            }
            if ((n = this.getValueType(string, true)) == 105) {
                processUnit = new BooleanUnit(string, this.processEngine);
                processUnit.lockValue(true);
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                return processUnit;
            }
            if (n == 100) {
                this.usingBinary64 = true;
                processUnit = new DecimalUnit(string, this.processEngine);
                processUnit.lockValue(true);
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                return processUnit;
            }
            if (n == 101) {
                this.usingBinary64 = true;
                try {
                    if (string.startsWith("0b") || string.startsWith("0B")) {
                        long l = Long.parseLong(string.substring(2, string.length()), 2);
                        string = "" + l;
                    } else if (string.startsWith("0o") || string.startsWith("0O")) {
                        long l = Long.parseLong(string.substring(2, string.length()), 8);
                        string = "" + l;
                    } else if (string.startsWith("0x") || string.startsWith("0X")) {
                        long l = Long.decode(string);
                        string = "" + l;
                    } else if (string.startsWith("0") && string.indexOf(".") < 0 && 2 <= string.length()) {
                        ProcessCompatibilityException processCompatibilityException = new ProcessCompatibilityException();
                        if (!processCompatibilityException.alert()) {
                            this.error(new ProcessSyntaxException().getInfoMessage(27));
                        }
                        long l = Long.decode(string);
                        string = "" + l;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                processUnit = new IntegerUnit(string, this.processEngine);
                processUnit.lockValue(true);
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                return processUnit;
            }
            if (n == 103) {
                this.usingVariable = true;
                if (string.endsWith("vf") || string.endsWith("VF")) {
                    string = string.substring(0, string.length() - 2);
                }
                processUnit = new BigDecimalUnit(string, this.processEngine);
                processUnit.lockValue(true);
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                return processUnit;
            }
            if (n == 104) {
                this.usingVariable = true;
                if (string.endsWith("v") || string.endsWith("V")) {
                    string = string.substring(0, string.length() - 1);
                } else if (string.endsWith("vi") || string.endsWith("VI")) {
                    ProcessCompatibilityException processCompatibilityException = new ProcessCompatibilityException();
                    if (!processCompatibilityException.alert()) {
                        this.error(new ProcessSyntaxException().getInfoMessage(21));
                    }
                    string = string.substring(0, string.length() - 2);
                }
                processUnit = new BigIntegerUnit(string, this.processEngine);
                processUnit.lockValue(true);
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                return processUnit;
            }
            if (n == 102) {
                String string7 = string;
                int n3 = string.length();
                if (n3 >= 2) {
                    string7 = string.substring(1, n3 - 1);
                    string7 = string7.replaceAll("\\\\\\\\", "\\\\");
                    string7 = string7.replaceAll("\\\\\"", "\\\"");
                }
                processUnit = new StringUnit(string7, this.processEngine);
                processUnit.lockValue(true);
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                return processUnit;
            }
            if (n == 140) {
                this.usingBinary64 = true;
                if (string.endsWith("i")) {
                    try {
                        string = string.substring(0, string.length() - 1);
                        double d = Double.parseDouble(string);
                        processUnit = new ComplexUnit(0.0, d, this.processEngine);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                processUnit.lockValue(true);
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                return processUnit;
            }
            if (n == 141) {
                this.usingVariable = true;
                if (string.endsWith("vci") || string.endsWith("VCI")) {
                    try {
                        string = string.substring(0, string.length() - 3);
                        BigDecimal bigDecimal = new BigDecimal("0.0");
                        BigDecimal bigDecimal2 = new BigDecimal(string);
                        processUnit = new BigComplexUnit(bigDecimal, bigDecimal2, this.processEngine);
                        processUnit.lockValue(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                processUnit.lockValue(true);
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                return processUnit;
            }
        } else {
            if (processUnit.getValueType() == 103 || processUnit.getValueType() == 104 || processUnit.getValueType() == 141) {
                this.processMode = VARIABLE;
            }
            return processUnit;
        }
        if (processUnit == null) {
            processUnit = this.memberAccess(string);
        }
        if (processUnit == null && !this.error) {
            this.error = true;
            if (0 < string.indexOf("SYSTEM_PROCESS_CAUTION_SEMICOLON_NOT_FOUND")) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u884c\u672b\u306b\u30bb\u30df\u30b3\u30ed\u30f3\u8a18\u53f7\u300c ; \u300d\u304c\u7121\u3044\u305f\u3081\u3001\u5f0f\u3092\u6b63\u3057\u304f\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : this.errorMessage + "Cannot parse the expression. Probably a semi-colon \";\" at the end of the statement is lacking.";
                this.error(this.errorMessage);
            } else if (string.startsWith("SYSTEM_PROCESS_U")) {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5f0f\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u300c ) \u300d\u306e\u5f8c\u306b\u6f14\u7b97\u5b50\uff08 + \u3084 - \u306a\u3069\u306e\u8a18\u53f7 \uff09\u304c\u629c\u3051\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002" : this.errorMessage + "Cannot parse the expression. Probably an operator (\"+\", \"-\", and so on) just after the close-parenthesis \")\" is lacking.";
                this.error(this.errorMessage);
            } else {
                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5ba3\u8a00\u3055\u308c\u3066\u3044\u306a\u3044\u5909\u6570\u300c " + string + " \u300d\u3092\u547c\u3073\u51fa\u3057\u3066\u3044\u307e\u3059\u3002" : this.errorMessage + "Using an undeclared variable \"" + string + "\".";
                this.error(this.errorMessage);
            }
            return null;
        }
        return processUnit;
    }

    public String getEscapedProgram(String string) {
        while (this.hasMoreEscapeSection(string)) {
            string = this.escapeSection(string);
        }
        return string;
    }

    public boolean hasMoreEscapeSection(String string) {
        int n = string.indexOf("\"");
        if (n != -1) {
            int n2 = string.indexOf("\"", n);
            return n2 != -1;
        }
        return false;
    }

    public String escapeSection(String string) {
        String string2 = string;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string2.length();
        for (int i = 0; i < n4; ++i) {
            if (string2.charAt(i) != '\"' || i != 0 && string2.charAt(i - 1) == '\\') continue;
            if (++n == 1) {
                n2 = i;
                continue;
            }
            n3 = i;
            break;
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1, n3);
        String string5 = string2.substring(n3 + 1, n4);
        ProcessUnit processUnit = this.getProcessUnit("\"" + string4 + "\"");
        string2 = string3 + processUnit.getID() + string5;
        return string2;
    }

    public void getEscapedProgram(BufferedStringOperator bufferedStringOperator) {
        while (this.hasMoreEscapeSection(bufferedStringOperator)) {
            this.escapeSection(bufferedStringOperator);
        }
    }

    public boolean hasMoreEscapeSection(BufferedStringOperator bufferedStringOperator) {
        String string = bufferedStringOperator.toString();
        int n = this.sectionIndexOf(string, 0);
        if (n != -1) {
            int n2 = this.sectionIndexOf(string, n);
            if (n2 != -1) {
                return true;
            }
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6587\u5b57\u5217\u30ea\u30c6\u30e9\u30eb\u304c\u9589\u3058\u3066\u3044\u307e\u305b\u3093\u3002\u300c \" \u300d\u8a18\u53f7\u306e\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002" : this.errorMessage + "There is an unclosed string literal. The number of double-quotation (\") is deficient.";
            this.error(this.errorMessage);
            return false;
        }
        return false;
    }

    public int sectionIndexOf(String string, int n) {
        String string2 = string;
        int n2 = string2.length();
        for (int i = n; i < n2; ++i) {
            if (string2.charAt(i) != '\"' || i != 0 && string2.charAt(i - 1) == '\\') continue;
            return i;
        }
        return -1;
    }

    public void escapeSection(BufferedStringOperator bufferedStringOperator) {
        String string = bufferedStringOperator.toString();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            if (string.charAt(i) != '\"') continue;
            if (i == 0) {
                if (++n == 1) {
                    n2 = i;
                    continue;
                }
                n3 = i;
                break;
            }
            if (string.charAt(i - 1) == '\\') {
                int n5 = 0;
                for (int j = i - 1; 0 <= j && string.charAt(j) == '\\'; --j) {
                    ++n5;
                }
                if (n5 % 2 != 0) continue;
                if (++n == 1) {
                    n2 = i;
                    continue;
                }
                n3 = i;
                break;
            }
            if (++n == 1) {
                n2 = i;
                continue;
            }
            n3 = i;
            break;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1, n3);
        String string4 = string.substring(n3 + 1, n4);
        ProcessUnit processUnit = this.getProcessUnit("\"" + string3 + "\"");
        bufferedStringOperator.replaceAllString(string, string2 + processUnit.getID() + string4);
    }

    public boolean formatErrorDetect(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                ++n;
                ++n4;
            }
            if (string.charAt(i) == ')') {
                ++n2;
                --n4;
            }
            if (n4 < 0) {
                bl = true;
            }
            if (string.charAt(i) != '=') continue;
            ++n3;
        }
        if (n > n2) {
            string2 = ScriptProcessor.locale.isJapanese() ? "\u304b\u3063\u3053\u304c\u9589\u3058\u3066\u3044\u307e\u305b\u3093\u3002\" ) \"\u306e\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002" : "There is an unclosed parenthesis. The number of \")\" is deficient.";
            this.error = true;
        }
        if (n < n2) {
            string2 = ScriptProcessor.locale.isJapanese() ? "\u304b\u3063\u3053\u304c\u9589\u3058\u3066\u3044\u307e\u305b\u3093\u3002\" ( \"\u306e\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002" : "There is an unclosed parenthesis. The number of \"(\" is deficient.";
            this.error = true;
        }
        if (bl && n == n2) {
            this.error = true;
            string2 = ScriptProcessor.locale.isJapanese() ? "\u6050\u3089\u304f\u3001\u304b\u3063\u3053\u3092\u4f7f\u3063\u305f\u7b87\u6240\u306b\u69cb\u6587\u7684\u306a\u8aa4\u308a\u304c\u5b58\u5728\u3057\u307e\u3059\u3002" : "Probably there are syntactically incorrect descriptions using parentheses.";
        }
        if (this.error) {
            this.errorMessage = this.errorMessage + "\t" + string2;
            this.error(this.errorMessage);
        }
        return this.error;
    }

    public boolean formatErrorDetect(BufferedStringOperator bufferedStringOperator) {
        ProcessCompatibilityException processCompatibilityException;
        ProcessCompatibilityException processCompatibilityException2;
        ProcessCompatibilityException processCompatibilityException3;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < bufferedStringOperator.length(); ++i) {
            if (bufferedStringOperator.charAt(i) == '(') {
                ++n;
                ++n4;
            }
            if (bufferedStringOperator.charAt(i) == ')') {
                ++n2;
                --n4;
            }
            if (n4 < 0) {
                bl = true;
            }
            if (bufferedStringOperator.charAt(i) != '=') continue;
            ++n3;
        }
        if (n > n2 && !(processCompatibilityException3 = new ProcessCompatibilityException()).alert()) {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u30d6\u30e9\u30b1\u30c3\u30c8\u304c\u9589\u3058\u3066\u3044\u307e\u305b\u3093\u3002\" ) \"\u306e\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002" : "There is an unclosed parenthesis. The number of \")\" is deficient.";
            this.error = true;
            this.error(this.errorMessage);
        }
        if (n < n2 && !(processCompatibilityException2 = new ProcessCompatibilityException()).alert()) {
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u30d6\u30e9\u30b1\u30c3\u30c8\u304c\u9589\u3058\u3066\u3044\u307e\u305b\u3093\u3002\" ( \"\u306e\u6570\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002" : "There is an unclosed parenthesis. The number of \"(\" is deficient.";
            this.error = true;
            this.error(this.errorMessage);
        }
        if (bl && n == n2 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u30d6\u30e9\u30b1\u30c3\u30c8\u306e\u69cb\u6587\u306b\u8aa4\u308a\u304c\u5b58\u5728\u3057\u307e\u3059\u3002" : "Probably there are syntactically incorrect descriptions using parentheses.";
            this.error(this.errorMessage);
        }
        return this.error;
    }

    public String createCircuit() {
        if (!this.error) {
            String string = this.createCircuit(this.formulaLine);
            return string;
        }
        return null;
    }

    public String createCircuit(String string) {
        block8: {
            this.firstErrorMessage = "";
            this.firstErrorCalled = false;
            if (this.error) break block8;
            try {
                String string2;
                block9: {
                    ProcessCompatibilityException processCompatibilityException;
                    block10: {
                        string2 = string;
                        string2 = this.createCircuit_INTERNAL(string2);
                        this.processMode = BINARY64;
                        string2 = this.createCircuit_INTERNAL(string);
                        if (!ProcessEngine.VARFLOAT_STATEMENT_FILTER || this.error || !this.usingBinary64) break block9;
                        if (this.usingVariable) break block10;
                        if (this.processMode != VARIABLE) break block9;
                    }
                    if (!(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                        this.error(new ProcessSyntaxException(this.processEngine).getInfo(3));
                    }
                }
                if (!ProcessEngine.VARFLOAT_STATEMENT_FILTER && !this.error) {
                    if (this.processMode == VARIABLE) {
                        string2 = this.createCircuit_INTERNAL(string);
                    }
                }
                return string2;
            }
            catch (Exception exception) {
                this.processEngine.showErrorText(exception);
                return null;
            }
        }
        return null;
    }

    public String createCircuit_BINARY64(String string) {
        if (!this.error) {
            try {
                this.processMode = BINARY64;
                String string2 = this.getEscapedProgram(string);
                string2 = this.createCircuit_INTERNAL(string2);
                return string2;
            }
            catch (Exception exception) {
                this.processEngine.showErrorText(exception);
                return null;
            }
        }
        return null;
    }

    public String createCircuit_VARIABLE(String string) {
        if (!this.error) {
            try {
                this.processMode = VARIABLE;
                String string2 = this.getEscapedProgram(string);
                string2 = this.createCircuit_INTERNAL(string2);
                return string2;
            }
            catch (Exception exception) {
                this.processEngine.showErrorText(exception);
                return null;
            }
        }
        return null;
    }

    public String createCircuit_INTERNAL(String string) {
        ProcessCodeLoader processCodeLoader = new ProcessCodeLoader();
        processCodeLoader.setProcessEngine(this.processEngine);
        StringBuffer stringBuffer = new StringBuffer(string);
        processCodeLoader.escape(stringBuffer);
        processCodeLoader.removeLineAddressCode(stringBuffer);
        processCodeLoader.unescape(stringBuffer);
        processCodeLoader.dispose();
        processCodeLoader = null;
        string = stringBuffer.toString();
        this.usingFunctionCall = false;
        this.usingConstOnly = true;
        this.usingConstOnlyAtRight = true;
        BufferedStringOperator bufferedStringOperator = new BufferedStringOperator();
        bufferedStringOperator.open(string);
        if (0 <= bufferedStringOperator.indexOf("alloc")) {
            bufferedStringOperator.replaceAllString("alloc[", "SYSTEM_PROCESS_DECLEARTION_ALLOC[");
            bufferedStringOperator.replaceAllString("alloc ", "SYSTEM_PROCESS_DECLEARTION_ALLOC");
            bufferedStringOperator.replaceAllString("alloc\t", "SYSTEM_PROCESS_DECLEARTION_ALLOC");
        }
        if (0 <= bufferedStringOperator.indexOf("free")) {
            bufferedStringOperator.replaceAllString("free ", "SYSTEM_PROCESS_DECLEARTION_FREE");
            bufferedStringOperator.replaceAllString("free\t", "SYSTEM_PROCESS_DECLEARTION_FREE");
        }
        if (0 <= bufferedStringOperator.indexOf("return")) {
            // empty if block
        }
        string = bufferedStringOperator.toString();
        bufferedStringOperator.close();
        bufferedStringOperator = null;
        if (this.error) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u5f0f\u3092\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u5f0f\u304c\u6b63\u3057\u3044\u5f62\u3092\u3057\u3066\u3044\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.error("Cannot interpret the expression. Probably it is syntactically incorrect.");
            }
            return null;
        }
        try {
            if (string != null && string.length() > 0) {
                this.formulaLine = string;
                String string2 = string;
                BufferedStringOperator bufferedStringOperator2 = new BufferedStringOperator();
                bufferedStringOperator2.open(string);
                bufferedStringOperator2.replaceAllString("\t", " ");
                bufferedStringOperator2.replaceAllString(" ", "");
                bufferedStringOperator2.replaceAllString(";", "");
                string2 = bufferedStringOperator2.toString();
                bufferedStringOperator2.close();
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                boolean bl = stringTokenizer.hasMoreTokens();
                stringTokenizer = null;
                if (bl) {
                    bufferedStringOperator2.open(string);
                    this.getEscapedProgram(bufferedStringOperator2);
                    this.getPreferedDescription(bufferedStringOperator2);
                    bufferedStringOperator2.replaceAllString("[=]", "SYSTEM_ESCAPE_LENGTH_EQUAL");
                    bufferedStringOperator2.replaceAllString("[", "[(");
                    bufferedStringOperator2.replaceAllString("]", ")]");
                    bufferedStringOperator2.replaceAllString("[()]", "[]");
                    bufferedStringOperator2.replaceAllString("[( )]", "[]");
                    bufferedStringOperator2.replaceAllString("[(\t)]", "[]");
                    this.formatErrorDetect(bufferedStringOperator2);
                    this.processCompoundAssignmentOperatorMacro(bufferedStringOperator2);
                    this.getProcessedSectionAll(bufferedStringOperator2);
                    if (bufferedStringOperator2.toString() == null) {
                        return null;
                    }
                    String string3 = bufferedStringOperator2.toString();
                    bufferedStringOperator2.close();
                    bufferedStringOperator2 = null;
                    if (!this.hasError()) {
                        ProcessUnit processUnit = this.getProcessUnit(string3);
                        processUnit.setRoot();
                        this.rootUnit = processUnit;
                        return string3;
                    }
                    return "0";
                }
                bufferedStringOperator2 = null;
                return "0";
            }
            return "0";
        }
        catch (Exception exception) {
            this.processEngine.showErrorText(exception);
            return "0";
        }
    }

    String getProcessedSectionAll(String string) {
        BufferedStringOperator bufferedStringOperator = new BufferedStringOperator();
        bufferedStringOperator.open(string);
        this.getProcessedSectionAll(bufferedStringOperator);
        String string2 = bufferedStringOperator.toString();
        bufferedStringOperator.close();
        bufferedStringOperator = null;
        return string2;
    }

    void getProcessedSectionAll(BufferedStringOperator bufferedStringOperator) {
        Object object;
        String string;
        String string2 = "";
        int[] nArray = new int[2];
        while (0 <= bufferedStringOperator.indexOf("(", 0)) {
            string2 = this.getTopPrioritySection(bufferedStringOperator.toString(), nArray);
            string = this.getProcessedSection(string2);
            if (string == null) {
                this.error(new ProcessSyntaxException().getInfoMessage(25));
                return;
            }
            if (this.useBracketUnit && string.indexOf("(") < 0) {
                object = null;
                if (!string.startsWith("SYSTEM_ESCAPE_CAST_")) {
                    object = this.getProcessUnit(string);
                }
                if (object != null) {
                    ProcessUnit processUnit;
                    boolean bl = false;
                    try {
                        processUnit = (FunctionCallUnit)object;
                        bl = true;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    try {
                        processUnit = (SystemFunctionUnit)object;
                        bl = true;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (!bl) {
                        string = this.bracket(string);
                    }
                }
            }
            if (this.hasError()) break;
            if (string == null) {
                if (!this.error) {
                    object = bufferedStringOperator.substring(nArray[0], nArray[1] + 1);
                    bufferedStringOperator.setString(null);
                    return;
                }
            } else {
                bufferedStringOperator.replace(nArray[0], nArray[1] + 1, string);
            }
            if (!this.hasError()) continue;
        }
        if (!this.hasError()) {
            string2 = this.getTopPrioritySection(bufferedStringOperator.toString(), nArray);
            string = this.getProcessedSection(string2);
            if (string == null) {
                if (!this.error) {
                    object = bufferedStringOperator.substring(nArray[0], nArray[1] + 1);
                    bufferedStringOperator.setString(null);
                    return;
                }
            } else {
                bufferedStringOperator.replace(nArray[0], nArray[1] + 1, string);
            }
        }
    }

    private boolean hasMoreSection(String string) {
        int n = string.indexOf("(", 0);
        return n != -1;
    }

    private boolean hasMoreSection(BufferedStringOperator bufferedStringOperator) {
        int n = bufferedStringOperator.indexOf("(", 0);
        return n != -1;
    }

    public String calculateSection(String string) {
        if (this.error) {
            return null;
        }
        String string2 = this.getTopPrioritySection(string);
        String string3 = this.getProcessedSection(string2);
        if (string3 == null) {
            return null;
        }
        BufferedStringOperator bufferedStringOperator = new BufferedStringOperator();
        bufferedStringOperator.open(string);
        bufferedStringOperator.replaceAllString(string2, string3);
        String string4 = bufferedStringOperator.toString();
        bufferedStringOperator.close();
        bufferedStringOperator = null;
        return string4;
    }

    private String getPreferedDescription(String string) {
        if (this.error) {
            return null;
        }
        String string2 = string;
        BufferedStringOperator bufferedStringOperator = new BufferedStringOperator();
        bufferedStringOperator.open(string2);
        bufferedStringOperator.replaceAllString(" ", "");
        bufferedStringOperator.replaceAllString("\t", "");
        if (0 < bufferedStringOperator.indexOf("e+") || 0 < bufferedStringOperator.indexOf("e-") || 0 < bufferedStringOperator.indexOf("E+") || 0 < bufferedStringOperator.indexOf("E-")) {
            for (int i = 0; i <= 9; ++i) {
                bufferedStringOperator.replaceAllString(i + "e+", i + "E");
                bufferedStringOperator.replaceAllString(i + "e-", i + "E-");
                bufferedStringOperator.replaceAllString(i + "E+", i + "E");
                bufferedStringOperator.replaceAllString(i + "E-", i + "SYSTEM_PROCESS_ESCAPE_EMINUS");
            }
        }
        if (1 <= bufferedStringOperator.length() && bufferedStringOperator.charAt(0) == '-') {
            bufferedStringOperator.setString("SYSTEM_PROCESS_ESCAPE_HEADMINUS" + bufferedStringOperator.substring(1, bufferedStringOperator.length()));
        }
        if (0 < bufferedStringOperator.indexOf("-")) {
            bufferedStringOperator.replaceAllString("+-", "-");
            bufferedStringOperator.replaceAllString("*-", "*SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("/-", "/SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("%-", "%SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("^-", "^SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("(-", "(SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("||-", "||SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("&&-", "&&SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("[-", "[SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("<-", "<SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString(">-", ">SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("=-", "=SYSTEM_PROCESS_ESCAPE_HEADMINUS");
        }
        string2 = bufferedStringOperator.toString();
        bufferedStringOperator.close();
        bufferedStringOperator = null;
        return string2;
    }

    private void getPreferedDescription(BufferedStringOperator bufferedStringOperator) {
        if (this.error) {
            return;
        }
        bufferedStringOperator.replaceAllString(" ", "");
        bufferedStringOperator.replaceAllString("\t", "");
        if (0 < bufferedStringOperator.indexOf("e+") || 0 < bufferedStringOperator.indexOf("e-") || 0 < bufferedStringOperator.indexOf("E+") || 0 < bufferedStringOperator.indexOf("E-")) {
            for (int i = 0; i <= 9; ++i) {
                bufferedStringOperator.replaceAllString(i + "e+", i + "E");
                bufferedStringOperator.replaceAllString(i + "e-", i + "E-");
                bufferedStringOperator.replaceAllString(i + "E+", i + "E");
                bufferedStringOperator.replaceAllString(i + "E-", i + "SYSTEM_PROCESS_ESCAPE_EMINUS");
            }
        }
        if (0 <= bufferedStringOperator.indexOf("++")) {
            bufferedStringOperator.replaceAllString("++", "SYSTEM_PROCESS_ESCAPE_INCREMENT");
        }
        if (0 <= bufferedStringOperator.indexOf("--")) {
            bufferedStringOperator.replaceAllString("--", "SYSTEM_PROCESS_ESCAPE_DECREMENT");
        }
        if (1 <= bufferedStringOperator.length() && bufferedStringOperator.charAt(0) == '-') {
            bufferedStringOperator.setString("SYSTEM_PROCESS_ESCAPE_HEADMINUS" + bufferedStringOperator.substring(1, bufferedStringOperator.length()));
        }
        if (0 < bufferedStringOperator.indexOf("-")) {
            bufferedStringOperator.replaceAllString("+-", "-");
            bufferedStringOperator.replaceAllString("--", "+");
            bufferedStringOperator.replaceAllString("*-", "*SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("/-", "/SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("%-", "%SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("^-", "^SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("(-", "(SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("||-", "||SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("&&-", "&&SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("[-", "[SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("<-", "<SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString(">-", ">SYSTEM_PROCESS_ESCAPE_HEADMINUS");
            bufferedStringOperator.replaceAllString("=-", "=SYSTEM_PROCESS_ESCAPE_HEADMINUS");
        }
    }

    private String getTopPrioritySection(String string) {
        return this.getTopPrioritySection(string, new int[]{0, 0});
    }

    private String getTopPrioritySection(String string, int[] nArray) {
        int n;
        int n2;
        int n3;
        ProcessCompatibilityException processCompatibilityException;
        if (this.error) {
            nArray[0] = 0;
            nArray[1] = 0;
            return null;
        }
        int n4 = string.length();
        int n5 = 0;
        int n6 = 0;
        n5 = string.indexOf("(", 0);
        n6 = string.indexOf(")", 0);
        if (n5 == -1 && n6 == -1) {
            nArray[0] = 0;
            nArray[1] = string.length() - 1;
            return string;
        }
        if (n5 == -1) {
            processCompatibilityException = new ProcessCompatibilityException();
            if (!processCompatibilityException.alert()) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u304b\u3063\u3053 ( ) \u306e\u6570\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                } else {
                    this.error("Correspondence of open/close parentheses ( ) are broken.");
                }
            }
            string = "(" + string;
            n4 = string.length();
            n5 = string.indexOf("(", 0);
            n6 = string.indexOf(")", 0);
        }
        if (n6 == -1) {
            processCompatibilityException = new ProcessCompatibilityException();
            if (!processCompatibilityException.alert()) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u304b\u3063\u3053 ( ) \u306e\u6570\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                } else {
                    this.error("Correspondence of open/close parentheses ( ) are broken.");
                }
            }
            string = string + ")";
            n4 = string.length();
            n5 = string.indexOf("(", 0);
            n6 = string.indexOf(")", 0);
        }
        for (int i = 0; i < n4 - 1; ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                n5 = i;
                continue;
            }
            if (c != ')') continue;
            n6 = i;
            break;
        }
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        string3 = string.substring(0, n5);
        boolean bl2 = false;
        String string4 = "";
        for (n3 = string3.length() - 1; 0 <= n3; --n3) {
            if (string3.charAt(n3) == ' ' || string3.charAt(n3) == '\t') continue;
            if (string3.charAt(n3) == '>') {
                bl2 = true;
                break;
            }
            bl2 = false;
            break;
        }
        if (bl2) {
            n3 = 0;
            n2 = this.cutCode.length;
            for (n = string3.length() - 1; 0 <= n; --n) {
                char c = string3.charAt(n);
                if (c == ' ' || c == '\t') continue;
                if (c == '>') {
                    ++n3;
                } else if (c == '<') {
                    --n3;
                }
                if (n3 != 0) continue;
                string4 = string3.substring(n, string3.length());
                string3 = string3.substring(0, n);
                break;
            }
        }
        n3 = -1;
        n2 = this.cutCode.length;
        for (n = 0; n < n2; ++n) {
            n3 = string3.indexOf(this.cutCode[n]);
            while (n3 != -1) {
                string3 = string3.substring(n3 + this.cutCode[n].length(), string3.length());
                n3 = string3.indexOf(this.cutCode[n]);
            }
        }
        if (bl2) {
            string3 = string3 + string4;
        }
        string3 = string3.replaceAll(" ", "");
        string3 = string3.replaceAll("\t", "");
        bl = (string3 = string3.replaceAll("\u3000", "")).length() > 0;
        string2 = string3 + string.substring(n5, n6 + 1);
        if (nArray != null) {
            nArray[0] = n5 - string3.length();
            nArray[1] = n6;
        }
        return string2;
    }

    public int countSubst(String string) {
        Object object;
        int n = 0;
        int n2 = 0;
        char[] cArray = new char[]{'+', '-', '*', '/', '%'};
        for (int i = 0; i < cArray.length; ++i) {
            object = cArray[i] + "=";
            n2 = 0;
            while (0 <= (n2 = string.indexOf((String)object, n2 + 1))) {
                ++n;
            }
        }
        String string2 = "=";
        n2 = 0;
        object = new char[]{'+', '-', '*', '/', '%', '<', '>', '!'};
        while (0 <= (n2 = string.indexOf(string2, n2 + 1))) {
            boolean bl = false;
            if (n2 + 1 < string.length() && string.charAt(n2 + 1) == '=' || 1 <= n2 && string.charAt(n2 - 1) == '=') {
                bl = true;
                continue;
            }
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (string.charAt(n2 - 1) != object[i]) continue;
                bl = true;
            }
            if (bl) continue;
            ++n;
        }
        return n;
    }

    public void checkSubstCount(String string) {
        int n = this.countSubst(string);
        if (2 <= n) {
            this.error(new ProcessSyntaxException().getInfoMessage(23));
        }
    }

    public String preProcess(String string) {
        return string;
    }

    public void preProcess(BufferedStringOperator bufferedStringOperator) {
    }

    public void processCompoundAssignmentOperatorMacro(BufferedStringOperator bufferedStringOperator) {
        if (this.error) {
            return;
        }
        String string = bufferedStringOperator.toString();
        if (0 < string.indexOf("=")) {
            String[] stringArray;
            if (0 < string.indexOf("+=")) {
                String[] stringArray2 = string.split("\\+=");
                if (stringArray2.length == 2) {
                    ProcessCompatibilityException processCompatibilityException;
                    boolean bl = 0 <= stringArray2[0].indexOf("SYSTEM_PROCESS_ESCAPE_INCREMENT") || 0 <= stringArray2[0].indexOf("SYSTEM_PROCESS_ESCAPE_DECREMENT") || 0 <= stringArray2[0].indexOf("=");
                    stringArray2[0] = this.getProcessedSectionAll(stringArray2[0]);
                    if ((bl || this.usingFunctionCall) && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                        if (ScriptProcessor.locale.isJapanese()) {
                            this.error("\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u306e\u5de6\u8fba\u306b\u304a\u3044\u3066\u3001\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3084\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3001\u4ee3\u5165\u6f14\u7b97\u3001\u95a2\u6570\u547c\u3073\u51fa\u3057\u306a\u3069\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u3092\u30de\u30af\u30ed\u7f6e\u63db\u306b\u3088\u3063\u3066\u51e6\u7406\u3059\u308b\u51e6\u7406\u7cfb\u306b\u304a\u3044\u3066\u306f\u3001\u3053\u308c\u3089\u306f\u30de\u30af\u30ed\u306e\u526f\u4f5c\u7528\u306b\u3088\u308a\u591a\u91cd\u5b9f\u884c\u3055\u308c\u3001\u610f\u56f3\u306b\u53cd\u3059\u308b\u7d50\u679c\u3092\u8fd4\u3057\u307e\u3059\u3002");
                        } else {
                            this.error("It isn't recommended to perform increment/decrement operations, assignment operations, or function calls, at the left-side of a compound assignment operation. It may lead unexpected behaviours depending on the implementation of the script engine.");
                        }
                    }
                    stringArray2[1] = this.getProcessedSectionAll(stringArray2[1]);
                    string = stringArray2[0] + "=" + stringArray2[0] + "+" + stringArray2[1];
                    string = this.getProcessedSectionAll(string);
                }
            } else if (0 < string.indexOf("-=")) {
                String[] stringArray3 = string.split("-=");
                if (stringArray3.length == 2) {
                    ProcessCompatibilityException processCompatibilityException;
                    boolean bl = 0 <= stringArray3[0].indexOf("SYSTEM_PROCESS_ESCAPE_INCREMENT") || 0 <= stringArray3[0].indexOf("SYSTEM_PROCESS_ESCAPE_DECREMENT") || 0 <= stringArray3[0].indexOf("=");
                    stringArray3[0] = this.getProcessedSectionAll(stringArray3[0]);
                    if ((bl || this.usingFunctionCall) && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                        if (ScriptProcessor.locale.isJapanese()) {
                            this.error("\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u306e\u5de6\u8fba\u306b\u304a\u3044\u3066\u3001\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3084\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3001\u4ee3\u5165\u6f14\u7b97\u3001\u95a2\u6570\u547c\u3073\u51fa\u3057\u306a\u3069\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u3092\u30de\u30af\u30ed\u7f6e\u63db\u306b\u3088\u3063\u3066\u51e6\u7406\u3059\u308b\u51e6\u7406\u7cfb\u306b\u304a\u3044\u3066\u306f\u3001\u3053\u308c\u3089\u306f\u30de\u30af\u30ed\u306e\u526f\u4f5c\u7528\u306b\u3088\u308a\u591a\u91cd\u5b9f\u884c\u3055\u308c\u3001\u610f\u56f3\u306b\u53cd\u3059\u308b\u7d50\u679c\u3092\u8fd4\u3057\u307e\u3059\u3002");
                        } else {
                            this.error("It isn't recommended to perform increment/decrement operations, assignment operations, or function calls, at the left-side of a compound assignment operation. It may lead unexpected behaviours depending on the implementation of the script engine.");
                        }
                    }
                    stringArray3[1] = this.getProcessedSectionAll(stringArray3[1]);
                    string = stringArray3[0] + "=" + stringArray3[0] + "-" + stringArray3[1];
                    string = this.getProcessedSectionAll(string);
                }
            } else if (0 < string.indexOf("*=")) {
                String[] stringArray4 = string.split("\\*=");
                if (stringArray4.length == 2) {
                    ProcessCompatibilityException processCompatibilityException;
                    boolean bl = 0 <= stringArray4[0].indexOf("SYSTEM_PROCESS_ESCAPE_INCREMENT") || 0 <= stringArray4[0].indexOf("SYSTEM_PROCESS_ESCAPE_DECREMENT") || 0 <= stringArray4[0].indexOf("=");
                    stringArray4[0] = this.getProcessedSectionAll(stringArray4[0]);
                    if ((bl || this.usingFunctionCall) && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                        if (ScriptProcessor.locale.isJapanese()) {
                            this.error("\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u306e\u5de6\u8fba\u306b\u304a\u3044\u3066\u3001\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3084\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3001\u4ee3\u5165\u6f14\u7b97\u3001\u95a2\u6570\u547c\u3073\u51fa\u3057\u306a\u3069\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u3092\u30de\u30af\u30ed\u7f6e\u63db\u306b\u3088\u3063\u3066\u51e6\u7406\u3059\u308b\u51e6\u7406\u7cfb\u306b\u304a\u3044\u3066\u306f\u3001\u3053\u308c\u3089\u306f\u30de\u30af\u30ed\u306e\u526f\u4f5c\u7528\u306b\u3088\u308a\u591a\u91cd\u5b9f\u884c\u3055\u308c\u3001\u610f\u56f3\u306b\u53cd\u3059\u308b\u7d50\u679c\u3092\u8fd4\u3057\u307e\u3059\u3002");
                        } else {
                            this.error("It isn't recommended to perform increment/decrement operations, assignment operations, or function calls, at the left-side of a compound assignment operation. It may lead unexpected behaviours depending on the implementation of the script engine.");
                        }
                    }
                    stringArray4[1] = this.getProcessedSectionAll(stringArray4[1]);
                    string = stringArray4[0] + "=" + stringArray4[0] + "*" + stringArray4[1];
                    string = this.getProcessedSectionAll(string);
                }
            } else if (0 < string.indexOf("/=")) {
                String[] stringArray5 = string.split("/=");
                if (stringArray5.length == 2) {
                    ProcessCompatibilityException processCompatibilityException;
                    boolean bl = 0 <= stringArray5[0].indexOf("SYSTEM_PROCESS_ESCAPE_INCREMENT") || 0 <= stringArray5[0].indexOf("SYSTEM_PROCESS_ESCAPE_DECREMENT") || 0 <= stringArray5[0].indexOf("=");
                    stringArray5[0] = this.getProcessedSectionAll(stringArray5[0]);
                    if ((bl || this.usingFunctionCall) && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                        if (ScriptProcessor.locale.isJapanese()) {
                            this.error("\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u306e\u5de6\u8fba\u306b\u304a\u3044\u3066\u3001\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3084\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3001\u4ee3\u5165\u6f14\u7b97\u3001\u95a2\u6570\u547c\u3073\u51fa\u3057\u306a\u3069\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u3092\u30de\u30af\u30ed\u7f6e\u63db\u306b\u3088\u3063\u3066\u51e6\u7406\u3059\u308b\u51e6\u7406\u7cfb\u306b\u304a\u3044\u3066\u306f\u3001\u3053\u308c\u3089\u306f\u30de\u30af\u30ed\u306e\u526f\u4f5c\u7528\u306b\u3088\u308a\u591a\u91cd\u5b9f\u884c\u3055\u308c\u3001\u610f\u56f3\u306b\u53cd\u3059\u308b\u7d50\u679c\u3092\u8fd4\u3057\u307e\u3059\u3002");
                        } else {
                            this.error("It isn't recommended to perform increment/decrement operations, assignment operations, or function calls, at the left-side of a compound assignment operation. It may lead unexpected behaviours depending on the implementation of the script engine.");
                        }
                    }
                    stringArray5[1] = this.getProcessedSectionAll(stringArray5[1]);
                    string = stringArray5[0] + "=" + stringArray5[0] + "/" + stringArray5[1];
                    string = this.getProcessedSectionAll(string);
                }
            } else if (0 < string.indexOf("%=") && (stringArray = string.split("%=")).length == 2) {
                ProcessCompatibilityException processCompatibilityException;
                boolean bl = 0 <= stringArray[0].indexOf("SYSTEM_PROCESS_ESCAPE_INCREMENT") || 0 <= stringArray[0].indexOf("SYSTEM_PROCESS_ESCAPE_DECREMENT") || 0 <= stringArray[0].indexOf("=");
                stringArray[0] = this.getProcessedSectionAll(stringArray[0]);
                if ((bl || this.usingFunctionCall) && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u306e\u5de6\u8fba\u306b\u304a\u3044\u3066\u3001\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3084\u30c7\u30af\u30ea\u30e1\u30f3\u30c8\u6f14\u7b97\u3001\u4ee3\u5165\u6f14\u7b97\u3001\u95a2\u6570\u547c\u3073\u51fa\u3057\u306a\u3069\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u5408\u4ee3\u5165\u6f14\u7b97\u5b50\u3092\u30de\u30af\u30ed\u7f6e\u63db\u306b\u3088\u3063\u3066\u51e6\u7406\u3059\u308b\u51e6\u7406\u7cfb\u306b\u304a\u3044\u3066\u306f\u3001\u3053\u308c\u3089\u306f\u30de\u30af\u30ed\u306e\u526f\u4f5c\u7528\u306b\u3088\u308a\u591a\u91cd\u5b9f\u884c\u3055\u308c\u3001\u610f\u56f3\u306b\u53cd\u3059\u308b\u7d50\u679c\u3092\u8fd4\u3057\u307e\u3059\u3002");
                    } else {
                        this.error("It isn't recommended to perform increment/decrement operations, assignment operations, or function calls, at the left-side of a compound assignment operation. It may lead unexpected behaviours depending on the implementation of the script engine.");
                    }
                }
                stringArray[1] = this.getProcessedSectionAll(stringArray[1]);
                string = stringArray[0] + "=" + stringArray[0] + "%" + stringArray[1];
                string = this.getProcessedSectionAll(string);
            }
        }
        bufferedStringOperator.setString(string);
    }

    public String processDeclear(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string3.startsWith("SYSTEM_PROCESS_DECLEARTION")) {
            string2 = string2.replaceAll("\t", " ");
            while (string2.charAt(0) == ' ') {
                string2 = string2.substring(1, string2.length());
            }
        }
        if (string2.startsWith("SYSTEM_PROCESS_DECLEARTION")) {
            int n;
            String string4;
            if (string2.startsWith("SYSTEM_PROCESS_DECLEARTION_RETURN")) {
                string2 = string2.replaceAll("SYSTEM_PROCESS_DECLEARTION_RETURN", "return=");
            }
            if (string2.startsWith("SYSTEM_PROCESS_DECLEARTION_ALLOC")) {
                string4 = string2.substring(32, string2.length());
                n = 0;
                int n2 = 0;
                for (int i = 0; i < string4.length(); ++i) {
                    if (string4.charAt(i) == '[') {
                        ++n2;
                        continue;
                    }
                    if (string4.charAt(i) == ']') {
                        --n2;
                        continue;
                    }
                    if (n2 != 0) continue;
                    n = i;
                    break;
                }
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n, string4.length());
                ProcessUnit processUnit = this.getProcessUnit(string6);
                if (!processUnit.isArrayType() && processUnit.getValueType() != 200) {
                    this.error(new ProcessSyntaxException(this.processEngine).getInfo(16));
                    return null;
                }
                string6 = processUnit.getID();
                String string7 = "";
                if (string5.indexOf(91) < 0) {
                    if (processUnit.getValueType() == 200 && !processUnit.isArrayType()) {
                        return this.calculateSection("(SYSTEM_PROCESS_SYSTEMCALL_stralloc(" + string6 + "))");
                    }
                    this.error(new ProcessSyntaxException(this.processEngine).getInfo(16));
                    return null;
                }
                string7 = "(SYSTEM_PROCESS_SYSTEMCALL_alloc(" + string6 + "))";
                while (0 <= string7.indexOf("(")) {
                    string7 = this.calculateSection(string7);
                }
                string7 = string7 + string5;
                string7 = this.calculateSection(string7);
                ProcessUnit processUnit2 = this.getProcessUnit(string7);
                ArrayAccessUnit arrayAccessUnit = (ArrayAccessUnit)processUnit2;
                ArrayAccessWrapperUnit arrayAccessWrapperUnit = new ArrayAccessWrapperUnit(this.processEngine, arrayAccessUnit);
                this.add(arrayAccessWrapperUnit);
                string2 = arrayAccessWrapperUnit.getID();
            }
            if (string2.startsWith("SYSTEM_PROCESS_DECLEARTION_FREE")) {
                string4 = string2.substring(31, string2.length());
                n = string4.indexOf("[");
                ProcessUnit processUnit = this.getProcessUnit(string4);
                string2 = "(SYSTEM_PROCESS_SYSTEMCALL_free( " + processUnit.getID() + " ))";
                while (0 <= string2.indexOf("(")) {
                    string2 = this.calculateSection(string2);
                }
            }
        }
        return string2;
    }

    public String getProcessedSection(String string) {
        if (this.error) {
            return null;
        }
        if (string == null) {
            return null;
        }
        string = this.processDeclear(string);
        BufferedStringOperator bufferedStringOperator = new BufferedStringOperator();
        bufferedStringOperator.open(string);
        String string2 = null;
        int n = string.indexOf("(");
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        Object object = "";
        bufferedStringOperator.replaceAllString(string2 + "(", "");
        bufferedStringOperator.replaceAllString(")", "");
        bufferedStringOperator.replaceAllString("(", "");
        String string3 = bufferedStringOperator.toString();
        boolean bl = true;
        if (string2 == null) {
            bl = false;
        }
        if (this.error) {
            return null;
        }
        if (!bl) {
            Object object2;
            String[] stringArray;
            Object object3;
            if (0 <= bufferedStringOperator.toString().indexOf(44)) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("VCSSL\u3067\u306f\u3001\u30b3\u30f3\u30de\u6f14\u7b97\u5b50\u300c , \u300d\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u30021\u3064\u306e\u6587\u306e\u4e2d\u306b\u3001\u30b3\u30f3\u30de\u3067\u533a\u5207\u3063\u3066\u8907\u6570\u306e\u5f0f\u3084\u6587\u3092\u8a18\u8ff0\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.error("In VCSSL, the comma operator \",\" is not supported, so you can not describe multiple expressions/statements with separating by commas.");
                }
                return "___SYSTEM_SYNRAX_ERROR";
            }
            this.checkSubstCount(bufferedStringOperator.toString());
            this.preProcess(bufferedStringOperator);
            this.getPreferedDescription(bufferedStringOperator);
            if (0 <= bufferedStringOperator.indexOf("^") && !((ProcessCompatibilityException)(object3 = new ProcessCompatibilityException())).alert()) {
                stringArray = new ProcessSyntaxException(this.processEngine);
                this.error(stringArray.getInfoMessage(13));
            }
            bufferedStringOperator.replaceAllString("**", "SYSTEM_ESCAPE_POWER");
            bufferedStringOperator.replaceAllString("^", "SYSTEM_ESCAPE_POWER");
            bufferedStringOperator.replaceAllString("==", "SYSTEM_ESCAPE_EQUAL");
            bufferedStringOperator.replaceAllString("!=", "SYSTEM_ESCAPE_NOT_EQUAL");
            bufferedStringOperator.replaceAllString(">=", "SYSTEM_ESCAPE_GREATER_EQUAL");
            bufferedStringOperator.replaceAllString("=>", "SYSTEM_ESCAPE_GREATER_EQUAL");
            bufferedStringOperator.replaceAllString(">", "SYSTEM_ESCAPE_GREATER_THAN");
            bufferedStringOperator.replaceAllString("<=", "SYSTEM_ESCAPE_LESS_EQUAL");
            bufferedStringOperator.replaceAllString("=<", "SYSTEM_ESCAPE_LESS_EQUAL");
            bufferedStringOperator.replaceAllString("<", "SYSTEM_ESCAPE_LESS_THAN");
            object3 = bufferedStringOperator.toString();
            object3 = this.processDeclear((String)object3);
            if (((String)object3).equals("int") || ((String)object3).equals("long")) {
                return "SYSTEM_ESCAPE_CAST_INTEGER";
            }
            if (((String)object3).equals("double") || ((String)object3).equals("float")) {
                return "SYSTEM_ESCAPE_CAST_DECIMAL";
            }
            if (((String)object3).equals("complex")) {
                return "SYSTEM_ESCAPE_CAST_COMPLEX";
            }
            if (((String)object3).equals("varint")) {
                return "SYSTEM_ESCAPE_CAST_BIGINTEGER";
            }
            if (((String)object3).equals("varfloat")) {
                return "SYSTEM_ESCAPE_CAST_BIGDECIMAL";
            }
            if (((String)object3).equals("varcomplex")) {
                return "SYSTEM_ESCAPE_CAST_BIGCOMPLEX";
            }
            if (((String)object3).equals("String") || ((String)object3).equals("string")) {
                return "SYSTEM_ESCAPE_CAST_STRING";
            }
            if (((String)object3).equals("boolean") || ((String)object3).equals("bool")) {
                return "SYSTEM_ESCAPE_CAST_BOOLEAN";
            }
            stringArray = ((String)object3).split("SYSTEM_ESCAPE_LENGTH_EQUAL");
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                object2 = stringArray[i].split("=");
                int n3 = ((String[])object2).length;
                for (int j = 0; j < n3; ++j) {
                    String[] stringArray2 = object2[j].split("\\|\\|");
                    int n4 = stringArray2.length;
                    for (int k = 0; k < n4; ++k) {
                        String[] stringArray3 = stringArray2[k].split("&&");
                        int n5 = stringArray3.length;
                        for (int i2 = 0; i2 < n5; ++i2) {
                            String[] stringArray4 = stringArray3[i2].split("SYSTEM_ESCAPE_EQUAL");
                            int n6 = stringArray4.length;
                            for (int i3 = 0; i3 < n6; ++i3) {
                                String[] stringArray5 = stringArray4[i3].split("SYSTEM_ESCAPE_NOT_EQUAL");
                                int n7 = stringArray5.length;
                                for (int i4 = 0; i4 < n7; ++i4) {
                                    String[] stringArray6 = stringArray5[i4].split("SYSTEM_ESCAPE_GREATER_THAN");
                                    int n8 = stringArray6.length;
                                    for (int i5 = 0; i5 < n8; ++i5) {
                                        String[] stringArray7 = stringArray6[i5].split("SYSTEM_ESCAPE_GREATER_EQUAL");
                                        int n9 = stringArray7.length;
                                        for (int i6 = 0; i6 < n9; ++i6) {
                                            String[] stringArray8 = stringArray7[i6].split("SYSTEM_ESCAPE_LESS_THAN");
                                            int n10 = stringArray8.length;
                                            for (int i7 = 0; i7 < n10; ++i7) {
                                                String[] stringArray9 = stringArray8[i7].split("SYSTEM_ESCAPE_LESS_EQUAL");
                                                int n11 = stringArray9.length;
                                                for (int i8 = 0; i8 < n11; ++i8) {
                                                    stringArray9[i8] = this.thirdPriorityConstruction(stringArray9[i8]);
                                                }
                                                String string4 = 1 < n11 ? this.lessEqual(stringArray9) : stringArray9[0];
                                                stringArray8[i7] = string4;
                                            }
                                            String string5 = 1 < n10 ? this.lessThan(stringArray8) : stringArray8[0];
                                            stringArray7[i6] = string5;
                                        }
                                        String string6 = 1 < n9 ? this.greaterEqual(stringArray7) : stringArray7[0];
                                        stringArray6[i5] = string6;
                                    }
                                    String string7 = 1 < n8 ? this.greaterThan(stringArray6) : stringArray6[0];
                                    stringArray5[i4] = string7;
                                }
                                String string8 = 1 < n7 ? this.notEqual(stringArray5) : stringArray5[0];
                                stringArray4[i3] = string8;
                            }
                            String string9 = 1 < n6 ? this.equal(stringArray4) : stringArray4[0];
                            stringArray3[i2] = string9;
                        }
                        String string10 = 1 < n5 ? this.and(stringArray3) : stringArray3[0];
                        stringArray2[k] = string10;
                    }
                    String string11 = 1 < n4 ? this.or(stringArray2) : stringArray2[0];
                    object2[j] = string11;
                }
                Object object4 = 1 < n3 ? this.substitution((String[])object2) : object2[0];
                stringArray[i] = object4;
            }
            String string12 = 1 < n2 ? this.arrayLengthSubstitution(stringArray) : stringArray[0];
            object2 = this.getProcessUnit(string12);
            if (this.error) {
                return null;
            }
            ((ProcessUnit)object2).setProcessKernel(this.kernel);
            object = ((ProcessUnit)object2).getID();
        } else if (string2.equals("SYSTEM_PROCESS_ESCAPE_HEADMINUS")) {
            if (this.error) {
                return null;
            }
            object = this.minus(this.getProcessedSectionAll(string3));
        } else if (string2.startsWith("SYSTEM_ESCAPE_CAST_")) {
            if (this.error) {
                return null;
            }
            String string13 = null;
            if (string2.startsWith("SYSTEM_ESCAPE_CAST_INTEGER")) {
                string2 = string2.substring("SYSTEM_ESCAPE_CAST_INTEGER".length(), string2.length());
                string13 = "SYSTEM_ESCAPE_CAST_INTEGER" + this.getProcessedSectionAll(string2 + "(" + this.getProcessedSectionAll(string3) + ")");
            } else if (string2.startsWith("SYSTEM_ESCAPE_CAST_DECIMAL")) {
                string2 = string2.substring("SYSTEM_ESCAPE_CAST_DECIMAL".length(), string2.length());
                string13 = "SYSTEM_ESCAPE_CAST_DECIMAL" + this.getProcessedSectionAll(string2 + "(" + this.getProcessedSectionAll(string3) + ")");
            } else if (string2.startsWith("SYSTEM_ESCAPE_CAST_COMPLEX")) {
                string2 = string2.substring("SYSTEM_ESCAPE_CAST_COMPLEX".length(), string2.length());
                string13 = "SYSTEM_ESCAPE_CAST_COMPLEX" + this.getProcessedSectionAll(string2 + "(" + this.getProcessedSectionAll(string3) + ")");
            } else if (string2.startsWith("SYSTEM_ESCAPE_CAST_BIGINTEGER")) {
                string2 = string2.substring("SYSTEM_ESCAPE_CAST_BIGINTEGER".length(), string2.length());
                string13 = "SYSTEM_ESCAPE_CAST_BIGINTEGER" + this.getProcessedSectionAll(string2 + "(" + this.getProcessedSectionAll(string3) + ")");
            } else if (string2.startsWith("SYSTEM_ESCAPE_CAST_BIGDECIMAL")) {
                string2 = string2.substring("SYSTEM_ESCAPE_CAST_BIGDECIMAL".length(), string2.length());
                string13 = "SYSTEM_ESCAPE_CAST_BIGDECIMAL" + this.getProcessedSectionAll(string2 + "(" + this.getProcessedSectionAll(string3) + ")");
            } else if (string2.startsWith("SYSTEM_ESCAPE_CAST_BIGCOMPLEX")) {
                string2 = string2.substring("SYSTEM_ESCAPE_CAST_BIGCOMPLEX".length(), string2.length());
                string13 = "SYSTEM_ESCAPE_CAST_BIGCOMPLEX" + this.getProcessedSectionAll(string2 + "(" + this.getProcessedSectionAll(string3) + ")");
            } else if (string2.startsWith("SYSTEM_ESCAPE_CAST_STRING")) {
                string2 = string2.substring("SYSTEM_ESCAPE_CAST_STRING".length(), string2.length());
                string13 = "SYSTEM_ESCAPE_CAST_STRING" + this.getProcessedSectionAll(string2 + "(" + this.getProcessedSectionAll(string3) + ")");
            } else if (string2.startsWith("SYSTEM_ESCAPE_CAST_BOOLEAN")) {
                string2 = string2.substring("SYSTEM_ESCAPE_CAST_BOOLEAN".length(), string2.length());
                string13 = "SYSTEM_ESCAPE_CAST_BOOLEAN" + this.getProcessedSectionAll(string2 + "(" + this.getProcessedSectionAll(string3) + ")");
            }
            String[] stringArray = new String[]{string13};
            String[] stringArray10 = this.prefix(stringArray);
            object = stringArray10[0];
        } else if (string2.startsWith("SYSTEM_PROCESS_ESCAPE_HEADMINUS")) {
            String string14 = string2.substring(31, string2.length());
            String string15 = string14 + "(" + string3 + ")";
            while (0 <= string15.indexOf("(")) {
                if ((string15 = this.calculateSection(string15)) != null) continue;
                return null;
            }
            object = this.minus(string15);
        } else if (this.processEngine.isProcessable(string2) || SystemFunctionUnit.isProcessable(string2) || this.programInstance != null && this.programInstance.getFunction(string2) != null) {
            Object object5;
            block101: {
                Object object6;
                Object object7;
                if (!string2.startsWith("SYSTEM_PROCESS_ARRAY_INITIALIZER") && !string2.startsWith("SYSTEM_PROCESS_SYSTEMCALL_alloc")) {
                    this.usingConstOnly = false;
                    this.usingFunctionCall = true;
                }
                if (string2.startsWith("SYSTEM_PROCESS_ARRAY_INITIALIZER")) {
                    if (this.kernel.isArray() && this.kernel.getKernelType() == ProcessKernel.VARIABLE_TYPE) {
                        if (string3.indexOf(",") < 0 && ((String)(object7 = ((ProcessUnit)(object5 = this.getProcessUnit(string3))).getStringValue())).startsWith("<ERROR>")) {
                            object6 = ((String)object7).substring(((String)object7).indexOf("</ERROR>") + 8, ((String)object7).length());
                            object7 = ((String)object7).substring(7, ((String)object7).indexOf("</ERROR>"));
                            String string16 = this.kernel.programLine;
                            string16 = string16.substring(0, string16.indexOf("SYSTEM_PROCESS_ARRAY_INITIALIZER"));
                            this.kernel.programLine = string16 = string16 + (String)object6;
                            this.error((String)object7);
                        }
                    } else {
                        object5 = this.kernel.programLine;
                        object5 = ((String)object5).substring(0, ((String)object5).indexOf("SYSTEM_PROCESS_ARRAY_INITIALIZER"));
                        this.kernel.programLine = object5 = (String)object5 + "{ ??? }";
                        object7 = ScriptProcessor.locale.isJapanese() ? "\u914d\u5217\u521d\u671f\u5316\u5b50\u306f\u3001\u914d\u5217\u5ba3\u8a00\u884c\u4ee5\u5916\u3067\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002" : "Cannot use array-initializers excluding in array declaration statements.";
                        this.error(this.errorMessage);
                    }
                }
                if (this.error) {
                    return null;
                }
                object7 = string3.split(",");
                object6 = this.programInstance == null ? null : this.programInstance.getFunction(string2);
                boolean bl2 = false;
                if (((String[])object7).length == 1 && (object7[0].length() == 0 || ((String)object7[0]).equals(""))) {
                    bl2 = true;
                }
                if (!bl2) {
                    for (int i = 0; i < ((Object)object7).length; ++i) {
                        if (this.isAdded((String)object7[i])) continue;
                        if (this.error) {
                            return null;
                        }
                        String string17 = this.getProcessedSection((String)object7[i]);
                        if (this.error) {
                            return null;
                        }
                        object7[i] = string17;
                    }
                }
                if (object6 == null) {
                    try {
                        if (this.processEngine.isProcessable(string2) || SystemFunctionUnit.isProcessable(string2)) {
                            object5 = string2.equals("___eval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.STRING_VECTOR) : (string2.equals("___feval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.DECIMAL_SCALAR) : (string2.equals("___ieval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.INTEGER_SCALAR) : (string2.equals("___ceval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.COMPLEX_SCALAR) : (string2.equals("___beval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.BOOLEAN_SCALAR) : (string2.equals("___seval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.STRING_SCALAR) : (string2.equals("___vfeval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.BIGDECIMAL_SCALAR) : (string2.equals("___vieval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.BIGINTEGER_SCALAR) : (string2.equals("___vceval") ? this.evalFunctionCall((String[])object7, EvalCallUnit.BIGCOMPLEX_SCALAR) : (string2.equals("___evaltr") ? this.calcFunctionCall((String[])object7) : (string2.equals("___evaluable") ? this.evaluableFunctionCall((String[])object7) : (string2.equals("___override") ? this.overrideFunctionCall((String[])object7) : (string2.equals("SYSTEM_PROCESS_SYSTEMCALL_stralloc") ? this.stralloc((String[])object7) : (string2.equals("SYSTEM_PROCESS_SYSTEMCALL_alloc") ? this.alloc((String[])object7) : (string2.equals("SYSTEM_PROCESS_SYSTEMCALL_free") ? this.free((String[])object7) : (SystemFunctionUnit.isProcessable(string2) ? this.systemFunctionCall(string2, (String[])object7) : this.connection(string2, (String[])object7))))))))))))))));
                            break block101;
                        }
                        object5 = this.connection(string2, (String[])object7);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        object5 = "NULL_GPCI_INSTRUCTION";
                    }
                } else {
                    int n12;
                    ProcessUnit[] processUnitArray;
                    if (this.FUNCTION_VARIABLE_CAST) {
                        processUnitArray = new ProcessUnit[((Object)object7).length];
                        for (n12 = 0; n12 < ((Object)object7).length; ++n12) {
                            if (((String)object7[n12]).length() != 0 && !object7.equals("")) {
                                processUnitArray[n12] = this.getProcessUnit((String)object7[n12]);
                                if (processUnitArray[n12].getValueType() != 103) {
                                    processUnitArray[n12] = new CastUnit(processUnitArray[n12], 103, this.processEngine);
                                    processUnitArray[n12].setBestInputType();
                                    this.add(processUnitArray[n12]);
                                }
                            }
                            if (!this.error) continue;
                            return null;
                        }
                        Object object8 = object6 = this.programInstance == null ? null : this.programInstance.getFunction(string2, processUnitArray);
                        if (object6 == null) {
                            processUnitArray = new ProcessUnit[((Object)object7).length];
                            for (n12 = 0; n12 < ((Object)object7).length; ++n12) {
                                if (((String)object7[n12]).length() != 0 && !object7.equals("")) {
                                    processUnitArray[n12] = this.getProcessUnit((String)object7[n12]);
                                }
                                if (!this.error) continue;
                                return null;
                            }
                            object6 = this.programInstance == null ? null : this.programInstance.getFunction(string2, processUnitArray);
                        }
                    } else {
                        processUnitArray = new ProcessUnit[((Object)object7).length];
                        for (n12 = 0; n12 < ((Object)object7).length; ++n12) {
                            if (((String)object7[n12]).length() != 0 && !object7.equals("")) {
                                processUnitArray[n12] = this.getProcessUnit((String)object7[n12]);
                            }
                            if (!this.error) continue;
                            return null;
                        }
                        Object object9 = object6 = this.programInstance == null ? null : this.programInstance.getFunction(string2, processUnitArray);
                        if (object6 != null) {
                            ((FunctionCallKernel)object6).checkArgument(processUnitArray, this);
                        }
                    }
                    if (this.error) {
                        return null;
                    }
                    if (object6 == null) {
                        if (SystemFunctionUnit.isProcessable(string2)) {
                            object5 = this.systemFunctionCall(string2, (String[])object7);
                        } else {
                            this.error = true;
                            if (ScriptProcessor.locale.isJapanese()) {
                                this.errorMessage = this.errorMessage + "\u95a2\u6570\u300c " + string2 + " \u300d\u3092\u3001\u5ba3\u8a00\u3068\u7570\u306a\u308b\u5f15\u6570\u306e\u578b/\u500b\u6570\u3067\u547c\u3073\u51fa\u3057\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                                this.errorMessage = this.errorMessage + "" + System.getProperty("line.separator");
                                this.errorMessage = this.errorMessage + "\t\u63a8\u6e2c\u3055\u308c\u308b\u95a2\u6570\u306e\u30ea\u30b9\u30c8\uff1a" + System.getProperty("line.separator");
                                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                            } else {
                                this.errorMessage = this.errorMessage + "Calling the function \"" + string2 + "\", but the number or data-types of arguments passed to the function are incompatible. \u300d\u3092\u3001\u5ba3\u8a00\u3068\u7570\u306a\u308b\u5f15\u6570\u306e\u578b/\u500b\u6570\u3067\u547c\u3073\u51fa\u3057\u3066\u3044\u307e\u3059\u3002" + System.getProperty("line.separator");
                                this.errorMessage = this.errorMessage + "" + System.getProperty("line.separator");
                                this.errorMessage = this.errorMessage + "  The list of alternate functions guessed by the code:" + System.getProperty("line.separator");
                                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                            }
                            String[] stringArray = string2.split("\\.");
                            String string18 = stringArray[stringArray.length - 1];
                            FunctionCallKernel[] functionCallKernelArray = this.processEngine.getAllFunctionCallKernel(string18);
                            for (int i = 0; i < functionCallKernelArray.length; ++i) {
                                this.errorMessage = functionCallKernelArray[i].isGeneric() ? this.errorMessage + "\t" + functionCallKernelArray[i].fileName + "." + string18 + functionCallKernelArray[i].getGenericsDescription() + "( " + functionCallKernelArray[i].getArgumentDescription() + " )" : this.errorMessage + "\t" + functionCallKernelArray[i].fileName + "." + string18 + "( " + functionCallKernelArray[i].getArgumentDescription() + " )";
                                this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                            }
                            if ((string2.startsWith("___") || string2.startsWith("SYSTEM_PROCESS")) && string2.equals("SYSTEM_PROCESS_ARRAY_INITIALIZER")) {
                                this.errorMessage = "";
                                this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u914d\u5217\u521d\u671f\u5316\u5b50\u3092\u6b63\u5e38\u306b\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : this.errorMessage + "Failed to interpret the array-initializer.";
                                if (this.kernel != null) {
                                    String string19 = this.kernel.programLine;
                                    string19 = string19.split("SYSTEM_PROCESS_ARRAY_INITIALIZER")[0];
                                    this.kernel.programLine = string19 = string19 + "{ ??? } ;";
                                }
                            }
                            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
                            this.error(this.errorMessage);
                            object5 = this.systemFunctionCall(string2, (String[])object7);
                        }
                    } else {
                        this.checkWarning((FunctionCallKernel)object6);
                        object6 = this.checkFunction((FunctionCallKernel)object6);
                        if (object6 == null) {
                            return null;
                        }
                        if (((ProcessKernel)object6).getKernelType() == ProcessKernel.FUNCTION_MACRO_TYPE) {
                            String[] stringArray = new String[((Object)object7).length];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray[i] = processUnitArray[i] == null ? null : (processUnitArray[i].getValueType() == 106 ? object7[i] : processUnitArray[i].getID());
                            }
                            FunctionMacroKernel functionMacroKernel = (FunctionMacroKernel)object6;
                            object5 = functionMacroKernel.processMacro((String[])object7);
                            object5 = this.getEscapedProgram((String)object5);
                            functionMacroKernel = null;
                        } else {
                            FunctionCallUnit functionCallUnit = new FunctionCallUnit(processUnitArray, (FunctionCallKernel)object6, this.processEngine);
                            functionCallUnit.parentKernel = this.kernel;
                            functionCallUnit.parentScope = this.parentScope;
                            functionCallUnit.functionName = string2;
                            functionCallUnit.setProcessKernel(this.kernel);
                            this.add(functionCallUnit);
                            object5 = functionCallUnit.getID();
                        }
                    }
                }
            }
            object = object5;
            if (this.error) {
                return null;
            }
            if (this.error) {
                return null;
            }
        } else {
            if (this.error) {
                return null;
            }
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5ba3\u8a00\u3055\u308c\u3066\u3044\u306a\u3044\u95a2\u6570\u300c " + string2 + " \u300d\u3092\u547c\u3073\u51fa\u3057\u3066\u3044\u307e\u3059\u3002" : this.errorMessage + "Calling the function \"" + string2 + "\", but this function is not declared.";
            this.error(this.errorMessage);
            object = "0";
        }
        if (this.error) {
            return null;
        }
        return object;
    }

    private boolean isSIMD(ProcessUnit[] processUnitArray) {
        boolean bl = false;
        for (int i = 0; i < processUnitArray.length; ++i) {
            if (!processUnitArray[i].arrayType) continue;
            bl = true;
        }
        return bl;
    }

    private void checkTypeArithmetic(ProcessUnit processUnit, String string) {
        ProcessCompatibilityException processCompatibilityException;
        if (processUnit == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u4e0d\u660e\u306a\u60c5\u5831\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u5f0f\u306e\u8a18\u8ff0\u304c\u6587\u6cd5\u7684\u306b\u6b63\u3057\u304f\u306a\u3044\u8a18\u8ff0\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.error("Cannot determine the kind of the operand. Probably this expression is syntactically incorrect.");
            }
            return;
        }
        int n = processUnit.getValueType();
        if (n != 101 && n != 100 && n != 104 && n != 103 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u6f14\u7b97\u5b50\u300c " + string + " \u300d\u306f\u3001\u6b21\u306e\u578b\u4ee5\u5916\u3067\u306e\u6f14\u7b97\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093: int, float, varint, varfloat");
            } else {
                this.error("The operator \"" + string + "\" is available for only the operands of the following data-types: int, float, varint, varfloat");
            }
        }
    }

    private void checkTypeArithmeticAndComplex(ProcessUnit processUnit, String string) {
        ProcessCompatibilityException processCompatibilityException;
        if (processUnit == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u4e0d\u660e\u306a\u60c5\u5831\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u5f0f\u306e\u8a18\u8ff0\u304c\u6587\u6cd5\u7684\u306b\u6b63\u3057\u304f\u306a\u3044\u8a18\u8ff0\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.error("Cannot determine the kind of the operand. Probably this expression is syntactically incorrect.");
            }
            return;
        }
        int n = processUnit.getValueType();
        if (n != 101 && n != 100 && n != 140 && n != 104 && n != 103 && n != 141 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u6f14\u7b97\u5b50\u300c " + string + " \u300d\u306f\u3001\u6b21\u306e\u578b\u4ee5\u5916\u3067\u306e\u6f14\u7b97\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093: int, float, complex, varint, varfloat, varcomplex");
            } else {
                this.error("The operator \"" + string + "\" is available for only the operands of the following data-types: int, float, complex, varint, varfloat, varcomplex");
            }
        }
    }

    private void checkTypeArithmeticAndComplexAndString(ProcessUnit processUnit, String string) {
        ProcessCompatibilityException processCompatibilityException;
        if (processUnit == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u4e0d\u660e\u306a\u60c5\u5831\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u5f0f\u306e\u8a18\u8ff0\u304c\u6587\u6cd5\u7684\u306b\u6b63\u3057\u304f\u306a\u3044\u8a18\u8ff0\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.error("Cannot determine the kind of the operand. Probably this expression is syntactically incorrect.");
            }
            return;
        }
        int n = processUnit.getValueType();
        if (n != 101 && n != 100 && n != 140 && n != 104 && n != 103 && n != 141 && n != 102 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u6f14\u7b97\u5b50\u300c " + string + " \u300d\u306f\u3001\u6b21\u306e\u578b\u4ee5\u5916\u3067\u306e\u6f14\u7b97\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093: string, int, float, complex, varint, varfloat, varcomplex");
            } else {
                this.error("The operator \"" + string + "\" is available for only the operands of the following data-types: string, int, float, complex, varint, varfloat, varcomplex");
            }
        }
    }

    private void checkTypeExceptStruct(ProcessUnit processUnit, String string) {
        ProcessCompatibilityException processCompatibilityException;
        if (processUnit == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u4e0d\u660e\u306a\u60c5\u5831\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u5f0f\u306e\u8a18\u8ff0\u304c\u6587\u6cd5\u7684\u306b\u6b63\u3057\u304f\u306a\u3044\u8a18\u8ff0\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.error("Cannot determine the kind of the operand. Probably this expression is syntactically incorrect.");
            }
            return;
        }
        int n = processUnit.getValueType();
        if (n == 200 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u6f14\u7b97\u5b50\u300c " + string + " \u300d\u306f\u3001\u6b21\u306e\u578b\u4ee5\u5916\u3067\u306e\u6f14\u7b97\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093: string, int, float, complex, varint, varfloat, varcomplex, bool");
            } else {
                this.error("The operator \"" + string + "\" is available for only the operands of the following data-types: string, int, float, complex, varint, varfloat, varcomplex, bool");
            }
        }
    }

    private void checkTypeString(ProcessUnit processUnit, String string) {
        ProcessCompatibilityException processCompatibilityException;
        if (processUnit == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u4e0d\u660e\u306a\u60c5\u5831\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u5f0f\u306e\u8a18\u8ff0\u304c\u6587\u6cd5\u7684\u306b\u6b63\u3057\u304f\u306a\u3044\u8a18\u8ff0\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.error("Cannot determine the kind of the operand. Probably this expression is syntactically incorrect.");
            }
            return;
        }
        int n = processUnit.getValueType();
        if (n != 102 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u6f14\u7b97\u5b50\u300c " + string + " \u300d\u306f\u3001\u6b21\u306e\u578b\u4ee5\u5916\u3067\u306e\u6f14\u7b97\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093: string");
            } else {
                this.error("The operator \"" + string + "\" is available for only the operands of the following data-types: string");
            }
        }
    }

    private void checkTypeBoolean(ProcessUnit processUnit, String string) {
        ProcessCompatibilityException processCompatibilityException;
        if (processUnit == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u4e0d\u660e\u306a\u60c5\u5831\u306e\u30aa\u30da\u30e9\u30f3\u30c9\u304c\u691c\u51fa\u3055\u308c\u307e\u3057\u305f\u3002\u5f0f\u306e\u8a18\u8ff0\u304c\u6587\u6cd5\u7684\u306b\u6b63\u3057\u304f\u306a\u3044\u8a18\u8ff0\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.error("Cannot determine the kind of the operand. Probably this expression is syntactically incorrect.");
            }
            return;
        }
        int n = processUnit.getValueType();
        if (n != 105 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u6f14\u7b97\u5b50\u300c " + string + " \u300d\u306f\u3001\u6b21\u306e\u578b\u4ee5\u5916\u3067\u306e\u6f14\u7b97\u3092\u884c\u3046\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093: bool");
            } else {
                this.error("The operator \"" + string + "\" is available for only the operands of the following data-types: bool");
            }
        }
    }

    private void checkRightHand(ProcessUnit processUnit) {
        ProcessCompatibilityException processCompatibilityException;
        if (processUnit instanceof SIMDSubstitutionUnit && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u3053\u306e\u5b9f\u884c\u74b0\u5883\u306b\u304a\u3044\u3066\u306f\u3001\u30d9\u30af\u30c8\u30eb\u4ee3\u5165\u6f14\u7b97\u306e\u7d50\u679c\u306f\u53f3\u8fba\u5024\u3068\u3057\u3066\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
            } else {
                this.error("Cannot use the result of a vector-assignment operation as a right-side value, on this script engine.");
            }
        }
    }

    private void checkLeftHand(ProcessUnit processUnit) {
        ProcessCompatibilityException processCompatibilityException;
        boolean bl = false;
        if (!(processUnit instanceof AndUnit || processUnit instanceof ArrayAllocUnit || processUnit instanceof ArrayFreeUnit || processUnit instanceof CalcCallUnit || processUnit instanceof CastUnit || processUnit instanceof EqualUnit || processUnit instanceof EvalCallUnit || processUnit instanceof EvaluableUnit || processUnit instanceof FunctionCallUnit || processUnit instanceof GreaterEqualUnit || processUnit instanceof GreaterThanUnit || processUnit instanceof KernelCallUnit || processUnit instanceof LessEqualUnit || processUnit instanceof LessThanUnit || processUnit instanceof MinusUnit || processUnit instanceof NotEqualUnit || processUnit instanceof OrUnit || processUnit instanceof OverrideCallUnit || processUnit instanceof ProcessConnectionUnit || processUnit instanceof ReverseUnit || processUnit instanceof ScopeCallUnit || processUnit instanceof SIMDAdditionUnit || processUnit instanceof SIMDDecrementUnit || processUnit instanceof SIMDDivisionUnit || processUnit instanceof SIMDIncrementUnit || processUnit instanceof SIMDMultiplicationUnit || processUnit instanceof SIMDPostDecrementUnit || processUnit instanceof SIMDPostIncrementUnit || processUnit instanceof SIMDPowerUnit || processUnit instanceof SIMDPoworUnit || processUnit instanceof SIMDRemainderUnit || processUnit instanceof SIMDSubstitutionUnit || processUnit instanceof SIMDSubtractionUnit || processUnit instanceof SISDAdditionUnit || processUnit instanceof SISDArraySubstitutionUnit || processUnit instanceof SISDDecrementUnit || processUnit instanceof SISDDivisionUnit || processUnit instanceof SISDIncrementUnit || processUnit instanceof SISDMultiplicationUnit || processUnit instanceof SISDPostDecrementUnit || processUnit instanceof SISDPostIncrementUnit || processUnit instanceof SISDPowerUnit || processUnit instanceof SISDRemainderUnit || processUnit instanceof SISDSubstitutionUnit || processUnit instanceof SISDSubtractionUnit || processUnit instanceof StructAllocUnit || processUnit instanceof SystemFunctionUnit)) {
            bl = true;
        }
        if (!bl && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u4ee3\u5165\u6f14\u7b97\u5b50\u300c = \u300d\u306e\u5de6\u8fba\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002\u5de6\u8fba\u306b\u306f\u5024\u3092\u683c\u7d0d\u53ef\u80fd\u306a\uff08 const\u3067\u306a\u3044 \uff09\u5909\u6570\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u5de6\u8fba\u306b\u306f\u3001\u53f3\u8fba\u306b\u8a18\u8ff0\u3055\u308c\u305f\u5f0f\u306e\u5024\u304c\u683c\u7d0d\u3055\u308c\u307e\u3059\u3002\u6570\u5f0f\u306e\u3088\u3046\u306b\u3001\u5de6\u8fba\u306b\u5f0f\u3092\u8a18\u8ff0\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u5fc5\u305a\u300c \u5909\u6570 = \u5f0f ; \u300d\u306e\u5f62\u5f0f\u3067\u8a18\u8ff0\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.error("The left-side of the assignment operator \"=\" is incorrect. At the left-side, specify a (non-const) variable. In that variable, the calculation result of the right-side will be stored. Different with mathematical formulas, we cannot describe an calculation expression at the left-side.");
            }
        }
    }

    private String firstPriorityConstruction(String string) {
        String[] stringArray = string.split("SYSTEM_ESCAPE_POWER");
        int n = stringArray.length;
        if (1 < n) {
            for (int i = 0; i < stringArray.length; ++i) {
                ProcessCompatibilityException processCompatibilityException;
                if (stringArray[i].startsWith("S") && stringArray[i].startsWith("SYSTEM_") && stringArray[i].startsWith("SYSTEM_PROCESS_ESCAPE_HEADMINUS") && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.error("\u6307\u6570\u6f14\u7b97\u5b50\u300c ** \u300d\u3068\u3001\u5358\u9805\u30de\u30a4\u30ca\u30b9\u6f14\u7b97\u5b50\u300c - \u300d\u3068\u306e\u4f75\u7528\u306f\u3001\u300c ( ) \u300d\u3092\u7528\u3044\u3066\u6f14\u7b97\u9806\u5e8f\u3092\u660e\u793a\u3059\u308b\u4e8b\u304c\u63a8\u5968\u3055\u308c\u307e\u3059\u3002\u73fe\u5728\u306e\u512a\u5148\u5ea6\u306f\u5c06\u6765\u7684\u306b\u5909\u66f4\u3055\u308c\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002 \u63a8\u5968\u8a18\u8ff0\u4f8b\uff1a -(1.2**3.0) \u3084 (-1.2)**(-3.0) \u306a\u3069\u3002 \u63a8\u5968\u3055\u308c\u306a\u3044\u8a18\u8ff0\u4f8b\uff1a -1.2**3.0 \u3084 -1.2**-3.0 \u306a\u3069\u3002");
                    } else {
                        this.error("Please specify the order of operations explicitly with parentheses ( ), for the combined use of exponentiation operator \"**\" and unary-minus operator \"-\". The current operator-precedences for them might change in future version. Examples of recommended descriptions: -(1.2**3.0), (-1.2)**(-3.0), etc. Examples of unrecommended descriptions: -1.2**3.0, -1.2**-3.0, etc.");
                    }
                }
                if (!this.error) continue;
                return null;
            }
        }
        if (this.error) {
            return null;
        }
        stringArray = this.increment(stringArray);
        if (this.error) {
            return null;
        }
        stringArray = this.prefix(stringArray);
        if (this.error) {
            return null;
        }
        String string2 = 1 < n ? this.power(stringArray) : stringArray[0];
        if (this.error) {
            return null;
        }
        return string2;
    }

    private String secondPriorityConstruction(String string) {
        char[] cArray = new char[]{'*', '/', '%'};
        int[] nArray = new int[]{1, 2, 3};
        int[] nArray2 = this.stringSplitter.getSplittedCode(string, cArray, nArray);
        String[] stringArray = this.stringSplitter.getSplittedWord(string, cArray, nArray);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.firstPriorityConstruction(stringArray[i]);
            if (!this.error) continue;
            return null;
        }
        if (nArray2.length == 0) {
            return this.firstPriorityConstruction(string);
        }
        String string2 = stringArray[0];
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 1) {
                string2 = this.multiplication(new String[]{string2, stringArray[i + 1]});
                continue;
            }
            if (nArray2[i] == 2) {
                string2 = this.division(new String[]{string2, stringArray[i + 1]});
                continue;
            }
            if (nArray2[i] != 3) continue;
            string2 = this.remainder(new String[]{string2, stringArray[i + 1]});
        }
        if (this.error) {
            return null;
        }
        return string2;
    }

    private String thirdPriorityConstruction(String string) {
        char[] cArray = new char[]{'+', '-'};
        int[] nArray = new int[]{1, 2};
        int[] nArray2 = this.stringSplitter.getSplittedCode(string, cArray, nArray);
        String[] stringArray = this.stringSplitter.getSplittedWord(string, cArray, nArray);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.secondPriorityConstruction(stringArray[i]);
            if (!this.error) continue;
            return null;
        }
        if (this.error) {
            return null;
        }
        if (nArray2.length == 0) {
            return this.secondPriorityConstruction(string);
        }
        String string2 = stringArray[0];
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 1) {
                string2 = this.addition(new String[]{string2, stringArray[i + 1]});
                continue;
            }
            if (nArray2[i] != 2) continue;
            string2 = this.subtraction(new String[]{string2, stringArray[i + 1]});
        }
        if (this.error) {
            return null;
        }
        return string2;
    }

    private String free(String[] stringArray) {
        if (this.error) {
            return null;
        }
        ProcessUnit[] processUnitArray = new ProcessUnit[]{this.getProcessUnit(stringArray[0])};
        this.checkRightHand(processUnitArray[0]);
        ArrayFreeUnit arrayFreeUnit = new ArrayFreeUnit(this.processEngine, processUnitArray);
        this.add(arrayFreeUnit);
        return arrayFreeUnit.getID();
    }

    private String stralloc(String[] stringArray) {
        if (this.error) {
            return null;
        }
        ProcessUnit[] processUnitArray = new ProcessUnit[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            this.checkRightHand(processUnitArray[i]);
        }
        StructAllocUnit structAllocUnit = new StructAllocUnit(this.processEngine, processUnitArray);
        this.add(structAllocUnit);
        return structAllocUnit.getID();
    }

    private String alloc(String[] stringArray) {
        if (this.error) {
            return null;
        }
        ProcessUnit[] processUnitArray = new ProcessUnit[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            this.checkRightHand(processUnitArray[i]);
        }
        ArrayAllocUnit arrayAllocUnit = new ArrayAllocUnit(this.processEngine, processUnitArray);
        this.add(arrayAllocUnit);
        return arrayAllocUnit.getID();
    }

    private String overrideFunctionCall(String[] stringArray) {
        if (this.error) {
            return null;
        }
        ProcessUnit[] processUnitArray = new ProcessUnit[]{this.getProcessUnit(stringArray[0]), this.getProcessUnit(stringArray[1]), this.getProcessUnit(stringArray[2])};
        OverrideCallUnit overrideCallUnit = new OverrideCallUnit(processUnitArray, this.processEngine, this.programInstance);
        this.add(overrideCallUnit);
        return overrideCallUnit.getID();
    }

    private String bracket(String string) {
        if (this.useBracketUnit) {
            if (this.error) {
                return null;
            }
            ProcessUnit processUnit = this.getProcessUnit(string);
            BracketUnit bracketUnit = new BracketUnit(processUnit, this.processEngine);
            this.add(bracketUnit);
            return bracketUnit.getID();
        }
        return string;
    }

    private String evalFunctionCall(String[] stringArray, int n) {
        if (this.error) {
            return null;
        }
        ProcessUnit[] processUnitArray = new ProcessUnit[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            this.checkRightHand(processUnitArray[i]);
        }
        EvalCallUnit evalCallUnit = new EvalCallUnit(processUnitArray, this.processEngine, this.programInstance);
        evalCallUnit.setEvalReturnType(n);
        int n2 = this.processUnit.length;
        ProcessUnit[] processUnitArray2 = new ProcessUnit[n2];
        for (int i = 0; i < n2; ++i) {
            processUnitArray2[i] = this.processUnit[i];
        }
        evalCallUnit.evalLocalVariable = processUnitArray2;
        this.add(evalCallUnit);
        return evalCallUnit.getID();
    }

    private String evaluableFunctionCall(String[] stringArray) {
        if (this.error) {
            return null;
        }
        ProcessUnit[] processUnitArray = new ProcessUnit[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            this.checkRightHand(processUnitArray[i]);
        }
        EvaluableUnit evaluableUnit = new EvaluableUnit(processUnitArray, this.processEngine, this.programInstance);
        int n = this.processUnit.length;
        ProcessUnit[] processUnitArray2 = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray2[i] = this.processUnit[i];
        }
        evaluableUnit.evalLocalVariable = processUnitArray2;
        this.add(evaluableUnit);
        return evaluableUnit.getID();
    }

    private String calcFunctionCall(String[] stringArray) {
        if (this.error) {
            return null;
        }
        ProcessUnit[] processUnitArray = new ProcessUnit[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            this.checkRightHand(processUnitArray[i]);
        }
        CalcCallUnit calcCallUnit = new CalcCallUnit(processUnitArray, this.processEngine, this.programInstance);
        int n = this.processUnit.length;
        ProcessUnit[] processUnitArray2 = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray2[i] = this.processUnit[i];
        }
        calcCallUnit.evalLocalVariable = processUnitArray2;
        this.add(calcCallUnit);
        return calcCallUnit.getID();
    }

    private String systemFunctionCall(String string, String[] stringArray) {
        if (this.error) {
            return null;
        }
        ProcessUnit[] processUnitArray = new ProcessUnit[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            this.checkRightHand(processUnitArray[i]);
        }
        SystemFunctionUnit systemFunctionUnit = new SystemFunctionUnit(processUnitArray, string, this.processEngine);
        systemFunctionUnit.setProcessKernel(this.kernel);
        systemFunctionUnit.setName("_SYSTEM_PROCESS_SFU_" + string);
        this.add(systemFunctionUnit);
        return systemFunctionUnit.getID();
    }

    public boolean highLiskWarning(String string) {
        int n;
        String[] stringArray = ScriptProcessor.locale.isJapanese() ? new String[]{string, "\u5b9f\u884c\u3092\u8a31\u53ef\u3057\u307e\u3059\u304b ?", "\u3000", "\u300c \u3044\u3044\u3048 \u300d\u3092\u9078\u629e\u3059\u308b\u3068\u3001\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3059\u3002"} : new String[]{string, "Do you permit it?", "\u3000", "If you select \"No\", this program will be terminated."};
        int n2 = JOptionPane.showConfirmDialog(null, stringArray, "! WARNING", 0);
        if (n2 == 0 && (n = ScriptProcessor.locale.isJapanese() ? JOptionPane.showConfirmDialog(null, "\u672c\u5f53\u306b\u5b9f\u884c\u3092\u8a31\u53ef\u3057\u307e\u3059\u304b ?", "! WARNING", 0) : JOptionPane.showConfirmDialog(null, "Are you sure to permit it?", "! WARNING", 0)) == 0) {
            return true;
        }
        this.processEngine.abnormallyExit();
        return false;
    }

    private String connection(String string, String[] stringArray) {
        int n;
        Object object;
        if (this.processEngine.hasError()) {
            return null;
        }
        if (this.processEngine.isOnRuntime() && this.runtimeCompileSecurityState) {
            if (string.startsWith("___native")) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.processEngine.error("eval \u307e\u305f\u306f override \u304b\u3089 \u30d7\u30e9\u30b0\u30a4\u30f3\u95a2\u6570\u3092\u201c\u76f4\u63a5\u7684\u306b\u201d\u30b3\u30fc\u30eb\u3059\u308b\u4e8b\u306f\u3001\u5b89\u5168\u6027\u306e\u305f\u3081\u306b\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\uff08 \u5bfe\u8c61\u306e\u95a2\u6570\uff1a" + string + " \uff09\u3002\u30b3\u30fc\u30eb\u3059\u308b\u305f\u3081\u306b\u306f\u3001\u30d7\u30e9\u30b0\u30a4\u30f3\u95a2\u6570\u3092VCSSL\u306e\u95a2\u6570\u3068\u3057\u3066\u30e9\u30c3\u30d4\u30f3\u30b0\u3057\u3001\u95a2\u6570\u3078\u306e\u53c2\u7167\u304c\u9759\u7684\u306b\uff08\u5b9f\u884c\u524d\u306b\uff09\u89e3\u6c7a\u3055\u308c\u308b\u3088\u3046\u306b\u3057\u3066\u4e0b\u3055\u3044\u3002\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u306e\u305f\u3081\u3001\u3053\u306e\u30d7\u30ed\u30bb\u30b9\u306f\u5f37\u5236\u7d42\u4e86\u3055\u308c\u307e\u3059\u3002");
                } else {
                    this.processEngine.error("Cannot call a function \"" + string + "\" which is provided by a plug-in directly, from the process executed by \"eval\" or \"override\" function. To call them, wrap them by functions declared in VCSSL code. This restriction is the restriction for the security. This process will be terminated immediately.");
                }
                this.processEngine.abnormallyExit();
                return null;
            }
            object = null;
            if (string.equals("___save") || string.equals("___load") || string.equals("___reset") || string.equals("___exit") || string.equals("___exec") || string.equals("___system") || string.equals("___openr") || string.equals("___openw") || string.equals("___opencsvr") || string.equals("___opencsvw") || string.equals("openr") || string.equals("openw") || string.equals("opencsvr") || string.equals("opencsvw") || string.equals("___mkdir")) {
                object = string;
            }
            if (object != null && object.startsWith("___")) {
                object = object.substring(3, object.length());
                n = ScriptProcessor.locale.isJapanese() ? (int)(this.highLiskWarning("eval \u307e\u305f\u306f override \u304b\u3089\u6b21\u306e\u95a2\u6570\u3092\u76f4\u63a5\u7684\u306b\u30b3\u30fc\u30eb\u3059\u308b\u4e8b\u306f\u3001\u5b89\u5168\u6027\u306e\u305f\u3081\u306b\u63a8\u5968\u3055\u308c\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") + "\u30b3\u30fc\u30eb\u3059\u308b\u306b\u306f\u3001\u3053\u306e\u95a2\u6570\u3092\u5225\u306e\u95a2\u6570\u3067\u30e9\u30c3\u30d4\u30f3\u30b0\u3057\u3001\u9593\u63a5\u7684\u306b\u30b3\u30fc\u30eb\u3057\u3066\u4e0b\u3055\u3044\u3002\u3053\u308c\u306f\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u306e\u305f\u3081\u306e\u914d\u616e\u3067\u3059\u3002" + System.getProperty("line.separator") + "\u3000\u3000\u5bfe\u8c61\u306e\u95a2\u6570\uff1a" + (String)object) ? 1 : 0) : (int)(this.highLiskWarning("Cannot call a function \"" + (String)object + "\" directly from the process executed by \"eval\" or \"override\" function." + System.getProperty("line.separator") + "To call them, wrap them by functions declared in VCSSL code." + System.getProperty("line.separator") + "This restriction is the restriction for the security.") ? 1 : 0);
                if (n == 0) {
                    if (ScriptProcessor.locale.isJapanese()) {
                        this.processEngine.error("\u5b9f\u884c\u4e2d\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u5f37\u5236\u7d42\u4e86\u3055\u308c\u307e\u3057\u305f\u3002");
                    } else {
                        this.processEngine.error("The program has been terminated.");
                    }
                    this.processEngine.abnormallyExit();
                    return null;
                }
            }
        }
        if (this.error) {
            return null;
        }
        object = new ProcessUnit[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            object[n] = this.getProcessUnit(stringArray[n]);
        }
        ProcessConnectionUnit processConnectionUnit = new ProcessConnectionUnit((ProcessUnit[])object, this.processEngine);
        processConnectionUnit.parentKernel = this.kernel;
        GeneralProcessConnectionInterface generalProcessConnectionInterface = this.processEngine.getGeneralProcessConnectionInterface(string);
        if (this.processEngine.isOnRuntime() && this.runtimeCompileSecurityState && generalProcessConnectionInterface instanceof GeneralProcessConnectionInterfaceAdapter) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.processEngine.error("eval \u307e\u305f\u306f override \u304b\u3089 \u30d7\u30e9\u30b0\u30a4\u30f3\u95a2\u6570\u3092\u201c\u76f4\u63a5\u7684\u306b\u201d\u30b3\u30fc\u30eb\u3059\u308b\u4e8b\u306f\u3001\u5b89\u5168\u6027\u306e\u305f\u3081\u306b\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\uff08 \u5bfe\u8c61\u306e\u95a2\u6570\uff1a" + string + " \uff09\u3002\u30b3\u30fc\u30eb\u3059\u308b\u305f\u3081\u306b\u306f\u3001\u30d7\u30e9\u30b0\u30a4\u30f3\u95a2\u6570\u3092VCSSL\u306e\u95a2\u6570\u3068\u3057\u3066\u30e9\u30c3\u30d4\u30f3\u30b0\u3057\u3001\u95a2\u6570\u3078\u306e\u53c2\u7167\u304c\u9759\u7684\u306b\uff08\u5b9f\u884c\u524d\u306b\uff09\u89e3\u6c7a\u3055\u308c\u308b\u3088\u3046\u306b\u3057\u3066\u4e0b\u3055\u3044\u3002\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u306e\u305f\u3081\u3001\u3053\u306e\u30d7\u30ed\u30bb\u30b9\u306f\u5f37\u5236\u7d42\u4e86\u3055\u308c\u307e\u3059\u3002");
            } else {
                this.processEngine.error("Cannot call a function \"" + string + "\" which is provided by a plug-in directly, from the process executed by \"eval\" or \"override\" function. To call them, wrap them by functions declared in VCSSL code. This restriction is the restriction for the security. This process will be terminated immediately.");
            }
            this.processEngine.abnormallyExit();
            return null;
        }
        processConnectionUnit.setProcessConnectionInterface(generalProcessConnectionInterface);
        processConnectionUnit.setConnectionCommand(string);
        processConnectionUnit.setProcessKernel(this.kernel);
        this.add(processConnectionUnit);
        return processConnectionUnit.getID();
    }

    private String[] unEscape(String[] stringArray) {
        if (this.error) {
            return new String[]{""};
        }
        int n = stringArray.length;
        if (0 < stringArray[0].indexOf("SYSTEM_PROCESS_ESCAPE")) {
            stringArray[0] = stringArray[0].replaceAll("SYSTEM_PROCESS_ESCAPE_EMINUS", "E-");
            stringArray[0] = stringArray[0].replaceAll("SYSTEM_PROCESS_ESCAPE_EPLUS", "E+");
            stringArray[0] = stringArray[0].replaceAll("SYSTEM_PROCESS_ESCAPE_HEADMINUS", "-");
        }
        for (int i = 0; i < n; ++i) {
            if (0 >= stringArray[i].indexOf("SYSTEM_PROCESS_ESCAPE")) continue;
            stringArray[i] = stringArray[i].replaceAll("SYSTEM_PROCESS_ESCAPE_EMINUS", "E-");
            stringArray[i] = stringArray[i].replaceAll("SYSTEM_PROCESS_ESCAPE_EPLUS", "E+");
            stringArray[i] = stringArray[i].replaceAll("SYSTEM_PROCESS_ESCAPE_HEADMINUS", "-");
        }
        return stringArray;
    }

    private String[] increment(String[] stringArray) {
        if (this.error) {
            return new String[]{""};
        }
        int n = stringArray.length;
        stringArray = this.unEscape(stringArray);
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            ProcessUnit processUnit;
            ProcessUnit processUnit2;
            if (0 > stringArray[i].indexOf("SYSTEM_PROCESS_ESCAPE")) {
                stringArray2[i] = stringArray[i];
                continue;
            }
            if (stringArray[i].startsWith("SYSTEM_PROCESS_ESCAPE_INCREMENT")) {
                stringArray[i] = stringArray[i].replaceAll("SYSTEM_PROCESS_ESCAPE_INCREMENT", "");
                processUnit2 = this.getProcessUnit(stringArray[i]);
                this.checkTypeArithmetic(processUnit2, "++");
                this.checkRightHand(processUnit2);
                processUnit = processUnit2.arrayType ? new SIMDIncrementUnit(processUnit2, this.processEngine) : new SISDIncrementUnit(processUnit2, this.processEngine);
                processUnit.setBestInputType();
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                stringArray2[i] = processUnit.getID();
                continue;
            }
            if (stringArray[i].endsWith("SYSTEM_PROCESS_ESCAPE_INCREMENT")) {
                stringArray[i] = stringArray[i].replaceAll("SYSTEM_PROCESS_ESCAPE_INCREMENT", "");
                processUnit2 = this.getProcessUnit(stringArray[i]);
                this.checkTypeArithmetic(processUnit2, "++");
                this.checkRightHand(processUnit2);
                processUnit = processUnit2.arrayType ? new SIMDPostIncrementUnit(processUnit2, this.processEngine) : new SISDPostIncrementUnit(processUnit2, this.processEngine);
                processUnit.setBestInputType();
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                stringArray2[i] = processUnit.getID();
                continue;
            }
            if (stringArray[i].startsWith("SYSTEM_PROCESS_ESCAPE_DECREMENT")) {
                stringArray[i] = stringArray[i].replaceAll("SYSTEM_PROCESS_ESCAPE_DECREMENT", "");
                processUnit2 = this.getProcessUnit(stringArray[i]);
                this.checkTypeArithmetic(processUnit2, "++");
                this.checkRightHand(processUnit2);
                processUnit = processUnit2.arrayType ? new SIMDDecrementUnit(processUnit2, this.processEngine) : new SISDDecrementUnit(processUnit2, this.processEngine);
                processUnit.setBestInputType();
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                stringArray2[i] = processUnit.getID();
                continue;
            }
            if (stringArray[i].endsWith("SYSTEM_PROCESS_ESCAPE_DECREMENT")) {
                stringArray[i] = stringArray[i].replaceAll("SYSTEM_PROCESS_ESCAPE_DECREMENT", "");
                processUnit2 = this.getProcessUnit(stringArray[i]);
                this.checkTypeArithmetic(processUnit2, "++");
                this.checkRightHand(processUnit2);
                processUnit = processUnit2.arrayType ? new SIMDPostDecrementUnit(processUnit2, this.processEngine) : new SISDPostDecrementUnit(processUnit2, this.processEngine);
                processUnit.setBestInputType();
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                stringArray2[i] = processUnit.getID();
                continue;
            }
            return stringArray;
        }
        return stringArray2;
    }

    public ProcessUnit checkCast(ProcessUnit processUnit) {
        ProcessCompatibilityException processCompatibilityException;
        if (processUnit == null) {
            return null;
        }
        if (processUnit.isArrayType() && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u914d\u5217\u578b\u3092\u30ad\u30e3\u30b9\u30c8\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            } else {
                this.error("Cannot cast array-types.");
            }
            return null;
        }
        return processUnit;
    }

    private String[] prefix(String[] stringArray) {
        if (this.error) {
            return new String[]{""};
        }
        int n = stringArray.length;
        stringArray = this.unEscape(stringArray);
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            ProcessUnit processUnit;
            ProcessUnit processUnit2;
            if (stringArray[i].startsWith("SYSTEM_PROCESS_ESCAPE_HEADMINUS")) {
                stringArray[i] = stringArray[i].substring(31, stringArray[i].length());
                stringArray[i] = this.minus(stringArray[i]);
                processUnit2 = this.getProcessUnit(this.getProcessedSection(stringArray[i]));
                this.checkTypeArithmeticAndComplex(processUnit2, "-");
                this.checkRightHand(processUnit2);
                if (this.error) {
                    return null;
                }
                stringArray2[i] = processUnit2.getID();
            }
            if (this.error) {
                return null;
            }
            if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST")) {
                if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST_INTEGER")) {
                    stringArray[i] = stringArray[i].substring("SYSTEM_ESCAPE_CAST_INTEGER".length(), stringArray[i].length());
                    processUnit2 = this.getProcessUnit(stringArray[i]);
                    processUnit2 = this.checkCast(processUnit2);
                    this.checkRightHand(processUnit2);
                    processUnit = new CastUnit(processUnit2, 101, this.processEngine);
                    processUnit.setBestInputType();
                    processUnit.setProcessKernel(this.kernel);
                    this.add(processUnit);
                    stringArray2[i] = processUnit.getID();
                    continue;
                }
                if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST_DECIMAL")) {
                    stringArray[i] = stringArray[i].substring("SYSTEM_ESCAPE_CAST_DECIMAL".length(), stringArray[i].length());
                    processUnit2 = this.getProcessUnit(stringArray[i]);
                    processUnit2 = this.checkCast(processUnit2);
                    this.checkRightHand(processUnit2);
                    processUnit = new CastUnit(processUnit2, 100, this.processEngine);
                    processUnit.setBestInputType();
                    processUnit.setProcessKernel(this.kernel);
                    this.add(processUnit);
                    stringArray2[i] = processUnit.getID();
                    continue;
                }
                if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST_COMPLEX")) {
                    stringArray[i] = stringArray[i].substring("SYSTEM_ESCAPE_CAST_COMPLEX".length(), stringArray[i].length());
                    processUnit2 = this.getProcessUnit(stringArray[i]);
                    processUnit2 = this.checkCast(processUnit2);
                    this.checkRightHand(processUnit2);
                    processUnit = new CastUnit(processUnit2, 140, this.processEngine);
                    processUnit.setBestInputType();
                    processUnit.setProcessKernel(this.kernel);
                    this.add(processUnit);
                    stringArray2[i] = processUnit.getID();
                    continue;
                }
                if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST_BIGINTEGER")) {
                    stringArray[i] = stringArray[i].substring("SYSTEM_ESCAPE_CAST_BIGINTEGER".length(), stringArray[i].length());
                    processUnit2 = this.getProcessUnit(stringArray[i]);
                    processUnit2 = this.checkCast(processUnit2);
                    this.checkRightHand(processUnit2);
                    processUnit = new CastUnit(processUnit2, 104, this.processEngine);
                    processUnit.setBestInputType();
                    processUnit.setProcessKernel(this.kernel);
                    this.add(processUnit);
                    stringArray2[i] = processUnit.getID();
                    continue;
                }
                if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST_BIGDECIMAL")) {
                    stringArray[i] = stringArray[i].substring("SYSTEM_ESCAPE_CAST_BIGDECIMAL".length(), stringArray[i].length());
                    processUnit2 = this.getProcessUnit(stringArray[i]);
                    processUnit2 = this.checkCast(processUnit2);
                    this.checkRightHand(processUnit2);
                    processUnit = new CastUnit(processUnit2, 103, this.processEngine);
                    processUnit.setBestInputType();
                    processUnit.setProcessKernel(this.kernel);
                    this.add(processUnit);
                    stringArray2[i] = processUnit.getID();
                    continue;
                }
                if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST_BIGCOMPLEX")) {
                    stringArray[i] = stringArray[i].substring("SYSTEM_ESCAPE_CAST_BIGCOMPLEX".length(), stringArray[i].length());
                    processUnit2 = this.getProcessUnit(stringArray[i]);
                    processUnit2 = this.checkCast(processUnit2);
                    this.checkRightHand(processUnit2);
                    processUnit = new CastUnit(processUnit2, 141, this.processEngine);
                    processUnit.setBestInputType();
                    processUnit.setProcessKernel(this.kernel);
                    this.add(processUnit);
                    stringArray2[i] = processUnit.getID();
                    continue;
                }
                if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST_STRING")) {
                    stringArray[i] = stringArray[i].substring("SYSTEM_ESCAPE_CAST_STRING".length(), stringArray[i].length());
                    processUnit2 = this.getProcessUnit(stringArray[i]);
                    processUnit2 = this.checkCast(processUnit2);
                    this.checkRightHand(processUnit2);
                    processUnit = new CastUnit(processUnit2, 102, this.processEngine);
                    processUnit.setBestInputType();
                    processUnit.setProcessKernel(this.kernel);
                    this.add(processUnit);
                    stringArray2[i] = processUnit.getID();
                    continue;
                }
                if (stringArray[i].startsWith("SYSTEM_ESCAPE_CAST_BOOLEAN")) {
                    stringArray[i] = stringArray[i].substring("SYSTEM_ESCAPE_CAST_BOOLEAN".length(), stringArray[i].length());
                    processUnit2 = this.getProcessUnit(stringArray[i]);
                    processUnit2 = this.checkCast(processUnit2);
                    this.checkRightHand(processUnit2);
                    processUnit = new CastUnit(processUnit2, 105, this.processEngine);
                    processUnit.setBestInputType();
                    processUnit.setProcessKernel(this.kernel);
                    this.add(processUnit);
                    stringArray2[i] = processUnit.getID();
                    continue;
                }
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u4e0d\u660e\u306a\u30ad\u30e3\u30b9\u30c8\u304c\u8a18\u8ff0\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                } else {
                    this.error("Cannot interpret the cast operation.");
                }
                return null;
            }
            if (stringArray[i].startsWith("!")) {
                stringArray[i] = stringArray[i].replaceAll("!", "");
                processUnit2 = this.getProcessUnit(stringArray[i]);
                this.checkTypeBoolean(processUnit2, "!");
                this.checkRightHand(processUnit2);
                processUnit = new ReverseUnit(processUnit2, this.processEngine);
                processUnit.setBestInputType();
                processUnit.setProcessKernel(this.kernel);
                this.add(processUnit);
                stringArray2[i] = processUnit.getID();
                continue;
            }
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    private String minus(String string) {
        if (this.error) {
            return null;
        }
        string = this.unEscape(new String[]{string})[0];
        ProcessUnit processUnit = this.getProcessUnit(string);
        this.checkTypeArithmeticAndComplex(processUnit, "-");
        this.checkRightHand(processUnit);
        if (this.error) {
            return null;
        }
        MinusUnit minusUnit = new MinusUnit(processUnit, this.processEngine);
        minusUnit.setBestInputType();
        minusUnit.setProcessKernel(this.kernel);
        this.add(minusUnit);
        return minusUnit.getID();
    }

    private String addition(String[] stringArray) {
        int n;
        if (this.error) {
            return null;
        }
        int n2 = stringArray.length;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n2];
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            processUnitArray[n] = this.getProcessUnit(stringArray[n]);
            if (this.error) {
                return null;
            }
            if (processUnitArray[n].getValueType() != 102) continue;
            bl = true;
        }
        for (n = 0; n < n2; ++n) {
            if (!bl || processUnitArray[n].getValueType() != 105) {
                this.checkTypeArithmeticAndComplexAndString(processUnitArray[n], "+");
            }
            if (!this.error) continue;
            return null;
        }
        if (this.error) {
            return null;
        }
        ProcessUnit processUnit = this.isSIMD(processUnitArray) ? new SIMDAdditionUnit(processUnitArray, this.processEngine) : new SISDAdditionUnit(processUnitArray, this.processEngine);
        processUnit.setBestInputType();
        processUnit.setProcessKernel(this.kernel);
        this.add(processUnit);
        return processUnit.getID();
    }

    private String subtraction(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmeticAndComplex(processUnitArray[i], "-");
            this.checkRightHand(processUnitArray[i]);
            if (!this.error) continue;
            return null;
        }
        if (this.error) {
            return null;
        }
        ProcessUnit processUnit = this.isSIMD(processUnitArray) ? new SIMDSubtractionUnit(processUnitArray, this.processEngine) : new SISDSubtractionUnit(processUnitArray, this.processEngine);
        processUnit.setBestInputType();
        processUnit.setProcessKernel(this.kernel);
        this.add(processUnit);
        return processUnit.getID();
    }

    private String division(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmeticAndComplex(processUnitArray[i], "/");
            this.checkRightHand(processUnitArray[i]);
            if (!this.error) continue;
            return null;
        }
        if (this.error) {
            return null;
        }
        ProcessUnit processUnit = this.isSIMD(processUnitArray) ? new SIMDDivisionUnit(processUnitArray, this.processEngine) : new SISDDivisionUnit(processUnitArray, this.processEngine);
        processUnit.setBestInputType();
        processUnit.setProcessKernel(this.kernel);
        this.add(processUnit);
        return processUnit.getID();
    }

    private String multiplication(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmeticAndComplex(processUnitArray[i], "*");
            this.checkRightHand(processUnitArray[i]);
            if (!this.error) continue;
            return null;
        }
        if (this.error) {
            return null;
        }
        ProcessUnit processUnit = this.isSIMD(processUnitArray) ? new SIMDMultiplicationUnit(processUnitArray, this.processEngine) : new SISDMultiplicationUnit(processUnitArray, this.processEngine);
        processUnit.setBestInputType();
        processUnit.setProcessKernel(this.kernel);
        this.add(processUnit);
        return processUnit.getID();
    }

    private String power(String[] stringArray) {
        ProcessCompatibilityException processCompatibilityException;
        int n;
        int n2;
        FunctionCallKernel functionCallKernel;
        if (this.error) {
            return null;
        }
        if (2 < stringArray.length) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u300c ** \u300d\u6f14\u7b97\u5b50\u3092\u8907\u6570\u4f7f\u7528\u3059\u308b\u969b\u306f\u3001\u8a18\u53f7\u300c ( ) \u300d\u3092\u7528\u3044\u3066\u51e6\u7406\u9806\u5e8f\u3092\u660e\u793a\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") : this.errorMessage + "When using multiple \"**\" operators, please specify their operation orders explicitly by parentheses ( )." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
            return "SYSTEM_PROCESS_ERROR";
        }
        FunctionCallKernel functionCallKernel2 = functionCallKernel = this.programInstance == null ? null : this.programInstance.getFunction("pow");
        if (functionCallKernel == null) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u300c ** \u300d\u6f14\u7b97\u5b50\u3092\u4f7f\u7528\u3059\u308b\u306b\u306f\u3001\u300c Math \u300d\u30e9\u30a4\u30d6\u30e9\u30ea\u304c\u5fc5\u8981\u3067\u3059\u3002\u30d7\u30ed\u30b0\u30e9\u30e0\u5148\u982d\u306b\u4e0b\u8a18\u306e\u4e00\u884c\u3092\u8ffd\u8a18\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") : this.errorMessage + "Using \"**\" operators require importing \"Math\" library. Please append the following line to the top of the code:" + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + "\timport Math ;" + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + "\t" + System.getProperty("line.separator");
            this.error(this.errorMessage);
            return "SYSTEM_PROCESS_ERROR";
        }
        functionCallKernel = null;
        int n3 = stringArray.length;
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            processUnitArray[n2] = this.getProcessUnit(stringArray[n2]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmeticAndComplex(processUnitArray[n2], "**");
            this.checkRightHand(processUnitArray[n2]);
            if (!this.error) continue;
            return null;
        }
        if (this.error) {
            return null;
        }
        n2 = 1;
        for (n = 0; n < n3; ++n) {
            if (processUnitArray[n].getValueType() == 101 || processUnitArray[n].getValueType() == 104) continue;
            n2 = 0;
        }
        if (n2 != 0 && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u300c ** \u300d\u6f14\u7b97\u5b50\u3092\u6574\u6570\u201c\u540c\u58eb\u201d\u306b\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u63a8\u5968\u3055\u308c\u307e\u305b\u3093\u3002\u300c ** \u300d\u6f14\u7b97\u5b50\u306f Math.pow \u95a2\u6570\u306e\u7cd6\u8863\u69cb\u6587\u3067\u3042\u308a\u3001\u6574\u6570\u540c\u58eb\u3067\u3082\u6f14\u7b97\u7d50\u679c\u306f\u6574\u6570\u306b\u306a\u308a\u307e\u305b\u3093\u3002\u6574\u6570\u540c\u58eb\u306b\u3088\u308b\u300c ** \u300d\u6f14\u7b97\u306e\u7d50\u679c\u306f\u3001\u76f4\u611f\u7684\u306b\u306f\u6574\u6570\u3067\u3042\u308b\u4e8b\u304c\u671f\u5f85\u3055\u308c\u308b\u305f\u3081\u3001\u3053\u306e\u6319\u52d5\u306f\u6df7\u4e71\u3092\u62db\u304d\u307e\u3059\u3002\u305d\u306e\u305f\u3081\u3001\u30b3\u30fc\u30c9\u5185\u3067\u660e\u793a\u7684\u306b\u3001\u6f14\u7b97\u5bfe\u8c61\uff08\u30aa\u30da\u30e9\u30f3\u30c9\uff09\u3092 float \u307e\u305f\u306f varfloat \u578b\u3078\u30ad\u30e3\u30b9\u30c8\u3059\u308b\u4e8b\u304c\u63a8\u5968\u3055\u308c\u307e\u3059\u3002\u4f8b\uff1aa = (float)b ** (float)c ;");
            } else {
                this.error("It is not recommended to use \"**\" operator for int-type values/variables. \"**\" operator is a syntax-sugar of Math.pow(float,float) function, so the operands of this operator are casted to float-type values automatically. To avoid confusion, please cast the operands to float-type explicitly in the code. Example: a = (float)b ** (float)c ;");
            }
        }
        n = 0;
        if (processUnitArray[1].getValueType() == 103 || processUnitArray[1].getValueType() == 103) {
            n = 1;
        }
        if (n != 0) {
            boolean bl = processUnitArray[0].getValueType() == 103;
            boolean bl2 = processUnitArray[1].getValueType() == 103;
            String string = "";
            if (bl && bl2) {
                string = "pow(" + processUnitArray[0].getID() + "," + processUnitArray[1].getID() + ")";
            }
            if (!bl && bl2) {
                string = "pow((varfloat)" + processUnitArray[0].getID() + "," + processUnitArray[1].getID() + ")";
            }
            if (bl && !bl2) {
                string = "pow(" + processUnitArray[0].getID() + ",(varfloat)" + processUnitArray[1].getID() + ")";
            }
            string = this.getProcessedSection(string);
            return string;
        }
        ProcessUnit processUnit = this.isSIMD(processUnitArray) ? new SIMDPowerUnit(processUnitArray, this.processEngine) : new SISDPowerUnit(processUnitArray, this.processEngine);
        processUnit.setBestInputType();
        processUnit.setProcessKernel(this.kernel);
        this.add(processUnit);
        return processUnit.getID();
    }

    private String remainder(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmetic(processUnitArray[i], "%");
            this.checkRightHand(processUnitArray[i]);
        }
        if (this.error) {
            return null;
        }
        ProcessUnit processUnit = 1 < n && this.isSIMD(processUnitArray) ? new SIMDRemainderUnit(processUnitArray, this.processEngine) : new SISDRemainderUnit(processUnitArray, this.processEngine);
        processUnit.setBestInputType();
        processUnit.setProcessKernel(this.kernel);
        this.add(processUnit);
        return processUnit.getID();
    }

    private String lessEqual(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        if (3 <= n) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6bd4\u8f03\u6f14\u7b97\u5b50\u3092\u30012\u500b\u4ee5\u4e0a\u7d9a\u3051\u3066\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u6570\u306e\u6bd4\u8f03\u6f14\u7b97\u7d50\u679c\u3092\u7d44\u307f\u5408\u308f\u305b\u305f\u6761\u4ef6\u3092\u4f5c\u308b\u306b\u306f\u3001\u8ad6\u7406\u6f14\u7b97\u5b50 && \u3084 || \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") : this.errorMessage + "Combination use of multiple comparison operators is syntactically incorrect. For combining the multiple comparison results, use logical operators: \"&&\" or \"||\"." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmetic(processUnitArray[i], "<=");
            this.checkRightHand(processUnitArray[i]);
        }
        if (this.error) {
            return null;
        }
        LessEqualUnit lessEqualUnit = new LessEqualUnit(processUnitArray, this.processEngine);
        lessEqualUnit.setBestInputType();
        lessEqualUnit.setValueType(105);
        lessEqualUnit.setProcessKernel(this.kernel);
        this.add(lessEqualUnit);
        return lessEqualUnit.getID();
    }

    private String lessThan(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        if (3 <= n) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6bd4\u8f03\u6f14\u7b97\u5b50\u3092\u30012\u500b\u4ee5\u4e0a\u7d9a\u3051\u3066\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u6570\u306e\u6bd4\u8f03\u6f14\u7b97\u7d50\u679c\u3092\u7d44\u307f\u5408\u308f\u305b\u305f\u6761\u4ef6\u3092\u4f5c\u308b\u306b\u306f\u3001\u8ad6\u7406\u6f14\u7b97\u5b50 && \u3084 || \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") : this.errorMessage + "Combination use of multiple comparison operators is syntactically incorrect. For combining the multiple comparison results, use logical operators: \"&&\" or \"||\"." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmetic(processUnitArray[i], "<");
            this.checkRightHand(processUnitArray[i]);
        }
        if (this.error) {
            return null;
        }
        LessThanUnit lessThanUnit = new LessThanUnit(processUnitArray, this.processEngine);
        lessThanUnit.setBestInputType();
        lessThanUnit.setValueType(105);
        lessThanUnit.setProcessKernel(this.kernel);
        this.add(lessThanUnit);
        return lessThanUnit.getID();
    }

    private String greaterEqual(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        if (3 <= n) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6bd4\u8f03\u6f14\u7b97\u5b50\u3092\u30012\u500b\u4ee5\u4e0a\u7d9a\u3051\u3066\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u6570\u306e\u6bd4\u8f03\u6f14\u7b97\u7d50\u679c\u3092\u7d44\u307f\u5408\u308f\u305b\u305f\u6761\u4ef6\u3092\u4f5c\u308b\u306b\u306f\u3001\u8ad6\u7406\u6f14\u7b97\u5b50 && \u3084 || \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") : this.errorMessage + "Combination use of multiple comparison operators is syntactically incorrect. For combining the multiple comparison results, use logical operators: \"&&\" or \"||\"." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmetic(processUnitArray[i], ">=");
            this.checkRightHand(processUnitArray[i]);
        }
        if (this.error) {
            return null;
        }
        GreaterEqualUnit greaterEqualUnit = new GreaterEqualUnit(processUnitArray, this.processEngine);
        greaterEqualUnit.setBestInputType();
        greaterEqualUnit.setValueType(105);
        greaterEqualUnit.setProcessKernel(this.kernel);
        this.add(greaterEqualUnit);
        return greaterEqualUnit.getID();
    }

    private String greaterThan(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        if (3 <= n) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6bd4\u8f03\u6f14\u7b97\u5b50\u3092\u30012\u500b\u4ee5\u4e0a\u7d9a\u3051\u3066\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u6570\u306e\u6bd4\u8f03\u6f14\u7b97\u7d50\u679c\u3092\u7d44\u307f\u5408\u308f\u305b\u305f\u6761\u4ef6\u3092\u4f5c\u308b\u306b\u306f\u3001\u8ad6\u7406\u6f14\u7b97\u5b50 && \u3084 || \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") : this.errorMessage + "Combination use of multiple comparison operators is syntactically incorrect. For combining the multiple comparison results, use logical operators: \"&&\" or \"||\"." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeArithmetic(processUnitArray[i], ">");
            this.checkRightHand(processUnitArray[i]);
        }
        if (this.error) {
            return null;
        }
        GreaterThanUnit greaterThanUnit = new GreaterThanUnit(processUnitArray, this.processEngine);
        greaterThanUnit.setBestInputType();
        greaterThanUnit.setValueType(105);
        greaterThanUnit.setProcessKernel(this.kernel);
        this.add(greaterThanUnit);
        return greaterThanUnit.getID();
    }

    private String notEqual(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        if (3 <= n) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6bd4\u8f03\u6f14\u7b97\u5b50\u3092\u30012\u500b\u4ee5\u4e0a\u7d9a\u3051\u3066\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u6570\u306e\u6bd4\u8f03\u6f14\u7b97\u7d50\u679c\u3092\u7d44\u307f\u5408\u308f\u305b\u305f\u6761\u4ef6\u3092\u4f5c\u308b\u306b\u306f\u3001\u8ad6\u7406\u6f14\u7b97\u5b50 && \u3084 || \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") : this.errorMessage + "Combination use of multiple comparison operators is syntactically incorrect. For combining the multiple comparison results, use logical operators: \"&&\" or \"||\"." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (!this.error) continue;
            return null;
        }
        NotEqualUnit notEqualUnit = new NotEqualUnit(processUnitArray, this.processEngine);
        notEqualUnit.setBestInputType();
        notEqualUnit.setValueType(105);
        notEqualUnit.setProcessKernel(this.kernel);
        this.add(notEqualUnit);
        return notEqualUnit.getID();
    }

    private String equal(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        if (3 <= n) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6bd4\u8f03\u6f14\u7b97\u5b50\u3092\u30012\u500b\u4ee5\u4e0a\u7d9a\u3051\u3066\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u8907\u6570\u306e\u6bd4\u8f03\u6f14\u7b97\u7d50\u679c\u3092\u7d44\u307f\u5408\u308f\u305b\u305f\u6761\u4ef6\u3092\u4f5c\u308b\u306b\u306f\u3001\u8ad6\u7406\u6f14\u7b97\u5b50 && \u3084 || \u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002" + System.getProperty("line.separator") : this.errorMessage + "Combination use of multiple comparison operators is syntactically incorrect. For combining the multiple comparison results, use logical operators: \"&&\" or \"||\"." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (!this.error) continue;
            return null;
        }
        EqualUnit equalUnit = new EqualUnit(processUnitArray, this.processEngine);
        equalUnit.setBestInputType();
        equalUnit.setValueType(105);
        this.add(equalUnit);
        equalUnit.setProcessKernel(this.kernel);
        return equalUnit.getID();
    }

    private String or(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeBoolean(processUnitArray[i], "||");
            this.checkRightHand(processUnitArray[i]);
        }
        if (this.error) {
            return null;
        }
        OrUnit orUnit = new OrUnit(processUnitArray, this.processEngine);
        orUnit.setBestInputType();
        orUnit.setValueType(105);
        orUnit.setProcessKernel(this.kernel);
        this.add(orUnit);
        return orUnit.getID();
    }

    private String and(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            this.checkTypeBoolean(processUnitArray[i], "&&");
            this.checkRightHand(processUnitArray[i]);
        }
        if (this.error) {
            return null;
        }
        AndUnit andUnit = new AndUnit(processUnitArray, this.processEngine);
        andUnit.setBestInputType();
        andUnit.setValueType(105);
        andUnit.setProcessKernel(this.kernel);
        this.add(andUnit);
        return andUnit.getID();
    }

    private void warn(String string) {
        ProcessCompatibilityException processCompatibilityException = new ProcessCompatibilityException();
        if (!processCompatibilityException.alert()) {
            this.error(string);
        }
    }

    public ProcessUnit[] checkSubstitution(ProcessUnit[] processUnitArray) {
        if (processUnitArray == null) {
            return null;
        }
        if (processUnitArray.length == 0) {
            return processUnitArray;
        }
        int n = processUnitArray[0].getValueType();
        int n2 = processUnitArray[1].getValueType();
        this.checkRightHand(processUnitArray[1]);
        this.checkLeftHand(processUnitArray[0]);
        if (this.error) {
            return null;
        }
        if (n == 101) {
            if (n2 == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("int \u578b\u306e\u5909\u6570\u306b complex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store complex-type values into int-type variables.");
                }
            } else if (n2 == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("int \u578b\u306e\u5909\u6570\u306b varcomplex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store varcomplex-type values into int-type variables.");
                }
            } else if (n2 == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("int \u578b\u306e\u5909\u6570\u306b bool \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store bool-type values into int-type variables.");
                }
            }
        }
        if (n == 100) {
            if (n2 == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("float \u578b\u306e\u5909\u6570\u306b complex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store complex-type values into float-type variables.");
                }
            } else if (n2 == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("float \u578b\u306e\u5909\u6570\u306b varcomplex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store varcomplex-type values into float-type variables.");
                }
            } else if (n2 == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("float \u578b\u306e\u5909\u6570\u306b bool \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store bool-type values into float-type variables.");
                }
            }
        }
        if (n == 104) {
            if (n2 == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("varint \u578b\u306e\u5909\u6570\u306b complex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store complex-type values into varint-type variables.");
                }
            } else if (n2 == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("varint \u578b\u306e\u5909\u6570\u306b varcomplex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store varcomplex-type values into varint-type variables.");
                }
            } else if (n2 == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("varint \u578b\u306e\u5909\u6570\u306b bool \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store bool-type values into varint-type variables.");
                }
            }
        }
        if (n == 103) {
            if (n2 == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("varint \u578b\u306e\u5909\u6570\u306b complex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store complex-type values into varfloat-type variables.");
                }
            } else if (n2 == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("varint \u578b\u306e\u5909\u6570\u306b varcomplex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store varcomplex-type values into varfloat-type variables.");
                }
            } else if (n2 == 105) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("varint \u578b\u306e\u5909\u6570\u306b bool \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.warn("Cannot store bool-type values into varfloat-type variables.");
                }
            }
        }
        if (n == 140 && n2 == 105) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.warn("complex \u578b\u306e\u5909\u6570\u306b bool \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3053\u306e\u6f14\u7b97\u306f\u5b9f\u884c\u6642\u306b\u5fc5\u305a\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002");
            } else {
                this.warn("Cannot store bool-type values into complex-type variables.");
            }
        }
        if (n == 141 && n2 == 105) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.warn("varcomplex \u578b\u306e\u5909\u6570\u306b bool \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3053\u306e\u6f14\u7b97\u306f\u5b9f\u884c\u6642\u306b\u5fc5\u305a\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002");
            } else {
                this.warn("Cannot store bool-type values into varcomplex-type variables.");
            }
        }
        if (n == 105) {
            if (n2 == 101) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("bool \u578b\u306e\u5909\u6570\u306b int \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3053\u306e\u6f14\u7b97\u306f\u5b9f\u884c\u6642\u306b\u5fc5\u305a\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002");
                } else {
                    this.warn("Cannot store int-type values into bool-type variables.");
                }
            } else if (n2 == 104) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("bool \u578b\u306e\u5909\u6570\u306b varint \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3053\u306e\u6f14\u7b97\u306f\u5b9f\u884c\u6642\u306b\u5fc5\u305a\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002");
                } else {
                    this.warn("Cannot store varint-type values into bool-type variables.");
                }
            } else if (n2 == 100) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("bool \u578b\u306e\u5909\u6570\u306b float \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3053\u306e\u6f14\u7b97\u306f\u5b9f\u884c\u6642\u306b\u5fc5\u305a\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002");
                } else {
                    this.warn("Cannot store float-type values into bool-type variables.");
                }
            } else if (n2 == 103) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("bool \u578b\u306e\u5909\u6570\u306b varfloat \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3053\u306e\u6f14\u7b97\u306f\u5b9f\u884c\u6642\u306b\u5fc5\u305a\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002");
                } else {
                    this.warn("Cannot store varfloat-type values into bool-type variables.");
                }
            } else if (n2 == 140) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("bool \u578b\u306e\u5909\u6570\u306b complex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3053\u306e\u6f14\u7b97\u306f\u5b9f\u884c\u6642\u306b\u5fc5\u305a\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002");
                } else {
                    this.warn("Cannot store complex-type values into bool-type variables.");
                }
            } else if (n2 == 141) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.warn("bool \u578b\u306e\u5909\u6570\u306b varcomplex \u578b\u306e\u5024\u3092\u4ee3\u5165\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3053\u306e\u6f14\u7b97\u306f\u5b9f\u884c\u6642\u306b\u5fc5\u305a\u30e9\u30f3\u30bf\u30a4\u30e0\u30a8\u30e9\u30fc\u3092\u767a\u751f\u3055\u305b\u307e\u3059\u3002");
                } else {
                    this.warn("Cannot store varcomplex-type values into bool-type variables.");
                }
            }
        }
        return processUnitArray;
    }

    private String substitution(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        if (3 <= n) {
            this.error = true;
            if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u884c\u672b\u306b\u300c ; \u300d\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u4e00\u3064\u306e\u6587\u3067\u8907\u6570\u306e\u4ee3\u5165\u6f14\u7b97\u5b50\u300c = \u300d\u3092\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            } else {
                this.error("Lacking a semi-colon \";\" at the end of the statement. Cannot use multiple assignment operators \"=\" in a statement.");
            }
        }
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        processUnitArray[0] = this.getProcessUnit(stringArray[0], true);
        for (int i = 1; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (!this.error) continue;
            return null;
        }
        if ((processUnitArray = this.checkSubstitution(processUnitArray))[0].isConst() && !this.constInitializer) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? "\u5909\u6570\u300c " + processUnitArray[0].getName() + " \u300d\u306f const \u3067\u3059\u3002\u5ba3\u8a00\u5f8c\u306f\u5024\u3092\u5909\u66f4\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : "Cannot change the value stored in the variable \"" + processUnitArray[0].getName() + "\", because this variable is declared with \"const\"." + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        if (processUnitArray[0].isArrayType() && processUnitArray[1].getValueType() == -100) {
            this.error(new ProcessSyntaxException().getInfoMessage(24));
        }
        if (processUnitArray[0].getValueType() == 200) {
            ProcessStruct processStruct = processUnitArray[0].getStruct();
            if (processUnitArray[1].getValueType() == 200) {
                ProcessStruct processStruct2 = processUnitArray[1].getStruct();
                if (processStruct != processStruct2) {
                    String string = "";
                    string = processStruct == null ? "(" + processUnitArray[0].valueTypeToString(processUnitArray[0].getValueType()) + ") = (" + processStruct2.getType() + ")" : (processStruct2 == null ? "(" + processStruct.getType() + ") = (" + processUnitArray[1].valueTypeToString(processUnitArray[1].getValueType()) + ")" : "(" + processStruct.getType() + ") = (" + processStruct2.getType() + ")");
                    this.error(string + " : " + new ProcessSyntaxException(this.processEngine).getInfoMessage(6));
                    return null;
                }
            } else if (processUnitArray[1].getValueType() != -100) {
                String string = "";
                string = processStruct == null ? "(" + processUnitArray[0].valueTypeToString(processUnitArray[0].getValueType()) + ") = (" + processUnitArray[1].valueTypeToString(processUnitArray[1].getValueType()) + ")" : "(" + processStruct.getType() + ") = (" + processUnitArray[1].valueTypeToString(processUnitArray[1].getValueType()) + ")";
                this.error(string + " : " + new ProcessSyntaxException(this.processEngine).getInfoMessage(6));
                return null;
            }
        }
        ProcessUnit processUnit = this.isSIMD(processUnitArray) ? new SIMDSubstitutionUnit(processUnitArray, this.processEngine) : (processUnitArray[0] instanceof ReferenceUnit ? new SIMDSubstitutionUnit(processUnitArray, this.processEngine) : (processUnitArray[0].specialType == 10002 ? new SISDArraySubstitutionUnit(processUnitArray, this.processEngine) : new SISDSubstitutionUnit(processUnitArray, this.processEngine)));
        processUnit.setProcessKernel(this.kernel);
        this.add(processUnit);
        return processUnit.getID();
    }

    private String arrayLengthSubstitution(String[] stringArray) {
        if (this.error) {
            return null;
        }
        int n = stringArray.length;
        if (3 <= n) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u4ee3\u5165\u6f14\u7b97\u5b50\u3092\u3001\u540c\u3058\u304b\u3063\u3053\u968e\u5c64\u5185\u3067\u30012\u500b\u4ee5\u4e0a\u7d9a\u3051\u3066\u4f7f\u7528\u3059\u308b\u4e8b\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "Combined use of multiple assignment operators in the same parenthesis-hierarchy is syntactically incorrect." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        double d = 0.0;
        stringArray = this.unEscape(stringArray);
        ProcessUnit[] processUnitArray = new ProcessUnit[n];
        for (int i = 0; i < n; ++i) {
            processUnitArray[i] = this.getProcessUnit(stringArray[i]);
            if (this.error) {
                return null;
            }
            if (i == 0) continue;
            this.checkRightHand(processUnitArray[i]);
        }
        if (!this.isSIMD(processUnitArray)) {
            this.error = true;
            this.errorMessage = ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u6f14\u7b97\u5b50 \" [=] \" \u306f\u3001\u914d\u5217\u3067\u306a\u3044\u5909\u6570\u306b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") : this.errorMessage + "Cannot use the operator \"[=]\" for non-array values/variables." + System.getProperty("line.separator");
            this.errorMessage = this.errorMessage + System.getProperty("line.separator");
            this.error(this.errorMessage);
        }
        ArrayLengthSubstitutionUnit arrayLengthSubstitutionUnit = new ArrayLengthSubstitutionUnit(processUnitArray, this.processEngine);
        arrayLengthSubstitutionUnit.setProcessKernel(this.kernel);
        this.add(arrayLengthSubstitutionUnit);
        return arrayLengthSubstitutionUnit.getID();
    }

    private String getMathHeadTag(String string) {
        return this.getMathHeadTag(string, 0);
    }

    private String getMathHeadTag(String string, int n) {
        String string2 = "";
        boolean bl = false;
        int n2 = string.length();
        if (5 <= n2 && !bl && ((string2 = string.substring(n, 5)).equals("asinh") || string2.equals("acosh") || string2.equals("atanh"))) {
            bl = true;
        }
        if (4 <= n2 && !bl && ((string2 = string.substring(n, 4)).equals("asin") || string2.equals("acos") || string2.equals("atan") || string2.equals("sqrt") || string2.equals("sinh") || string2.equals("cosh") || string2.equals("tanh"))) {
            bl = true;
        }
        if (3 <= n2 && !bl && ((string2 = string.substring(n, 3)).equals("sin") || string2.equals("cos") || string2.equals("log") || string2.equals("tan") || string2.equals("abs") || string2.equals("exp"))) {
            bl = true;
        }
        if (2 <= n2 && !bl && (string2 = string.substring(n, 2)).equals("ln")) {
            bl = true;
        }
        if (1 <= n2 && !bl && (string2 = string.substring(n, 1)).equals("!")) {
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return string2;
    }

    private String getMathTailTag(String string) {
        String string2 = "";
        boolean bl = false;
        int n = string.length();
        if (n - 1 >= 0 && !bl && (string2 = string.substring(n - 2, n - 1)).equals("^")) {
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return string2;
    }

    public FunctionCallKernel checkFunction(FunctionCallKernel functionCallKernel) {
        if (this.processEngine.hasError()) {
            return null;
        }
        if (functionCallKernel == null) {
            return null;
        }
        if (functionCallKernel.getFunctionName().equals(this.checkFunctionNameStock)) {
            if (functionCallKernel.programInstance == null && this.checkFunctionLibNameStock == null) {
                if (this.checkFunctionStock == null) {
                    return null;
                }
                return functionCallKernel;
            }
            if (functionCallKernel.programInstance != null && this.checkFunctionLibNameStock != null && functionCallKernel.programInstance.getName().equals(this.checkFunctionLibNameStock)) {
                if (this.checkFunctionStock == null) {
                    return null;
                }
                return functionCallKernel;
            }
        }
        this.checkFunctionNameStock = null;
        this.checkFunctionLibNameStock = null;
        this.checkFunctionStock = null;
        if (this.processEngine != null && this.processEngine.isOnRuntime() && this.runtimeCompileSecurityState) {
            boolean bl;
            String string = functionCallKernel.getFunctionName();
            if (string == null) {
                return functionCallKernel;
            }
            String string2 = null;
            if (string.startsWith("___")) {
                string = string.substring(3, string.length());
            }
            if (string.startsWith("exec")) {
                string2 = "System.exec";
            }
            if (string.startsWith("system")) {
                string2 = "System.system";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_NATIVE_createProcess")) {
                string2 = "Process.newProcess";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_NATIVE_disposeProcess")) {
                string2 = "Process.deleteProcess";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_NATIVE_waitForProcess")) {
                string2 = "Process.waitForProcess";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessExitValue")) {
                string2 = "Process.getProcessExitValue";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_NATIVE_getProcessOutput")) {
                string2 = "Process.getProcessOutput";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_NATIVE_setProcessInput")) {
                string2 = "Process.getProcessInput";
            }
            if (string.startsWith("newProcess")) {
                string2 = "Process.newProcess";
            }
            if (string.startsWith("deleteProcess")) {
                string2 = "Process.deleteProcess";
            }
            if (string.startsWith("waitForProcess")) {
                string2 = "Process.waitForProcess";
            }
            if (string.startsWith("getProcessExitValue")) {
                string2 = "Process.getProcessExitValue";
            }
            if (string.startsWith("getProcessOutput")) {
                string2 = "Process.getProcessOutput";
            }
            if (string.startsWith("setProcessInput")) {
                string2 = "Process.getProcessInput";
            }
            if (string2 != null) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.processEngine.error("eval \u307e\u305f\u306f override \u304b\u3089 \u30d7\u30e9\u30b0\u30a4\u30f3\u95a2\u6570\u3092\u201c\u76f4\u63a5\u7684\u306b\u201d\u30b3\u30fc\u30eb\u3059\u308b\u4e8b\u306f\u3001\u5b89\u5168\u6027\u306e\u305f\u3081\u306b\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\uff08 \u5bfe\u8c61\u306e\u95a2\u6570\uff1a" + string2 + " \uff09\u3002\u30b3\u30fc\u30eb\u3059\u308b\u305f\u3081\u306b\u306f\u3001\u30d7\u30e9\u30b0\u30a4\u30f3\u95a2\u6570\u3092VCSSL\u306e\u95a2\u6570\u3068\u3057\u3066\u30e9\u30c3\u30d4\u30f3\u30b0\u3057\u3001\u95a2\u6570\u3078\u306e\u53c2\u7167\u304c\u9759\u7684\u306b\uff08\u5b9f\u884c\u524d\u306b\uff09\u89e3\u6c7a\u3055\u308c\u308b\u3088\u3046\u306b\u3057\u3066\u4e0b\u3055\u3044\u3002\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u306e\u305f\u3081\u3001\u3053\u306e\u30d7\u30ed\u30bb\u30b9\u306f\u5f37\u5236\u7d42\u4e86\u3055\u308c\u307e\u3059\u3002");
                } else {
                    this.processEngine.error("Cannot call a function \"" + string2 + "\" which is provided by a plug-in directly, from the process executed by \"eval\" or \"override\" function. To call them, wrap them by functions declared in VCSSL code. This restriction is the restriction for the security. This process will be terminated immediately.");
                }
                this.processEngine.abnormallyExit();
                return null;
            }
            string2 = null;
            if (string.equals("reset") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.reset";
            }
            if (string.equals("___reset")) {
                string2 = "System.reset";
            }
            if (string.equals("exit") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.exit";
            }
            if (string.equals("___exit")) {
                string2 = "System.exit";
            }
            if (string2 != null) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.processEngine.error("eval \u307e\u305f\u306f override \u304b\u3089 \u30d7\u30e9\u30b0\u30a4\u30f3\u95a2\u6570\u3092\u201c\u76f4\u63a5\u7684\u306b\u201d\u30b3\u30fc\u30eb\u3059\u308b\u4e8b\u306f\u3001\u5b89\u5168\u6027\u306e\u305f\u3081\u306b\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\uff08 \u5bfe\u8c61\u306e\u95a2\u6570\uff1a" + string2 + " \uff09\u3002\u30b3\u30fc\u30eb\u3059\u308b\u305f\u3081\u306b\u306f\u3001\u30d7\u30e9\u30b0\u30a4\u30f3\u95a2\u6570\u3092VCSSL\u306e\u95a2\u6570\u3068\u3057\u3066\u30e9\u30c3\u30d4\u30f3\u30b0\u3057\u3001\u95a2\u6570\u3078\u306e\u53c2\u7167\u304c\u9759\u7684\u306b\uff08\u5b9f\u884c\u524d\u306b\uff09\u89e3\u6c7a\u3055\u308c\u308b\u3088\u3046\u306b\u3057\u3066\u4e0b\u3055\u3044\u3002\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u306e\u305f\u3081\u3001\u3053\u306e\u30d7\u30ed\u30bb\u30b9\u306f\u5f37\u5236\u7d42\u4e86\u3055\u308c\u307e\u3059\u3002");
                } else {
                    this.processEngine.error("Cannot call a function \"" + string2 + "\" which is provided by a plug-in directly, from the process executed by \"eval\" or \"override\" function. To call them, wrap them by functions declared in VCSSL code. This restriction is the restriction for the security. This process will be terminated immediately.");
                }
                this.processEngine.abnormallyExit();
                return null;
            }
            string2 = null;
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_FILE_makeDirectory")) {
                string2 = "File.makeDirectory";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_FILE_makeFile")) {
                string2 = "File.makeFile";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_FILE_removeFile")) {
                string2 = "File.removeFile";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_FILE_renameFile")) {
                string2 = "File.renameFile";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_FILE_copyFile")) {
                string2 = "File.copyFile";
            }
            if (string.startsWith("makeDirectory") && functionCallKernel.programInstance.getName().equals("File")) {
                string2 = "File.makeDirectory";
            }
            if (string.startsWith("makeFile") && functionCallKernel.programInstance.getName().equals("File")) {
                string2 = "File.makeFile";
            }
            if (string.startsWith("removeFile") && functionCallKernel.programInstance.getName().equals("File")) {
                string2 = "File.removeFile";
            }
            if (string.startsWith("renameFile") && functionCallKernel.programInstance.getName().equals("File")) {
                string2 = "File.renameFile";
            }
            if (string.startsWith("copyFile") && functionCallKernel.programInstance.getName().equals("File")) {
                string2 = "File.copyFile";
            }
            if (string.startsWith("newGraphics") && functionCallKernel.programInstance.getName().equals("Graphics")) {
                string2 = "Graphics.newGraphics";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_GRAPHICS_loadGraphics")) {
                string2 = "Graphics.newGraphics";
            }
            if (string.startsWith("exportGraphics") && functionCallKernel.programInstance.getName().equals("Graphics")) {
                string2 = "Graphics.exportGraphics";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_GRAPHICS_exportGraphics")) {
                string2 = "Graphics.exportGraphics";
            }
            if (string.startsWith("newSound") && functionCallKernel.programInstance.getName().equals("Sound")) {
                string2 = "Sound.newSound";
            }
            if (string.startsWith("SYSTEM_PROCESS_DRIVER_SOUND_newSound")) {
                string2 = "Sound.newSound";
            }
            if (string.startsWith("___open")) {
                string2 = "System.open";
            }
            if (string.startsWith("___write")) {
                string2 = "System.write";
            }
            if (string.startsWith("___writeln")) {
                string2 = "System.writeln";
            }
            if (string.startsWith("___read")) {
                string2 = "System.read";
            }
            if (string.startsWith("___readln")) {
                string2 = "System.readln";
            }
            if (string.startsWith("___close")) {
                string2 = "System.close";
            }
            if (string.startsWith("___exit")) {
                string2 = "System.exit";
            }
            if (string.startsWith("___mkdir")) {
                string2 = "System.mkdir";
            }
            if (string.equals("openw")) {
                string2 = "System.openw";
            }
            if (string.equals("openr")) {
                string2 = "System.openr";
            }
            if (string.equals("opencsvw")) {
                string2 = "System.opencsvw";
            }
            if (string.equals("opencsvr")) {
                string2 = "System.opencsvr";
            }
            if (string.equals("open") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.open";
            }
            if (string.equals("write") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.write";
            }
            if (string.equals("writeln") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.writeln";
            }
            if (string.equals("read") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.read";
            }
            if (string.equals("readln") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.readln";
            }
            if (string.equals("close") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.close";
            }
            if (string.equals("exit") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.exit";
            }
            if (string.equals("mkdir") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.mkdir";
            }
            if (string.equals("save") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.save";
            }
            if (string.equals("save") && functionCallKernel.programInstance != null && functionCallKernel.programInstance.getName().equals("System")) {
                string2 = "System.load";
            }
            if (string2 != null && !(bl = ScriptProcessor.locale.isJapanese() ? this.highLiskWarning("eval \u307e\u305f\u306f override \u304b\u3089\u6b21\u306e\u95a2\u6570\u3092\u76f4\u63a5\u7684\u306b\u30b3\u30fc\u30eb\u3059\u308b\u4e8b\u306f\u3001\u5b89\u5168\u6027\u306e\u305f\u3081\u306b\u63a8\u5968\u3055\u308c\u307e\u305b\u3093\u3002" + System.getProperty("line.separator") + "\u30b3\u30fc\u30eb\u3059\u308b\u306b\u306f\u3001\u3053\u306e\u95a2\u6570\u3092\u5225\u306e\u95a2\u6570\u3067\u30e9\u30c3\u30d4\u30f3\u30b0\u3057\u3001\u9593\u63a5\u7684\u306b\u30b3\u30fc\u30eb\u3057\u3066\u4e0b\u3055\u3044\u3002\u3053\u308c\u306f\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u306e\u305f\u3081\u306e\u914d\u616e\u3067\u3059\u3002" + System.getProperty("line.separator") + "\u3000\u3000\u5bfe\u8c61\u306e\u95a2\u6570\uff1a" + string2) : this.highLiskWarning("Cannot call a function \"" + string2 + "\" directly from the process executed by \"eval\" or \"override\" function." + System.getProperty("line.separator") + "To call them, wrap them by functions declared in VCSSL code." + System.getProperty("line.separator") + "This restriction is the restriction for the security."))) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.processEngine.error("\u5b9f\u884c\u4e2d\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u5f37\u5236\u7d42\u4e86\u3055\u308c\u307e\u3057\u305f\u3002");
                } else {
                    this.processEngine.error("The program has been terminated.");
                }
                this.processEngine.abnormallyExit();
                return null;
            }
            this.checkFunctionNameStock = functionCallKernel.getFunctionName();
            this.checkFunctionLibNameStock = functionCallKernel.programInstance != null ? functionCallKernel.programInstance.getName() : null;
            this.checkFunctionStock = functionCallKernel;
        }
        return functionCallKernel;
    }
}

