/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process;

import java.awt.TextArea;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngineDriveInterface;
import rxvesapi.process.ProcessEnvironmentProperty;
import rxvesapi.process.ProcessErrorEvent;
import rxvesapi.process.ProcessOutputListener;
import rxvesapi.process.ProcessProgram;
import rxvesapi.process.ProcessRuntimeException;
import rxvesapi.process.ProcessSecurity;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.connection.ConnectionClassLoaderTerminal;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.connection.GeneralProcessConnectionInterfaceAdapter;
import rxvesapi.process.decode.ProcessCodeConstructor;
import rxvesapi.process.decode.ProcessCodeLoader;
import rxvesapi.process.decode.ProcessCodeNameFilter;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.kernel.ScopeCallKernel;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.unit.ProcessUnit;
import rxvesapi.process.unit.StringArrayUnit;

public class ProcessEngine {
    private static String sysClassPath = System.getProperty("java.class.path");
    private static File jarLocationDir = new File(sysClassPath);
    public boolean onRuntime = false;
    public boolean fullDecode = true;
    ProcessOutputListener outputListener = null;
    Object mathContext = null;
    public Thread thread;
    public boolean processRequest = true;
    public String stackTraceBuffer = "";
    public boolean errorWaitFor = false;
    public String errorMessageBuffer = "";
    public boolean runtimeErrorLock = false;
    public File mainProgramDirectory = jarLocationDir;
    public URL mainProgramURL;
    public String onlineDirectoryPath = this.mainProgramDirectory.getPath();
    public boolean errorLock = false;
    private ProcessSecurity security;
    public ProcessUnit[] mainArgumentUnit;
    public FunctionCallKernel mainFunctionKernel;
    public static boolean NAME_FILTER;
    public static boolean XOR_OPERATOR_FILTER;
    public static boolean VARFLOAT_STATEMENT_FILTER;
    public static boolean varfloatStatementFilterWarning;
    public static boolean compatibilityMode;
    public boolean internalIibraryAccessPermission = true;
    public int scopeStartIndexBuffer;
    public int scopeEndIndexBuffer;
    public int scopeBodyStartIndexBuffer;
    public int scopeBodyEndIndexBuffer;
    public int scopeHeadStartIndexBuffer;
    public String scopeBuffer;
    public String scopeBodyBuffer;
    public String scopeHeadBuffer;
    public String scopeArgsBuffer;
    public String scopeNameBuffer;
    public int scopeReturnTypeBuffer;
    public boolean scopeReturnArrayTypeBuffer;
    public int scopeReturnArrayDimensionBuffer;
    public boolean error = false;
    public String errorMessage = "";
    public int errorIndex = 0;
    public boolean breaker = false;
    public BigInteger bi_ten = new BigInteger("10");
    public GeneralProcessConnectionInterface[] connector;
    public ProcessEngineDriveInterface[] engineDriver;
    public ProcessErrorEvent errorEvent;
    public int lastConnectorIndex = 0;
    public static int BINARY64;
    public static int DECIMAL;
    public int processMode = DECIMAL;
    public DecimalFormat decimalFormat = new DecimalFormat("0.0E0");
    private int counter = 0;
    public ProcessKernel[] processKernel;
    public ProcessKernel[] libraryKernel;
    public ScopeCallKernel[] rootProcessKernel;
    public ProcessProgram[] programInstance;
    public ProcessStruct[] struct;
    public ProcessUnit[] variable;
    public JFrame errorTextFrame;
    public TextArea errorTextArea;
    public boolean libraryLoading = false;
    public long drive = 0L;
    public long operationCounter = 0L;
    private int rootProcessKernelInitialCapacity = 8;
    private int rootProcessKernelRegistered = 0;
    private int processKernelInitialCapacity = 16;
    private int processKernelRegistered = 0;
    private int libraryKernelInitialCapacity = 16;
    private int libraryKernelRegistered = 0;
    private int programInstanceInitialCapacity = 8;
    private int programInstanceRegistered = 0;
    private int variableInitialCapacity = 8;
    private int variableRegistered = 0;
    private int structInitialCapacity = 8;
    private int structRegistered = 0;
    private int currentScopeIndex = 0;
    public GeneralProcessConnectionInterface shellPrintDriver;
    public long startTime;
    private String[] libraryPath = null;
    boolean abnormallyExitMessageOut = true;
    boolean showErrorTextMessageOut = true;
    private int scopeCounter = 0;
    private int kernelCounter = 0;
    static final int errorMax = 1;
    int errorCounter;

    public void setProcessOutputListener(ProcessOutputListener processOutputListener) {
        this.outputListener = processOutputListener;
    }

    public void output(ProcessUnit[] processUnitArray) {
        this.outputListener.output(processUnitArray);
    }

    public void setMathContext(Object object) {
        this.mathContext = object;
    }

    public Object getMathContext() {
        return this.mathContext;
    }

    public int nextScopeIndex() {
        return this.currentScopeIndex++;
    }

    public boolean isOnRuntime() {
        return this.onRuntime;
    }

    public void print(String string) {
        if (this.shellPrintDriver == null) {
            int n = this.connector.length;
            for (int i = 0; i < n; ++i) {
                if (!this.connector[i].isProcessable("___print")) continue;
                this.shellPrintDriver = this.connector[i];
            }
        }
        this.shellPrintDriver.process("___print", new String[]{string});
    }

    public ProcessEngine() {
    }

    public ProcessEngine(ProcessSecurity processSecurity) {
        this.security = processSecurity;
    }

    public ProcessSecurity getSecurity() {
        return this.security;
    }

    public void setCompatibilityMode(boolean bl) {
        compatibilityMode = bl;
    }

    public boolean isCompatibilityMode() {
        return compatibilityMode;
    }

    public void resetWarning() {
        ProcessCompatibilityException.alerted = false;
        NAME_FILTER = true;
        XOR_OPERATOR_FILTER = true;
        VARFLOAT_STATEMENT_FILTER = true;
        varfloatStatementFilterWarning = true;
        ProcessCodeNameFilter.setWarningState(false);
        ProcessCodeLoader.setLineFeedReplaceMode(false);
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void disposeResource() {
        this.disposeResource(false);
    }

    public void disposeResource(boolean bl) {
        int n;
        this.mainProgramDirectory = null;
        this.format(bl);
        this.thread = null;
        this.currentScopeIndex = 0;
        this.shellPrintDriver = null;
        if (this.programInstance != null) {
            for (n = 0; n < this.programInstance.length; ++n) {
                if (this.programInstance[n] == null) continue;
                this.programInstance[n].disposeResource();
                this.programInstance[n] = null;
            }
            this.programInstance = null;
        }
        if (this.variable != null) {
            for (n = 0; n < this.variable.length; ++n) {
                if (this.variable[n] == null) continue;
                this.variable[n].disposeResource();
                this.variable[n] = null;
            }
            this.variable = null;
        }
        for (n = 0; n < this.connector.length; ++n) {
            try {
                if (this.connector[n] != null) {
                    this.connector[n].dispose();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.connector[n] = null;
        }
        for (n = 0; n < this.rootProcessKernelRegistered; ++n) {
            if (this.rootProcessKernel == null || this.rootProcessKernel[n] == null) continue;
            this.rootProcessKernel[n].disposeResource();
            this.rootProcessKernel[n] = null;
        }
        for (n = 0; n < this.processKernelRegistered; ++n) {
            if (this.processKernel == null || this.processKernel[n] == null) continue;
            this.processKernel[n].disposeResource();
            this.processKernel[n] = null;
        }
        for (n = 0; n < this.libraryKernelRegistered; ++n) {
            if (this.libraryKernel == null || this.libraryKernel[n] == null) continue;
            this.libraryKernel[n].disposeResource();
            this.libraryKernel[n] = null;
        }
        if (this.mainArgumentUnit != null) {
            this.mainArgumentUnit[0].disposeResource();
            this.mainArgumentUnit[0] = null;
            this.mainArgumentUnit = null;
        }
    }

    public void error(String string) {
        this.error(string, null, null);
    }

    public void error(String string, String string2, String string3) {
        while (string3 != null && string3.startsWith(" ")) {
            string3 = string3.substring(1, string3.length());
        }
        while (string3 != null && string3.startsWith("\t")) {
            string3 = string3.substring(1, string3.length());
        }
        String string4 = string;
        if (ScriptProcessor.locale.isJapanese()) {
            if (string.indexOf("[ INFO") < 0) {
                string = "";
                if (string2 != null) {
                    string = string + "[ \u5834\u6240 ] " + string2 + System.getProperty("line.separator");
                }
                if (string3 != null) {
                    string = string + "[ \u5185\u5bb9 ] " + string3 + System.getProperty("line.separator");
                }
                string = string + "[ \u8a73\u7d30 ] " + string4;
                string = string + System.getProperty("line.separator");
                string = string + System.getProperty("line.separator");
                string = string + System.getProperty("line.separator");
            }
        } else if (string.indexOf("[ INFO") < 0) {
            string = "";
            if (string2 != null) {
                string = string + "[ LINE ] " + string2 + System.getProperty("line.separator");
            }
            if (string3 != null) {
                string = string + "[ CODE ] " + string3 + System.getProperty("line.separator");
            }
            string = string + "[ INFO ] " + string4;
            string = string + System.getProperty("line.separator");
            string = string + System.getProperty("line.separator");
            string = string + System.getProperty("line.separator");
        }
        ++this.errorIndex;
        this.error = true;
        this.errorMessage = "";
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.errorMessage = this.onRuntime ? (ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u5b9f\u884c\u6642\u30a8\u30e9\u30fc" : this.errorMessage + "RUNTIME ERROR") : (ScriptProcessor.locale.isJapanese() ? this.errorMessage + "\u69cb\u6587\u30a8\u30e9\u30fc" : this.errorMessage + "SYNTAX ERROR");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + System.getProperty("line.separator");
        this.errorMessage = this.errorMessage + string;
        this.showErrorMessage(this.errorMessage);
    }

    public String getConsoleText() {
        int n = this.engineDriver.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + this.engineDriver[i].processConsoleRequested();
        }
        return string;
    }

    public boolean hasError() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getOnlineProgramDirectoryPath() {
        return this.onlineDirectoryPath;
    }

    public void setOnlineProgramDirectory(String string) {
        this.onlineDirectoryPath = string;
        ProcessEnvironmentProperty.setOnlineDirectoryPath(string);
    }

    public void setMainProgramDirectory(File file) {
        this.mainProgramDirectory = file;
    }

    public File getMainProgramDirectory() {
        return this.mainProgramDirectory;
    }

    public void setMainProgramURL(URL uRL) {
        this.mainProgramURL = uRL;
    }

    public String[] getLibraryPath() {
        return this.libraryPath;
    }

    public void setLibraryPath(String[] stringArray) {
        this.libraryPath = stringArray;
    }

    public File getResourceFile(String string) {
        Serializable serializable;
        if (string.length() == 0 && !((ProcessCompatibilityException)(serializable = new ProcessCompatibilityException())).alert()) {
            ProcessRuntimeException processRuntimeException = new ProcessRuntimeException(this);
            processRuntimeException.setInfo(1);
            throw processRuntimeException;
        }
        serializable = new File(string);
        if (((File)(serializable = this.verifyOrErrorFile((File)serializable))).isAbsolute()) {
            return serializable;
        }
        serializable = new File(this.mainProgramDirectory, string);
        String string2 = ((File)serializable).getPath();
        return serializable;
    }

    public static boolean verifyURL(URL uRL) {
        String string = uRL.toString();
        if (string.startsWith("file:")) {
            return true;
        }
        if (string.startsWith("http://www.rinearn.com/")) {
            return true;
        }
        if (string.startsWith("https://vcssl.sakura.ne.jp/play/")) {
            return true;
        }
        return string.startsWith("https://vcssl.sakura.ne.jp/code/spec/");
    }

    public URL verifyOrErrorURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (ProcessEngine.verifyURL(uRL)) {
            return uRL;
        }
        this.error("Permission Denied: " + uRL);
        return null;
    }

    public File verifyOrErrorFile(File file) {
        if (file == null) {
            return null;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(file.toString());
        if (uRL == null) {
            String string = file.toString().replaceAll("\\\\", "/").replaceFirst(":/", "://");
            URL uRL2 = classLoader.getResource(string);
            if ((uRL2 = this.verifyOrErrorURL(uRL2)) == null) {
                try {
                    URL uRL3 = file.toURI().toURL();
                    uRL3 = this.verifyOrErrorURL(uRL3);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else {
            uRL = this.verifyOrErrorURL(uRL);
        }
        return file;
    }

    public URL getResourceURL(String string) {
        Serializable serializable;
        if (string.length() == 0 && !((ProcessCompatibilityException)(serializable = new ProcessCompatibilityException())).alert()) {
            ProcessRuntimeException processRuntimeException = new ProcessRuntimeException(this);
            processRuntimeException.setInfo(1);
            throw processRuntimeException;
        }
        serializable = new File(string);
        if (((File)serializable).isAbsolute()) {
            try {
                URL uRL = ((File)serializable).toURI().toURL();
                return this.verifyOrErrorURL(uRL);
            }
            catch (Exception exception) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                URL uRL = classLoader.getResource(string);
                return this.verifyOrErrorURL(uRL);
            }
        }
        serializable = new File(this.mainProgramDirectory, string);
        String string2 = ((File)serializable).getPath();
        try {
            URL uRL = ((File)serializable).toURI().toURL();
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL2 = classLoader.getResource(string2);
            if (uRL2 != null) {
                uRL = uRL2;
            }
            return this.verifyOrErrorURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public File getMainRelativeFile(String string) {
        Serializable serializable;
        if (string.length() == 0 && !((ProcessCompatibilityException)(serializable = new ProcessCompatibilityException())).alert()) {
            ProcessRuntimeException processRuntimeException = new ProcessRuntimeException(this);
            processRuntimeException.setInfo(1);
            throw processRuntimeException;
        }
        serializable = new File(string);
        if (((File)serializable).isAbsolute()) {
            return serializable;
        }
        serializable = new File(this.mainProgramDirectory, string);
        return serializable;
    }

    public void reset(URL uRL, String[] stringArray) {
        this.onRuntime = false;
        for (int i = 0; i < this.engineDriver.length; ++i) {
            this.engineDriver[i].processResetting(uRL, stringArray);
        }
    }

    public void exit_NODISPOSE() {
        this.onRuntime = false;
        if (this.rootProcessKernel != null) {
            for (int i = 0; i < this.rootProcessKernelRegistered; ++i) {
                this.rootProcessKernel[i].exit();
            }
        }
    }

    public void exit() {
        int n;
        this.onRuntime = false;
        if (this.rootProcessKernel != null) {
            for (n = 0; n < this.rootProcessKernelRegistered; ++n) {
                if (this.rootProcessKernel[n] == null) continue;
                this.rootProcessKernel[n].exit();
            }
        }
        if (this.programInstance != null) {
            n = this.programInstance.length;
            for (int i = 0; i < n; ++i) {
                if (this.programInstance[i] == null) continue;
                try {
                    this.programInstance[i].exitAllFunctions();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (this.engineDriver != null) {
            for (n = 0; n < this.engineDriver.length; ++n) {
                if (this.engineDriver[n] == null) continue;
                this.engineDriver[n].processNormallyEnded();
            }
        }
    }

    public void abnormallyExit() {
        int n;
        this.onRuntime = false;
        if (this.rootProcessKernel != null) {
            for (n = 0; n < this.rootProcessKernelRegistered; ++n) {
                if (this.rootProcessKernel[n] == null) continue;
                this.rootProcessKernel[n].exit();
            }
        }
        if (this.abnormallyExitMessageOut) {
            if (this.isOnRuntime()) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.error("\u5b9f\u884c\u4e2d\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u306f\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
                } else {
                    this.error("The running program has been crashed.");
                }
            } else if (ScriptProcessor.locale.isJapanese()) {
                this.error("\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u69cb\u6587\u89e3\u6790/\u521d\u671f\u5316\u51e6\u7406\u306f\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            } else {
                this.error("The persing/initialization of the program has been crashed.");
            }
        }
        if (this.engineDriver != null) {
            for (n = 0; n < this.engineDriver.length; ++n) {
                if (this.engineDriver[n] == null) continue;
                this.engineDriver[n].processAbnormallyEnded();
            }
        }
        this.abnormallyExitMessageOut = false;
        this.disposeResource(true);
    }

    public void setMainArgument(String[] stringArray) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = stringArray.length;
        this.mainArgumentUnit = new ProcessUnit[1];
        this.mainArgumentUnit[0] = new StringArrayUnit(nArray, this);
        for (int i = 0; i < stringArray.length; ++i) {
            nArray2[0] = i;
            this.mainArgumentUnit[0].setIndex(nArray2);
            this.mainArgumentUnit[0].setStringValue(stringArray[i]);
        }
    }

    public void addRootProcessKernel(ScopeCallKernel scopeCallKernel) {
        int n;
        int n2;
        if (this.rootProcessKernel == null) {
            this.rootProcessKernel = new ScopeCallKernel[this.rootProcessKernelInitialCapacity];
        }
        if ((n2 = this.rootProcessKernelRegistered) < (n = this.rootProcessKernel.length)) {
            this.rootProcessKernel[n2] = scopeCallKernel;
        } else {
            int n3;
            ScopeCallKernel[] scopeCallKernelArray = new ScopeCallKernel[n];
            for (n3 = 0; n3 < n; ++n3) {
                scopeCallKernelArray[n3] = this.rootProcessKernel[n3];
            }
            this.rootProcessKernel = new ScopeCallKernel[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.rootProcessKernel[n3] = scopeCallKernelArray[n3];
            }
            scopeCallKernelArray = null;
            this.rootProcessKernel[n2] = scopeCallKernel;
        }
        ++this.rootProcessKernelRegistered;
    }

    public void addProgram(ProcessProgram processProgram) {
        int n;
        int n2;
        if (this.programInstance == null) {
            this.programInstance = new ProcessProgram[this.programInstanceInitialCapacity];
        }
        if ((n2 = this.programInstanceRegistered) < (n = this.programInstance.length)) {
            this.programInstance[n2] = processProgram;
        } else {
            int n3;
            ProcessProgram[] processProgramArray = new ProcessProgram[n];
            for (n3 = 0; n3 < n; ++n3) {
                processProgramArray[n3] = this.programInstance[n3];
            }
            this.programInstance = new ProcessProgram[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.programInstance[n3] = processProgramArray[n3];
            }
            processProgramArray = null;
            this.programInstance[n2] = processProgram;
        }
        ++this.programInstanceRegistered;
    }

    public ProcessProgram[] getAllProgram() {
        return this.programInstance;
    }

    public boolean isImported(String string) {
        for (int i = 0; i < this.programInstance.length; ++i) {
            if (this.programInstance[i] == null || !this.programInstance[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public int addVariable(ProcessUnit processUnit) {
        int n;
        int n2;
        if (this.variable == null) {
            this.variable = new ProcessUnit[this.variableInitialCapacity];
        }
        if ((n2 = this.variableRegistered) < (n = this.variable.length)) {
            this.variable[n2] = processUnit;
        } else {
            int n3;
            ProcessUnit[] processUnitArray = new ProcessUnit[n];
            for (n3 = 0; n3 < n; ++n3) {
                processUnitArray[n3] = this.variable[n3];
            }
            this.variable = new ProcessUnit[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.variable[n3] = processUnitArray[n3];
            }
            processUnitArray = null;
            this.variable[n2] = processUnit;
        }
        ++this.variableRegistered;
        return n2;
    }

    public int addStruct(ProcessStruct processStruct) {
        int n;
        int n2;
        if (this.struct == null) {
            this.struct = new ProcessStruct[this.structInitialCapacity];
        }
        if ((n2 = this.structRegistered) < (n = this.struct.length)) {
            this.struct[n2] = processStruct;
        } else {
            int n3;
            ProcessStruct[] processStructArray = new ProcessStruct[n];
            for (n3 = 0; n3 < n; ++n3) {
                processStructArray[n3] = this.struct[n3];
            }
            this.struct = new ProcessStruct[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.struct[n3] = processStructArray[n3];
            }
            processStructArray = null;
            this.struct[n2] = processStruct;
        }
        ++this.structRegistered;
        return n2;
    }

    public ProcessUnit[] getVariableList() {
        return this.variable;
    }

    public ProcessStruct[] getStructList() {
        return this.struct;
    }

    public ProcessStruct getStructByType(String string) {
        int n = this.struct.length;
        for (int i = 0; i < n; ++i) {
            if (this.struct[i] == null || !this.struct[i].getType().equals(string)) continue;
            return this.struct[i];
        }
        return null;
    }

    public ProcessProgram[] getProgarmList() {
        return this.programInstance;
    }

    public ProcessKernel[] getFunctionList() {
        return this.processKernel;
    }

    public void importProgram() {
        for (int i = 0; i < this.programInstance.length; ++i) {
            if (this.programInstance[i] == null || this.error) continue;
            this.programInstance[i].importProgram();
        }
    }

    public void initClass() {
        if (this.error) {
            this.showErrorMessage(this.errorMessage);
        } else if (this.struct == null) {
            this.struct = new ProcessStruct[0];
        } else {
            for (int i = 0; i < this.struct.length; ++i) {
                if (this.struct[i] == null) continue;
                this.struct[i].ready();
            }
        }
    }

    public void initClassMemberVariable() {
        if (this.error) {
            this.showErrorMessage(this.errorMessage);
        } else if (this.struct != null) {
            for (int i = 0; i < this.struct.length; ++i) {
                if (this.struct[i] == null) continue;
                this.struct[i].initMemberVariable();
            }
        }
    }

    public void defineClass() {
        if (this.error) {
            this.showErrorMessage(this.errorMessage);
        } else {
            for (int i = 0; i < this.programInstance.length; ++i) {
                if (this.programInstance[i] == null || this.error) continue;
                ProcessCodeConstructor processCodeConstructor = new ProcessCodeConstructor(this);
                processCodeConstructor.defineClass(this.programInstance[i]);
            }
        }
    }

    public void initProgram() {
        if (this.error) {
            this.showErrorMessage(this.errorMessage);
        } else {
            for (int i = 0; i < this.programInstance.length; ++i) {
                if (this.programInstance[i] == null || this.error) continue;
                ProcessCodeConstructor processCodeConstructor = new ProcessCodeConstructor(this);
                processCodeConstructor.construct(this.programInstance[i]);
                processCodeConstructor = null;
            }
        }
    }

    public void compile() {
        this.onRuntime = false;
        this.importProgram();
        this.defineClass();
        this.initClass();
        this.initProgram();
    }

    public void ready() {
        if (!this.error) {
            try {
                this.resetWarning();
                this.compile();
                for (int i = 0; i < this.programInstance.length; ++i) {
                    if (this.programInstance[i] == null || this.error) continue;
                    this.programInstance[i].ready();
                }
                if (this.error) {
                    // empty if block
                }
                this.start();
            }
            catch (Exception exception) {
                this.showErrorText(exception);
            }
        }
    }

    public void process_DIRECT() {
        this.abnormallyExitMessageOut = true;
        this.showErrorTextMessageOut = true;
        this.onRuntime = true;
        if (this.programInstance != null) {
            for (int i = 0; i < this.programInstance.length; ++i) {
                if (this.programInstance[i] == null) continue;
                this.programInstance[i].process();
            }
        }
    }

    public void breakAll() {
    }

    public void start() {
    }

    public void showErrorText(Exception exception) {
        if (!this.showErrorTextMessageOut) {
            return;
        }
        String string = "";
        if (ScriptProcessor.locale.isJapanese()) {
            string = string + "\u30b9\u30af\u30ea\u30d7\u30c8\u30a8\u30f3\u30b8\u30f3\u5185\u90e8\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + System.getProperty("line.separator");
            string = string + "\uff08\u8907\u96d1\u306a\u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u89e3\u91c8\u306b\u5931\u6557\u3057\u305f\u5834\u5408\u306a\u3069\u306b\u751f\u3058\u308b\u4e8b\u304c\u3042\u308a\u307e\u3059\u3002\uff09" + System.getProperty("line.separator");
            string = string + "--------------------------------------------------" + System.getProperty("line.separator");
            string = string + "\u30a8\u30e9\u30fc\u5185\u5bb9\uff08\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\uff09\uff1a" + System.getProperty("line.separator");
        } else {
            string = string + "An error occurred in the processing of the script engine." + System.getProperty("line.separator");
            string = string + "(This may be occurs when it failed to parse a complicated program.)" + System.getProperty("line.separator");
            string = string + "--------------------------------------------------" + System.getProperty("line.separator");
            string = string + "Details (stack-trace):" + System.getProperty("line.separator");
        }
        System.out.println(string);
        StringWriter stringWriter = null;
        Object var4_4 = null;
        stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        String string2 = stringWriter.toString();
        string = string + string2;
        this.showErrorText(string);
        this.abnormallyExit();
        this.showErrorTextMessageOut = false;
    }

    public void initConst() {
        if (this.programInstance != null) {
            for (int i = 0; this.programInstance != null && i < this.programInstance.length; ++i) {
                if (this.programInstance == null || this.programInstance[i] == null) continue;
                this.programInstance[i].initConst();
            }
        }
    }

    public void process(String[] stringArray) {
        this.abnormallyExitMessageOut = true;
        this.showErrorTextMessageOut = true;
        this.runtimeErrorLock = false;
        this.errorCounter = 0;
        this.errorWaitFor = false;
        this.stackTraceBuffer = "";
        try {
            this.startTime = System.currentTimeMillis();
            this.setMainArgument(stringArray);
            this.initProcessConnectionInterface();
            this.onRuntime = true;
            this.initConst();
            this.initClassMemberVariable();
            if (this.programInstance != null) {
                for (int i = 0; this.programInstance != null && i < this.programInstance.length; ++i) {
                    if (this.programInstance == null || this.programInstance[i] == null) continue;
                    this.programInstance[i].process();
                    if (this.programInstance != null && this.programInstance[i] == null) continue;
                }
            }
            if (this.programInstance != null) {
                this.programInstance[this.programInstanceRegistered - 1].callMain(this.mainArgumentUnit);
            }
        }
        catch (ProcessRuntimeException processRuntimeException) {
            this.onRuntime = false;
            if (this.errorWaitFor) {
                this.errorWaitFor = false;
                if (processRuntimeException.hasInfo() && (this.errorMessageBuffer == null || this.errorMessageBuffer.length() == 0)) {
                    this.showErrorMessage(processRuntimeException.getInfoMessage());
                } else {
                    this.showErrorMessage(this.errorMessageBuffer);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = "";
            String string2 = System.getProperty("line.separator");
            string = ScriptProcessor.locale.isJapanese() ? string + "\u30e1\u30e2\u30ea\u30fc\u4f7f\u7528\u91cf\u304c\u8a2d\u5b9a\u5024\u3092\u8d85\u904e\u3057\u305f\u305f\u3081\u3001\u51e6\u7406\u3092\u5b8c\u4e86\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + string2 + "\u7533\u3057\u8a33\u3042\u308a\u307e\u305b\u3093\u304c\u3001\u3053\u306e\u51e6\u7406\u306f\u5f37\u5236\u7d42\u4e86\u3055\u308c\u307e\u3059\u3002" + string2 : string + "The memory usage exceeds the configured upper limit." + string2 + "This process will be terminated immediately." + string2;
            this.showErrorMessage(string);
            System.exit(0);
            this.processRequest = false;
            outOfMemoryError.printStackTrace();
            this.format(true);
            this.disposeResource();
        }
        catch (Exception exception) {
            this.showErrorText(exception);
            exception.printStackTrace();
        }
    }

    public void sleep(int n) {
        if (this.thread != null) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void sleep(int n, int n2) {
        if (this.thread != null) {
            try {
                Thread.sleep(n, n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ProcessKernel[] getRootProcessKernel() {
        return this.rootProcessKernel;
    }

    public int countScope() {
        ++this.scopeCounter;
        return this.scopeCounter;
    }

    public int countKernel() {
        ++this.kernelCounter;
        return this.kernelCounter;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public int getProcessMode() {
        return this.processMode;
    }

    public void setProcessMode(int n) {
        this.processMode = n;
    }

    public int getProcessDigit() {
        try {
            return ((MathContext)this.mathContext).getPrecision();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return 0;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return 0;
        }
    }

    public void format() {
        this.format(false);
    }

    public void format(boolean bl) {
        int n;
        this.errorLock = false;
        this.errorIndex = 0;
        this.counter = 0;
        this.scopeCounter = 0;
        this.kernelCounter = 0;
        if (!bl) {
            this.formatProcessEngineDriveInterface();
        }
        this.disposeProcessConnectionInterface();
        if (this.processKernel != null) {
            for (n = 0; n < this.rootProcessKernelRegistered; ++n) {
                if (this.rootProcessKernel == null || this.rootProcessKernel[n] == null) continue;
                this.rootProcessKernel[n].disposeResource();
                this.rootProcessKernel[n] = null;
            }
            for (n = 0; n < this.processKernelRegistered; ++n) {
                if (this.processKernel == null || this.processKernel[n] == null) continue;
                this.processKernel[n].disposeResource();
                this.processKernel[n] = null;
            }
        }
        this.processKernelRegistered = 0;
        this.processKernel = new ProcessKernel[this.processKernelInitialCapacity];
        this.rootProcessKernel = null;
        if (this.programInstance != null) {
            try {
                for (n = 0; n < this.programInstance.length; ++n) {
                    if (this.programInstance[n] != null) {
                        this.programInstance[n].disposeResource();
                        this.programInstance[n] = null;
                    }
                    this.programInstance[n] = null;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.programInstanceRegistered = 0;
        this.programInstance = new ProcessProgram[this.programInstanceInitialCapacity];
        if (this.variable != null) {
            try {
                int n2 = this.variable.length;
                for (int i = 0; i < n2; ++i) {
                    if (this.variable[i] != null) {
                        this.variable[i].disposeResource();
                        this.variable[i] = null;
                    }
                    this.variable = null;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.variableRegistered = 0;
        this.variable = new ProcessUnit[this.variableInitialCapacity];
        if (!bl) {
            this.errorMessage = "";
            this.error = false;
        }
    }

    public String preTransform(String string) {
        return string;
    }

    public void showErrorText(String string) {
        if (this.errorTextFrame == null) {
            this.errorTextFrame = new JFrame();
            this.errorTextArea = new TextArea();
            this.errorTextFrame.setBounds(0, 0, 500, 300);
            this.errorTextFrame.getContentPane().add(this.errorTextArea);
            this.errorTextArea.setText(string);
            this.errorTextFrame.setVisible(true);
            this.errorTextArea.setVisible(true);
            System.out.println(string);
        } else if (!this.errorTextFrame.isVisible()) {
            this.errorTextArea.setText(string);
            this.errorTextFrame.setVisible(true);
            this.errorTextArea.setVisible(true);
            System.out.println(string);
        }
    }

    public void addProcessConnectionInterface(GeneralProcessConnectionInterface generalProcessConnectionInterface) {
        int n;
        if (this.connector == null) {
            this.connector = new GeneralProcessConnectionInterface[0];
        }
        int n2 = this.connector.length;
        for (int i = 0; i < n2; ++i) {
            if (this.connector[i] != generalProcessConnectionInterface) continue;
            return;
        }
        GeneralProcessConnectionInterface[] generalProcessConnectionInterfaceArray = new GeneralProcessConnectionInterface[n2];
        for (n = 0; n < n2; ++n) {
            generalProcessConnectionInterfaceArray[n] = this.connector[n];
        }
        this.connector = new GeneralProcessConnectionInterface[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.connector[n] = generalProcessConnectionInterfaceArray[n];
        }
        generalProcessConnectionInterfaceArray = null;
        this.connector[n2] = generalProcessConnectionInterface;
    }

    public void initProcessConnectionInterface() {
        if (this.connector != null) {
            for (int i = 0; i < this.connector.length; ++i) {
                try {
                    if (this.connector[i] == null) continue;
                    this.connector[i].init();
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void disposeProcessConnectionInterface() {
        if (this.connector != null) {
            for (int i = 0; i < this.connector.length; ++i) {
                try {
                    if (this.connector[i] != null) {
                        this.connector[i].dispose();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.connector[i] = null;
            }
        }
    }

    public void addProcessEngineDriveInterface(ProcessEngineDriveInterface processEngineDriveInterface) {
        int n;
        if (this.engineDriver == null) {
            this.engineDriver = new ProcessEngineDriveInterface[0];
        }
        int n2 = this.engineDriver.length;
        for (int i = 0; i < n2; ++i) {
            if (this.engineDriver[i] != processEngineDriveInterface) continue;
            return;
        }
        ProcessEngineDriveInterface[] processEngineDriveInterfaceArray = new ProcessEngineDriveInterface[n2];
        for (n = 0; n < n2; ++n) {
            processEngineDriveInterfaceArray[n] = this.engineDriver[n];
        }
        this.engineDriver = new ProcessEngineDriveInterface[n2 + 1];
        for (n = 0; n < n2; ++n) {
            this.engineDriver[n] = processEngineDriveInterfaceArray[n];
        }
        processEngineDriveInterfaceArray = null;
        this.engineDriver[n2] = processEngineDriveInterface;
    }

    public void formatProcessEngineDriveInterface() {
        if (this.engineDriver != null) {
            int n = this.engineDriver.length;
            for (int i = 0; i < n; ++i) {
                this.engineDriver[i] = null;
            }
        }
    }

    public GeneralProcessConnectionInterface getGeneralProcessConnectionInterface(String string) {
        for (int i = this.connector.length - 1; 0 <= i; --i) {
            try {
                if (this.connector[i] == null || !this.connector[i].isProcessable(string)) continue;
                return this.connector[i];
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isProcessable(String string) {
        if (string.equals("SYSTEM_PROCESS_SYSTEMCALL_stralloc")) {
            return true;
        }
        if (string.equals("SYSTEM_PROCESS_SYSTEMCALL_alloc")) {
            return true;
        }
        if (string.equals("SYSTEM_PROCESS_SYSTEMCALL_free")) {
            return true;
        }
        if (string.equals("___evaltr")) {
            return true;
        }
        if (string.equals("___evaluable")) {
            return true;
        }
        if (string.equals("___eval")) {
            return true;
        }
        if (string.equals("___feval") || string.equals("___ieval") || string.equals("___beval") || string.equals("___vfeval") || string.equals("___vieval") || string.equals("___seval") || string.equals("___ceval") || string.equals("___vceval")) {
            return true;
        }
        if (string.equals("___override")) {
            return true;
        }
        if (this.connector == null) {
            this.error = true;
            String string2 = "";
            if (ScriptProcessor.locale.isJapanese()) {
                string2 = string2 + "\u72b6\u614b\u306b\u30a8\u30e9\u30fc\u304c\u5b58\u5728\u3057\u307e\u3059\u3002" + System.getProperty("line.separator");
                string2 = string2 + System.getProperty("line.separator");
                string2 = string2 + "[ \u8a73\u7d30\u5185\u5bb9 ] \u5fc5\u9808\u306e\u6a5f\u80fd\u3092\u63d0\u4f9b\u3059\u308b\u30d7\u30e9\u30b0\u30a4\u30f3\u304c\u63a5\u7d9a\u3055\u308c\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u30c7\u30fc\u30bf\u306e\u5165\u51fa\u529b\u304c\u3067\u304d\u307e\u305b\u3093\u3002" + System.getProperty("line.separator");
            } else {
                string2 = string2 + "An error is detected for the state of this software." + System.getProperty("line.separator");
                string2 = string2 + System.getProperty("line.separator");
                string2 = string2 + "[ Details ] No plug-in which provides mandatory features is connected." + System.getProperty("line.separator");
            }
            this.error(string2);
            return false;
        }
        for (int i = this.connector.length - 1; 0 <= i; --i) {
            try {
                if (this.connector[i] == null || !this.connector[i].isProcessable(string)) continue;
                return true;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this.getFunctionCallKernel(string) != null;
    }

    public GeneralProcessConnectionInterface getLastGeneralProcessConnectionInterface() {
        return this.connector[this.lastConnectorIndex];
    }

    public void connect(String string) {
        Object object;
        Class clazz = null;
        try {
            clazz = ConnectionClassLoaderTerminal.getInstance().loadClassFromAbsolutePath(string);
        }
        catch (Exception exception) {
            object = null;
            Object var5_9 = null;
            object = new StringWriter();
            exception.printStackTrace(new PrintWriter((Writer)object));
            String string2 = ((StringWriter)object).toString();
        }
        if (clazz == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                String string3 = "\u30d7\u30e9\u30b0\u30a4\u30f3" + System.getProperty("line.separator") + "\u300c" + string + "\u300d" + System.getProperty("line.separator") + "\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u3053\u306e\u30b7\u30b9\u30c6\u30e0\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.showErrorMessage(string3);
            } else {
                String string4 = "The plug-in " + System.getProperty("line.separator") + "\"" + string + "\"" + System.getProperty("line.separator") + "does not exit, or is not available for this script engine.";
                this.showErrorMessage(string4);
            }
            return;
        }
        try {
            Object t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            object = new GeneralProcessConnectionInterfaceAdapter(clazz, t);
            ((GeneralProcessConnectionInterfaceAdapter)object).engine = this;
            this.addProcessConnectionInterface((GeneralProcessConnectionInterface)object);
        }
        catch (Exception exception) {
            if (ScriptProcessor.locale.isJapanese()) {
                object = "\u30d7\u30e9\u30b0\u30a4\u30f3" + System.getProperty("line.separator") + "\u300c" + string + "\u300d" + System.getProperty("line.separator") + "\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u3053\u306e\u30b7\u30b9\u30c6\u30e0\u306b\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093\u3002";
                this.showErrorMessage((String)object);
            } else {
                object = "The plug-in " + System.getProperty("line.separator") + "\"" + string + "\"" + System.getProperty("line.separator") + "does not exit, or is not available for this script engine.";
                this.showErrorMessage((String)object);
            }
            return;
        }
    }

    public void showErrorMessage(String string) {
        if (this.runtimeErrorLock) {
            return;
        }
        this.error = true;
        if (this.errorWaitFor) {
            this.errorMessageBuffer = string;
            return;
        }
        if (this.engineDriver != null) {
            this.errorEvent = new ProcessErrorEvent();
            this.errorEvent.setSource(this);
            if (!this.stackTraceBuffer.equals("")) {
                string = string + System.getProperty("line.separator");
                string = ScriptProcessor.locale.isJapanese() ? string + "[ \u95a2\u6570\u30b3\u30fc\u30eb\u5c65\u6b74\uff08\u539f\u56e0\u306b\u8fd1\u3044\u307b\u3069\u4e0a\u306b\u8868\u793a\uff09]" + System.getProperty("line.separator") : string + "[ TRACE OF FUNCTION CALLS (The top is the most recent call) ]" + System.getProperty("line.separator");
                string = string + System.getProperty("line.separator");
                string = string + this.stackTraceBuffer;
                string = string + System.getProperty("line.separator");
                string = string + System.getProperty("line.separator");
            }
            ++this.errorCounter;
            if (1 <= this.errorCounter && !this.runtimeErrorLock) {
                this.runtimeErrorLock = true;
            }
            string = string + System.getProperty("line.separator");
            System.out.println(string);
            this.errorEvent.setErrorMessage(string);
            for (int i = 0; i < this.engineDriver.length; ++i) {
                try {
                    this.engineDriver[i].processErrorDetected(this.errorEvent);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public String addProcessKernel(ProcessKernel processKernel) {
        if (this.processKernel == null) {
            this.processKernel = new ProcessKernel[0];
        }
        int n = this.processKernel.length;
        int n2 = this.processKernelRegistered;
        String string = "SYSTEM_PROCESS_KERNEL_K" + processKernel.getKernelNumber() + "S" + processKernel.getScopeNumber();
        processKernel.setKernelID(string);
        processKernel.setKernelName(string);
        if (n2 < n) {
            this.processKernel[n2] = processKernel;
        } else {
            int n3;
            ProcessKernel[] processKernelArray = new ProcessKernel[n];
            for (n3 = 0; n3 < n; ++n3) {
                processKernelArray[n3] = this.processKernel[n3];
            }
            this.processKernel = new ProcessKernel[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.processKernel[n3] = processKernelArray[n3];
            }
            processKernelArray = null;
            this.processKernel[n2] = processKernel;
        }
        ++this.counter;
        return string;
    }

    public int countFunction() {
        return this.processKernelRegistered;
    }

    public int countVariable() {
        return this.variableRegistered;
    }

    public void addFunctionProcessKernel(ProcessKernel[] processKernelArray) {
        for (int i = 0; i < processKernelArray.length; ++i) {
            this.addFunctionProcessKernel(processKernelArray[i]);
        }
    }

    public int addFunctionProcessKernel(ProcessKernel processKernel) {
        int n;
        int n2;
        if (this.processKernel == null) {
            this.processKernel = new ProcessKernel[this.processKernelInitialCapacity];
        }
        if ((n2 = this.processKernelRegistered) < (n = this.processKernel.length)) {
            this.processKernel[n2] = processKernel;
        } else {
            int n3;
            ProcessKernel[] processKernelArray = new ProcessKernel[n];
            for (n3 = 0; n3 < n; ++n3) {
                processKernelArray[n3] = this.processKernel[n3];
            }
            this.processKernel = new ProcessKernel[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.processKernel[n3] = processKernelArray[n3];
            }
            processKernelArray = null;
            this.processKernel[n2] = processKernel;
        }
        ++this.processKernelRegistered;
        return n2;
    }

    public void addLibraryProcessKernel(ProcessKernel processKernel) {
        int n;
        int n2;
        if (this.libraryKernel == null) {
            this.libraryKernel = new ProcessKernel[this.libraryKernelInitialCapacity];
        }
        if ((n2 = this.libraryKernelRegistered) < (n = this.libraryKernel.length)) {
            this.libraryKernel[n2] = processKernel;
        } else {
            int n3;
            ProcessKernel[] processKernelArray = new ProcessKernel[n];
            for (n3 = 0; n3 < n; ++n3) {
                processKernelArray[n3] = this.libraryKernel[n3];
            }
            this.libraryKernel = new ProcessKernel[n * 2];
            for (n3 = 0; n3 < n; ++n3) {
                this.libraryKernel[n3] = processKernelArray[n3];
            }
            processKernelArray = null;
            this.libraryKernel[n2] = processKernel;
        }
        ++this.libraryKernelRegistered;
    }

    public FunctionCallKernel getFunctionCallKernel(String string) {
        FunctionCallKernel functionCallKernel = null;
        try {
            int n;
            if (this.processKernel != null) {
                for (n = this.processKernelRegistered - 1; 0 <= n; --n) {
                    if (this.processKernel[n] == null || this.processKernel[n].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.processKernel[n]).getFunctionName().equals(string) || this.processKernel[n].accessPermission != ProcessKernel.PUBLIC) continue;
                    functionCallKernel = (FunctionCallKernel)this.processKernel[n];
                    functionCallKernel.use();
                    return functionCallKernel;
                }
            }
            if (this.internalIibraryAccessPermission && this.libraryKernel != null) {
                for (n = this.libraryKernelRegistered - 1; 0 <= n; --n) {
                    if (this.libraryKernel[n] == null || this.libraryKernel[n].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.libraryKernel[n]).getFunctionName().equals(string) || this.processKernel[n].accessPermission != ProcessKernel.PUBLIC) continue;
                    functionCallKernel = (FunctionCallKernel)this.libraryKernel[n];
                    functionCallKernel.use();
                    return functionCallKernel;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return functionCallKernel;
    }

    public FunctionCallKernel getFunctionCallKernel(String string, ProcessUnit[] processUnitArray) {
        FunctionCallKernel functionCallKernel = null;
        try {
            int n;
            if (this.processKernel != null) {
                for (n = this.processKernelRegistered - 1; 0 <= n; --n) {
                    if (this.processKernel[n] == null || this.processKernel[n].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.processKernel[n]).getFunctionName().equals(string) || !((FunctionCallKernel)this.processKernel[n]).isProcessableArgument(processUnitArray) || this.processKernel[n].accessPermission != ProcessKernel.PUBLIC) continue;
                    functionCallKernel = (FunctionCallKernel)this.processKernel[n];
                    functionCallKernel.use();
                    return functionCallKernel;
                }
            }
            if (this.internalIibraryAccessPermission && this.libraryKernel != null) {
                for (n = this.libraryKernelRegistered - 1; 0 <= n; --n) {
                    if (this.libraryKernel[n] == null || this.libraryKernel[n].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.libraryKernel[n]).getFunctionName().equals(string) || !((FunctionCallKernel)this.libraryKernel[n]).isProcessableArgument(processUnitArray) || this.processKernel[n].accessPermission != ProcessKernel.PUBLIC) continue;
                    functionCallKernel = (FunctionCallKernel)this.libraryKernel[n];
                    functionCallKernel.use();
                    return functionCallKernel;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return functionCallKernel;
    }

    public FunctionCallKernel[] getAllFunctionCallKernel(String string) {
        int n = 0;
        try {
            int n2;
            if (this.processKernel != null) {
                for (n2 = 0; n2 < this.processKernelRegistered; ++n2) {
                    if (this.processKernel[n2] == null || this.processKernel[n2].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n2].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.processKernel[n2]).getFunctionName().equals(string) || this.processKernel[n2].accessPermission != ProcessKernel.PUBLIC) continue;
                    ++n;
                }
            }
            if (this.internalIibraryAccessPermission && this.libraryKernel != null) {
                for (n2 = 0; n2 < this.processKernelRegistered; ++n2) {
                    if (this.libraryKernel[n2] == null || this.libraryKernel[n2].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n2].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.libraryKernel[n2]).getFunctionName().equals(string) || this.processKernel[n2].accessPermission != ProcessKernel.PUBLIC) continue;
                    ++n;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        FunctionCallKernel[] functionCallKernelArray = new FunctionCallKernel[n];
        int n3 = 0;
        try {
            int n4;
            if (this.processKernel != null) {
                for (n4 = 0; n4 < this.processKernelRegistered; ++n4) {
                    if (this.processKernel[n4] == null || this.processKernel[n4].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n4].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.processKernel[n4]).getFunctionName().equals(string) || this.processKernel[n4].accessPermission != ProcessKernel.PUBLIC) continue;
                    functionCallKernelArray[n3] = (FunctionCallKernel)this.processKernel[n4];
                    functionCallKernelArray[n3].use();
                    ++n3;
                }
            }
            if (this.internalIibraryAccessPermission && this.libraryKernel != null) {
                for (n4 = 0; n4 < this.processKernelRegistered; ++n4) {
                    if (this.libraryKernel[n4] == null || this.libraryKernel[n4].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n4].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.libraryKernel[n4]).getFunctionName().equals(string) || this.processKernel[n4].accessPermission != ProcessKernel.PUBLIC) continue;
                    functionCallKernelArray[n3] = (FunctionCallKernel)this.libraryKernel[n4];
                    functionCallKernelArray[n3].use();
                    ++n3;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return functionCallKernelArray;
    }

    public FunctionCallKernel[] getAllFunctionCallKernel(String string, ProcessUnit[] processUnitArray) {
        int n = 0;
        try {
            int n2;
            if (this.processKernel != null) {
                for (n2 = 0; n2 < this.processKernelRegistered; ++n2) {
                    if (this.processKernel[n2] == null || this.processKernel[n2].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n2].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.processKernel[n2]).getFunctionName().equals(string) || !((FunctionCallKernel)this.processKernel[n2]).isProcessableArgument(processUnitArray) || this.processKernel[n2].accessPermission != ProcessKernel.PUBLIC) continue;
                    ++n;
                }
            }
            if (this.internalIibraryAccessPermission && this.libraryKernel != null) {
                for (n2 = 0; n2 < this.processKernelRegistered; ++n2) {
                    if (this.libraryKernel[n2] == null || this.libraryKernel[n2].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n2].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.libraryKernel[n2]).getFunctionName().equals(string) || !((FunctionCallKernel)this.processKernel[n2]).isProcessableArgument(processUnitArray) || this.processKernel[n2].accessPermission != ProcessKernel.PUBLIC) continue;
                    ++n;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        FunctionCallKernel[] functionCallKernelArray = new FunctionCallKernel[n];
        int n3 = 0;
        try {
            int n4;
            if (this.processKernel != null) {
                for (n4 = 0; n4 < this.processKernelRegistered; ++n4) {
                    if (this.processKernel[n4] == null || this.processKernel[n4].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n4].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.processKernel[n4]).getFunctionName().equals(string) || !((FunctionCallKernel)this.processKernel[n4]).isProcessableArgument(processUnitArray) || this.processKernel[n4].accessPermission != ProcessKernel.PUBLIC) continue;
                    functionCallKernelArray[n3] = (FunctionCallKernel)this.processKernel[n4];
                    functionCallKernelArray[n3].use();
                    ++n3;
                }
            }
            if (this.internalIibraryAccessPermission && this.libraryKernel != null) {
                for (n4 = 0; n4 < this.processKernelRegistered; ++n4) {
                    if (this.libraryKernel[n4] == null || this.libraryKernel[n4].getKernelType() != ProcessKernel.FUNCTION_CALL_TYPE && this.processKernel[n4].getKernelType() != ProcessKernel.FUNCTION_MACRO_TYPE || !((FunctionCallKernel)this.libraryKernel[n4]).getFunctionName().equals(string) || !((FunctionCallKernel)this.processKernel[n4]).isProcessableArgument(processUnitArray) || this.processKernel[n4].accessPermission != ProcessKernel.PUBLIC) continue;
                    functionCallKernelArray[n3] = (FunctionCallKernel)this.libraryKernel[n4];
                    functionCallKernelArray[n3].use();
                    ++n3;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return functionCallKernelArray;
    }

    public ProcessKernel getProcessKernel(String string) {
        String string2;
        int n;
        if (this.processKernel != null) {
            for (n = 0; n < this.processKernelRegistered; ++n) {
                string2 = this.processKernel[n].getKernelID();
                string2 = string2.replaceAll(" ", "");
                if (!(string2 = string2.replaceAll("\t", "")).equals(string)) continue;
                return this.processKernel[n];
            }
        }
        if (this.internalIibraryAccessPermission && this.libraryKernel != null) {
            for (n = 0; n < this.libraryKernelRegistered; ++n) {
                string2 = this.libraryKernel[n].getKernelID();
                string2 = string2.replaceAll(" ", "");
                if (!(string2 = string2.replaceAll("\t", "")).equals(string)) continue;
                return this.libraryKernel[n];
            }
        }
        return null;
    }

    public ScopeCallKernel getScopeCallKernel(String string) {
        String string2;
        int n;
        if (this.processKernel != null) {
            for (n = 0; n < this.processKernelRegistered; ++n) {
                string2 = this.processKernel[n].getKernelID();
                string2 = string2.replaceAll(" ", "");
                if (!(string2 = string2.replaceAll("\t", "")).equals(string)) continue;
                return (ScopeCallKernel)this.processKernel[n];
            }
        }
        if (this.internalIibraryAccessPermission && this.libraryKernel != null) {
            for (n = 0; n < this.libraryKernelRegistered; ++n) {
                string2 = this.libraryKernel[n].getKernelID();
                string2 = string2.replaceAll(" ", "");
                if (!(string2 = string2.replaceAll("\t", "")).equals(string)) continue;
                return (ScopeCallKernel)this.libraryKernel[n];
            }
        }
        return null;
    }

    static {
        if (sysClassPath.endsWith(".jar")) {
            if (sysClassPath.contains(System.getProperty("file.separator"))) {
                String string = sysClassPath.substring(0, sysClassPath.lastIndexOf(System.getProperty("file.separator")));
                jarLocationDir = new File(string);
            } else {
                jarLocationDir = new File(".");
            }
        }
        NAME_FILTER = true;
        XOR_OPERATOR_FILTER = true;
        VARFLOAT_STATEMENT_FILTER = true;
        varfloatStatementFilterWarning = true;
        compatibilityMode = false;
        BINARY64 = 1064;
        DECIMAL = 1010;
    }
}

