/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.decode;

import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessProgram;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.decode.ProcessCodeFunctionModeler;
import rxvesapi.process.decode.ProcessCodeScopeConstructor;
import rxvesapi.process.decode.ProcessCodeScopeForm;
import rxvesapi.process.kernel.FunctionCallKernel;
import rxvesapi.process.kernel.ProcessKernel;
import rxvesapi.process.kernel.ScopeCallKernel;
import rxvesapi.process.object.ProcessStruct;
import rxvesapi.process.unit.ProcessUnit;

public class ProcessCodeConstructor {
    public ProcessEngine engine;
    public boolean error;

    public ProcessCodeConstructor(ProcessEngine processEngine) {
        this.engine = processEngine;
    }

    public void disposeResource() {
        this.engine = null;
    }

    public boolean hasError() {
        return this.error;
    }

    public void defineClass(ProcessProgram processProgram) {
        String string = processProgram.CODE;
        String string2 = processProgram.getName();
        ProcessCodeFunctionModeler processCodeFunctionModeler = new ProcessCodeFunctionModeler();
        ProcessCodeScopeForm[] processCodeScopeFormArray = processCodeFunctionModeler.getForm(string);
        if (processCodeScopeFormArray == null) {
            if (ScriptProcessor.locale.isJapanese()) {
                this.engine.error("\u95a2\u6570\u3084\u30d6\u30ed\u30c3\u30af\u30b9\u30b3\u30fc\u30d7\u3092\u6b63\u5e38\u306b\u89e3\u91c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u300c { \u300d \u3068 \u300c } \u300d \u306e\u6570\u3084\u5bfe\u5fdc\u95a2\u4fc2\u304c\u6b63\u3057\u304f\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
            } else {
                this.engine.error("Cannot interpret a function or a block-scope. Probably the correspondence between \"{\" and \"}\" is broken.");
            }
            return;
        }
        if (this.engine.error) {
            return;
        }
        for (int i = 1; i < processCodeScopeFormArray.length; ++i) {
            if (!processCodeScopeFormArray[i].getType().equals("struct")) continue;
            ProcessStruct processStruct = new ProcessStruct(processCodeScopeFormArray[i], processProgram, this.engine);
            if (processCodeScopeFormArray[i].getAccessPermission() != null) {
                processStruct.setAccessPermission(processCodeScopeFormArray[i].getAccessPermission());
            }
            processProgram.addStruct(processStruct);
            this.engine.addStruct(processStruct);
        }
    }

    public static int getLHSEndIndex(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '[') {
                ++n2;
            } else if (cArray[i] == ']') {
                --n2;
            }
            if (n2 != 0 || cArray[i] != '=') continue;
            return i - 1;
        }
        return n;
    }

    public void construct(ProcessProgram processProgram) {
        ProcessUnit processUnit;
        int n;
        int n2;
        String string = processProgram.CODE;
        String string2 = processProgram.getName();
        processProgram.FUNCTION_ACCESSABLE_INDEX = this.engine.countFunction();
        processProgram.VARIABLE_ACCESSABLE_INDEX = this.engine.countVariable();
        ProcessCodeFunctionModeler processCodeFunctionModeler = new ProcessCodeFunctionModeler();
        ProcessCodeScopeForm[] processCodeScopeFormArray = processCodeFunctionModeler.getForm(string);
        if (this.engine.error) {
            return;
        }
        ProcessCodeScopeConstructor processCodeScopeConstructor = new ProcessCodeScopeConstructor(this.engine, processProgram);
        ScopeCallKernel scopeCallKernel = processCodeScopeConstructor.constructScope(processCodeScopeFormArray[0]);
        if (this.engine.error) {
            return;
        }
        processProgram.KERNEL = scopeCallKernel;
        this.engine.addRootProcessKernel(scopeCallKernel);
        String string3 = ";";
        for (n2 = 1; n2 < processCodeScopeFormArray.length; ++n2) {
            String string4 = processCodeScopeFormArray[n2].type;
            for (int i = 0; i < processCodeScopeFormArray[n2].dimension; ++i) {
                string4 = string4 + "[]";
            }
            string4 = string4 + " ";
            string4 = string4 + processCodeScopeFormArray[n2].name;
            string4 = string4 + "( ";
            string4 = string4 + processCodeScopeFormArray[n2].argument;
            string4 = string4 + " )";
            if (processCodeScopeFormArray[n2].getType().equals("struct")) continue;
            FunctionCallKernel functionCallKernel = processCodeScopeConstructor.constructFunction(processCodeScopeFormArray[n2]);
            if (functionCallKernel == null) {
                return;
            }
            functionCallKernel.fileName = string2;
            if (this.engine.error) {
                return;
            }
            functionCallKernel.form = processCodeScopeFormArray[n2];
            if (processProgram != null) {
                functionCallKernel.setProgram(processProgram);
                processProgram.addFunction(functionCallKernel);
            }
            string3 = string3 + processCodeScopeFormArray[n2].name + ";";
            if (this.engine == null) continue;
            processProgram.FUNCTION_ACCESSABLE_INDEX = this.engine.addFunctionProcessKernel(functionCallKernel);
        }
        processCodeScopeConstructor.disposeResource();
        processCodeFunctionModeler = null;
        n2 = scopeCallKernel.getProcessScope().processKernel.length;
        String string5 = ";";
        for (n = 0; n < n2; ++n) {
            ProcessKernel processKernel = scopeCallKernel.getProcessScope().processKernel[n];
            if (processKernel.getKernelType() != ProcessKernel.VARIABLE_TYPE) continue;
            processKernel.setFieldDefine(true);
            processUnit = processKernel.getVariableProcessUnit();
            string5 = string5 + processUnit.getName() + ";";
            processProgram.addVariable(processUnit);
            processProgram.VARIABLE_ACCESSABLE_INDEX = this.engine.addVariable(processUnit);
        }
        for (n = 0; n < n2; ++n) {
            ProcessUnit processUnit2;
            ProcessKernel processKernel = scopeCallKernel.getProcessScope().processKernel[n];
            if (processKernel.getKernelType() != ProcessKernel.VARIABLE_TYPE || (processUnit = processKernel.getVariableProcessUnit()) == (processUnit2 = processProgram.getVariable(processUnit.getName()))) continue;
            processKernel.setVariableProcessUnit(processUnit2);
            boolean bl = true;
            if (processUnit.getValueType() == processUnit2.getValueType()) {
                if (processUnit.isArrayType() != processUnit2.isArrayType()) {
                    bl = false;
                }
                if (processUnit.getValueType() == 200 && processUnit.getStruct() != processUnit2.getStruct()) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) continue;
            String string6 = ScriptProcessor.locale.isJapanese() ? "\u30b0\u30ed\u30fc\u30d0\u30eb\u5909\u6570\u300c " + processProgram.getName() + "." + processUnit.name + " \u300d\u304c\u3001\u7570\u306a\u308b\u578b\u3067\u91cd\u8907\u5ba3\u8a00\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u5ba3\u8a00\u3092\u4e0a\u66f8\u304d\u3059\u308b\u306b\u306f\u3001\u540c\u3058\u578b\u306b\u63c3\u3048\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" : "There are duplicate declarations of the global variable \"" + processProgram.getName() + "." + processUnit.name + "\" with different data-types. To overwrite the declaration of a global variable, must re-declare with the same data-type.";
            for (int i = 0; i < n2; ++i) {
                processKernel = scopeCallKernel.getProcessScope().processKernel[i];
                if (processKernel.getKernelType() != ProcessKernel.VARIABLE_TYPE || !processKernel.getVariableProcessUnit().getName().equals(processUnit2.getName())) continue;
                processKernel.error(string6);
            }
            return;
        }
    }
}

