/*
 * Decompiled with CFR 0.152.
 */
package rxvesapi.process.driver;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import rxvesapi.io.CSVVertexReader;
import rxvesapi.io.CSVVertexWriter;
import rxvesapi.io.TSVVertexReader;
import rxvesapi.io.TSVVertexWriter;
import rxvesapi.process.ProcessCompatibilityException;
import rxvesapi.process.ProcessEngine;
import rxvesapi.process.ProcessSyntaxException;
import rxvesapi.process.ScriptProcessor;
import rxvesapi.process.connection.GeneralProcessConnectionInterface;
import rxvesapi.process.io.FileIOEngine;
import rxvesapi.process.io.FileOutputEngine;
import rxvesapi.process.io.function.Function_append;
import rxvesapi.process.io.function.Function_countln;
import rxvesapi.process.io.function.Function_lf;
import rxvesapi.process.io.function.Function_loadI;
import rxvesapi.process.io.function.Function_loadS;
import rxvesapi.process.io.function.Function_loadVOID;
import rxvesapi.process.io.function.Function_loadlnI;
import rxvesapi.process.io.function.Function_openSS;
import rxvesapi.process.io.function.Function_openSSS;
import rxvesapi.process.io.function.Function_opencsvrIS;
import rxvesapi.process.io.function.Function_opencsvrISS;
import rxvesapi.process.io.function.Function_opencsvrS;
import rxvesapi.process.io.function.Function_opencsvrSS;
import rxvesapi.process.io.function.Function_opencsvwIS;
import rxvesapi.process.io.function.Function_opencsvwISS;
import rxvesapi.process.io.function.Function_opencsvwS;
import rxvesapi.process.io.function.Function_opencsvwSS;
import rxvesapi.process.io.function.Function_openrIS;
import rxvesapi.process.io.function.Function_openrISS;
import rxvesapi.process.io.function.Function_openrS;
import rxvesapi.process.io.function.Function_openrSS;
import rxvesapi.process.io.function.Function_openwIS;
import rxvesapi.process.io.function.Function_openwISS;
import rxvesapi.process.io.function.Function_openwS;
import rxvesapi.process.io.function.Function_openwSS;
import rxvesapi.process.io.function.Function_write;
import rxvesapi.process.kernel.FunctionCallKernel;

public class FileIOProcessDriver
implements GeneralProcessConnectionInterface {
    public ProcessEngine engine;
    public boolean deresolvesNetworkDrivePath = true;
    public TSVVertexWriter[] writer;
    public TSVVertexReader[] reader;
    public StringBuffer[] buffer;
    public CSVVertexWriter[] writerCSV;
    public CSVVertexReader[] readerCSV;
    public FileIOEngine[] ioEngine;
    public int[] mode;
    public String[][] tokenBuffer;
    public int[] tokenIndex;
    public static int NULL_FILE = -1;
    public static int IO2G_TEXT_WITHOUT_TOKEN_WRITE = 2000;
    public static int IO2G_TEXT_WITHOUT_TOKEN_READ = 2001;
    public static int IO2G_TEXT_TOKEN_WRITE = 2100;
    public static int IO2G_TEXT_TOKEN_READ = 2101;
    public static int IO2G_BINARY_WRITE = 2200;
    public static int IO2G_BINARY_READ = 2201;
    public static int IO2G_TEXT_TSV_WRITE = 2300;
    public static int IO2G_TEXT_TSV_READ = 2301;
    public static int IO2G_TEXT_CSV_WRITE = 2400;
    public static int IO2G_TEXT_CSV_READ = 2401;
    public static int WRITE_FILE = 100;
    public static int READ_FILE = 101;
    public static int WRITE_CSV_FILE = 200;
    public static int READ_CSV_FILE = 201;
    public static int BUFFER_FILE = 102;
    public static int BUFFER_CSV_FILE = 202;
    public String lfc = System.getProperty("line.separator");
    public String LFC = System.getProperty("line.separator");
    public FunctionCallKernel[] kernel;

    public FileIOProcessDriver() {
        this.createKernel();
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
        this.disposeResource();
    }

    public FunctionCallKernel[] getKernel() {
        return this.kernel;
    }

    public void createKernel() {
        int n = 26;
        int n2 = 0;
        this.kernel = new FunctionCallKernel[n];
        this.kernel[n2] = new Function_write(this);
        this.kernel[++n2] = new Function_append(this);
        this.kernel[++n2] = new Function_openwISS(this);
        this.kernel[++n2] = new Function_openwIS(this);
        this.kernel[++n2] = new Function_openwSS(this);
        this.kernel[++n2] = new Function_openwS(this);
        this.kernel[++n2] = new Function_openrISS(this);
        this.kernel[++n2] = new Function_openrIS(this);
        this.kernel[++n2] = new Function_openrSS(this);
        this.kernel[++n2] = new Function_openrS(this);
        this.kernel[++n2] = new Function_opencsvwISS(this);
        this.kernel[++n2] = new Function_opencsvwIS(this);
        this.kernel[++n2] = new Function_opencsvwSS(this);
        this.kernel[++n2] = new Function_opencsvwS(this);
        this.kernel[++n2] = new Function_opencsvrISS(this);
        this.kernel[++n2] = new Function_opencsvrIS(this);
        this.kernel[++n2] = new Function_opencsvrSS(this);
        this.kernel[++n2] = new Function_opencsvrS(this);
        this.kernel[++n2] = new Function_loadI(this);
        this.kernel[++n2] = new Function_loadS(this);
        this.kernel[++n2] = new Function_loadVOID(this);
        this.kernel[++n2] = new Function_loadlnI(this);
        this.kernel[++n2] = new Function_lf(this);
        this.kernel[++n2] = new Function_countln(this);
        this.kernel[++n2] = new Function_openSSS(this);
        this.kernel[++n2] = new Function_openSS(this);
        ++n2;
    }

    public void disposeResource() {
        if (this.mode != null) {
            int n = this.mode.length;
            for (int i = 0; i < n; ++i) {
                if (this.writer != null) {
                    this.writer[i].close();
                    this.writer[i] = null;
                }
                if (this.reader != null) {
                    this.reader[i].close();
                    this.reader[i] = null;
                }
                if (this.writerCSV != null) {
                    this.writerCSV[i].close();
                    this.writerCSV[i] = null;
                }
                if (this.readerCSV != null) {
                    this.readerCSV[i].close();
                    this.readerCSV[i] = null;
                }
                this.buffer[i] = null;
                if (this.ioEngine == null) continue;
                this.ioEngine[i].close();
                this.ioEngine[i].dispose();
                this.ioEngine[i] = null;
            }
        }
        this.writer = null;
        this.reader = null;
        this.writerCSV = null;
        this.readerCSV = null;
        this.ioEngine = null;
        this.buffer = null;
        this.mode = null;
    }

    @Override
    public boolean isProcessable(String string) {
        return string.equals("opend") || string.equals("opencsvd") || string.equals("___read") || string.equals("___readln") || string.equals("___readline") || string.equals("___readLine") || string.equals("___save") || string.equals("___clear") || string.equals("___close") || string.equals("___linefeed") || string.equals("___lineFeed") || string.equals("___browse") || string.equals("___choose") || string.equals("___linecount") || string.equals("___lineCount") || string.equals("___countline") || string.equals("___countLine") || string.equals("___flush");
    }

    @Override
    public String[] process(String string, String[] stringArray) {
        int n;
        Object object;
        Object object2;
        int n2;
        String[] stringArray2 = new String[]{"false"};
        if (string.equals("___read")) {
            ProcessCompatibilityException processCompatibilityException;
            if (2 <= stringArray.length && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.engine.error("System.read \u95a2\u6570\u306e\u30b3\u30fc\u30eb\u306b\u304a\u3051\u308b\u5f15\u6570\u304c\u591a\u3059\u304e\u307e\u3059\u3002\u5f15\u6570\u306b\u306f\u3001int \u578b\u3067\u30d5\u30a1\u30a4\u30ebID\u306e\u307f\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                } else {
                    this.engine.error("Too many arguments are passed to \"System.read\" function. For the arg of this function, specify the file ID as int-type value.");
                }
                return null;
            }
            n2 = -1;
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                new ProcessSyntaxException(this.engine).throwRuntime(19);
                return null;
            }
            if (this.ioEngine[n2] != null) {
                return this.ioEngine[n2].read();
            }
            if (this.mode[n2] == READ_FILE) {
                object2 = this.reader[n2].load();
                int n3 = 0;
                object = new StringTokenizer((String)object2);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    ((StringTokenizer)object).nextToken();
                    ++n3;
                }
                stringArray2 = new String[n3];
                n = 0;
                object = new StringTokenizer((String)object2);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    stringArray2[n] = ((StringTokenizer)object).nextToken();
                    ++n;
                }
                this.tokenIndex[n2] = -1;
            } else if (this.mode[n2] == READ_CSV_FILE) {
                object2 = this.readerCSV[n2].load();
                object2 = ((String)object2).replaceAll("\\r\\n", ",");
                object2 = ((String)object2).replaceAll("\\n\\r", ",");
                object2 = ((String)object2).replaceAll("\\n", ",");
                object2 = ((String)object2).replaceAll("\\r", ",");
                stringArray2 = ((String)object2).split(",");
            } else {
                stringArray2 = new String[]{"false"};
            }
        }
        if (string.equals("___readln")) {
            ProcessCompatibilityException processCompatibilityException;
            if (2 <= stringArray.length && !(processCompatibilityException = new ProcessCompatibilityException()).alert()) {
                if (ScriptProcessor.locale.isJapanese()) {
                    this.engine.error("System.readln \u95a2\u6570\u306e\u30b3\u30fc\u30eb\u306b\u304a\u3051\u308b\u5f15\u6570\u304c\u591a\u3059\u304e\u307e\u3059\u3002\u5f15\u6570\u306b\u306f\u3001int \u578b\u3067\u30d5\u30a1\u30a4\u30ebID\u306e\u307f\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                } else {
                    this.engine.error("Too many arguments are passed to \"System.readln\" function. For the arg of this function, specify the file ID as int-type value.");
                }
                return null;
            }
            n2 = -1;
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                new ProcessSyntaxException(this.engine).throwRuntime(19);
                return null;
            }
            if (this.ioEngine[n2] != null) {
                return this.ioEngine[n2].readln();
            }
            try {
                if (this.mode[n2] == READ_FILE) {
                    stringArray2 = this.reader[n2].readString();
                    this.tokenIndex[n2] = -1;
                } else if (this.mode[n2] == READ_CSV_FILE) {
                    stringArray2 = this.readerCSV[n2].readString();
                    this.tokenIndex[n2] = -1;
                } else {
                    stringArray2 = new String[]{"false"};
                }
            }
            catch (NullPointerException nullPointerException) {
                new ProcessSyntaxException(this.engine).throwRuntime(18);
                return null;
            }
        }
        if (string.equals("___save")) {
            String string2 = stringArray[0];
            string2 = this.engine.getResourceFile(string2).getPath();
            if (!this.engine.getSecurity().request_WRITE_FILE(string2)) {
                this.engine.exit();
                return new String[]{""};
            }
            if (new File(string2).exists() && !this.engine.getSecurity().request_OVERWRITE_FILE(string2)) {
                this.engine.exit();
                return new String[]{""};
            }
            object2 = null;
            object2 = stringArray.length == 1 ? this.engine.getConsoleText() : stringArray[1];
            object = new FileOutputEngine(string2, 0, null, null, false);
            try {
                ((FileOutputEngine)object).write((String)object2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ((FileOutputEngine)object).flush();
            ((FileOutputEngine)object).close();
            ((FileOutputEngine)object).dispose();
            object = null;
            stringArray2 = new String[]{""};
        }
        if (string.equals("opend")) {
            int n4;
            if (stringArray.length == 0 || stringArray[0].equals("")) {
                n4 = this.getAvailableIndex();
            } else {
                n4 = Integer.parseInt(stringArray[0]);
                this.setStreamCapacity(n4);
            }
            if (this.buffer[n4] != null) {
                this.buffer[n4] = null;
            }
            this.buffer[n4] = new StringBuffer();
            this.mode[n4] = BUFFER_FILE;
            stringArray2 = new String[]{"" + n4};
        }
        if (string.equals("opencsvd")) {
            int n5;
            if (stringArray.length == 0 || stringArray[0].equals("")) {
                n5 = this.getAvailableIndex();
            } else {
                n5 = Integer.parseInt(stringArray[0]);
                this.setStreamCapacity(n5);
            }
            if (this.buffer[n5] != null) {
                this.buffer[n5] = null;
            }
            this.buffer[n5] = new StringBuffer();
            this.mode[n5] = BUFFER_CSV_FILE;
            stringArray2 = new String[]{"" + n5};
        }
        if (string.equals("readline") || string.equals("readLine")) {
            int n6 = Integer.parseInt(stringArray[0]);
            if (this.mode[n6] == READ_FILE) {
                stringArray2 = new String[]{this.reader[n6].readLine()};
                this.tokenIndex[n6] = -1;
            } else if (this.mode[n6] == READ_CSV_FILE) {
                stringArray2 = new String[]{this.readerCSV[n6].readLine()};
                this.tokenIndex[n6] = -1;
            } else {
                stringArray2 = new String[]{"false"};
            }
        }
        if (string.equals("linecount") || string.equals("lineCount") || string.equals("countline") || string.equals("countLine")) {
            int n7 = Integer.parseInt(stringArray[0]);
            if (this.mode[n7] == READ_FILE) {
                stringArray2 = new String[]{Integer.toString(this.reader[n7].getLineCount())};
            } else if (this.mode[n7] == READ_CSV_FILE) {
                stringArray2 = new String[]{Integer.toString(this.readerCSV[n7].getLineCount())};
            } else if (this.mode[n7] == BUFFER_FILE) {
                object2 = this.buffer[n7].toString();
                int n8 = ((String)object2).split(System.getProperty("line.separator")).length;
                stringArray2 = new String[]{Integer.toString(n8)};
            } else if (this.mode[n7] == BUFFER_CSV_FILE) {
                object2 = this.buffer[n7].toString();
                int n9 = ((String)object2).split(System.getProperty("line.separator")).length;
                stringArray2 = new String[]{Integer.toString(n9)};
            } else {
                stringArray2 = new String[]{"false"};
            }
        }
        if (string.equals("clear")) {
            int n10 = Integer.parseInt(stringArray[0]);
            if (this.mode[n10] == BUFFER_FILE) {
                this.buffer[n10] = null;
                stringArray2 = new String[]{"true"};
            } else if (this.mode[n10] == BUFFER_CSV_FILE) {
                this.buffer[n10] = null;
                stringArray2 = new String[]{"true"};
            } else {
                stringArray2 = new String[]{"false"};
            }
        }
        if (string.equals("___close")) {
            int n11 = Integer.parseInt(stringArray[0]);
            stringArray2 = new String[]{"false"};
            if (this.ioEngine != null && this.ioEngine[n11] != null) {
                this.ioEngine[n11].close();
                stringArray2 = new String[]{"true"};
            }
            if (this.mode[n11] == READ_FILE) {
                this.reader[n11].close();
                stringArray2 = new String[]{"true"};
            }
            if (this.mode[n11] == WRITE_FILE) {
                this.writer[n11].close();
                stringArray2 = new String[]{"true"};
            }
            if (this.mode[n11] == BUFFER_FILE) {
                this.buffer[n11] = null;
                stringArray2 = new String[]{"true"};
            }
            if (this.mode[n11] == READ_CSV_FILE) {
                this.readerCSV[n11].close();
                stringArray2 = new String[]{"true"};
            }
            if (this.mode[n11] == WRITE_CSV_FILE) {
                this.writerCSV[n11].close();
                stringArray2 = new String[]{"true"};
            }
            if (this.mode[n11] == BUFFER_CSV_FILE) {
                this.buffer[n11] = null;
                stringArray2 = new String[]{"true"};
            }
            this.mode[n11] = NULL_FILE;
        }
        if (string.equals("___flush")) {
            int n12 = Integer.parseInt(stringArray[0]);
            stringArray2 = new String[]{"false"};
            if (this.ioEngine != null) {
                this.ioEngine[n12].flush();
                stringArray2 = new String[]{"true"};
            }
        }
        if (string.equals("linefeed") || string.equals("lineFeed")) {
            stringArray2 = new String[]{System.getProperty("line.separator")};
        }
        if (string.equals("___choose_platform_dependent_ui")) {
            FileDialog fileDialog = new FileDialog((Frame)null, "");
            fileDialog.setMultipleMode(true);
            if (2 <= stringArray.length) {
                fileDialog.setDirectory(this.engine.getResourceFile(stringArray[1]).getPath());
            }
            fileDialog.setVisible(true);
            object2 = fileDialog.getFiles();
            if (((File[])object2).length == 0) {
                stringArray2 = new String[]{"false"};
            } else {
                int n13 = ((File[])object2).length;
                String[] stringArray3 = new String[n13];
                for (n = 0; n < n13; ++n) {
                    stringArray3[n] = ((File)object2[n]).getPath();
                }
                stringArray2 = stringArray3;
            }
            fileDialog.dispose();
        }
        if (string.equals("___choose")) {
            String string3 = stringArray[0];
            object2 = 2 <= stringArray.length ? stringArray[1] : null;
            stringArray2 = this.chooseImpl(string3, (String)object2);
        }
        if (string.equals("browse")) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(stringArray[0]);
            jFileChooser.showOpenDialog(null);
            stringArray2 = new String[]{"false"};
            try {
                object2 = jFileChooser.getSelectedFile();
                String string4 = ((File)object2).toString();
                stringArray2 = new String[]{string4};
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            jFileChooser = null;
        }
        return stringArray2;
    }

    String[] chooseImpl(String string, String string2) {
        boolean bl = System.getProperty("os.name").toLowerCase(Locale.ROOT).trim().startsWith("windows");
        if (bl && this.deresolvesNetworkDrivePath) {
            return this.chooseImpl_deresolveUNC(string, string2);
        }
        return this.chooseImpl_simple(string, string2);
    }

    String[] chooseImpl_simple(String string, String string2) {
        String[] stringArray;
        JFileChooser jFileChooser = new JFileChooser();
        if (string2 != null) {
            stringArray = this.engine.getResourceFile(string2);
            jFileChooser.setCurrentDirectory((File)stringArray);
            jFileChooser.rescanCurrentDirectory();
        }
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setDialogTitle(string);
        jFileChooser.showOpenDialog(null);
        stringArray = new String[]{"false"};
        try {
            File[] fileArray = jFileChooser.getSelectedFiles();
            String[] stringArray2 = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray2[i] = fileArray[i].toString();
            }
            stringArray = stringArray2;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        jFileChooser = null;
        return stringArray;
    }

    String[] chooseImpl_deresolveUNC(String string, String string2) {
        String string3;
        String string4;
        boolean bl = System.getProperty("os.name").toLowerCase(Locale.ROOT).trim().startsWith("windows");
        if (!bl) {
            throw new IllegalStateException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f Windows \u74b0\u5883\u5c02\u7528\u3067\u3059\u3002\u3053\u306e\u74b0\u5883\u3067\u547c\u3070\u308c\u3066\u3044\u308b\u306e\u306f\u5b9f\u88c5\u306e\u7570\u5e38\u3067\u3059\u3002");
        }
        String[] stringArray = this.chooseImpl_simple(string, string2);
        if (stringArray.length == 1 && stringArray[0].equals("false")) {
            return stringArray;
        }
        String string5 = this.engine.getResourceFile(string2).getPath();
        File file = null;
        File[] fileArray = File.listRoots();
        for (File file2 : fileArray) {
            string4 = file2.getPath();
            string3 = file2.getPath().replace("\\", "/");
            if (!string5.startsWith(string4) && !string5.startsWith(string3)) continue;
            file = file2;
            break;
        }
        if (file == null) {
            return stringArray;
        }
        if (!file.getPath().endsWith("\\")) {
            return stringArray;
        }
        Object object = null;
        String string6 = null;
        try {
            object = new File(file, ".").getCanonicalFile();
            string6 = ((File)object).getPath();
            if (!string6.endsWith("\\") && !string6.endsWith("/")) {
                string6 = string6 + System.getProperty("file.separator");
                object = new File(string6);
            }
        }
        catch (IOException iOException) {
            return this.chooseImpl_simple(string, string2);
        }
        int n = string6.startsWith("\\\\") ? 1 : 0;
        if (n != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string7;
                string4 = stringArray[i];
                if (!string4.startsWith(string6)) continue;
                string3 = string4.substring(string6.length(), string4.length());
                stringArray[i] = string7 = file.getPath() + string3;
            }
        }
        return stringArray;
    }

    public int getAvailableIndex() {
        int n;
        if (this.mode == null) {
            this.setStreamCapacity(1);
        }
        for (n = 0; n < this.mode.length; ++n) {
            if (this.mode[n] != NULL_FILE) continue;
            return n;
        }
        this.setStreamCapacity(this.mode.length * 2);
        for (n = 0; n < this.mode.length; ++n) {
            if (this.mode[n] != NULL_FILE) continue;
            return n;
        }
        return -1;
    }

    public void setStreamCapacity(int n) {
        int n2;
        ++n;
        if (this.mode == null) {
            this.ioEngine = new FileIOEngine[n];
            this.writer = new TSVVertexWriter[n];
            this.reader = new TSVVertexReader[n];
            this.writerCSV = new CSVVertexWriter[n];
            this.readerCSV = new CSVVertexReader[n];
            this.buffer = new StringBuffer[n];
            this.mode = new int[n];
            this.tokenBuffer = new String[n][];
            this.tokenIndex = new int[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.mode[n2] = NULL_FILE;
            }
        }
        if ((n2 = this.mode.length) < n) {
            int n3;
            FileIOEngine[] fileIOEngineArray = new FileIOEngine[n2];
            TSVVertexWriter[] tSVVertexWriterArray = new TSVVertexWriter[n2];
            TSVVertexReader[] tSVVertexReaderArray = new TSVVertexReader[n2];
            CSVVertexWriter[] cSVVertexWriterArray = new CSVVertexWriter[n2];
            CSVVertexReader[] cSVVertexReaderArray = new CSVVertexReader[n2];
            StringBuffer[] stringBufferArray = new StringBuffer[n2];
            int[] nArray = new int[n2];
            String[][] stringArrayArray = new String[n][];
            int[] nArray2 = new int[n];
            for (n3 = 0; n3 < n2; ++n3) {
                fileIOEngineArray[n3] = this.ioEngine[n3];
                tSVVertexWriterArray[n3] = this.writer[n3];
                tSVVertexReaderArray[n3] = this.reader[n3];
                cSVVertexWriterArray[n3] = this.writerCSV[n3];
                cSVVertexReaderArray[n3] = this.readerCSV[n3];
                stringBufferArray[n3] = this.buffer[n3];
                nArray[n3] = this.mode[n3];
                stringArrayArray[n3] = this.tokenBuffer[n3];
                nArray2[n3] = this.tokenIndex[n3];
            }
            this.ioEngine = new FileIOEngine[n];
            this.writer = new TSVVertexWriter[n];
            this.reader = new TSVVertexReader[n];
            this.writerCSV = new CSVVertexWriter[n];
            this.readerCSV = new CSVVertexReader[n];
            this.buffer = new StringBuffer[n];
            this.mode = new int[n];
            this.tokenBuffer = new String[n][];
            this.tokenIndex = new int[n];
            for (n3 = 0; n3 < n2; ++n3) {
                this.ioEngine[n3] = fileIOEngineArray[n3];
                this.writer[n3] = tSVVertexWriterArray[n3];
                this.reader[n3] = tSVVertexReaderArray[n3];
                this.writerCSV[n3] = cSVVertexWriterArray[n3];
                this.readerCSV[n3] = cSVVertexReaderArray[n3];
                this.buffer[n3] = stringBufferArray[n3];
                this.mode[n3] = nArray[n3];
                this.tokenBuffer[n3] = stringArrayArray[n3];
                this.tokenIndex[n3] = nArray2[n3];
            }
            for (n3 = n2; n3 < this.mode.length; ++n3) {
                this.mode[n3] = NULL_FILE;
            }
        }
    }
}

